<?php if (!empty($data['details'])):?>
      <?php
            $inline = (!empty($data['urls']) && Bug_Monitor_Helper::normalize_url($data['details']['filename']) == Bug_Monitor_Helper::normalize_url(array_keys($data['urls'])[0]));
            $origin = ($inline ? esc_html__('an inline script', 'bug-monitor') : Bug_Monitor_Helper::get_url_origin($data['details']['filename']));
      ?>
      <?php echo sprintf(esc_html__('A JavaScript error has been detected in %s', 'bug-monitor'), $origin);?><br><br>
      <?php if (!empty($data['details']['stack'])):?>
            <pre class="bm-js-error-wrapper"><?php echo Bug_Monitor_Dashboard::format_js_error($data);?></pre>
      <?php else:?>
      <?php echo sprintf(esc_html__('File: %s%s%s', 'bug-monitor'), '<strong>', $data['details']['filename'], '</strong>');?>
      <?php if ($inline):?>
            <?php esc_html_e('(inline script)', 'bug-monitor');?>
      <?php endif;?><br>
      <?php echo sprintf(esc_html__('Line: %s%s%s', 'bug-monitor'), '<strong>', $data['details']['lineno'], '</strong>');?><br>
      <?php echo sprintf(esc_html__('Message: %s%s%s', 'bug-monitor'), '<strong>', $data['details']['message'], '</strong>');?>
      <?php endif;?>
<?php endif;?>