<div class="bug-monitor-event-col">
      <div class="bug-monitor-event-icon bm-<?php echo esc_attr($data['level']);?>">
            <?php echo Bug_Monitor_Helper::get_icon($data['category']);?>
      </div>
      <div class="bug-monitor-event-category"><?php echo Bug_Monitor_Dashboard::get_category($data['category']);?> <?php echo Bug_Monitor_Dashboard::get_level($data['level']);?></div>
</div>
<div class="bug-monitor-event-col">
      <div class="bug-monitor-event-head">
            <div class="bug-monitor-event-type">
                  <?php echo Bug_Monitor_Dashboard::get_title($data['type'])?>
                  <?php if (!empty($data['details']['revenue'])):?>
                        <span class="bug-monitor-revenue-loss"><?php echo sprintf(esc_html__('Possible revenue loss: %s', 'bug-monitor'), $data['details']['revenue'])?></span>
                  <?php endif;?>
                  <span class="bug-monitor-date">
                        <?php echo Bug_Monitor_Dashboard::get_timestamps($data)?>
                        (<?php echo esc_html(sprintf(_n('one event', '%d events', $data['count'], 'bug-monitor'), $data['count']));?>)
                  </span>
            </div>
            <?php if (!empty($data['visual_type'])):?>
            <div class="bug-monitor-visuals">
                  <a href="#" class="bug-monitor-event-details" data-hash="<?php echo esc_attr($data['event_hash']);?>">
                        <?php if ($data['visual_type'] == 'video'):?>
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/video.svg">
                              <?php esc_html_e('View video', 'bug-monitor');?>
                        <?php elseif ($data['visual_type'] == 'email'):?>
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/email.svg">
                              <?php esc_html_e('View email', 'bug-monitor');?>
                        <?php else:?>
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/image.svg">
                              <?php esc_html_e('View Screenshot', 'bug-monitor');?>
                        <?php endif;?>
                  </a>
            </div>
            <?php elseif(in_array($data['type'], array_merge(Bug_Monitor_Log::$record_types, Bug_Monitor_Log::$screenshot_types)) && !empty($data['preview_link'])):?>
                  <?php if (!empty($data['encrypted'])):?>
                        <a href="#" class="bug-monitor-event-details" data-hash="<?php echo esc_attr($data['event_hash']);?>">
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/link-preview.svg">
                              <?php esc_html_e('Live Preview', 'bug-monitor');?>
                        </a>
                  <?php else:?>
                        <a href="<?php echo esc_attr($data['preview_link']);?>" target="_blank" class="bug-monitor-event-details">
                              <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/link-preview.svg">
                              <?php esc_html_e('Live Preview', 'bug-monitor');?>
                        </a>
                  <?php endif;?>
            <?php endif;?>
      </div>
      <div class="bug-monitor-event-description">
            <p><?php echo Bug_Monitor_Dashboard::get_description($data)?></p>
            <a href="#" class="bug-monitor-event-details" data-hash="<?php echo esc_attr($data['event_hash']);?>"><?php esc_html_e('See Details', 'bug-monitor');?></a>
      </div>
      <div class="bug-monitor-actions">
            <a href="#" data-action="solve" data-id="<?php echo esc_attr($data['event_hash']);?>"><?php esc_html_e('Solved', 'bug-monitor');?></a>
            <a href="#" data-action="ignore" data-id="<?php echo esc_attr($data['event_hash']);?>"><?php esc_html_e('Ignore', 'bug-monitor');?></a>
            <a href="#" data-action="ignore/category" data-id="<?php echo esc_attr($data['category']);?>"><?php echo sprintf(__('Ignore %s issues', 'bug-monitor'), Bug_Monitor_Dashboard::get_category($data['category']));?></a>
            <a href="#" data-action="ignore/type" data-id="<?php echo esc_attr($data['type']);?>"><?php echo sprintf(__('Ignore %s issues', 'bug-monitor'), Bug_Monitor_Dashboard::get_title($data['type']));?></a>
            <a href="#" data-action="undo-ignore" data-id="<?php echo $data['event_hash'];?>"><?php esc_html_e('Remove from ignored events', 'bug-monitor');?></a>
      </div>
</div>