<?php if (!empty($data)):?>
<div class="bug-monitor-popup-event-head">
      <div class="bug-monitor-event-icon bm-<?php echo esc_attr($data['level']);?>">
            <?php echo Bug_Monitor_Helper::get_icon($data['category']);?>
      </div>
      <div class="bug-monitor-event-type">
            <?php echo Bug_Monitor_Dashboard::get_title($data['type'])?>
            <?php if (!empty($data['details']['revenue'])):?>
                  <span class="bug-monitor-revenue-loss"><?php echo sprintf(esc_html__('Possible revenue loss: %s', 'bug-monitor'), $data['details']['revenue'])?></span>
            <?php endif;?>
            <span class="bug-monitor-date"><?php echo Bug_Monitor_Dashboard::get_timestamps($data)?></span>
      </div>
</div>
<div class="bug-monitor-popup-body">
      <?php if (!empty($data['visuals'])):?>
      <div class="bug-monitor-popup-col bug-monitor-popup-col-visuals">
            <div class="bug-monitor-event-visuals">
                        <?php $is_record_type = in_array($data['type'], Bug_Monitor_Log::$record_types);?>
                        <?php if (isset($data['visual_encrypted']) && $data['visual_encrypted'] == 1):?>
                              <div class="bug-monitor-need-subscription">
                                <p class="bug-monitor-need-subscription-message"><?php echo sprintf(esc_html__('You need a valid subscription to see %s', 'bug-monitor'), ($is_record_type ? __('video', 'bug-monitor') : __('screenshot', 'bug-monitor')));?></p>
                                <div class="bug-monitor-need-subscription-buttons">
                                  <a href="<?php echo add_query_arg(array('site' => home_url(), 'site-key' => Bug_Monitor_API::get_site_key(), 'plugin' => 'bugmonitor', 'redirect_to' => Bug_Monitor_Helper::get_dashbord_url() ), 'https://musthaveplugins.com/my-account/api/connect/');?>" class="bm-btn bm-btn-inverse"><?php esc_html_e('Connect your site', 'bug-monitor');?></a>
                                  <a href="https://musthaveplugins.com/bugmonitor/instant-access/" target="_blank" class="bm-btn bm-btn-light"><?php esc_html_e('Get instant access', 'bug-monitor');?></a></div>
                              </div>
                        <?php endif;?>
                        <?php if ($data['type'] == 'php/email_sending_error'):?>
                              <div class="bm-mail-error-wrapper">
                                    <?php echo esc_html($data['details']['subject']);?><br>
                                    <?php echo sprintf(esc_html__('To: %s%s%s', 'bug-monitor'), '<span class="bm-mail-error-to">', esc_html($data['details']['to']), '</span>');?>
                                    <hr class="bm-mail-error-divider">
                                    <div class="bm-mail-error-iframe-wrapper">
                                    <?php if (strpos($data['details']['message'], '<html') !== false):?>
                                          <iframe class="bm-mail-error-iframe" srcdoc="<?php echo esc_attr($data['details']['message']);?>" sandbox="allow-same-origin"></iframe>
                                    <?php else:?>
                                          <iframe class="bm-mail-error-iframe" srcdoc="<pre><?php echo htmlentities($data['details']['message']);?></pre>"></iframe>
                                    <?php endif;?>
                                    </div>
                              </div>
                        <?php else:?>
                              <div class="bug-monitor-event-visual-active-wrapper">
                                    <img src="<?php echo esc_attr($data['visuals'][0]['preview']);?>"<?php echo ($is_record_type ? ' data-record="' . $data['visuals'][0]['hash'] . '"' : 'data-src="' . $data['visuals'][0]['screenshot'] . '"');?> class="bug-monitor-event-visual-active<?php echo (!empty($data['visuals'][0]['adjust_bgcolor']) ? ' bm-adjust-bgcolor' : '')?>" crossorigin="anonymous">
                                    <?php if ($is_record_type):?>
                                          <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M464 256A208 208 0 1 0 48 256a208 208 0 1 0 416 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM188.3 147.1c7.6-4.2 16.8-4.1 24.3 .5l144 88c7.1 4.4 11.5 12.1 11.5 20.5s-4.4 16.1-11.5 20.5l-144 88c-7.4 4.5-16.7 4.7-24.3 .5s-12.3-12.2-12.3-20.9V168c0-8.7 4.7-16.7 12.3-20.9z"/></svg>
                                    <?php else:?>
                                          <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><path d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z"/></svg>
                                    <?php endif;?>
                              </div>
                              <?php if (count($data['visuals']) > 1):?>
                              <ul class="bug-monitor-event-visual-list">
                                    <?php foreach ($data['visuals'] as $visual):?>
                                          <li><img src="<?php echo esc_attr($visual['preview']);?>" data-src="<?php echo esc_attr($visual['screenshot']);?>"<?php echo ($is_record_type ? ' data-record="' . $visual['hash'] . '"' : '');?><?php echo (!empty($data['visuals'][0]['adjust_bgcolor']) ? ' class="bm-adjust-bgcolor" crossorigin="anonymous"' : '')?>></li>
                                    <?php endforeach;?>
                              </ul>
                              <?php endif;?>
                        <?php endif;?>
            </div>
      </div>
      <?php endif;?>
      <div class="bug-monitor-popup-col">
            <div class="bug-monitor-event-description-wrapper">
                  <div class="bug-monitor-event-description-head"><?php esc_html_e('Details', 'bug-monitor');?></div>
                  <div class="bug-monitor-event-description">
                  <?php if ($data['encrypted'] == 1):?>
                        <div class="bug-monitor-need-subscription">
                          <p class="bug-monitor-need-subscription-message"><?php esc_html_e('You need a valid subscription to see details', 'bug-monitor');?></p>
                          <div class="bug-monitor-need-subscription-buttons">
                            <a href="<?php echo add_query_arg(array('site' => home_url(), 'site-key' => Bug_Monitor_API::get_site_key(), 'plugin' => 'bugmonitor', 'redirect_to' => Bug_Monitor_Helper::get_dashbord_url()), 'https://musthaveplugins.com/my-account/api/connect/');?>" class="bm-btn bm-btn-inverse"><?php esc_html_e('Connect your site', 'bug-monitor');?></a>
                            <a href="https://musthaveplugins.com/bugmonitor/instant-access/" target="_blank" class="bm-btn bm-btn-light"><?php esc_html_e('Get instant access', 'bug-monitor');?></a></div>
                        </div>
                  <?php endif;?>
                  <?php
                        $description = trim(Bug_Monitor_Helper::get_template('events/' . $data['type'], $data));
                        if (!empty($description)){
                              echo $description;
                        }
                        else {
                              echo Bug_Monitor_Dashboard::get_description($data);
                        }
                  ?>
                  <?php if(in_array($data['type'], array_merge(Bug_Monitor_Log::$record_types, Bug_Monitor_Log::$screenshot_types)) && empty($data['visuals']) && !empty($data['preview_link'])):?>
                        <div class="bm-missing-visual">
                              <?php esc_html_e('BugMonitor couldn\'t capture a screenshot or video for this event. You can check the problematic element in the live preview.', 'bug-monitor');?><br>
                              <a href="<?php echo esc_attr($data['preview_link']);?>" target="_blank" class="bm-btn-large">
                                    <img src="<?php echo BUG_MONITOR_PLUGIN_URL;?>/images/icons/link-preview.svg">
                                    <?php esc_html_e('Live Preview', 'bug-monitor');?>
                              </a>
                        </div>
                  <?php endif;?>
                  <div class="bm-error-insights">
                        <?php esc_html_e('Read Error Insights to learn more about this type of issue', 'bug-monitor');?>
                        <a href="<?php echo Bug_Monitor_Dashboard::get_error_insight_link($data['type']);?>" class="bm-btn-large" target="_blank"><?php esc_html_e('Error Insights', 'bug-monitor');?></a>
                  </div>
                  </div>
            </div>
            <div class="bug-monitor-actions">
                  <a href="#" data-action="solve" data-id="<?php echo esc_attr($data['event_hash']);?>"><?php esc_html_e('Solved', 'bug-monitor');?></a>
                  <a href="#" data-action="ignore" data-id="<?php echo esc_attr($data['event_hash']);?>"><?php esc_html_e('Ignore', 'bug-monitor');?></a>
                  <a href="#" data-action="ignore/category" data-id="<?php echo esc_attr($data['category']);?>"><?php echo sprintf(__('Ignore %s issues', 'bug-monitor'), Bug_Monitor_Dashboard::get_category($data['category']));?></a>
                  <a href="#" data-action="ignore/type" data-id="<?php echo esc_attr($data['type']);?>"><?php echo sprintf(__('Ignore %s issues', 'bug-monitor'), Bug_Monitor_Dashboard::get_title($data['type']));?></a>
            </div>
            <input type="checkbox" id="bug-monitor-event-urls" class="bug-monitor-event-properties-trigger">
            <div class="bug-monitor-event-properties-wrapper">
                  <label for="bug-monitor-event-urls"><?php esc_html_e('Affected URLs', 'bug-monitor');?> <span class="bm-count">(<?php echo count($data['urls']);?>)</span></label>
                  <div class="bug-monitor-event-properties">
                        <ul>
                        <?php foreach ($data['urls'] as $url => $occurance):?>
                              <li>
                                    <a href="<?php echo esc_url($url);?>" target="_blank"><?php echo esc_url($url);?></a>
                                    <?php echo sprintf(_n('(one time)', '(%d times)', $occurance, 'bug-monitor'), $occurance);?>
                                    <?php if (!empty($data['selector']) && $data['encrypted'] != 1):?>
                                          <a href="<?php echo esc_url(add_query_arg('bm-preview', urlencode($data['selector']), $url));?>" target="_blank"><?php esc_html_e('Preview', 'bug-monitor')?></a>
                                    <?php endif;?>
                              </li>
                        <?php endforeach;?>
                        </ul>
                  </div>
            </div>
            <?php if (!empty($data['browsers'])):?>
            <input type="checkbox" id="bug-monitor-event-browsers" class="bug-monitor-event-properties-trigger">
            <div class="bug-monitor-event-properties-wrapper">
                  <label for="bug-monitor-event-browsers"><?php esc_html_e('Devices', 'bug-monitor');?> <span class="bm-count">(<?php echo count($data['browsers']);?>)</span></label>
                  <div class="bug-monitor-event-properties">
                        <ul>
                        <?php foreach ($data['browsers'] as $ua => $occurance):?>
                              <li class="bm-device-icons">
                                    <?php echo Bug_Monitor_Helper::get_device_icons($ua);?>
                                    <?php echo sprintf(_n('(one time)', '(%d times)', $occurance, 'bug-monitor'), $occurance);?>
                              </li>
                        <?php endforeach;?>
                        </ul>
                  </div>
            </div>
            <?php endif;?>
      </div>
</div>
<?php else:?>
      <div class="bug-monitor-event-head">
            <div class="bug-monitor-event-type">
                  <?php esc_html_e('Event is missing', 'bug-monitor');?>
            </div>
      </div>
      <div class="bm-event-missing">
            <?php esc_html_e('This event has already been solved or deleted.', 'bug-monitor');?>
      </div>
<?php endif;?>