<?php
/**
 * Plugin Name: BugMonitor
 * Plugin URI: https://bug-monitor.com
 * Description: Bug Monitor continuously monitors your website and notifies you of any functionality or SEO, speed, network, JavaScript, UX/UI errors.
 * Version: 0.3.1
 * Author: Must-Have Plguins
 * Author URI: https://musthaveplugins.com
 * Text Domain: bug-monitor
 */
if (defined('BUG_MONITOR_PLUGIN_FILE')){
       return;
}
 define('BUG_MONITOR_PLUGIN_FILE', __FILE__);
 define('BUG_MONITOR_PLUGIN_DIR', plugin_dir_path(__FILE__));
 define('BUG_MONITOR_PLUGIN_URL', trailingslashit(plugins_url(basename(__DIR__))));
 define('BUG_MONITOR_PLUGIN_SLUG', basename(__DIR__) . '/' .basename(__FILE__));
 define('BUG_MONITOR_SITE_URL', 'https://bug-monitor.com/');
 define('BUG_MONITOR_API_URL', 'https://api.bug-monitor.com/');
 spl_autoload_register(function ($class_name) {
     if (strpos($class_name, 'Bug_Monitor_') === 0) {
         $filename = strtolower(str_replace('_', '-', substr($class_name, 12))) . '.class.php';
         $file = BUG_MONITOR_PLUGIN_DIR . 'classes/' . $filename;
         if (file_exists($file)) {
             include $file;
         }
     }
 });

 class Bug_Monitor {

      private static $options;
      private static $instance = null;
      private function __construct() {
            self::$options = Bug_Monitor_Config::get_options();
            Bug_Monitor_Compatibility::init();
            add_action('init', array('Bug_Monitor_Dashboard', 'session_endpoint'));
            add_action('admin_menu', array('Bug_Monitor_Dashboard', 'init'));

            if (Bug_Monitor_Config::is_db_uptodate()){
                  add_action('rest_api_init', function () {
                      register_rest_route('bug-monitor/v1', '/report/(?P<action>[a-zA-Z_]+)', array(
                          'methods' => 'POST',
                          'callback' => array('Bug_Monitor_Log', 'handle_rest_request'),
                          'permission_callback' => '__return_true',
                          'args' => array(
                              'action' => array(
                                  'validate_callback' => function($param, $request, $key) {
                                      return (in_array($param, array('event', 'single_event', 'session', 'screenshot', 'mutations')));
                                  }
                              ),
                          ),
                      ));
                  });

                  Bug_Monitor_Server::init();
                  Bug_Monitor_Cron::init();

            }
            Bug_Monitor_Frontend::init();
            add_action('wp_ajax_bug_monitor', array('Bug_Monitor_Ajax', 'endpoint'));
            register_activation_hook(__FILE__, array(__CLASS__, 'activation'));
            register_deactivation_hook(__FILE__, array(__CLASS__, 'deactivation'));
            add_action('init', array(__CLASS__, 'load_textdomain'));
      }
      public static function get_instance() {
            if (null === self::$instance) {
                  self::$instance = new self();
            }
            return self::$instance;
      }
      public static function get_option($key, $default = null) {
            $option_value = isset(self::$options[$key]) ? self::$options[$key] : $default;
            return apply_filters('bug_monitor/get_option', $option_value, $key);
      }

      public static function check_option($key, $value, $compare = '='){
            $option = self::get_option($key);

            switch ($compare){
                  case '=':
                        $result = ($option == $value);
                        break;
                  case '!=':
                        $result = ($option != $value);
                        break;
                  case '<':
                        $result = (Bug_Monitor_Helper::str2number($option) < Bug_Monitor_Helper::str2number($value));
                        break;
                  case '>':
                        $result = (Bug_Monitor_Helper::str2number($option) > Bug_Monitor_Helper::str2number($value));
                        break;
                  case '<=':
                        $result = (Bug_Monitor_Helper::str2number($option) <= Bug_Monitor_Helper::str2number($value));
                        break;
                  case '>=':
                        $result = (Bug_Monitor_Helper::str2number($option) >= Bug_Monitor_Helper::str2number($value));
                        break;
                  case 'CONTAINS':
                        if (is_array($value)){
                              $result = in_array($option, $value);
                        }
                        else {
                              $result = (strpos($option, $value) !== false);
                        }
                        break;
                  case 'IN':
                        $result = (is_array($option) && in_array($value, $option));
                        break;
            }

            return apply_filters('bug_monitor/check_option_' . $key, $result, $value, $compare);
      }
      public static function set_option($key, $value) {
          $value = apply_filters('bug_monitor/set_option', $value, $key);
          self::$options[$key] = $value;
      }
      public static function update_option($key, $value) {
          $value = apply_filters('bug_monitor/update_option', $value, $key);
          self::$options[$key] = $value;
          update_option('bug_monitor_options', self::$options);
          do_action('bug_monitor/option_updated', $value, $key);
      }

      public static function activation(){
            Bug_Monitor_Config::install_mu_loader();
      }
      public static function deactivation(){
            Bug_Monitor_Cron::deschedule();
            Bug_Monitor_Config::uninstall_mu_loader();
      }

      public static function uninstall(){
            Bug_Monitor_Cron::deschedule();
            Bug_Monitor_API::request('disconnect');
            delete_transient('bug_monitor_update_data');
            delete_transient('bug_monitor_log_count');
            delete_option('bug_monitor_options');
            Bug_Monitor_Helper::$db->query("DROP TABLE IF EXISTS " . Bug_Monitor_Helper::$db->bug_monitor_hits);
            Bug_Monitor_Helper::$db->query("DROP TABLE IF EXISTS " . Bug_Monitor_Helper::$db->bug_monitor_events);
            Bug_Monitor_Helper::$db->query("DROP TABLE IF EXISTS " . Bug_Monitor_Helper::$db->bug_monitor_sessions);
            Bug_Monitor_Helper::$db->query("DROP TABLE IF EXISTS " . Bug_Monitor_Helper::$db->bug_monitor_screenshots);
            Bug_Monitor_Config::uninstall_mu_loader();
      }

      public static function load_textdomain() {
            $locale = get_locale();
            $mo_file =  BUG_MONITOR_PLUGIN_DIR . 'languages/bug-monitor-' . $locale . '.mo';

            if (file_exists($mo_file)) {
                  load_textdomain('bug-monitor', $mo_file);
            }
      }
 }
 $bugMonitor = Bug_Monitor::get_instance();