<?php

class Bug_Monitor_Frontend {

      public static function init(){
            if (apply_filters('bug_monitor/disable_frontend', false)){
                  return;
            }

            // Include Bug Monitor head
            add_action('wp_head', function(){
                  include BUG_MONITOR_PLUGIN_DIR . 'templates/frontend-js.tpl.php';
            }, apply_filters('bug_monitor/frontend/init_priority', -PHP_INT_MAX));

            if (isset($_GET['bm-preview'])){
                  add_filter('determine_current_user', '__return_false', PHP_INT_MAX);
                  $cookie_key = 'wordpress_logged_in_' . (defined('COOKIEHASH') ? COOKIEHASH : md5(site_url()));
                  unset($_COOKIE[$cookie_key]);

                  add_action('wp_enqueue_scripts', function(){
                        $ver = substr(md5_file(BUG_MONITOR_PLUGIN_DIR . 'assets/frontend-preview.js'),0,6);
                        wp_enqueue_script('bug-monitor', BUG_MONITOR_PLUGIN_URL . 'assets/frontend-preview.js', '', $ver, array('in_footer' => true));
                        wp_enqueue_style('bug-monitor', BUG_MONITOR_PLUGIN_URL . 'assets/frontend-preview.css');
                  });

                  add_action('wp_footer', function(){
                        include BUG_MONITOR_PLUGIN_DIR . 'templates/frontend-preview.tpl.php';
                  }, PHP_INT_MAX);
            }
            else {
                  add_action('wp_enqueue_scripts', function(){
                        $ver = substr(md5_file(BUG_MONITOR_PLUGIN_DIR . 'assets/bm.js'),0,6);
                        wp_enqueue_script('bug-monitor', BUG_MONITOR_PLUGIN_URL . 'assets/bm.js', '', $ver, array('strategy' => 'defer', 'in_footer' => true));
                  });
            }
      }

}