<?php

class Bug_Monitor_Ajax {

      public static function endpoint(){
            if (!current_user_can('manage_options')){
                  header('HTTP/1.0 403 Forbidden');
            }
            else if (!isset($_REQUEST['nonce']) || !wp_verify_nonce($_REQUEST['nonce'], 'bug-monitor-ajax')){
                  header('HTTP/1.0 400 Bad request');
                  echo 'Bad request';die;
            }
            else {
                  switch ($_REQUEST['bmaction']) {
                        case 'solve':
                              Bug_Monitor_Log::solve($_POST['id']);
                              break;
                        case 'ignore':
                              Bug_Monitor_Log::ignore(array('event_hash' => $_POST['id']));
                              break;
                        case 'ignore/category':
                              Bug_Monitor_Log::ignore(array('category' => $_POST['id']));
                              echo Bug_Monitor_Helper::get_template('settings');
                              break;
                        case 'ignore/type':
                              Bug_Monitor_Log::ignore(array('type' => $_POST['id']));
                              echo Bug_Monitor_Helper::get_template('settings');
                              break;
                        case 'undo-ignore':
                              Bug_Monitor_Log::undo_ignore(array('event_hash' => $_POST['id']));
                              break;
                        case 'event-details':
                              Bug_Monitor_Dashboard::load_event($_POST['id']);
                              break;
                        case 'update-option':
                              Bug_Monitor::update_option($_POST['option'], $_POST['value']);
                              break;
                        case 'disconnect':
                              Bug_Monitor_API::request('disconnect');
                              Bug_Monitor::update_option('activated', 0);
                              echo Bug_Monitor_Helper::get_template('settings');
                              break;
                        case 'notifications/get':
                              $res = Bug_Monitor_API::request('notifications', array('action' => 'get'));
                              if (!empty($res)){
                                    $endpoints = json_decode($res['body'], true);
                                    wp_send_json($endpoints);
                              }
                              break;
                        case 'notifications/save':
                              switch ($_POST['type']){
                                    case 'email':
                                          $data = json_encode(array(
                                                'label' => $_POST['email'],
                                                'email' => $_POST['email'])
                                          );
                                          break;
                                    case 'webhook':
                                          $data = json_encode(array(
                                                'label' => '[' . $_POST['method'] . '] ' . $_POST['url'],
                                                'url' => $_POST['url'],
                                                'method' => $_POST['method']
                                          ));
                                          break;
                              }
                              $res = Bug_Monitor_API::request('notifications', array('action' => 'put', 'type' => $_POST['type'], 'data' => $data));
                              if (!empty($res)){
                                    $endpoints = json_decode($res['body'], true);
                                    wp_send_json($endpoints);
                              }
                              break;
                        case 'notifications/remove':
                              $res = Bug_Monitor_API::request('notifications', array('action' => 'delete', 'type' => $_POST['type'], 'id' => $_POST['id']));
                              if (!empty($res)){
                                    $endpoints = json_decode($res['body'], true);
                                    wp_send_json($endpoints);
                              }
                              break;
                        case 'notifications/qr':
                              $qr = new Bug_Monitor_QRCode("https://push.bug-monitor.com/?site=" . home_url() . "&site_key=" . Bug_Monitor_API::get_site_key());
                              $qr->output_image();
                              die;
                              break;
                        case 'load-session':
                              $session = Bug_Monitor_Helper::$db->get_var(Bug_Monitor_Helper::$db->prepare("SELECT source FROM " . Bug_Monitor_Helper::$db->bug_monitor_sessions. " WHERE hash = %s", $_GET['session']));
                              echo Bug_Monitor_Helper::ugz($session);
                              break;
                        case 'reset':
                              Bug_Monitor_Log::reset();
                              break;
                        case 'dismiss-notice':
                              Bug_Monitor_Dashboard::delete_notice($_POST['id']);
                              break;
                  }
            }
            die;
      }

}