jQuery(document).ready( function($) {
	$("#bsk_gfblcv_list_edit_form_id").keypress(function(e) {
		var key = e.charCode || e.keyCode || 0;     
		if (key == 13) {
			e.preventDefault();
		}
    });
	
	$("#bsk_gfblcv_blacklist_list_save_ID").click(function(){
		var list_name = $("#bsk_gfblcv_list_name_ID").val();
        
		list_name = $.trim(list_name);
		if( list_name == "" ){
			alert( "List name cannot be empty" );
			$("#bsk_gfblcv_list_name_ID").focus();
			
			return false;
		}
		
		$("#bsk_gfblcv_list_edit_form_id").submit();
	});
    
    
	//for IP address, only accpet number, . , * and -
    $(".add-item-input-for-iplist").keyup( function(){
        //only number & letters
        this.value = this.value.replace(/[^0-9.\*\- ]/g, '');
    });
    
	function bsk_gfblcv_valid_email_address( email_address ) {
        var pattern = new RegExp(/^[+a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/i);
        if( pattern.test( email_address ) ){
			return true;
		}
		
		//check if *@domain.com
		var email_str_array = email_address.split('@');
		if( Array.isArray( email_str_array ) == false || 
			email_str_array.length < 2 ){
				
			return false;
		}
		
		if( email_str_array[0] == '*' || pattern.test( 'abc' + email_str_array[1] ) ){
			return true;
		}
		
		return false;
    }
    
    function bsk_gfblcv_valid_ip_address( ip_address ) {
        var pattern = new RegExp(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/g);
        
        if( pattern.test( ip_address ) ){
			return true;
		}
		
		//check if 45.91.94.*
		var pattern = new RegExp(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]|\*)$/g);
        if( pattern.test( ip_address ) ){
			return true;
		}
        
        //check if 45.91.94.1 - 45.91.94.123
		var pattern = new RegExp(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\ \-\ (([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/g);
        
        if( pattern.test( ip_address ) ){
            var ip_start_end = ip_address.split( '-' );
            ip_start_end[0] = $.trim( ip_start_end[0] );
            ip_start_end[1] = $.trim( ip_start_end[1] );
            var ip_start_array = ip_start_end[0].split( '.' );
            var ip_end_array = ip_start_end[1].split( '.' );
            
            if( ip_start_array.length != 4 || ip_end_array.length != 4 ){
                return false;
            }
            
            if( ip_start_array[0] != ip_end_array[0] ){
                return false;
            }
            
            ip_start_array[1] = parseInt( ip_start_array[1] );
            ip_start_array[2] = parseInt( ip_start_array[2] );
            ip_start_array[3] = parseInt( ip_start_array[3] );
            ip_end_array[1] = parseInt( ip_end_array[1] );
            ip_end_array[2] = parseInt( ip_end_array[2] );
            ip_end_array[3] = parseInt( ip_end_array[3] );
            
            if( ip_start_array[1] > ip_end_array[1] ){
                return false;
            }
            
            if( ip_start_array[1] == ip_end_array[1] &&
                ip_start_array[2] > ip_end_array[2] ){
                return false;
            }
            
            if( ip_start_array[1] == ip_end_array[1] &&
                ip_start_array[2] == ip_end_array[2] && 
                ip_start_array[3] > ip_end_array[3] ){
                return false;
            }
            
			return true;
		}

        //check if 45.91.94.1-45.91.94.123
		var pattern = new RegExp(/^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\-(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/g);
        if( pattern.test( ip_address ) ){
            var ip_start_end = ip_address.split( '-' );
            var ip_start_array = ip_start_end[0].split( '.' );
            var ip_end_array = ip_start_end[1].split( '.' );
            
            if( ip_start_array[0] != ip_end_array[0] ){
                return false;
            }
            
            ip_start_array[1] = parseInt( ip_start_array[1] );
            ip_start_array[2] = parseInt( ip_start_array[2] );
            ip_start_array[3] = parseInt( ip_start_array[3] );
            ip_end_array[1] = parseInt( ip_end_array[1] );
            ip_end_array[2] = parseInt( ip_end_array[2] );
            ip_end_array[3] = parseInt( ip_end_array[3] );
            
            if( ip_start_array[1] > ip_end_array[1] ){
                return false;
            }
            
            if( ip_start_array[1] == ip_end_array[1] &&
                ip_start_array[2] > ip_end_array[2] ){
                return false;
            }
            
            if( ip_start_array[1] == ip_end_array[1] &&
                ip_start_array[2] == ip_end_array[2] && 
                ip_start_array[3] > ip_end_array[3] ){
                return false;
            }
            
			return true;
		}
        
		return false;
    }
	
	$("#bsk_gfblcv_add_item_by_input_save_anchor_ID").click(function(){
		var item_value = $("#bsk_gfblcv_add_item_by_input_name_ID").val();
		var item_list_type = $("#bsk_gfblcv_items_list_type_ID").val();
		
		item_value = $.trim(item_value);
		if( item_value == "" ){
			alert( "Item value cannot be empty" );
			$("#bsk_gfblcv_add_item_by_input_name_ID").focus();
			
			return false;
		}
		if( item_list_type == 'EMAIL_LIST' ){
			//check if item _value a valid email
			if( !bsk_gfblcv_valid_email_address( item_value ) ){
				alert( "Please enter valid email address or email domain name." );
				$("#bsk_gfblcv_add_item_by_input_name_ID").focus();
				
				return false;
			}
		}else if( item_list_type == 'IP_LIST' ){
			//check if item _value a valid email
			if( !bsk_gfblcv_valid_ip_address( item_value ) ){
				alert( "Please enter valid IP address or IP ranges" );
				$("#bsk_gfblcv_add_item_by_input_name_ID").focus();
				
				return false;
			}
		}
		
		$("#bsk_gfblcv_action_ID").val( "save_item" );
		$("#bsk_gfblcv_items_form_id").submit();
	});
	
	$(".bsk-gfblcv-item-delete-anchor").click(function(){
		var item_id = $(this).attr('rel');
		
		if( parseInt(item_id) < 1 ){
			$(this).parents('tr').find(".bsk-gfblcv-item-action-msg-p").html( 'Invalid item ID' ).addClass( 'bsk-gfblcv-error-message' );
            $(this).parents('tr').find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            
            return;
		}
		
        confirm_msg = 'Are you sure to delete? <a class="bsk-gfblcv-item-delete-cfm-yes-anchor" data-item_id="'+item_id+'">Yes</a>, <a class="bsk-gfblcv-item-delete-cfm-no-anchor">No</a>.<span class="item-action-confirm-id" data-item_id="'+item_id+'"></span><span class="bsk-gfblcv-item-delete-ajax-loader"></span>';
        
        $(this).parents('tr').find(".bsk-gfblcv-item-action-confirm-p").html( confirm_msg );
        $(this).parents('tr').find(".bsk-gfblcv-item-action-confirm-p").css( "display", "block" );
        
        //hide all others
        $("#bsk_gfblcv_items_form_id").find( ".bsk-gfblcv-item-action-confirm-p" ).each( function(i, e ){
            if( $(this).find('.item-action-confirm-id').data( 'item_id' ) != item_id ){
                var td_obj = $(this).parent();
                td_obj.find(".bsk-gfblcv-item-action-msg-p").html( '' ).removeClass( 'bsk-gfblcv-error-message' );
                td_obj.find(".bsk-gfblcv-item-action-msg-p").html( '' ).css( "display", "none" );

                td_obj.find(".bsk-gfblcv-item-action-confirm-p").html( '' );
                td_obj.find(".bsk-gfblcv-item-action-confirm-p").css( "display", "none" );
            }
        });
	});
    
    $("#bsk_gfblcv_items_form_id").on( 'click', '.bsk-gfblcv-item-delete-cfm-yes-anchor', function(){
        var item_id_val = $(this).data('item_id');
        var tr_obj = $(this).parents('tr');
		if( parseInt(item_id_val) < 1 ){
			tr_obj.find(".bsk-gfblcv-item-action-msg-p").html( 'Invalid item ID' ).addClass( 'bsk-gfblcv-error-message' );
            tr_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            
            return;
		}
        
        //ajax to delete
        var ajax_loader = tr_obj.find(".bsk-gfblcv-item-action-ajax-loader");
        
        var nonce_val = $("#bsk_gfblcv_items_form_id").find( '.bsk-gfblcv-item-operation-ajax-nonce' ).val();
        var data = { 
                        action: 'bsk_gfblcv_delete_item',
                        item_id: item_id_val,
                        nonce: nonce_val
                   };
        ajax_loader.css( "display", "inline-block" );
        $.post( ajaxurl, data, function( response ) {
            ajax_loader.css( "display", "none" );
            var return_obj = $.parseJSON( response );
            if( return_obj.success == false ){
                tr_obj.find(".bsk-gfblcv-item-action-msg-p").html( return_obj.msg ).addClass( 'bsk-gfblcv-error-message' );
                tr_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            }else{
                tr_obj.remove();
            }
        });
    });
    
    $("#bsk_gfblcv_items_form_id").on( 'click', '.bsk-gfblcv-item-delete-cfm-no-anchor', function(){
        $(this).parents('tr').find(".bsk-gfblcv-item-action-confirm-p").html( '' );
        $(this).parents('tr').find(".bsk-gfblcv-item-action-confirm-p").css( "display", "none" );
    });
    
    //send out by mail
    $(".bsk-gfblcv-item-send-out-anchor").click(function(){
		var item_id_val = $(this).attr('rel');
		
		if( parseInt(item_id_val) < 1 ){
			row_obj.find(".bsk-gfblcv-item-action-msg-p").html( 'Invalid item ID' ).addClass( 'bsk-gfblcv-error-message' );
            row_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            
            return;
		}
        
        var row_obj = $(this).parents('tr');
        //query if email address entered
        var email_address = $(this).parent().find( ".bsk-gfblcv-item-send-to-email-address" ).val();
		if( email_address == '' || email_address == undefined ){
            confirm_msg = 'Email address: <input type="text" class="bsk-gfblcv-item-send-to-email-address" style="width: 100%;" />';
            confirm_msg += '<br /><br /><a class="bsk-gfblcv-item-send-to-cfm-yes-anchor" data-item_id="'+item_id_val+'">Send</a>&nbsp;&nbsp;<a class="bsk-gfblcv-item-send-to-cfm-no-anchor">Cancel</a><span class="item-action-confirm-id" data-item_id="'+item_id_val+'"></span>';
        
            row_obj.find(".bsk-gfblcv-item-action-confirm-p").html( confirm_msg );
            row_obj.find(".bsk-gfblcv-item-action-confirm-p").css( "display", "block" );
        }
        
        //hide all others
        $("#bsk_gfblcv_items_form_id").find( ".bsk-gfblcv-item-action-confirm-p" ).each( function(i, e ){
            if( $(this).find('.item-action-confirm-id').data( 'item_id' ) != item_id_val ){
                var td_obj = $(this).parent();
                td_obj.find(".bsk-gfblcv-item-action-msg-p").html( '' ).removeClass( 'bsk-gfblcv-error-message' );
                td_obj.find(".bsk-gfblcv-item-action-msg-p").html( '' ).css( "display", "none" );

                td_obj.find(".bsk-gfblcv-item-action-confirm-p").html( '' );
                td_obj.find(".bsk-gfblcv-item-action-confirm-p").css( "display", "none" );
            }
        });
    });
    
    $("#bsk_gfblcv_items_form_id").on( 'click', '.bsk-gfblcv-item-send-to-cfm-yes-anchor', function(){
        var row_obj = $(this).parents('tr');
        var item_id_val = $(this).data('item_id');
		
		if( parseInt(item_id_val) < 1 ){
			row_obj.find(".bsk-gfblcv-item-action-msg-p").html( 'Invalid item ID' ).addClass( 'bsk-gfblcv-error-message' );
            row_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            
            return;
		}
        //check email
        var email_address = row_obj.find( ".bsk-gfblcv-item-send-to-email-address" ).val();
        if( email_address == '' || !bsk_gfblcv_valid_email_address( email_address ) ){
            row_obj.find(".bsk-gfblcv-item-action-msg-p").html( 'Invalid email address' ).addClass( 'bsk-gfblcv-error-message' );
            row_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            
            return;
        }
        
        //ajax
        var ajax_loader = row_obj.find( '.bsk-gfblcv-item-send-out-ajax-loder' );
        var nonce_val = $("#bsk_gfblcv_items_form_id").find( '.bsk-gfblcv-item-operation-ajax-nonce' ).val();
        var data = { 
                        action: 'bsk_gfblcv_send_item_to_email',
                        email: email_address,
                        item_id: item_id_val,
                        nonce: nonce_val
                   };
        
        ajax_loader.css( "display", "inline-block" );
        $.post( ajaxurl, data, function( response ) {
            ajax_loader.css( "display", "none" );
            var return_obj = $.parseJSON( response );
            if( return_obj.success == false ){
                row_obj.find(".bsk-gfblcv-item-action-msg-p").html( return_obj.msg ).addClass( 'bsk-gfblcv-error-message' );
                row_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
            }else{
                row_obj.find(".bsk-gfblcv-item-action-msg-p").html( return_obj.msg ).removeClass( 'bsk-gfblcv-error-message' );
                row_obj.find(".bsk-gfblcv-item-action-msg-p").css( "display", "block" );
                //update extra
                row_obj.find(".column-hits").html( return_obj.extra );
            }
        });
	});
    
    $("#bsk_gfblcv_items_form_id").on( 'click', '.bsk-gfblcv-item-send-to-cfm-no-anchor', function(){
        var row_obj = $(this).parents('tr');
        row_obj.find(".bsk-gfblcv-item-action-msg-p").html( '' ).removeClass( 'bsk-gfblcv-error-message' );
        row_obj.find(".bsk-gfblcv-item-action-msg-p").html( '' ).css( "display", "none" );
        
        row_obj.find(".bsk-gfblcv-item-action-confirm-p").html( '' );
        row_obj.find(".bsk-gfblcv-item-action-confirm-p").css( "display", "none" );
    });
	
	$("#bsk_gfblcv_add_item_by_csv_ID").change(function (){
       var file_name = $(this).val();
       $("#bsk_gfblcv_add_item_by_csv_selected_file_ID").val( file_name );
    });
	
	$("#bsk_gfblcv_add_item_by_csv_save_anchor_ID").click(function(){
		var selected_file = $("#bsk_gfblcv_add_item_by_csv_selected_file_ID").val();
		if( selected_file == "" ){
			alert( "Please select a CSV file first" );
			return false;
		}
		
		$("#bsk_gfblcv_action_ID").val( "save_item_by_csv" );
		$("#bsk_gfblcv_items_form_id").submit();
	});
	
	$("#bsk_gfblcv_export_items_as_CSV_anchor_ID").click(function(){
		$("#bsk_gfblcv_action_ID").val( "export_items_as_csv" );
		$("#bsk_gfblcv_items_form_id").submit();
	});
	
	$(".bsk-gfblcv-admin-delete-list").click(function(){
		var list_id = $(this).attr("rel");
		var count = $(this).attr("count");
        var row_obj = $(this).parents('tr');
		
		if( parseInt(list_id) < 1 ){
			row_obj.find(".bsk-gfblcv-list-action-msg-p").html( 'Invalid list ID' ).addClass( 'bsk-gfblcv-error-message' );
            row_obj.find(".bsk-gfblcv-list-action-msg-p").css( "display", "block" );
            
            return;
		}
		
		if( parseInt(count) > 0 ){
            confirm_msg = count + ' item(s) inlcuded, are you sure to delete? <a class="bsk-gfblcv-list-delete-cfm-yes-anchor" data-list_id="'+list_id+'">Yes</a>, <a class="bsk-gfblcv-list-delete-cfm-no-anchor">No</a>.<span class="list-action-confirm-id" data-list_id="'+list_id+'"></span>';

			row_obj.find(".bsk-gfblcv-list-action-confirm-p").html( confirm_msg );
            row_obj.find(".bsk-gfblcv-list-action-confirm-p").css( "display", "block" );
            
            //hide all others
            $("#bsk_gfblcv_items_form_id").find( ".bsk-gfblcv-list-action-confirm-p" ).each( function(i, e ){
                if( $(this).find('.list-action-confirm-id').data( 'list_id' ) != list_id ){
                    var td_obj = $(this).parent();
                    td_obj.find(".bsk-gfblcv-list-action-msg-p").html( '' ).removeClass( 'bsk-gfblcv-error-message' );
                    td_obj.find(".bsk-gfblcv-list-action-msg-p").html( '' ).css( "display", "none" );

                    td_obj.find(".bsk-gfblcv-list-action-confirm-p").html( '' );
                    td_obj.find(".bsk-gfblcv-list-action-confirm-p").css( "display", "none" );
                }
            });
		}else{
            $("#bsk_gfblcv_list_id_to_be_processed_ID").val( list_id );
            $("#bsk_gfblcv_action_ID").val( "delete_list_by_id" );
            $("#bsk_gfblcv_lists_form_id").submit();
        }
	});
    
    $("#bsk_gfblcv_lists_form_id").on( 'click', '.bsk-gfblcv-list-delete-cfm-yes-anchor', function(){
        var list_id = $(this).data('list_id');
		if( parseInt(list_id) < 1 ){
			row_obj.find(".bsk-gfblcv-list-action-msg-p").html( 'Invalid list ID' ).addClass( 'bsk-gfblcv-error-message' );
            row_obj.find(".bsk-gfblcv-list-action-msg-p").css( "display", "block" );
            
            return;
		}
        $("#bsk_gfblcv_list_id_to_be_processed_ID").val( list_id );
        $("#bsk_gfblcv_action_ID").val( "delete_list_by_id" );
        $("#bsk_gfblcv_lists_form_id").submit();
    });
    
    $("#bsk_gfblcv_lists_form_id").on( 'click', '.bsk-gfblcv-list-delete-cfm-no-anchor', function(){
        $(this).parents('tr').find(".bsk-gfblcv-list-action-confirm-p").html( '' );
        $(this).parents('tr').find(".bsk-gfblcv-list-action-confirm-p").css( "display", "none" );
    });
	
	$("#bsk_gfblcv_add_email_domain_name_checkbox_ID").on("click", function(){
		if( $(this).is(":checked") ){
			$("#bsk_gfblcv_add_email_domain_name_input_container_ID").css( "display", "block" );
			
			$("#bsk_gfblcv_add_email_list_item_input_container_ID").css( "display", "none" );
		}else{
			$("#bsk_gfblcv_add_email_domain_name_input_container_ID").css( "display", "none" );
			
			$("#bsk_gfblcv_add_email_list_item_input_container_ID").css( "display", "block" );
		}
	});
	
	$("#bsk_gfblcv_add_email_domain_name_save_anchor_ID").click(function(){
		var item_value = $("#bsk_gfblcv_email_domain_name_ID").val();
		var item_list_type = $("#bsk_gfblcv_items_list_type_ID").val();
		
		item_value = $.trim(item_value);
		if( item_value == "" ){
			alert( "Item value cannot be empty" );
			$("#bsk_gfblcv_add_item_by_input_name_ID").focus();
			
			return false;
		}
		if( item_list_type == 'EMAIL_LIST' ){
			//check if item _value a valid email
			if( !bsk_gfblcv_valid_email_address( item_value ) ){
				alert( "Please enter valid email address" );
				$("#bsk_gfblcv_add_item_by_input_name_ID").focus();
				
				return false;
			}
		}
		
		$("#bsk_gfblcv_action_ID").val( "save_item" );
		$("#bsk_gfblcv_items_form_id").submit();
	});
    
    /* IP List */
    $( ".bsk-gfblcv-ip-list-check-way-radio" ).click( function(){
        var ip_check_way = $(this).val();
        
        if( ip_check_way == 'COUNTRY' ){
            $( "#bsk_gfblcv_edit_item_container_ID" ).css( "display", "none" );
            $( "#bsk_gfblcv_iplist_by_country_settings_container_ID" ).css( "display", "block" );
        }else{
            $( "#bsk_gfblcv_edit_item_container_ID" ).css( "display", "block" );
            $( "#bsk_gfblcv_iplist_by_country_settings_container_ID" ).css( "display", "none" );
        }
    } );
    
    $("#bsk_gfblcv_iplist_by_country_country_to_block_or_allow_ID").change( function() {
        var country_code = $(this).val();
        if( country_code == '' ){
            return;
        }
        //add new cat id
        var exist_country_codes = $("#bsk_gfblcv_iplist_by_country_exist_countries_code_ID").val();
        var exist_country_codes_array = new Array;
        var already_set = false;
        if( exist_country_codes.length > 0 ){
            exist_country_codes_array = exist_country_codes.split(',');
            if( exist_country_codes_array.length > 0 ){
                for( var i = 0; i < exist_country_codes_array.length; i++ ){
                    if( exist_country_codes_array[i] == country_code ){
                        already_set = true;
                        break;
                    }
                }
            }
        }
        if( already_set == true ){
            return;
        }
        exist_country_codes_array.push( country_code );
        var country_label = $("#bsk_gfblcv_iplist_by_country_country_to_block_or_allow_ID option:selected").text();
        country_label = $.trim(country_label);
        var delete_icon = $("#bsk_gfblcv_delete_country_code_icon_ID").val();
        var html = '<span style="display: inline-block;padding-right:10px;"><a href="javascript:void(0);" class="bsk-gfblcv-delete-country-code-anchor" data-country_code="' + country_code + '"><img src="' + delete_icon + '" style="width:12px;height:12px;" /></a>&nbsp;' + country_label + '</span>';
        $("#bsk_gfblcv_iplist_by_country_added_countries_container_ID").append( html );
        $("#bsk_gfblcv_iplist_by_country_exist_countries_code_ID").val( exist_country_codes_array.join(',') );
    });
    
    $("#bsk_gfblcv_iplist_by_country_settings_container_ID").on("click", ".bsk-gfblcv-delete-country-code-anchor", function(){
        var country_code = $(this).data( 'country_code' );
        
        var exist_country_codes = $("#bsk_gfblcv_iplist_by_country_exist_countries_code_ID").val();
        var exist_country_codes_array = new Array;
        var new_country_codes_array = new Array;
        if( exist_country_codes.length > 0 ){
            exist_country_codes_array = exist_country_codes.split(',');
            if( exist_country_codes_array.length > 0 ){
                for( var i = 0; i < exist_country_codes_array.length; i++ ){
                    if( exist_country_codes_array[i] == country_code ){
                        continue;
                    }
                    new_country_codes_array.push( exist_country_codes_array[i] );
                }
            }
        }
        var new_str = new_country_codes_array.join(',');
        $("#bsk_gfblcv_iplist_by_country_exist_countries_code_ID").val( new_str );
        
        $(this).parent().remove();
    });
    
    
    $( ".bsk-gfblcv-iplist-test-anchor" ).click( function() {
        var api_server = $("#bsk_gfblcv_iplist_by_country_API_server_to_use_ID").val();
        api_server_key_require = $("#bsk_gfblcv_iplist_by_country_API_server_to_use_ID").children(":selected").attr("id");
        var api_key = '';
        var api_test_ip = $("#bsk_gfblcv_iplist_by_country_API_test_IP_value_ID").val();
        
        if( $("#bsk_gfblcv_iplist_by_country_API_key_ID").length ){
            api_key = $("#bsk_gfblcv_iplist_by_country_API_key_ID").val();
        }
        
        $( "#bsk_gfblcv_iplist_api_test_response_container_ID" ).html( '' );
        if( api_server == '' ){
            $( "#bsk_gfblcv_iplist_api_test_response_container_ID" ).html( '<p style="color: #FF0000;">Please choose a API serer.</p>' );
            $("#bsk_gfblcv_iplist_by_country_API_server_to_use_ID").focus();
            
            return;
        }
        
        if( api_server_key_require == 'YES' && $.trim( api_key ) == '' ){
            $( "#bsk_gfblcv_iplist_api_test_response_container_ID" ).html( '<p style="color: #FF0000;">Please enter you API key.</p>' );
            $( "#bsk_gfblcv_iplist_by_country_API_key_ID" ).focus();
            
            return;
        }
        
        api_test_ip = $.trim( api_test_ip );
        if( api_test_ip == '' ){
            $( "#bsk_gfblcv_iplist_api_test_response_container_ID" ).html( '<p style="color: #FF0000;">Please enter an IP address.</p>' );
            $( "#bsk_gfblcv_iplist_by_country_API_test_IP_value_ID" ).focus();
            
            return;
        }else{
            validate_ip_return = bsk_gfblcv_valid_ip_address( api_test_ip );
            if( validate_ip_return == false ){
                $( "#bsk_gfblcv_iplist_api_test_response_container_ID" ).html( '<p style="color: #FF0000;">Invalid IP address.</p>' );
                $( "#bsk_gfblcv_iplist_by_country_API_test_IP_value_ID" ).focus();

                return;
            }
        }
        
        selected_country_val = $("#bsk_gfblcv_iplist_by_country_exist_countries_code_ID").val();
        var ajax_loader = $(this).parent().find( '.bsk-gfblcv-iplist-api-test-ajax-loder' );
        
        //ajax to check api
        var nonce_val = $("#bsk_gfblcv_ip_list_test_api_nonce_ID").val();
        var data = { 
                        action: 'bsk_gfblcv_ip_list_test_API',
                        server: api_server,
                        key: api_key,
                        ip: api_test_ip,
                        selected_country: selected_country_val,
                        nonce: nonce_val
                   };
        
        ajax_loader.css( "display", "inline-block" );
        $.post( ajaxurl, data, function( response ) {
            ajax_loader.css( "display", "none" );
            $( "#bsk_gfblcv_iplist_api_test_response_container_ID" ).html( response );
        });
        
    });
    
    $("#bsk_gfblcv_iplist_by_country_API_server_to_use_ID").change( function(){
        var api_server = $(this).val();
        api_server_key_require = $(this).children(":selected").attr("id");
        console.log( api_server_key_require );
        $("#bsk_gfblcv_iplist_by_country_settings_container_ID").find( ".bsk-gfblcv-iplist-by-country-api-server-ref" ).css( "display", "none" );
        $("#bsk_gfblcv_iplist_by_country_settings_container_ID").find( "#bsk_gfblcv_iplist_by_country_API_key_ID" ).removeAttr( "disabled" );
        $("#bsk_gfblcv_iplist_by_country_settings_container_ID").find( "#bsk_gfblcv_iplist_by_country_API_key_ID" ).val( "" );
        if( api_server == '' ){
            return;
        }
        api_server = api_server.replace( /\./g, '_' );
        $("#bsk_gfblcv_iplist_by_country_api_server_ref_" + api_server + '_ID').css( "display", "inline-block" );
        
        if( api_server_key_require == 'NO' ){
            $("#bsk_gfblcv_iplist_by_country_settings_container_ID").find( "#bsk_gfblcv_iplist_by_country_API_key_ID" ).prop( 'disabled', true );
        }
    });
    
    /*
     * invitation codes list
     */
    $("#bsk_gfblcv_generate_item_button_ID").click(function(){
		var count = $("#bsk_gfblcv_generate_item_count_ID").val();
		if( count < 1 ){
			$("#bsk_gfblcv_generate_item_error_p_ID").html( '<label class="bsk-gfblcv-admin-label">&nbsp;</label><label>Please enter a valid count</label>' );
            $("#bsk_gfblcv_generate_item_error_p_ID").css( "display", "block" );
            $("#bsk_gfblcv_generate_item_count_ID").focus();
            
			return false;
		}
        
        var nonce_val = $( "#bsk_gfblcv_items_form_id" ).find( '.bsk-gfblcv-item-operation-ajax-nonce' ).val();
        var data = { 
                        action: 'bsk_gfblcv_generate_item_valid',
                        nonce: nonce_val
                   };
        $( "#bsk_gfblcv_items_form_id" ).find( ".bsk-gfblcv-generate-itme-only-loader").css( "display", "inline-block" );
        $.post( ajaxurl, data, function( response ) {
            $( "#bsk_gfblcv_items_form_id" ).find( ".bsk-gfblcv-generate-itme-only-loader").css( "display", "none" );
            
            var return_obj = $.parseJSON( response );
            if( return_obj.success == false ){
                $("#bsk_gfblcv_generate_item_error_p_ID").html( '<label class="bsk-gfblcv-admin-label">&nbsp;</label><label>'+return_obj.msg+'</label>' );
                $("#bsk_gfblcv_generate_item_error_p_ID").css( "display", "block" );
                
                return;
            }else{
                $("#bsk_gfblcv_action_ID").val( "genereate_items" );
		        $("#bsk_gfblcv_items_form_id").submit();
            }
        });	
	});
    
    $("#bsk_gfblcv_items_form_id").on( "click", '#bsk_gfblcv_send_item_by_user_role_anchor_ID, #bsk_gfblcv_send_item_by_email_list_anchor_ID', function(){
        var type = $(this).data( 'type' );
        var type_label = 'user role';
        var type_no_label = 'no user in the role';
        var type_count_label = 'user(s) in the role';
        if( type == 'email_list' ){
            type_label = 'email list';
            type_no_label = 'no email address in the list';
            type_count_label = 'email(s) in the list';
        }
        $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").html( '' );
        $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").removeClass( 'bsk-gfblcv-error-message' );
        $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").css( "display", "none" );
        
        
        var user_role_or_list_id = $("#bsk_gfblcv_send_item_by_" + type + "_ID").val();
        if( !user_role_or_list_id ){
            $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").html( '<label class="bsk-gfblcv-admin-label"></label>' + 'Please select a ' + type_label );
            $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").addClass( 'bsk-gfblcv-error-message' );
            $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").css( "display", "block" );
            $("#bsk_gfblcv_send_item_by_" + type + "_ID").focus();
            
            return;
        }

        var nonce_val = $( "#bsk_gfblcv_items_form_id" ).find( '.bsk-gfblcv-item-operation-ajax-nonce' ).val();
        var data = { 
                        action: 'bsk_gfblcv_get_valid_count_by_' + type,
                        role_or_id: user_role_or_list_id,
                        nonce: nonce_val
                   };
        $( "#bsk_gfblcv_items_form_id" ).find( ".bsk-gfblcv-generate-itme-by-" + type + "-loader").css( "display", "inline-block" );
        $.post( ajaxurl, data, function( response ) {
            $( "#bsk_gfblcv_items_form_id" ).find( ".bsk-gfblcv-generate-itme-by-" + type + "-loader").css( "display", "none" );
            
            var return_obj = $.parseJSON( response );
            if( return_obj.success == false ){
                $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").html( '<label class="bsk-gfblcv-admin-label"></label>' + return_obj.msg );
                $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").addClass( 'bsk-gfblcv-error-message' );
                $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").css( "display", "block" );
                
                return;
            }
            
            confirm_msg = '<label class="bsk-gfblcv-admin-label"></label><b>' + return_obj.count + '</b> ' + type_count_label + ', are you sure to generate code and send to each one? <a class="bsk-gfblcv-item-generate-cfm-yes-anchor" data-form_action="genereate_items_by_' + type + '">Yes</a>, <a class="bsk-gfblcv-item-generate-cfm-no-anchor" data-type="' + type + '">No</a>.';

            $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").html( confirm_msg );
            $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").removeClass( 'bsk-gfblcv-error-message' );
            $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").css( "display", "block" );
        });
    });
    
    $("#bsk_gfblcv_items_form_id").on( "click", '.bsk-gfblcv-item-generate-cfm-yes-anchor', function(){
        var form_action = $(this).data( 'form_action' );
        $("#bsk_gfblcv_action_ID").val( form_action );
		$("#bsk_gfblcv_items_form_id").submit();
    });
    
    $("#bsk_gfblcv_items_form_id").on( "click", '.bsk-gfblcv-item-generate-cfm-no-anchor', function(){
        var type = $(this).data( 'type' );
        
        $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").html( '' );
        $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").removeClass( 'bsk-gfblcv-error-message' );
        $("#bsk_gfblcv_generate_item_by_" + type + "_msg_p_ID").css( "display", "none" );
    });

    /*
     * License
     */
    $(".bsk-gfblcv-refresh-license-summary").click(function(){
        var section_obj = $(this).parents(".bsk-gfblcv-license-summary-section");
        var license_type_obj = section_obj.find(".bsk-gfblcv-license-type-span");
        var license_expiry_date_obj = section_obj.find(".bsk-gfblcv-license-expiry-date-span");
        var ajax_loader_obj = section_obj.find(".bsk-gfblcv-refresh-license-summary-ajax-loader");
        var error_message_obj = section_obj.find(".bsk-gfblcv-error-message");
        var nonce_val = section_obj.find(".bsk-gfblcv-refresh-license-ajax-nonce").val();
        
        error_message_obj.html( '' );
        error_message_obj.css( "display", "none" );
        
        var data = { 
                        action: 'bsk_gfblcv_refresh_license_summary',
                        nonce: nonce_val
                   };
        ajax_loader_obj.css( "display", "inline-block" );
        $.post( ajaxurl, data, function( response ) {
            ajax_loader_obj.css( "display", "none" );
            
            var return_obj = $.parseJSON( response );
            if( return_obj.success == false ){
                error_message_obj.html( return_obj.msg );
                error_message_obj.css( "display", "block" );
                
                return;
            }
            license_type_obj.html( return_obj.type );
            license_expiry_date_obj.html( return_obj.expiry_date );
        });
    });
    
    /*
     * Settings
     *
     */
    /* settings tab switch */
	$("#bsk_gfblcv_setings_wrap_ID .nav-tab-wrapper a").click(function(){
		//alert( $(this).index() );
		$('#bsk_gfblcv_setings_wrap_ID section').hide();
		$('#bsk_gfblcv_setings_wrap_ID section').eq($(this).index()).show();
		
		$(".nav-tab").removeClass( "nav-tab-active" );
		$(this).addClass( "nav-tab-active" );
		
		return false;
	});
    
	//settings target tab
	if( $("#bsk_gfblcv_settings_target_tab_ID").length > 0 ){
		var target = $("#bsk_gfblcv_settings_target_tab_ID").val();
		if( target ){
			$("#bsk_gfblcv_setings_tab-" + target).click();
		}
	}
    
    $("#bsk_gfbl_form_select_to_list_entries_ID, #bsk_gfbl_form_selected_plugin_ID").change( function(){
        var slected_form = $(this).val();
        
        $(this).parents( 'form' ).submit();
    });
    
    $( ".bsk-gfblcv-notify-bloked-enable-radio" ).click( function(){
        var notify_blocked_enable = $("input[name='bsk_gfblcv_notify_blocked_enable']:checked").val();
        var details_container = $(this).parents( ".bsk-gfblcv-notify-administrtor-settings" ).find( ".bsk-gfblcv-administrator-mails-details-container" );
        
        if( notify_blocked_enable == 'NO' ){
            details_container.css( "display", "none" );
            return;
        }
        
        details_container.css( "display", "block" );
    });
    
    
    /*
     * gravity forms form settings
     */
    $( ".bsk-gfblcv-form-settings-enable-raido" ).change( function () {

        var enable = $("input[type='radio'][name='bsk_gfblcv_form_settings_enable']:checked").val();
        var form_settings_container = $(this).parents( '.bsk-gfblcv-form-settings-container' );
        
        if( enable == 'DISABLE' ){
            form_settings_container.find( ".bsk-gfblcv-form-settings-actions-container" ).css( "display", "none" );
            form_settings_container.find( ".bsk-gfblcv-form-settings-blocked-data-container" ).css( "display", "none" );
            form_settings_container.find( ".bsk-gfblcv-form-settings-entry-container" ).css( "display", "none" );
            form_settings_container.find( ".bsk-gfblcv-form-settings-error-messages-container" ).css( "display", "none" );

            form_settings_container.parent().find( "#bsk_gfblcv_cf7_form_mappings_ID" ).css( "display", "none" );
            
            return;
        }
        
        form_settings_container.find( ".bsk-gfblcv-form-settings-actions-container" ).css( "display", "table-row" );
        form_settings_container.parent().find( "#bsk_gfblcv_cf7_form_mappings_ID" ).css( "display", "block" );
        
        bsk_gfblcv_control_settings_display( form_settings_container );
    });
    
    function bsk_gfblcv_control_settings_display( $root_container_object ){
        
        $root_container_object.find( ".bsk-gfblcv-form-settings-blocked-data-container" ).css( "display", "none" );
        $root_container_object.find( ".bsk-gfblcv-form-settings-entry-container" ).css( "display", "none" );
        $root_container_object.find( ".bsk-gfblcv-form-settings-error-messages-container" ).css( "display", "none" );
        
        $root_container_object.find( ".bsk-gfblcv-notificaitons-to-skip" ).css( 'display', 'none' );
        $root_container_object.find( ".bsk-gfblcv-confirmations-to-go" ).css( 'display', 'none' );
        
        var is_action_block = $( ".bsk-gfblcv-form-settings-action-block-chk" ).is( ":checked" );
        var is_action_skip = $( ".bsk-gfblcv-form-settings-action-skip-chk" ).is( ":checked" );
        var is_action_confirmation = $( ".bsk-gfblcv-form-settings-action-confirmation-chk" ).is( ":checked" );
        var is_notify_administrator = $("input[type='radio'][name='bsk_gfblcv_notify_administrators']:checked").val();
        var is_notify_administrator = is_notify_administrator == 'YES' ? true : false;
        
        
        $root_container_object.find( ".bsk-gfblcv-form-settings-entry-container" ).css( "display", "block" );

        if( is_action_block ){
            $root_container_object.find( ".bsk-gfblcv-form-settings-blocked-data-container" ).css( "display", "block" );
            $root_container_object.find( ".bsk-gfblcv-form-settings-error-messages-container" ).css( "display", "block" );
            $root_container_object.find( ".bsk-gfblcv-form-settings-entry-container" ).css( "display", "none" );
        }
        
        if( is_action_skip ){
            $root_container_object.find( ".bsk-gfblcv-notificaitons-to-skip" ).css( 'display', 'table-row' );
        }
        
        if( is_action_confirmation ){
            $root_container_object.find( ".bsk-gfblcv-confirmations-to-go" ).css( 'display', 'table-row' );
        }
        
        if( is_notify_administrator ){
            $root_container_object.find( ".bsk-gfblcv-form-settings-notify-send-to" ).css( 'display', 'table-row' );
        }
    }

    $( ".bsk-gfblcv-form-settings-action-block-chk, .bsk-gfblcv-form-settings-action-skip-chk, .bsk-gfblcv-form-settings-action-confirmation-chk" ).change( function( event ){

        var form_settings_container = $(this).parents( '.bsk-gfblcv-form-settings-container' );

        if( $(this).hasClass( 'bsk-gfblcv-form-settings-action-block-chk' ) ){
            if( $(this).is( ':checked' ) ){
                form_settings_container.find( ".bsk-gfblcv-form-settings-action-skip-chk" ).prop( 'checked', false );
                form_settings_container.find( ".bsk-gfblcv-form-settings-action-confirmation-chk" ).prop( 'checked', false );
            }
        }else if( $(this).hasClass( 'bsk-gfblcv-form-settings-action-skip-chk' ) ){
            if( $(this).is( ':checked' ) ){
                form_settings_container.find( ".bsk-gfblcv-form-settings-action-block-chk" ).prop( 'checked', false );
            }
        }else if( $(this).hasClass( 'bsk-gfblcv-form-settings-action-confirmation-chk' ) ){
            if( $(this).is( ':checked' ) ){
                form_settings_container.find( ".bsk-gfblcv-form-settings-action-block-chk" ).prop( 'checked', false );
            }
        }
        
        bsk_gfblcv_control_settings_display( form_settings_container );
    });
    
    $(".bsk-gfblcv-notifiy-administrators-raido").change( function(){
        var notify_administrator = $("input[type='radio'][name='bsk_gfblcv_notify_administrators']:checked").val();
        var form_settings_container = $(this).parents( '.bsk-gfblcv-form-settings-container' );
        
        if( notify_administrator == 'YES' ){
            form_settings_container.find( ".bsk-gfblcv-form-settings-notify-send-to" ).css( 'display', 'table-row' );
        }else{
            form_settings_container.find( ".bsk-gfblcv-form-settings-notify-send-to" ).css( 'display', 'none' );
        }
    })
    
    /*
     * formidable forms form field
     */
    $( ".bsk-gfbl-ff-form-field-apply-list-chk" ).click( function() {
        var checked = $(this).is(":checked");
        var type = $(this).data( 'list-type' );
        
        //uncheck or checkbox
        $(this).parents( 'ul' ).find( '.bsk-gfbl-ff-form-field-apply-list-chk' ).prop( 'checked', false );
        $(this).parents( 'ul' ).find( 'select' ).val( '');
        $(this).parents( 'ul' ).find( 'select' ).slideUp();
        //hide validaiton message
        $(this).parents( 'ul' ).find( '.bsk-gfbl-validation-message-field-setting' ).css( "display", "none" );
        
        //check the current
        if ( checked ) {
            $(this).prop( 'checked', true );
            //show select
            $(this).parent().find( 'select' ).slideDown();
            $(this).parents( 'ul' ).find( '.bsk-gfbl-validation-message-field-setting' ).css( "display", "block" );
        }
        
    });
    
    
    /*
      * invitation code copy
     */
    $(".bsk-gfbl-copy-anchor").hover(function(){
            $(this).parent().find( ".bsk-gfbl-copy-tooltip-text" ).css( "visibility", "visible" );
            $(this).parent().find( ".bsk-gfbl-copy-tooltip-text" ).css( "opacity", "1" );
        }, 
        function() {
            // mouse left
            $(this).parent().find( ".bsk-gfbl-copy-tooltip-text" ).css( "visibility", "hidden" );
            $(this).parent().find( ".bsk-gfbl-copy-tooltip-text" ).css( "opacity", "0" );
            $(this).parent().find( ".bsk-gfbl-copy-tooltip-text" ).html( "click to copy" );    
        }
    );
    
    $(".bsk-gfbl-copy-anchor").click( function(){
        var code_to_copy_text = $(this).parents( ".bsk-gfbl-invitation-code" ).find(".bsk-gfbl-code-to-copy").html();
        
        var temp_input = $( "<input>" );
        $( "body" ).append( temp_input );
        temp_input.val( code_to_copy_text ).select();
        document.execCommand("copy");
        temp_input.remove();
        
        $(this).parent().find( ".bsk-gfbl-copy-tooltip-text" ).html( 'Copied' );
    });


    /* CF7 */
    $("#cf7_blacklist_skip_main_mail_chk_ID").click(function(){
        if( $(this).is(":checked") ){
            $("#cf7_blacklist_skip_mail_2_chk_li_ID").css("display", "none");
        }else{
            $("#cf7_blacklist_skip_mail_2_chk_li_ID").css("display", "inline-block");
        }
    });

    $( ".bsk-gfblcv-cf7-mapping-list-type-select" ).change( function() {
        var list_type = $( this ).val();

        $( this ).parents( 'tr' ).find( ".bsk-gfblcv-cf7-mapping-list-id-select, .bsk-gfblcv-cf7-mapping-comparison, .bsk-gfblcv-cf7-mapping-action, .bsk-gfblcv-cf7-mapping-action-for-invit, .bsk-gfblcv-cf7-validation-message" ).css( "display", "none" );
        if ( list_type == '' ) {
            return;
        }
        var list_id_class_identifier = '';
        var list_comparison_class_identifier = '';
        var validation_message_class_identifier = 'bsk-gfblcv-cf7-validation-message';
        switch( list_type ) {
            case 'BLACK_LIST':
                list_id_class_identifier = 'bsk-gfblcv-cf7-blacklist';
                list_comparison_class_identifier = 'bsk-gfblcv-cf7-mapping-comparison';
            break;
            case 'WHITE_LIST':
                list_id_class_identifier = 'bsk-gfblcv-cf7-whitelist';
                list_comparison_class_identifier = 'bsk-gfblcv-cf7-mapping-comparison';
            break;
            case 'EMAIL_LIST':
                list_id_class_identifier = 'bsk-gfblcv-cf7-emaillist';
                list_comparison_class_identifier = 'bsk-gfblcv-cf7-mapping-action';
            break;
            case 'IP_LIST':
                list_id_class_identifier = 'bsk-gfblcv-cf7-iplist';
                list_comparison_class_identifier = 'bsk-gfblcv-cf7-mapping-action';
            break;
            case 'INVIT_LIST':
                list_id_class_identifier = 'bsk-gfblcv-cf7-invitlist';
                list_comparison_class_identifier = 'bsk-gfblcv-cf7-mapping-action-for-invit';
            break;
            default:
                validation_message_class_identifier = ''; 
            break;
        }

        
        $( this ).parents( 'tr' ).find( ".bsk-gfblcv-cf7-mapping-list-id-select." + list_id_class_identifier ).css( "display", "inline-block" );
        $( this ).parents( 'tr' ).find( "." + list_comparison_class_identifier ).css( "display", "inline-block" );
        $( this ).parents( 'tr' ).find( "." + validation_message_class_identifier ).css( "display", "inline-block" );
    });

    $( ".bsk-gfblcv-cf7-mapping-list-id-select, .bsk-gfblcv-cf7-mapping-comparison, .bsk-gfblcv-cf7-mapping-action").change( function() {
        if ( $ ( this ).val() != '' ) {
            $( this ).parent().find( '.bsk-gfblcv-error-message' ).css( "display", "none" );
        }
    });

     /*
     * formidable forms form field
     */
    $("#bsk_gfblcv_forminator_setings_wrap_ID .nav-tab-wrapper a").click(function(){
		//alert( $(this).index() );
		$('#bsk_gfblcv_forminator_setings_wrap_ID section').hide();
		$('#bsk_gfblcv_forminator_setings_wrap_ID section').eq($(this).index()).show();
		
		$(".nav-tab").removeClass( "nav-tab-active" );
		$(this).addClass( "nav-tab-active" );
		
		return false;
	});
    
	//settings target tab
	if( $( "#bsk_gfblcv_forminator_settings_target_tab_ID" ).length > 0 ){
		var target = $( "#bsk_gfblcv_forminator_settings_target_tab_ID" ).val();
		if( target ){
			$( "#bsk_gfblcv_forminator_setings_tab-" + target ).click();
		}
	}

    $( ".bsk-gfblcv-frmt-mapping-list-type-select" ).change( function() {
        var list_type = $( this ).val();

        $( this ).parents( 'tr' ).find( ".bsk-gfblcv-frmt-mapping-list-id-select, .bsk-gfblcv-frmt-mapping-comparison, .bsk-gfblcv-frmt-mapping-action, .bsk-gfblcv-frmt-mapping-action-for-invit, .bsk-gfblcv-frmt-validation-message" ).css( "display", "none" );
        if ( list_type == '' ) {
            return;
        }
        var list_id_class_identifier = '';
        var list_comparison_class_identifier = '';
        var validation_message_class_identifier = 'bsk-gfblcv-frmt-validation-message';
        switch( list_type ) {
            case 'BLACK_LIST':
                list_id_class_identifier = 'bsk-gfblcv-frmt-blacklist';
                list_comparison_class_identifier = 'bsk-gfblcv-frmt-mapping-comparison';
            break;
            case 'WHITE_LIST':
                list_id_class_identifier = 'bsk-gfblcv-frmt-whitelist';
                list_comparison_class_identifier = 'bsk-gfblcv-frmt-mapping-comparison';
            break;
            case 'EMAIL_LIST':
                list_id_class_identifier = 'bsk-gfblcv-frmt-emaillist';
                list_comparison_class_identifier = 'bsk-gfblcv-frmt-mapping-action';
            break;
            case 'IP_LIST':
                list_id_class_identifier = 'bsk-gfblcv-frmt-iplist';
                list_comparison_class_identifier = 'bsk-gfblcv-frmt-mapping-action';
            break;
            case 'INVIT_LIST':
                list_id_class_identifier = 'bsk-gfblcv-frmt-invitlist';
                list_comparison_class_identifier = 'bsk-gfblcv-frmt-mapping-action-for-invit';
            break;
            default:
                validation_message_class_identifier = ''; 
            break;
        }

        
        $( this ).parents( 'tr' ).find( ".bsk-gfblcv-frmt-mapping-list-id-select." + list_id_class_identifier ).css( "display", "inline-block" );
        $( this ).parents( 'tr' ).find( "." + list_comparison_class_identifier ).css( "display", "inline-block" );
        $( this ).parents( 'tr' ).find( "." + validation_message_class_identifier ).css( "display", "inline-block" );
    });

    $( ".bsk-gfblcv-frmt-mapping-list-id-select, .bsk-gfblcv-frmt-mapping-comparison, .bsk-gfblcv-frmt-mapping-action").change( function() {
        if ( $ ( this ).val() != '' ) {
            $( this ).parent().find( '.bsk-gfblcv-error-message' ).css( "display", "none" );
        }
    });

});
