<?php 

class BSK_GFBLCV_Pro_Updater {

  function __construct() {

        add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'pre_set_site_transient_update_plugins_filter' ) );
		    add_filter( 'plugins_api', array( $this, 'plugins_api_filter' ), 10, 3);
		    add_filter( 'http_request_args', array( $this, 'http_request_args' ), 10, 2 );
	}
	
	function pre_set_site_transient_update_plugins_filter( $_transient_data ) {

		if( empty( $_transient_data ) ) return $_transient_data;
		
		$license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license, '' );
		if( !$license ){
			return;
		}
		
		$latest_info = $this->remote_get_latest_info( $license );
		if( false !== $latest_info && is_object( $latest_info ) && isset( $latest_info->new_version ) ) {
			if( version_compare( BSK_GFBLCV_Pro::$_plugin_version, $latest_info->new_version, '<' ) ) {
				$_transient_data->response[BSK_GFBLCV_Pro_Update_Helper::$_plugin_folder.'/'.BSK_GFBLCV_Pro_Update_Helper::$_plugin_main_file] = $latest_info;
			}
		}

		return $_transient_data;
	}
	
	function plugins_api_filter( $_data, $_action = '', $_args = null ) {
		if( $_action != 'plugin_information' || 
			!isset( $_args->slug ) || 
			$_args->slug != BSK_GFBLCV_Pro_Update_Helper::$_plugin_slug ){
			
			return $_data;
		}
		
		$license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license, '' );
		if( !$license ){
			return $_data;
		}

		$latest_info = $this->remote_get_latest_info( $license );
		if( false !== $latest_info ){
			$_data = $latest_info;
		}

		return $_data;
	}

	function http_request_args( $args, $url ) {
		// If it is an https request and we are performing a package download, disable ssl verification
		if( strpos( $url, 'https://' ) !== false && strpos( $url, 'bskddaction=package_download' ) ) {
			$args['sslverify'] = false;
		}
		return $args;
	}

	function remote_get_latest_info( $license ) {
		if( trim($license) == "" ){
			return false;
		}
		
		$api_params = array( 
			'bskddaction' 	=> 'get_latest_info',
			'license' 		=> $license,
			'slug'			=> BSK_GFBLCV_Pro_Update_Helper::$_plugin_slug,
			'author'		=> BSK_GFBLCV_Pro_Update_Helper::$_plugin_author,
			'product_id' 	=> BSK_GFBLCV_Pro_Update_Helper::$_plugin_product_id,
            'site' => site_url()
		);

		$request = wp_remote_get( 
                                    add_query_arg( $api_params, BSK_GFBLCV_Pro_Update_Helper::$_plugin_home_url ), 
                                    array( 'timeout' => 15, 'ssverify' => false ) 
                                  );
		if ( is_wp_error( $request ) ){
			return false;
		}
		
		$data = json_decode( wp_remote_retrieve_body( $request ) );
		if( $data ){
			$data->sections = maybe_unserialize( $data->sections );
		}

		return $data;
	}
}