<?php

class BSK_GFBLCV_Pro_Update_Helper {

  public static $_plugin_name = 'BSK Forms Blacklist Pro';
	public static $_plugin_product_id = 495;
	public static $_plugin_folder = 'bsk-gravityforms-blcv-pro';
	public static $_plugin_main_file = 'bsk-gravityforms-blcv-pro.php';
	public static $_plugin_home_url = 'https://www.bannersky.com/';
	public static $_plugin_product_details_page_url = 'https://www.bannersky.com/gravity-forms-blacklist-and-custom-validation/';
	public static $_plugin_author = 'Bannersky.com';
    
    public static $_remote_purchase_history_page = 'https://www.bannersky.com/purchase-history/';
    public static $_remote_license_policy_page = 'https://www.bannersky.com/plugin-licensing/';
	public static $_remote_license_checkout_page = 'https://www.bannersky.com/refund-policy/';
	public static $_remote_account_page = 'https://www.bannersky.com/your-account/';
    
    public static $_plugin_license_n_update_page_url = '';
	public static $_plugin_slug = 'bsk-gravityforms-blcv-pro';
	
	public function __construct() {
		
        self::$_plugin_license_n_update_page_url = admin_url( 'admin.php?page='.BSK_GFBLCV_Pro_Dashboard::$_bsk_gfblcv_pages['license_update']['slug'] );
		
        add_action( 'admin_notices', array($this, 'bsk_gfblcv_admin_notice_fun') );
        //add_action( 'bsk_gfblcv_pro_action_check_license_daily_test', array( $this, 'bsk_gfblcv_admin_schedule_check_license_daily_fun') );
        add_action( 'bsk_gfblcv_admin_schedule', array( $this, 'bsk_gfblcv_admin_schedule_check_license_daily_fun') );
        if ( function_exists('wp_next_scheduled') && function_exists('wp_schedule_event') ){
			if ( !wp_next_scheduled( 'bsk_gfblcv_admin_schedule' ) ) {
				wp_schedule_event( time(), 'daily', 'bsk_gfblcv_admin_schedule' );
			}
		}
        
        add_action ( 'wp_ajax_bsk_gfblcv_refresh_license_summary', array( $this, 'bsk_gfblcv_refresh_license_summary_fun' ) );
	}
	
	function bsk_gfblcv_admin_notice_fun(){
		global $pagenow;
		
		if( 'index.php' !== $pagenow ){
			return;
		}
		$license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license, '' );
		if( $license ){
			$this->bsk_gfblcv_get_license_data( $license );
            
            $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
            if( $license_status == 'EXPIRED' ){
                $this->bsk_gfblcv_notice_expired( $license );
            }else if( $license_status == 'DISABLED' ){
                $this->bsk_gfblcv_notice_disabled();
            }
		}

		update_option("_".self::$_plugin_slug."_expired_dismissed", 0);
		update_option("_".self::$_plugin_slug."_disabled_dismissed", 0);
		
		$latest_info = $this->bsk_gfblcv_remote_get_latest_info();
		if( !$latest_info || !is_object( $latest_info ) ){
			return;
		}
		if( version_compare( BSK_GFBLCV_Pro::$_plugin_version, $latest_info->new_version, '>=' ) ) {
			return;
		}
		$this->bsk_gfblcv_notice_new_update( $latest_info->new_version, $license_status );
	}
	
	function bsk_gfblcv_notice_new_update( $new_version, $license_status ){
		$dismissed_new_versions = get_option("_".self::$_plugin_slug."_update_dismissed", '');
		if( $dismissed_new_versions && in_array($new_version, $dismissed_new_versions) ){
			//don't show if the new version message has been dismissed
			return;
		}
		
        $message = '';
        if( $license_status == 'VALID' || $license_status == 'EXPIRED' ){
            $message = "New update available for <b>".self::$_plugin_name."</b> <a href='".self::$_plugin_license_n_update_page_url."'>View Details</a>";
        }else{
            $message = "New update available for <b>".self::$_plugin_name."</b> <a href='".self::$_plugin_license_n_update_page_url."'>View Details</a>";
        }
		?>
		<div class='notice notice-info is-dismissible' style='padding:15px; position:relative;' id='_dashboard_message_<?php echo $this->_plugin_slug; ?>'>
			<?php echo $message ?>
		</div>
		<?php
	}
	
	function bsk_gfblcv_notice_expired( $license ){
		$expired_dismissed = get_option("_".self::$_plugin_slug."_expired_dismissed", 0);
		if( $expired_dismissed ){
			return;
		}
		
		$message = 'Your '.self::$_plugin_name.' license has expired. <a href="'.self::$_remote_license_policy_page.'" target="_blank">Learn more here</a>';
		$update_license_url = add_query_arg( array('bskddaction' => 'renewlicense', 'bskddlicense' => $license), 
                                                               self::$_plugin_home_url );
		?>
		<div class='notice notice-warning is-dismissible' style='padding:15px; position:relative;'>
			<?php echo $message ?>
            &nbsp;&nbsp;
            <a class='button-primary' href='<?php echo $update_license_url; ?>' target="_blank">Update license</a>
		</div>
		<?php
	}
	
	function bsk_gfblcv_notice_disabled(){
		$message = 'Your '.self::$_plugin_name.' license is disabled. <a href="'.self::$_remote_license_policy_page.'" target="_blank">Learn more here</a>';
		?>
		<div class='notice notice-error' style='padding:15px; position:relative;' id='_dashboard_invalid_message_<?php echo self::$_plugin_slug; ?>'>
			<?php echo $message ?>
            &nbsp;&nbsp;
            <a class='button-primary' href='<?php echo self::$_plugin_product_details_page_url; ?>' target="_blank">Buy a license</a>
		</div>
		<?php
	}
	
    function bsk_gfblcv_plugin_update_center(){
        ?>
        <div class="bsk-gfblcv-update-center-section" style="margin-top: 60px;">
            <h3>Update Centre</h3>
        <?php
        //check if the plugin activated manually
        if( get_option(BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived_manually, NULL) ){
        ?>
        <p>As your server cannot connect to ours well so get the latest version and update manually.</p>
        <p>Please visit <a href="<?php echo self::$_remote_purchase_history_page; ?>" target="_blank">Purchase History</a> to check if new version available or not first. If you decided to install a new version, then please follow the instucutres here.</p>
        <h3>Manually Update Steps: </h3>
        <p>1. Download the latest version package from <a href="<?php echo self::$_remote_purchase_history_page; ?>" target="_blank">Purchase History</a></p>
        <p>2. Extract the package to your local</p>
        <p>3. Upload all files in the package to your server /wp-content/plugins/<?php echo self::$_plugin_folder; ?>/, overwrite all files.</p>
        <?php
            return;
        }
        
		//get latest plugin info from server, if there's new version, show new version info
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license, NULL );
		$latest_info = $this->bsk_gfblcv_remote_get_latest_info();
		if( !$latest_info || !is_object( $latest_info ) || version_compare( BSK_GFBLCV_Pro::$_plugin_version, $latest_info->new_version, '>=' ) ){
			echo '<p>The version '.BSK_GFBLCV_Pro::$_plugin_version.' you have is the latest.</p>';
            if ( $latest_info && is_object( $latest_info ) && 
                 isset( $latest_info->sections ) && is_array( $latest_info->sections ) && isset( $latest_info->sections['changelog'] ) ) {
                
                echo '<h4>What\'s new</h4>';
                echo $latest_info->sections['changelog'];
            }
		}else{
			$this->bsk_gfblcv_update_center_show_update( $latest_info );
		}
        
        $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
        if( $license_status == 'EXPIRED' ){
            $this->bsk_gfblcv_update_center_show_expired( $license );
        }else if( $license_status == 'DISABLED' ){
            $this->bsk_gfblcv_update_center_show_disabled();
        }else if( $license_status != 'VALID' ){
            $this->bsk_gfblcv_update_center_show_purchase( $license_status );
        }
        ?>
        </div>
        <?php
	}
	
	function bsk_gfblcv_update_center_show_expired( $license ){
		$message = 'Updates are not available for '.self::$_plugin_name.' as your license has expired. <a href="'.self::$_remote_license_policy_page.'" target="_blank">Learn more here';
		$update_license_url = add_query_arg( array('bskddaction' => 'renewlicense', 'bskddlicense' => $license), 
                                                               self::$_plugin_home_url );
	?>
        <div style="width:95%; padding:20px; border: 1px solid #E6DB55; background-color: #FFFBCC; color: #424242;">
            <p><?php echo $message; ?></p>
            <a class='button-primary' href='<?php echo $update_license_url; ?>' target="_blank">Renew license here</a> &nbsp;
        </div>
    <?php
	}
	
	function bsk_gfblcv_update_center_show_disabled(){
		$message = 'Updates are not available for '.self::$_plugin_name.' as your license is disabled. <a href="'.self::$_remote_license_policy_page.'" target="_blank">Learn more here';
	?>
        <div style="width:95%; padding:20px; border: 1px solid #E6DB55; background-color: #FFFBCC; color: #424242;">
            <p><?php echo $message; ?></p>
            <a class='button-primary' href='<?php echo self::$_plugin_product_details_page_url; ?>' target="_blank">Buy a license</a> &nbsp;
        </div>
    <?php
	}
    
    function bsk_gfblcv_update_center_show_purchase( $license_status ){
        $license_status = $license_status ? $license_status : 'NONE EXISTS';
		$message = 'Updates are not available for '.self::$_plugin_name.' as your license is <span style="font-weight:bold;">'.$license_status.'</span>';
	?>
        <div style="width:95%; padding:20px; border: 1px solid #E6DB55; background-color: #FFFBCC; color: #424242;">
            <p><?php echo $message; ?></p>
            <a class='button-primary' href='<?php echo self::$_plugin_product_details_page_url; ?>' target="_blank">Buy a license</a> &nbsp;
        </div>
    <?php
	}
    
    function bsk_gfblcv_update_center_show_update( $latest_info ){
		//see if WordPress created its update array or not, if the array not exist then can not upgrade automatically
		$only_can_update_manually = false;
		$update_transient = get_site_transient( 'update_plugins' );
		if( empty( $update_transient ) ){
			$only_can_update_manually = true;
		}else{
			//To make the update works it must set the update transient data first, because WordPress will read it to download the package
			$update_transient->response[self::$_plugin_folder.'/'.self::$_plugin_main_file] = $latest_info;
			set_site_transient( 'update_plugins', $update_transient );
			
			//url to show update automatically
			$plugin_file_with_folder = self::$_plugin_folder.'/'.self::$_plugin_main_file;
			$upgrade_url = wp_nonce_url('update.php?action=upgrade-plugin&amp;plugin=' . urlencode($plugin_file_with_folder), 'upgrade-plugin_' . $plugin_file_with_folder);
		}
		?>
        <div style="width:95%; margin-top: 10px; padding: 20px; border:1px solid #ccc; background-color: #e5f3f9;">
        	<p>There is a new version of <span style="font-weight:bold;"><?php echo self::$_plugin_name.' '.$latest_info->new_version; ?></span> available. </p>
            <h3>What's New</h3>
            <?php if( isset($latest_info->sections['changelog']) ) echo $latest_info->sections['changelog']; ?>
            <?php
			//if license is expired or disabled, then don't show update tab
			$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
			if( $license_status == 'VALID' ){ 
			?>
                <h3 style="margin-top:40px;">Update</h3>
                <?php
                if( is_multisite() && !is_super_admin() ){
                    echo '<p>Only Super Admin can do plugin upgrade</p>';
                }else{
                    if( $only_can_update_manually == false ){
                ?>
                        <p>You can update to the latest version automatically.</p>
                        <a class='button-primary' href='<?php echo $upgrade_url; ?>'>Update Automatically</a> &nbsp;
                    <?php 
                    }else{ //show download manually 
                    ?>
                        <p>The WordPress automatic update feature is disabled on your site. You may download the latest version and update manually. </p>
                         <h4>Manually Update Steps: </h4>
                        <p>1. Download the latest version package from <a href="<?php echo self::$_remote_purchase_history_page; ?>" target="_blank">Purchase History</a></p>
                        <p>2. Extract the package to your local</p>
                        <p>3. Upload all files in the package to your server /wp-content/plugins/<?php echo self::$_plugin_folder; ?>/ by <b>FTP</b>, overwrite all files.</p>
                    <?php
                        if( isset($latest_info->package) && $latest_info->package ){
                            $download_page_url = $latest_info->package;
                            $target = "_blank";
                            echo '<a class="button-primary" href="'.$download_page_url.'" target="'.$target.'">Download latest package</a>';
                        }
                    } //show download manually 
                }
			}
			?>
        </div>
    <?php
	}	
	
	
	function bsk_gfblcv_remote_get_latest_info() {

        $api_params = array( 
			'bskddaction' 	=> 'get_latest_info',
			'slug'			=> self::$_plugin_slug,
			'author'		=> self::$_plugin_author,
			'product_id' 	=> self::$_plugin_product_id,
            'site' => site_url()
		);
		
		$request = wp_remote_get( add_query_arg( $api_params, self::$_plugin_home_url ), 
                                                array( 'timeout' => 15, 'ssverify' => false ) );
		if ( is_wp_error( $request ) ){
			return false;
		}
		
		$data = json_decode( wp_remote_retrieve_body( $request ) );
		if( $data ){
			$data->sections = maybe_unserialize( $data->sections );
		}

		return $data;
	}
	
	function bsk_gfblcv_get_license_data( $license ) {
		if( trim($license) == "" ){
			return false;
		}
		
		$api_params = array( 
			'bskddaction' 	=> 'check_license',
			'license' 		=> $license, 
			'product_id' 	=> self::$_plugin_product_id,
            'site'          => site_url(),
		);

        if( get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived_manually, false ) ){
			return false;
		}

        $response = wp_remote_get( add_query_arg( $api_params, self::$_plugin_home_url ), 
                                   array( 'timeout' => 15, 'ssverify' => false ) );
		if ( is_wp_error( $response ) ){
			return false;
		}

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		if( $license_data && isset($license_data->license_status) ){
			update_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts, $license_data->license_status );
            
            $license_type = isset($license_data->license_type) ? $license_data->license_type : 'PERSONAL';
            update_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, $license_type );

            $expiry_date = isset($license_data->expiry_date) ? $license_data->expiry_date : '';
            update_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_expiry_date, $expiry_date );        
		}
	}
    
    function bsk_gfblcv_admin_schedule_check_license_daily_fun(){
        //check if license key expired or not
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license, '' );
        if( trim($license) == "" ){
            return;
        }
		$this->bsk_gfblcv_get_license_data( $license );
        
    }//end of function
    
    function bsk_gfblcv_show_license_summary_fun(){
        ?>
        <div class="bsk-gfblcv-license-summary-section" style="margin-top: 60px;">
            <h3>License Summary:</h3>
            <p>
                <span style="display: inline-block; width: 150px;">Type:</span>
                <span class="bsk-gfblcv-license-type-span">
                    <?php echo get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' ); ?>
                </span>
            </p>
            <p>
                <span style="display: inline-block; width: 150px;">Expires on:</span>
                <span class="bsk-gfblcv-license-expiry-date-span">
                    <?php echo get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_expiry_date, '' ); ?>
                </span>
            </p>
            <p>
                <input type="button" class="button-secondary bsk-gfblcv-refresh-license-summary" value="Refresh" />
                <span class="bsk-gfblcv-refresh-license-summary-ajax-loader" style="margin-left: 20px; display: none;"><?php echo BSK_GFBLCV_Pro::$ajax_loader; ?></span>
            </p>
            <p class="bsk-gfblcv-error-message"></p>
            <?php $refresh_ajax_nonce = wp_create_nonce( "bsk-gfblcv-refresh-license-summary" ); ?>
            <input type="hidden" class="bsk-gfblcv-refresh-license-ajax-nonce" value="<?php echo $refresh_ajax_nonce; ?>" />
        </div>
        <?php
    }
    
    function bsk_gfblcv_refresh_license_summary_fun(){
        $data_to_return = array();
        
        if( !check_ajax_referer( 'bsk-gfblcv-refresh-license-summary', 'nonce' ) ){
            $data_to_return['success'] = false;
            $data_to_return['msg'] = 'Invalid nonce, please refresh page to try again.';
            
            wp_die( json_encode($data_to_return) );
        }

        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license, '' );
        if( trim($license) == "" ){
            
            $data_to_return['success'] = false;
            $data_to_return['msg'] = 'License NONE_EXIST';
            
            wp_die( json_encode($data_to_return) );
        }
        
		$this->bsk_gfblcv_get_license_data( $license );
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $license_expiry_date = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_expiry_date, '' );
        
        $data_to_return['success'] = true;
        $data_to_return['type'] = $license_type;
        $data_to_return['expiry_date'] = $license_expiry_date;
        
        wp_die( json_encode($data_to_return) );
    }
}
