<?php

class BSK_GFBLCV_Pro_Submitting_WPForms {
    
    var $_OBJ_common = false;
    
	public function __construct( $args ) {
        
        $this->_OBJ_common = $args['common_class'];
        
        if ( BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_is_form_plugin_supported('WPF') ) {
            add_action( 'wpforms_process_validate_text', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
            add_action( 'wpforms_process_validate_name', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
            add_action( 'wpforms_process_validate_email', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
            add_action( 'wpforms_process_validate_textarea', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
            add_action( 'wpforms_process_validate_address', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
            add_action( 'wpforms_process_validate_phone', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
            add_action( 'wpforms_process_validate_url', array( $this, 'bsk_gfblcv_front_form_validation' ), 9999, 3 );
          
            //wpforms_entry_email_process
            /*$process_email = apply_filters( 'wpforms_entry_email_process', true, $fields, $form_data, $notification_id, $context );
            if ( ! $process_email ) {
              continue;
            }*/
            add_action ( 'wpforms_entry_email_process', array( $this, 'bsk_gfblcv_front_form_validate_notification' ), 9999, 5 );

            //wpforms_process_complete
            //update hits itme for invit list in this function too
            add_action( 'wpforms_process_complete', array( $this, 'bsk_gfblcv_front_form_delte_entry' ), 9990, 4 );
            
            //wpforms_entry_confirmation_process
            /*$process_confirmation = apply_filters( 'wpforms_entry_confirmation_process', true, $this->fields, $form_data, $confirmation_id );
            if ( $process_confirmation ) {
              break;
            }*/
            add_action ( 'wpforms_entry_confirmation_process', array( $this, 'bsk_gfblcv_front_form_validate_confirmation' ), 9990, 4 );
        }
		
	}
    
	function bsk_gfblcv_front_form_validation( $field_id, $field_submit, $form_data ){

        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
        $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
        $license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
        if( trim($license) == '' || 
          $license_actived != 'ACTIVED' ||
            ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){

          return;
        }
        
        if( !isset( $form_data['settings']['bsk_gfblcv_form_settings_enable'] ) ||
            $form_data['settings']['bsk_gfblcv_form_settings_enable'] != 'ENABLE' ) {
            
            return;
        }

        //form settings
        $bsk_gfblcv_form_settings = $form_data['settings'];
      
        $enable = true;
        $action_when_hit = array();
        $validation_message_array = array();
        $validation_message_array['black'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['white'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['email'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['ip'] = 'Your IP address [VISITOR_IP] is forbidden!';
        $validation_message_array['invit'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_enable'];
            if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_actions_block'] ) &&
                $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_actions_block'] ){
                if( !in_array( 'BLOCK', $action_when_hit ) ){
                    $action_when_hit[] = 'BLOCK';
                }
            }
            
            $validation_message_array['black'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_blacklist_error_message'];
            $validation_message_array['white'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_whitelist_error_message'];
            $validation_message_array['email'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_emaillist_error_message'];
            $validation_message_array['ip'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_iplist_error_message'];
            if( isset($bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message']) && 
                $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message'] ){
                $validation_message_array['invit'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message'];
            }
        }
        
        if( !in_array( 'BLOCK', $action_when_hit ) ){
            return;
        }
        
        $field = $form_data['fields'][$field_id];
        $field_value = $field_submit;

        $return_validation_result = $this->bsk_gfblcv_front_form_validation_mapping( 
                                                                                    $form_data,
                                                                                    $field,
                                                                                    $field_value,
                                                                                    $validation_message_array,
                                                                                    true
                                                                                   );
        
		  return $return_validation_result;
	}
	
	//return ture means have kewords hit, error occur
	function bsk_gfblcv_front_form_validation_mapping( $form_data, $field, $field_value, $validation_message_array, $for_block ){
		  global $wpdb;

      $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
      $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
      $license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
      if( trim($license) == '' || 
        $license_actived != 'ACTIVED' ||
          ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
          return false;
      }
        
      $field_type = $field['type'];
      if( $field_type == 'hidden' ){
          return false;
      }

      $field_id_str = $field['id'];
      $field_label = $field['label'];
      $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
      $fields_hit_item_array = array(); //only for blocked
      $form_data_array = array();

      if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
          $form_data_array[$field_id_str] = array( 'label' => $field_label, 'value' => $field_value );
      }

      $has_failed_validation = false;
      $property_appendix = '';
      $validation_result = array();
      
      if( $field['type'] == 'name' || $field['type'] == 'address' ){
          if( is_array( $field_value ) && 
              ( ( $field['type'] == 'name' && $field['format'] != 'simple' ) || $field['type'] == 'address' ) ){
              foreach( $field_value as $sub_field_id => $sub_field_value ){
                  $field_id_str = $field['id'].'.'.$sub_field_id;

                  if( !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_type']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == '' ||
                      !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_id']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_id'] < 1 ||
                      ( !isset($field['bsk_gfblcv_'.$sub_field_id.'_comparison']) && !isset($field['bsk_gfblcv_'.$sub_field_id.'_action']) ) ||
                      ($field['bsk_gfblcv_'.$sub_field_id.'_comparison'] == '' && $field['bsk_gfblcv_'.$sub_field_id.'_action'] == '' ) ){
                      continue;
                  }

                  $property_appendix = '_'.$sub_field_id;
                  if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'BLACK_LIST' ){
                      $field['bsk_gfblcv_blacklist_chk'.$property_appendix] = 'YES';
                      $field['bsk_gfblcv_blacklist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_comparison'];
                      $field['bsk_gfblcv_blacklist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                  }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'WHITE_LIST' ){
                      $field['bsk_gfblcv_whitelist_chk'.$property_appendix] = 'YES';
                      $field['bsk_gfblcv_whitelist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_comparison'];
                      $field['bsk_gfblcv_whitelist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                  }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'EMAIL_LIST' ){
                      $field['bsk_gfblcv_emaillist_chk'.$property_appendix] = 'YES';
                      $field['bsk_gfblcv_emaillist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                      $field['bsk_gfblcv_emaillist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                  }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'IP_LIST' ){
                      $field['bsk_gfblcv_iplist_chk'.$property_appendix] = 'YES';
                      $field['bsk_gfblcv_iplist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                      $field['bsk_gfblcv_iplist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                  }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'INVIT_LIST' ){
                      $field['bsk_gfblcv_iplist_chk'.$property_appendix] = 'YES';
                      $field['bsk_gfblcv_iplist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                      $field['bsk_gfblcv_iplist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                  }
                  $field['bsk_gfblcv_validation_message'.$property_appendix] = '';
                  if( isset($field['bsk_gfblcv_'.$sub_field_id.'_validation_message']) ){
                      $field['bsk_gfblcv_validation_message'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_validation_message'];
                  }

                  $validation_return = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                $property_appendix,
                                                                $fields_hit_item_array,
                                                                $field,
                                                                $validation_result,
                                                                $field_id_str, 
                                                                $sub_field_value, 
                                                                $field_label, 
                                                                $field, 
                                                                $validation_message_array
                                                              );
                  if( $validation_return ){
                      $has_failed_validation = true;
                      if( $for_block ){
                          wpforms()->process->errors[ $form_data['id'] ][ $field['id'] ][$sub_field_id] = $validation_result['validation_message'];
                      }
                  }
              }
          }else{
              $sub_field_id = 'first';
              if( !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_type']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == '' ||
                    !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_id']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_id'] < 1 ||
                    ( !isset($field['bsk_gfblcv_'.$sub_field_id.'_comparison']) && !isset($field['bsk_gfblcv_'.$sub_field_id.'_action']) ) ||
                    ($field['bsk_gfblcv_'.$sub_field_id.'_comparison'] == '' && $field['bsk_gfblcv_'.$sub_field_id.'_action'] == '' ) ){
                    return false;
                }

                $property_appendix = '_'.$sub_field_id;
                if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'BLACK_LIST' ){
                    $field['bsk_gfblcv_blacklist_chk'.$property_appendix] = 'YES';
                    $field['bsk_gfblcv_blacklist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_comparison'];
                    $field['bsk_gfblcv_blacklist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'WHITE_LIST' ){
                    $field['bsk_gfblcv_whitelist_chk'.$property_appendix] = 'YES';
                    $field['bsk_gfblcv_whitelist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_comparison'];
                    $field['bsk_gfblcv_whitelist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'EMAIL_LIST' ){
                    $field['bsk_gfblcv_emaillist_chk'.$property_appendix] = 'YES';
                    $field['bsk_gfblcv_emaillist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                    $field['bsk_gfblcv_emaillist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'IP_LIST' ){
                    $field['bsk_gfblcv_iplist_chk'.$property_appendix] = 'YES';
                    $field['bsk_gfblcv_iplist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                    $field['bsk_gfblcv_iplist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                }else if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'INVIT_LIST' ){
                    $field['bsk_gfblcv_iplist_chk'.$property_appendix] = 'YES';
                    $field['bsk_gfblcv_iplist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                    $field['bsk_gfblcv_iplist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                }
                $field['bsk_gfblcv_validation_message'.$property_appendix] = '';
                if( isset($field['bsk_gfblcv_'.$sub_field_id.'_validation_message']) ){
                    $field['bsk_gfblcv_validation_message'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_validation_message'];
                }
                $sub_field_value = $field_value;
                $validation_return = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                              $property_appendix,
                                                              $fields_hit_item_array,
                                                              $field,
                                                              $validation_result,
                                                              $field_id_str, 
                                                              $sub_field_value, 
                                                              $field_label, 
                                                              $field, 
                                                              $validation_message_array
                                                            );
                if( $validation_return ){
                    $has_failed_validation = true;
                    if( $for_block ){
                        wpforms()->process->errors[ $form_data['id'] ][ $field['id'] ] = $validation_result['validation_message'];
                    }
                }
          }
      }else{
          $validation_return = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                            $property_appendix,
                                                            $fields_hit_item_array,
                                                            $field,
                                                            $validation_result,
                                                            $field_id_str, 
                                                            $field_value, 
                                                            $field_label, 
                                                            $field, 
                                                            $validation_message_array
                                                          );

          if( $validation_return ){
              $has_failed_validation = true;
              if( $for_block ){
                  wpforms()->process->errors[ $form_data['id'] ][ $field['id'] ] = $validation_result['validation_message'];
              }
          }
      }
        
      //insert form data and hits data into database
      //only for blocked
      if( ( $license_type == 'BUSINESS' || $license_type == 'ELITE' ) && $for_block ){

          //global settings
          $settings_data = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_settings_option, false );
          $global_save_blocked_entry = 'NO';
          $global_notify_blocked = 'NO';
          if( $settings_data && is_array( $settings_data ) && count( $settings_data ) > 0 ){
              if( isset( $settings_data['save_blocked_entry'] ) ){
                  $global_save_blocked_entry = $settings_data['save_blocked_entry'];
              }
              if( isset( $settings_data['notify_blocked'] ) ){
                  $global_notify_blocked = $settings_data['notify_blocked'];
              }
          }

          //form settings
          $bsk_gfblcv_form_settings = $form_data['settings'];

          $save_blocked_data = 'NO';
          $notify_administrators = 'NO';
          $form_notify_send_to = '';
          if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
              if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_save_blocked_data'] ) ){
                  $save_blocked_data = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_save_blocked_data'];
              }
              if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_notify_administrators'] ) ){
                  $notify_administrators = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_notify_administrators'];
              }
              if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_notify_send_to'] ) ){
                  $form_notify_send_to = $bsk_gfblcv_form_settings['bsk_gfblcv_notify_send_to'];
              }
          }

          //get final settings
          $final_save_blocked_form_data = true;
          $final_notify_administrators = false;
          if( $global_save_blocked_entry == 'NO' || $save_blocked_data == 'NO' ){
              $final_save_blocked_form_data = false;
          }
          if( $global_notify_blocked == 'YES' && $notify_administrators == 'YES' ){
              $final_notify_administrators = true;
          }

          if( $fields_hit_item_array && is_array( $fields_hit_item_array ) && count( $fields_hit_item_array ) > 0 ){
              //save hits data
              if( $final_save_blocked_form_data ){
                  $form_data_array['form_id'] = $form_data['id'];
                  $this->_OBJ_common->bsk_gfblcv_save_blocked_form_data( $fields_hit_item_array, $form_data_array, 'WPF' );
              }

              //send out administrator notifications
              if( $final_notify_administrators ){
                  $this->_OBJ_common->bsk_gfblcv_notify_administrators( $form_notify_send_to, $form_data['settings']['form_title'], $form_data_array, $fields_hit_item_array, 'WPF' );
              }
          }

      }
      
      return $has_failed_validation;
	}
    
    function bsk_gfblcv_check_field_value_againsit_list_item( $property_appendix,
                                                              &$fields_hit_item_array,
                                                              $field,
                                                              &$validation_result,
                                                              $field_id_str, 
                                                              $field_value, 
                                                              $field_label, 
                                                              $field_obj_array, 
                                                              $validation_message_array ){
        
        global $wpdb;
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        
        $list_id_to_check = '';
        $comparison_to_check = '';
        $validation_message = '';
        $list_type = '';
        
        if( isset($field_obj_array['bsk_gfblcv_blacklist_chk'.$property_appendix]) &&
            $field_obj_array['bsk_gfblcv_blacklist_chk'.$property_appendix] &&
            $field_obj_array['bsk_gfblcv_blacklist_chk'.$property_appendix] == 'YES' &&
            isset($field_obj_array['bsk_gfblcv_blacklist_comparison'.$property_appendix]) && 
            $field_obj_array['bsk_gfblcv_blacklist_comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfblcv_blacklist_list'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfblcv_blacklist_comparison'.$property_appendix];
            $list_type = 'BLACK_LIST';
        }else if( isset($field_obj_array['bsk_gfblcv_whitelist_chk'.$property_appendix]) &&
                  $field_obj_array['bsk_gfblcv_whitelist_chk'.$property_appendix] &&
                  $field_obj_array['bsk_gfblcv_whitelist_chk'.$property_appendix] == 'YES' &&
                  isset($field_obj_array['bsk_gfblcv_whitelist_comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfblcv_whitelist_comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfblcv_whitelist_list'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfblcv_whitelist_comparison'.$property_appendix];
            $list_type = 'WHITE_LIST';
        }else if( isset($field_obj_array['bsk_gfblcv_emaillist_chk'.$property_appendix]) &&
                  $field_obj_array['bsk_gfblcv_emaillist_chk'.$property_appendix] &&
                  $field_obj_array['bsk_gfblcv_emaillist_chk'.$property_appendix] == 'YES' &&
                  isset($field_obj_array['bsk_gfblcv_emaillist_comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfblcv_emaillist_comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfblcv_emaillist_list'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfblcv_emaillist_comparison'.$property_appendix];
            $list_type = 'EMAIL_LIST';
        }else if( isset($field_obj_array['bsk_gfblcv_iplist_chk'.$property_appendix]) &&
                  $field_obj_array['bsk_gfblcv_iplist_chk'.$property_appendix] &&
                  $field_obj_array['bsk_gfblcv_iplist_chk'.$property_appendix] == 'YES' &&
                  isset($field_obj_array['bsk_gfblcv_iplist_comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfblcv_iplist_comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfblcv_iplist_list'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfblcv_iplist_comparison'.$property_appendix];
            $list_type = 'IP_LIST';
            $field_value = wpforms_get_ip();
        }else if( isset($field_obj_array['bsk_gfblcv_invitlist_chk'.$property_appendix]) &&
                  $field_obj_array['bsk_gfblcv_invitlist_chk'.$property_appendix] &&
                  $field_obj_array['bsk_gfblcv_invitlist_chk'.$property_appendix] == 'YES' &&
                  isset($field_obj_array['bsk_gfblcv_invitlist_comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfblcv_invitlist_comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfblcv_invitlist_list'.$property_appendix];
            $comparison_to_check = 'ALLOW'; //$field_obj_array['bsk_gfblcv_invitlist_comparison'.$property_appendix];
            $list_type = 'INVIT_LIST';
        }
        
        if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
            $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
        }
        if( trim( $validation_message ) == '' ){
            $validation_message = $validation_message_array['black'];
        }

        $invalid_validation = false;
        if( $field_value == "" || $list_type == '' ){
            return $invalid_validation;
        }

        if( !$list_id_to_check || !$comparison_to_check ){
            return $invalid_validation;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return $invalid_validation;
        }
        
        $validation_message = $this->_OBJ_common->bsk_gfblcv_render_validation_message( 
                                                                                    $validation_message, 
                                                                                    $field_label, 
                                                                                    $field_value, 
                                                                                    wpforms_get_ip() 
                                                                                );
        
        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array($checked_results) && count($checked_results) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
        }
        
        switch( $list_type ){
            case 'BLACK_LIST':
                if( $checked_results ){
                    
                    $validation_result['validation_message'] = $validation_message;
                    $invalid_validation = true;

                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_id_str] = array( 
                                                                        'list_id' => $list_id_to_check, 
                                                                        'items_id' => explode( ',', $item_id_str ),
                                                                        'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                    );
                    }
                }
            break;
            case 'WHITE_LIST':
                if( ! $checked_results ){
                    
                    $validation_result['validation_message'] = $validation_message;
                    $invalid_validation = true;

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => array( -1 ), 
                                                                            'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                        );
                    }
                }else{
                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                }
            break;
            case 'IP_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){
                        
                        $validation_result['validation_message'] = $validation_message;
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => array( -2 ), 
                                                                                'extra_data' => array( 'mode' => 'ALLOW' )
                                                                            );
                        }

                        break;
                    }else if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ) {
                        //for the case by country, it only return true or false, so won't come to here
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){
                        
                        $validation_result['validation_message'] = $validation_message;
                        $invalid_validation = true;

                        $blocked_item_id_to_save = array( -2 ); //default -2 is for IP list COUNTRY check way
                        if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ){
                            //for the case by country, it only return true or false, so won't come to here
                            //update hits counter
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                            $blocked_item_id_to_save = explode( ',', $item_id_str );
                        }

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => $blocked_item_id_to_save, 
                                                                                'extra_data' => array( 'mode' => 'BLOCK' )
                                                                            );
                        }
                    }
                }
            break;
            case 'EMAIL_LIST':
            case 'INVIT_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){
                        
                        $validation_result['validation_message'] = $validation_message;
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                            'list_id' => $list_id_to_check, 
                                                                                            'items_id' => array( -1 ), 
                                                                                            'extra_data' => array( 'mode' => 'ALLOW' )
                                                                                        );
                        }

                        break;
                    }else{
                        //update hits counter, invit codes list will be updated to entry id at the last
                        if( $list_type != 'INVIT_LIST' ){
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                        }
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){
                        
                        $validation_result['validation_message'] = $validation_message;
                        $invalid_validation = true;
                        
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => explode( ',', $item_id_str ), 
                                                                            'extra_data' => array( 'mode' => 'BLOCK' )
                                                                         );
                        }
                    }
                }
            break;
        }
        
        return $invalid_validation;
    }
  
    function bsk_gfblcv_front_form_validate_notification( $process, $fields, $form_data, $notification_id, $context ){
        return $this->bsk_gfblcv_front_form_validate_notification_confirmation( $process, $fields, $form_data, $notification_id, 'notification' );
    }
  
    function bsk_gfblcv_front_form_validate_confirmation( $process, $fields, $form_data, $confirmation_id ){
        
        return $this->bsk_gfblcv_front_form_validate_notification_confirmation( $process, $fields, $form_data, $confirmation_id, 'confirmation' );
    }
	 
    function bsk_gfblcv_front_form_validate_notification_confirmation( $process, $fields, $form_data, $notification_confirmation_id, $type ){
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
        $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
        $license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
        if( trim($license) == '' || 
          $license_actived != 'ACTIVED' ||
            ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){

            return $process;
        }
        
        if( !isset( $form_data['settings']['bsk_gfblcv_form_settings_enable'] ) ||
            $form_data['settings']['bsk_gfblcv_form_settings_enable'] != 'ENABLE' ) {
            
            return $process;
        }

        //form settings
        $bsk_gfblcv_form_settings = $form_data['settings'];
      
        $enable = true;
        $action_when_hit = array();
        $validation_message_array = array();
        $validation_message_array['black'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['white'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['email'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['ip'] = 'Your IP address [VISITOR_IP] is forbidden!';
        $validation_message_array['invit'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        
        $skip_notifiction_ids = array();
        $go_confirmation_ids = array();
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_enable'];
            if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_actions_skip'] ) &&
                $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_actions_skip'] ){
                if( !in_array( 'SKIP', $action_when_hit ) ){
                    $action_when_hit[] = 'SKIP';
                }
              
                //process skipped notification id
                foreach( $bsk_gfblcv_form_settings['notifications'] as $notification_id => $notification ){
                    if( isset($bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_skip_notifications_'.$notification_id]) && 
                        $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_skip_notifications_'.$notification_id] ){
                        $skip_notifiction_ids[] = $notification_id;
                    }
                }
            }
            if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_actions_confirmation'] ) &&
                $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_actions_confirmation'] ){
                if( !in_array( 'CONFIRMATION', $action_when_hit ) ){
                    $action_when_hit[] = 'CONFIRMATION';
                }
                //process confirmation id
                foreach( $bsk_gfblcv_form_settings['confirmations'] as $confirmation_id => $confirmation ){
                    if( isset($bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_skip_confirmations_'.$confirmation_id]) && 
                        $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_skip_confirmations_'.$confirmation_id] ){
                        $go_confirmation_ids[] = $confirmation_id;
                        break;
                    }
                }
            }
            
            $validation_message_array['black'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_blacklist_error_message'];
            $validation_message_array['white'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_whitelist_error_message'];
            $validation_message_array['email'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_emaillist_error_message'];
            $validation_message_array['ip'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_iplist_error_message'];
            if( isset($bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message']) && 
                $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message'] ){
                $validation_message_array['invit'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message'];
            }
        }
        
        if( $type == 'notification' ){
            if( !in_array( 'SKIP', $action_when_hit ) || !in_array( $notification_confirmation_id, $skip_notifiction_ids ) ){
                return $process;
            }
        }else if ( $type == 'confirmation' ){
            $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
            if( $license_type == 'PERSONAL' ){
                return $process;
            }
            if( count( $go_confirmation_ids ) < 1 || !in_array( 'CONFIRMATION', $action_when_hit ) ){
                return $process;
            }
        }
        
        $has_list_hit = false;
        foreach( $form_data['fields'] as $field_id => $field ){
            $field_value = $fields[$field_id]['value'];
            if( $field['type'] == 'name' ){
                $field_value = $this->bsk_gfblcv_organize_name_value( $fields[$field_id], $field );
            }else if( $field['type'] == 'address' ){
                $field_value = $this->bsk_gfblcv_organize_address_value( $fields[$field_id], $field );
            }
            $has_list_hit = $this->bsk_gfblcv_front_form_validation_mapping( 
                                                                              $form_data,
                                                                              $field,
                                                                              $field_value,
                                                                              $validation_message_array,
                                                                              false
                                                                             );
            if( $has_list_hit ){
                break;
            }
        }
        
        if( $type == 'notification' ){
            return !$has_list_hit;
        }else if( $type == 'confirmation' ){
            return !$has_list_hit;
        }
		    
        return $process;
    }
    
    function bsk_gfblcv_front_form_delte_entry( $fields, $entry, $form_data, $entry_id ){
        /*
         * this function will process delete entry
         * this function will process update invitaiton code hits
         */
        if( !$entry || $entry_id < 1 ){
            //wpforms lite version $entry_id is 0
            //return;
        }
        
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
        $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
        $license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
        if( trim($license) == '' || 
            $license_actived != 'ACTIVED' ||
            ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            return;
        }
        
        if( !isset( $form_data['settings']['bsk_gfblcv_form_settings_enable'] ) ||
            $form_data['settings']['bsk_gfblcv_form_settings_enable'] != 'ENABLE' ) {
            return;
        }
        
        //form settings
        $bsk_gfblcv_form_settings = $form_data['settings'];
        
        $validation_message_array = array();
        $validation_message_array['black'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['white'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['email'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['ip'] = 'Your IP address [VISITOR_IP] is forbidden!';
        $validation_message_array['invit'] = 'The value for field "[FIELD_LABEL]" is invalid!';
      
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            
            $validation_message_array['black'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_blacklist_error_message'];
            $validation_message_array['white'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_whitelist_error_message'];
            $validation_message_array['email'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_emaillist_error_message'];
            $validation_message_array['ip'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_iplist_error_message'];
            if( isset($bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message']) &&
                $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message'] ){
                
                $validation_message_array['invit'] = $bsk_gfblcv_form_settings['bsk_gfblcv_form_settings_invitlist_error_message'];
            }
        }
        foreach( $form_data['fields'] as $field_id => $field ){
            if( !isset( $entry['fields'][$field_id] ) ){
                continue;
            }
            $field_value = $entry['fields'][$field_id];
            $has_list_hit = $this->bsk_gfblcv_front_form_validation_mapping( 
                                                                              $form_data,
                                                                              $field,
                                                                              $field_value,
                                                                              $validation_message_array,
                                                                              false
                                                                             );
            if( $has_list_hit ){
              
                if( ( wpforms()->entry && is_object( wpforms()->entry ) ) && 
                    ( ( wpforms()->entry_meta ) && is_object( wpforms()->entry_meta ) ) && 
                    ( ( wpforms()->entry_fields ) && is_object( wpforms()->entry_fields ) ) ){
                    
                    if( isset( $form_data['settings']['bsk_gfblcv_form_settings_actions_block'] ) &&
                        $form_data['settings']['bsk_gfblcv_form_settings_actions_block'] == 1 ){

                        continue;
                    }
                    
                    if( isset( $bsk_gfblcv_form_settings['bsk_gfblcv_wpform_settings_delete_entry'] ) &&
                        $bsk_gfblcv_form_settings['bsk_gfblcv_wpform_settings_delete_entry'] == 'YES' ){
                        //delete entry
                        $entry  = wpforms()->entry->delete( $entry_id );
                        $meta   = wpforms()->entry_meta->delete_by( 'entry_id', $entry_id );
                        $fields = wpforms()->entry_fields->delete_by( 'entry_id', $entry_id );
                    }
                }
                
            }else{
                //valid passed, update hits for invit code here
                $this->bsk_gfblcv_update_invit_list_item_hits( 
                                                              $form_data,
                                                              $field,
                                                              $field_value,
                                                              $entry_id
                                                             );
            }
        }

    }
  
    function bsk_gfblcv_organize_name_value( $field_values, $field ){
        if( $field['format'] == 'simple' ){
            return $field_values['value'];
        }
        
        $format_a = explode( '-', $field['format'] );
        
        $value = array();
        foreach( $format_a as $key ){
            if( isset( $field_values[$key] ) ){
                $value[$key] = $field_values[$key];
            }
        }
      
        return $value;
    }
    
    function bsk_gfblcv_organize_address_value( $field_values, $field ){
        $format_a = array( 'address1', 'address2', 'city', 'state', 'postal' );
        if( $field['scheme'] == 'international' ){
            $format_a[] = 'country';
        }
        $value = array();
        foreach( $format_a as $key ){
            if( isset( $field_values[$key] ) ){
                $value[$key] = $field_values[$key];
            }
        }
      
        return $value;
    }
    
    function bsk_gfblcv_update_invit_list_item_hits( $form_data, $field, $field_value, $entry_id ){
      global $wpdb;

      $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
      $license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
      $license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
      if( trim($license) == '' || 
        $license_actived != 'ACTIVED' ||
          ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
          return false;
      }
        
      $field_type = $field['type'];
      if( $field_type == 'hidden' ){
          return false;
      }

      $field_id_str = $field['id'];
      $field_label = $field['label'];
      $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
      $fields_hit_item_array = array(); //only for blocked

      $has_failed_validation = false;
      $property_appendix = '';
      $validation_result = array();
      
      if( $field['type'] == 'name' || $field['type'] == 'address' ){
          if( is_array( $field_value ) && 
              ( ( $field['type'] == 'name' && $field['format'] != 'simple' ) || $field['type'] == 'address' ) ){
              foreach( $field_value as $sub_field_id => $sub_field_value ){
                  $field_id_str = $field['id'].'.'.$sub_field_id;

                  if( !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_type']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == '' ||
                      !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_id']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_id'] < 1 ||
                      ( !isset($field['bsk_gfblcv_'.$sub_field_id.'_comparison']) && !isset($field['bsk_gfblcv_'.$sub_field_id.'_action']) ) ||
                      ($field['bsk_gfblcv_'.$sub_field_id.'_comparison'] == '' && $field['bsk_gfblcv_'.$sub_field_id.'_action'] == '' ) ){
                      continue;
                  }
                  
                  $list_id_to_check = 0;
                  $list_type = '';
                  $property_appendix = '_'.$sub_field_id;
                  if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'INVIT_LIST' ){
                      $list_type = 'INVIT_LIST';
                      $list_id_to_check = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                      
                      $field['bsk_gfblcv_iplist_chk'.$property_appendix] = 'YES';
                      $field['bsk_gfblcv_iplist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                      $field['bsk_gfblcv_iplist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                  }
                  
                      
                    //check if the list still active, as some case the list deleted but it still save in form settings
                    if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
                        return;
                    }
                  
                    $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                                    $list_type,
                                                                    $list_id_to_check, 
                                                                    $comparison_to_check, 
                                                                    $field_value
                                                                );
                    $item_id_str = '';
                    if( $checked_results ){
                        if( is_array($checked_results) && count($checked_results) > 0 ){
                            $item_id_str = implode( ',', $checked_results );
                        }else{
                            $item_id_str = $checked_results;
                        }
                        if( $entry_id == 0 ){
                            $entry_id = -1;
                        }
                        //update hits to entry id
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits_to( $item_id_str, $form_data['id'], $entry_id, 'WPF' );
                    }
              }
          }else{
              $sub_field_id = 'first';
              if( !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_type']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == '' ||
                    !isset($field['bsk_gfblcv_'.$sub_field_id.'_list_id']) || $field['bsk_gfblcv_'.$sub_field_id.'_list_id'] < 1 ||
                    ( !isset($field['bsk_gfblcv_'.$sub_field_id.'_comparison']) && !isset($field['bsk_gfblcv_'.$sub_field_id.'_action']) ) ||
                    ($field['bsk_gfblcv_'.$sub_field_id.'_comparison'] == '' && $field['bsk_gfblcv_'.$sub_field_id.'_action'] == '' ) ){
                    return false;
                }
                
                $list_id_to_check = 0;
                $list_type = '';
                $property_appendix = '_'.$sub_field_id;
                if( $field['bsk_gfblcv_'.$sub_field_id.'_list_type'] == 'INVIT_LIST' ){
                    $list_type = 'INVIT_LIST';
                    $list_id_to_check = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                    
                    $field['bsk_gfblcv_iplist_chk'.$property_appendix] = 'YES';
                    $field['bsk_gfblcv_iplist_comparison'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_action'];
                    $field['bsk_gfblcv_iplist_list'.$property_appendix] = $field['bsk_gfblcv_'.$sub_field_id.'_list_id'];
                }
              
                //check if the list still active, as some case the list deleted but it still save in form settings
                if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
                    return;
                }

                $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                                $list_type,
                                                                $list_id_to_check, 
                                                                $comparison_to_check, 
                                                                $field_value
                                                            );
                $item_id_str = '';
                if( $checked_results ){
                    if( is_array($checked_results) && count($checked_results) > 0 ){
                        $item_id_str = implode( ',', $checked_results );
                    }else{
                        $item_id_str = $checked_results;
                    }
                    if( $entry_id == 0 ){
                        $entry_id = -1;
                    }
                    //update hits to entry id
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits_to( $item_id_str, $orm_data['id'], $entry_id, 'WPF' );
                }
               
          }
      }else{
          $list_id_to_check = 0;
          $list_type = '';
          $comparison_to_check = '';
          $property_appendix = '';
          if( isset($field['bsk_gfblcv_invitlist_chk'.$property_appendix]) &&
              $field['bsk_gfblcv_invitlist_chk'.$property_appendix] &&
              $field['bsk_gfblcv_invitlist_chk'.$property_appendix] == 'YES' &&
              isset($field['bsk_gfblcv_invitlist_comparison'.$property_appendix]) && 
              $field['bsk_gfblcv_invitlist_comparison'.$property_appendix] ){

                $list_id_to_check = $field['bsk_gfblcv_invitlist_list'.$property_appendix];
                $comparison_to_check = 'ALLOW'; //field['bsk_gfblcv_invitlist_comparison'.$property_appendix];
                $list_type = 'INVIT_LIST';
            }

            //check if the list still active, as some case the list deleted but it still save in form settings
            if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
                return;
            }

            $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                            $list_type,
                                                            $list_id_to_check, 
                                                            $comparison_to_check, 
                                                            $field_value
                                                        );
            $item_id_str = '';
            if( $checked_results ){
                if( is_array($checked_results) && count($checked_results) > 0 ){
                    $item_id_str = implode( ',', $checked_results );
                }else{
                    $item_id_str = $checked_results;
                }
                if( $entry_id == 0 ){
                    $entry_id = -1;
                }
                //update hits to entry id
                $this->_OBJ_common->bsk_gfblcv_update_item_hits_to( $item_id_str, $form_data['id'], $entry_id, 'WPF' );
            }
      }
      
      return;
	}
    
}
