<?php

class BSK_GFBLCV_Pro_Submitting_GravityForms {
    
    var $_OBJ_common = false;

	public function __construct( $args ) {
        
        $this->_OBJ_common = $args['common_class'];
        
        if ( BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_is_form_plugin_supported('GF') ) {
            add_filter( 'gform_validation', array($this, 'bsk_gfblcv_front_form_validation'), 10, 1 );
            add_filter( 'gform_disable_notification', array($this, 'bsk_gfblcv_disable_notification'), 10, 4 );
            add_filter( 'gform_confirmation', array($this, 'bsk_gfblcv_change_confirmation'), 10, 4 );
            add_action( 'gform_after_submission', array( $this, 'bsk_gfblcv_remove_form_entry' ), 10, 2 );
            add_action( 'gform_after_submission', array( $this, 'bsk_gfblcv_update_invit_list_items_hits_data' ), 999999, 2 );
        }
		
	}
	
	function bsk_gfblcv_front_form_validation( $validation_result ){
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
			return $validation_result;
		}

        $form = $validation_result['form'];
        
        //check a reCAPTCHA field exist and failed to validate, if so then return.
        foreach( $form['fields'] as $field_obj ){
            if( $field_obj->type != 'captcha' ){
                continue;
            }
            if( isset($field_obj->failed_validation) && $field_obj->failed_validation ){
                return $validation_result;
            }
        }
        
        //form settings
        $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );

        $enable = true;
        $action_when_hit = array( 'BLOCK' );
        $validation_message_array = array();
        $validation_message_array['black'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['white'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['email'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['ip'] = 'Your IP address [VISITOR_IP] is forbidden!';
        $validation_message_array['invit'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $validation_message_array['black'] = $bsk_gfblcv_form_settings['blacklist_message'];
            $validation_message_array['white'] = $bsk_gfblcv_form_settings['whitelist_message'];
            $validation_message_array['email'] = $bsk_gfblcv_form_settings['emaillist_message'];
            $validation_message_array['ip'] = $bsk_gfblcv_form_settings['iplist_message'];
            if( isset($bsk_gfblcv_form_settings['invitlist_message']) && 
                $bsk_gfblcv_form_settings['invitlist_message'] ){
                $validation_message_array['invit'] = $bsk_gfblcv_form_settings['invitlist_message'];
            }
        }else{
            //compatible with old savd data format
            if( isset( $form['block_or_skip_notification'] ) && $form['block_or_skip_notification'] == 'SKIP' ) {
                $action_when_hit = array( 'SKIP' ); 
            }
            
            if( isset( $form['bsk_gfblcv_validation_message'] ) && $form['bsk_gfblcv_validation_message'] ) {
                $validation_message_array['black'] = $form['bsk_gfblcv_validation_message'];
            }
            
            if( isset( $form['whitelist_validation_message'] ) && $form['whitelist_validation_message'] ) {
                $validation_message_array['white'] = $form['whitelist_validation_message'];
            }
            
            if( isset( $form['emaillist_validation_message'] ) && $form['emaillist_validation_message'] ) {
                $validation_message_array['email'] = $form['emaillist_validation_message'];
            }
            
            if( isset( $form['iplist_validation_message'] ) && $form['iplist_validation_message'] ) {
                $validation_message_array['ip'] = $form['iplist_validation_message'];
            }
        }
        
        if( !$enable ){
            return $validation_result;
        }
        
        if( !in_array( 'BLOCK', $action_when_hit ) ){
            return $validation_result;
        }

        $return_validation_result = $this->bsk_gfblcv_front_form_validation_mapping( 
                                                                                    $validation_result,
                                                                                    $validation_message_array
                                                                                   );
        
		return $return_validation_result;
	}
	
	
	function bsk_gfblcv_front_form_validation_mapping( $validation_result, $validation_message_array ){
		global $wpdb;

        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
			return $validation_result;
		}
		
		$form = $validation_result['form'];
		//validation
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $fields_hit_item_array = array(); //only for blocked
        $form_data_array = array();
		$current_page = rgpost( 'gform_source_page_number_' . $form['id'] ) ? rgpost( 'gform_source_page_number_' . $form['id'] ) : 1;
		foreach( $form['fields'] as $field ){
			if ( $current_page != $field->pageNumber ) {
				continue;
			}
            
			if( $field->is_field_hidden ){
                continue;
            }
            
			$field_obj_array = json_decode( json_encode($field), true );
			if( $field->type == 'name' || 
                $field->type == 'address' || 
                $field->type == 'checkbox' ||
                $field->type == 'time' ){
                //checkbox will come to here
                //let empty value can be checked for supporting checkbox_all rule
				foreach($field['inputs'] as $gravity_form_field_input) {
					if( isset($gravity_form_field_input['isHidden']) && $gravity_form_field_input['isHidden'] ){
						continue;
					}
                    
					$field_id_str = $gravity_form_field_input['id'];
                    
					$field_value = rgpost( 'input_'.str_replace( '.', '_', $field_id_str) );
                    $field_label = $field['label'].'.'.$gravity_form_field_input['label'];
                    
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $form_data_array[$field_id_str] = array( 'label' => $field_label, 'value' => $field_value );
                    }
                    
                    $property_appendix = '_'.$field_id_str;
                    
                    $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str, 
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
				}//end of foreach
			}else{
				$field_id_str = $field['id'];
				$field_value = rgpost( 'input_'.$field_id_str );
                $field_label = $field['label'];
                
                if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                    $form_data_array[$field_id_str] = array( 'label' => $field_label, 'value' => $field_value );
                }
                
                $property_appendix = '';

                $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field,
                                                                      $validation_result,
                                                                      $field_id_str, 
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                
			}//end of multiple inputs filed or single field
		}
        
        //insert form data and hits data into database
        //only for blocked
        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
            
            //global settings
            $settings_data = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_settings_option, false );
            $global_save_blocked_entry = 'NO';
            $global_notify_blocked = 'NO';
            if( $settings_data && is_array( $settings_data ) && count( $settings_data ) > 0 ){
                if( isset( $settings_data['save_blocked_entry'] ) ){
                    $global_save_blocked_entry = $settings_data['save_blocked_entry'];
                }
                if( isset( $settings_data['notify_blocked'] ) ){
                    $global_notify_blocked = $settings_data['notify_blocked'];
                }
            }
            
            //form settings
            $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );

            $save_blocked_data = 'NO';
            $notify_administrators = 'NO';
            $form_notify_send_to = '';
            $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );
            if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
                $save_blocked_data = $bsk_gfblcv_form_settings['save_blocked_data'];
                $notify_administrators = $bsk_gfblcv_form_settings['notify_administrators'];
                $form_notify_send_to = $bsk_gfblcv_form_settings['notify_send_to'];
            }
            
            //get final settings
            $final_save_blocked_form_data = true;
            $final_notify_administrators = false;
            if( $global_save_blocked_entry == 'NO' || $save_blocked_data == 'NO' ){
                $final_save_blocked_form_data = false;
            }
            if( $global_notify_blocked == 'YES' && $notify_administrators == 'YES' ){
                $final_notify_administrators = true;
            }
            
            if( $fields_hit_item_array && is_array( $fields_hit_item_array ) && count( $fields_hit_item_array ) > 0 ){
                //save hits data
                if( $final_save_blocked_form_data ){
                    $form_data_array['form_id'] = $form['id'];
                    $this->_OBJ_common->bsk_gfblcv_save_blocked_form_data( $fields_hit_item_array, $form_data_array, 'GF' );
                }
                
                //send out administrator notifications
                if( $final_notify_administrators ){
                    $this->_OBJ_common->bsk_gfblcv_notify_administrators( $form_notify_send_to, $form['title'], $form_data_array, $fields_hit_item_array, 'GF' );
                }
            }
            
        }

        $validation_result['form'] = $form;
		return $validation_result;
	}
    
    function bsk_gfblcv_check_field_value_againsit_list_item( $property_appendix,
                                                              &$fields_hit_item_array,
                                                              &$field,
                                                              &$validation_result,
                                                              $field_id_str, 
                                                              $field_value, 
                                                              $field_label, 
                                                              $field_obj_array, 
                                                              $validation_message_array ){
        
        global $wpdb;
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        
        $list_id_to_check = '';
        $comparison_to_check = '';
        $validation_message = '';
        $list_type = '';
        
        if( isset($field_obj_array['bsk_gfbl_apply_blacklist_Property'.$property_appendix]) &&
            $field_obj_array['bsk_gfbl_apply_blacklist_Property'.$property_appendix] &&
            isset($field_obj_array['bsk_gfbl_apply_blacklist_Comparison'.$property_appendix]) && 
            $field_obj_array['bsk_gfbl_apply_blacklist_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_blacklist_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_blacklist_Comparison'.$property_appendix];
            $list_type = 'BLACK_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['black'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_white_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_white_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_white_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_white_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_white_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_white_list_Comparison'.$property_appendix];
            $list_type = 'WHITE_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['white'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_email_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_email_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_email_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_email_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_email_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_email_list_Comparison'.$property_appendix];
            $list_type = 'EMAIL_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['email'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_ip_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_ip_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_ip_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_ip_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_ip_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_ip_list_Comparison'.$property_appendix];
            $list_type = 'IP_LIST';
            $field_value = GFFormsModel::get_ip();

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['ip'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix];
            $list_type = 'INVIT_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['invit'];
            }
        }

        $invalid_validation = false;
        if( $field_value == "" || $list_type == '' ){
            return $invalid_validation;
        }

        if( !$list_id_to_check || !$comparison_to_check ){
            return $invalid_validation;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return $invalid_validation;
        }

        $validation_message = $this->_OBJ_common->bsk_gfblcv_render_validation_message( 
                                                                                    $validation_message, 
                                                                                    $field_label, 
                                                                                    $field_value, 
                                                                                    GFFormsModel::get_ip() 
                                                                                );
        
        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array($checked_results) && count($checked_results) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
        }
        
        switch( $list_type ){
            case 'BLACK_LIST':
                if( $checked_results ){
                    $validation_result['is_valid'] = false;
                    $field['failed_validation'] = true;
                    $field['validation_message'] = $validation_message;
                    
                    $invalid_validation = true;

                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_id_str] = array( 
                                                                        'list_id' => $list_id_to_check, 
                                                                        'items_id' => explode( ',', $item_id_str ),
                                                                        'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                    );
                    }
                }
            break;
            case 'WHITE_LIST':
                if( ! $checked_results ){
                    $validation_result['is_valid'] = false;
                    $field['failed_validation'] = true;
                    $field['validation_message'] = $validation_message;
                    
                    $invalid_validation = true;

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => array( -1 ), 
                                                                            'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                        );
                    }
                }else{
                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                }
            break;
            case 'IP_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){
                        $validation_result['is_valid'] = false;
                        $field['failed_validation'] = true;
                        $field['validation_message'] = $validation_message;
                        
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => array( -2 ), 
                                                                                'extra_data' => array( 'mode' => 'ALLOW' )
                                                                            );
                        }

                        break;
                    }else if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ) {
                        //for the case by country, it only return true or false, so won't come to here
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){
                        $validation_result['is_valid'] = false;
                        $field['failed_validation'] = true;
                        $field['validation_message'] = $validation_message;
                        
                        $invalid_validation = true;

                        $blocked_item_id_to_save = array( -2 ); //default -2 is for IP list COUNTRY check way
                        if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ){
                            //for the case by country, it only return true or false, so won't come to here
                            //update hits counter
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                            $blocked_item_id_to_save = explode( ',', $item_id_str );
                        }

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => $blocked_item_id_to_save, 
                                                                                'extra_data' => array( 'mode' => 'BLOCK' )
                                                                            );
                        }
                    }
                }
            break;
            case 'EMAIL_LIST':
            case 'INVIT_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){
                        $validation_result['is_valid'] = false;
                        $field['failed_validation'] = true;
                        $field['validation_message'] = $validation_message;
                        
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => array( -1 ), 
                                                                            'extra_data' => array( 'mode' => 'ALLOW' )
                                                                         );
                        }

                        break;
                    }else{
                        //update hits counter, invit codes list will be updated to entry id at the last
                        if( $list_type != 'INVIT_LIST' ){
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                        }
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){
                        $validation_result['is_valid'] = false;
                        $field['failed_validation'] = true;
                        $field['validation_message'] = $validation_message;
                        
                        $invalid_validation = true;
                        
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => explode( ',', $item_id_str ), 
                                                                            'extra_data' => array( 'mode' => 'BLOCK' )
                                                                         );
                        }
                    }
                }
            break;
        }
        
        return $invalid_validation;
    }
	
	function bsk_gfblcv_disable_notification( $is_disabled, $notification, $form, $entry ) {
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
			return $is_disabled;
		}

        //form settings
        $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );

        $enable = true;
        $action_when_hit = array();
        $notifications_to_skip = array();
        
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $notifications_to_skip = $bsk_gfblcv_form_settings['notification_to_skip'];
        }else{
            //compatible with old savd data format
            if( isset( $form['block_or_skip_notification'] ) && $form['block_or_skip_notification'] == 'SKIP' ) {
                $action_when_hit = array( 'SKIP' ); 
            }
            if( isset( $form['notifications_to_skip'] ) && $form['notifications_to_skip'] ) {
                $notifications_to_skip = $form['notifications_to_skip'];
            }
        }
        
        if( !$enable || !in_array( 'SKIP', $action_when_hit ) || !in_array( $notification['id'], $notifications_to_skip ) ){
            return $is_disabled;
        }

        $invalid_validation = false;
        $validation_result = array();
        $validation_message_array = array();
        $validation_message_array['black'] = '';
        $validation_message_array['white'] = '';
        $validation_message_array['email'] = '';
        $validation_message_array['ip'] = '';
        $validation_message_array['invit'] = '';
        
		//validation
        $fields_hit_item_array = array(); //only for blocked
		$current_page = rgpost( 'gform_source_page_number_' . $form['id'] ) ? rgpost( 'gform_source_page_number_' . $form['id'] ) : 1;
		foreach( $form['fields'] as $field ){
			if ( $current_page != $field->pageNumber ) {
				continue;
			}
			
			$field_obj_array = json_decode( json_encode($field), true );
			if( $field->type == 'name' || 
                $field->type == 'address' || 
                $field->type == 'checkbox' ||
                $field->type == 'time' ){
                //checkbox will come to here
                //let empty value can be checked for supporting checkbox_all rule
				foreach($field['inputs'] as $gravity_form_field_input) {
					if( isset($gravity_form_field_input['isHidden']) && $gravity_form_field_input['isHidden'] ){
						continue;
					}
                    
					$field_id_str = $gravity_form_field_input['id'];
                    
					$field_value = rgpost( 'input_'.str_replace( '.', '_', $field_id_str) );
                    $field_label = $field['label'].'.'.$gravity_form_field_input['label'];
                    
                    $property_appendix = '_'.$field_id_str;
                    
                    $invalid_validation = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str,
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                    if( $invalid_validation ){
                        //true means disabled the notifiction
                        return $invalid_validation;
                    }
				}//end of foreach
			}else{
				$field_id_str = $field['id'];
				$field_value = rgpost( 'input_'.$field_id_str );
                $field_label = $field['label'];
                
                $property_appendix = '';
                
                $invalid_validation = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str,
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                if( $invalid_validation ){
                    //true means disabled the notifiction
                    return $invalid_validation;
                }
                
			}//end of multiple inputs filed or single field
		}

		return $invalid_validation;
	}
	
    function bsk_gfblcv_change_confirmation( $confirmation, $form, $lead, $ajax ){
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
			return $confirmation;
		}
        
        //form settings
        $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );

        $enable = true;
        $action_when_hit = array();
        $confirmations_to_go = '';
        
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $confirmations_to_go = $bsk_gfblcv_form_settings['confirmation_to_go'];
        }
        
        if( !$enable ){
            return $confirmation;
        }
        
        if( !in_array( 'CONFIRMATION', $action_when_hit ) || 
            !array_key_exists( $confirmations_to_go, $form['confirmations'] ) ){

            return $confirmation;
        }
        
        //check if set confirmation active
        if( isset( $form['confirmations'][$confirmations_to_go]['isActive'] ) && !$form['confirmations'][$confirmations_to_go]['isActive'] ){
            return $confirmation;
        }

        $invalid_validation = false;
        $validation_result = array();
        $validation_message_array = array();
        $validation_message_array['black'] = '';
        $validation_message_array['white'] = '';
        $validation_message_array['email'] = '';
        $validation_message_array['ip'] = '';
        $validation_message_array['invit'] = '';
        
		//validation
        $fields_hit_item_array = array(); //only for blocked
		$current_page = rgpost( 'gform_source_page_number_' . $form['id'] ) ? rgpost( 'gform_source_page_number_' . $form['id'] ) : 1;
		foreach( $form['fields'] as $field ){
			if ( $current_page != $field->pageNumber ) {
				continue;
			}
			
			$field_obj_array = json_decode( json_encode($field), true );
			if( $field->type == 'name' || 
                $field->type == 'address' || 
                $field->type == 'checkbox' ||
                $field->type == 'time' ){
                //checkbox will come to here
                //let empty value can be checked for supporting checkbox_all rule
				foreach($field['inputs'] as $gravity_form_field_input) {
					if( isset($gravity_form_field_input['isHidden']) && $gravity_form_field_input['isHidden'] ){
						continue;
					}
                    
					$field_id_str = $gravity_form_field_input['id'];
                    
					$field_value = rgpost( 'input_'.str_replace( '.', '_', $field_id_str) );
                    $field_label = $field['label'].'.'.$gravity_form_field_input['label'];
                    
                    $property_appendix = '_'.$field_id_str;
                    
                    $invalid_validation = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str, 
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                    if( $invalid_validation ){
                        break;
                    }
				}//end of foreach
			}else{
				$field_id_str = $field['id'];
				$field_value = rgpost( 'input_'.$field_id_str );
                $field_label = $field['label'];
                
                $property_appendix = '';
                
                $invalid_validation = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str, 
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                if( $invalid_validation ){
                    break;
                }
                
			}//end of multiple inputs filed or single field
		}
        
        if( !$invalid_validation ){
            return $confirmation;
        }
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        if( $license_type == 'PERSONAL' ){
            return $confirmation;
        }
        
        $form['confirmation'] = $form['confirmations'][$confirmations_to_go];
        
        if ( $form['confirmation']['type'] == 'message' ) {
			$confirmation = GFFormDisplay::get_confirmation_message( $form['confirmation'], $form, $lead, array() );
		} else {
			if ( ! empty( $form['confirmation']['pageId'] ) ) {
				$url = get_permalink( $form['confirmation']['pageId'] );

			} else {
				$url = GFCommon::replace_variables( trim( $form['confirmation']['url'] ), $form, $lead, false, false, true, 'text' );
			}

			$url_info = parse_url( $url );
			$query_string  = rgar( $url_info, 'query' );
			$dynamic_query = GFCommon::replace_variables( trim( $form['confirmation']['queryString'] ), $form, $lead, true, false, false, 'text' );
			$dynamic_query = str_replace( array( "\r", "\n" ), '', $dynamic_query );
			$query_string .= rgempty( 'query', $url_info ) || empty( $dynamic_query ) ? $dynamic_query : '&' . $dynamic_query;

			if ( ! empty( $url_info['fragment'] ) ) {
				$query_string .= '#' . rgar( $url_info, 'fragment' );
			}

			$url = isset( $url_info['scheme'] ) ? $url_info['scheme'] : 'http';
			$url .= '://' . rgar( $url_info, 'host' );
			if ( ! empty( $url_info['port'] ) ) {
				$url .= ':' . rgar( $url_info, 'port' );
			}

			$url .= rgar( $url_info, 'path' );
			if ( ! empty( $query_string ) ) {
				$url .= "?{$query_string}";
			}

			/**
			 * Allows the confirmation redirect header to be suppressed. Required by GFAPI::submit_form().
			 *
			 * @since 2.3
			 *
			 * @param bool $suppress_redirect
			 */
			$suppress_redirect = apply_filters( 'gform_suppress_confirmation_redirect', $suppress_redirect );

			if ( ( headers_sent() || $ajax ) && ! $suppress_redirect ) {
				// Perform client side redirect for AJAX forms, of if headers have already been sent.
				$confirmation = $this->get_js_redirect_confirmation( $url, $ajax );
			} else {
				$confirmation = array( 'redirect' => $url );
			}
		}
        
        return $confirmation;
    }
    
    function get_js_redirect_confirmation( $url, $ajax ) {
		// JSON_HEX_TAG is available on PHP >= 5.3. It will prevent payloads such as <!--<script> from causing an error on redirection.
		$url =  defined( 'JSON_HEX_TAG' ) ? json_encode( $url, JSON_HEX_TAG ) : json_encode( $url );
		$confirmation = "<script type=\"text/javascript\">" . apply_filters( 'gform_cdata_open', '' ) . " function gformRedirect(){document.location.href={$url};}";
		if ( ! $ajax ) {
			$confirmation .= 'gformRedirect();';
		}

		$confirmation .= apply_filters( 'gform_cdata_close', '' ) . '</script>';

		return $confirmation;
	}
    
    function bsk_gfblcv_remove_form_entry( $entry, $form ) {
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return;
		}
        
        //form settings
        $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );

        $enable = true;
        $action_when_hit = array( 'BLOCK' );
        $delete_entry = 'NO';
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $delete_entry = $bsk_gfblcv_form_settings['delete_entry'];
        }
        
        if( !$enable || $delete_entry != 'YES' ){

            return;
        }
        
        if( in_array( 'BLOCK', $action_when_hit ) ){

            return;
        }
        
        $invalid_validation = false;
        $validation_result = array();
        $validation_message_array = array();
        $validation_message_array['black'] = '';
        $validation_message_array['white'] = '';
        $validation_message_array['email'] = '';
        $validation_message_array['ip'] = '';
        $validation_message_array['invit'] = '';
        
		//validation
        $fields_hit_item_array = array(); //only for blocked
		$current_page = rgpost( 'gform_source_page_number_' . $form['id'] ) ? rgpost( 'gform_source_page_number_' . $form['id'] ) : 1;
		foreach( $form['fields'] as $field ){
			if ( $current_page != $field->pageNumber ) {
				continue;
			}
			
			$field_obj_array = json_decode( json_encode($field), true );
			if( $field->type == 'name' || 
                $field->type == 'address' || 
                $field->type == 'checkbox' ||
                $field->type == 'time' ){
                //checkbox will come to here
                //let empty value can be checked for supporting checkbox_all rule
				foreach($field['inputs'] as $gravity_form_field_input) {
					if( isset($gravity_form_field_input['isHidden']) && $gravity_form_field_input['isHidden'] ){
						continue;
					}
                    
					$field_id_str = $gravity_form_field_input['id'];
                    
					$field_value = rgpost( 'input_'.str_replace( '.', '_', $field_id_str) );
                    $field_label = $field['label'].'.'.$gravity_form_field_input['label'];
                    
                    $property_appendix = '_'.$field_id_str;
                    
                    $invalid_validation = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str, 
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                    if( $invalid_validation ){
                        break;
                    }
				}//end of foreach
			}else{
				$field_id_str = $field['id'];
				$field_value = rgpost( 'input_'.$field_id_str );
                $field_label = $field['label'];
                
                $property_appendix = '';
                
                $invalid_validation = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                      $property_appendix,
                                                                      $fields_hit_item_array,
                                                                      $field, 
                                                                      $validation_result,
                                                                      $field_id_str, 
                                                                      $field_value, 
                                                                      $field_label, 
                                                                      $field_obj_array, 
                                                                      $validation_message_array
                                                                    );
                if( $invalid_validation ){
                    break;
                }
                
			}//end of multiple inputs filed or single field
		}
        
        if( !$invalid_validation ){

            return;
        }
        
        GFAPI::delete_entry( $entry['id'] );
    }
    
    function bsk_gfblcv_update_invit_list_items_hits_data( $entry, $form ) {
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return;
		}
        
        //form settings
        $bsk_gfblcv_form_settings = rgar( $form, 'bsk_gfblcv_form_settings' );
        $enable = true;
        
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
        }
        
        if( !$enable ){
            return;
        }
        
        $fields_hit_item_array = array(); //only for blocked
		$current_page = rgpost( 'gform_source_page_number_' . $form['id'] ) ? rgpost( 'gform_source_page_number_' . $form['id'] ) : 1;
		foreach( $form['fields'] as $field ){
			if ( $current_page != $field->pageNumber ) {
				continue;
			}
			
			$field_obj_array = json_decode( json_encode($field), true );
			if( $field->type == 'name' || 
                $field->type == 'address' || 
                $field->type == 'checkbox' ||
                $field->type == 'time' ){
                //checkbox will come to here
                //let empty value can be checked for supporting checkbox_all rule
				foreach($field['inputs'] as $gravity_form_field_input) {
					if( isset($gravity_form_field_input['isHidden']) && $gravity_form_field_input['isHidden'] ){
						continue;
					}
                    
					$field_id_str = $gravity_form_field_input['id'];
					$field_value = rgpost( 'input_'.str_replace( '.', '_', $field_id_str) );
                    $field_label = $field['label'].'.'.$gravity_form_field_input['label'];
                    if( $field_value == '' ){
                        continue;
                    }
                    
                    $property_appendix = '_'.$field_id_str;

                    $this->bsk_gfblcv_update_invit_list_item_hits( $property_appendix, $field_id_str, $field_value, $field_obj_array, $entry );
				}//end of foreach
			}else{
				$field_id_str = $field['id'];
				$field_value = rgpost( 'input_'.$field_id_str );
                $field_label = $field['label'];
                if( $field_value == '' ){
                    continue;
                }
                
                $property_appendix = '';
                
                $this->bsk_gfblcv_update_invit_list_item_hits( $property_appendix, $field_id_str, $field_value, $field_obj_array, $entry );
                
			}//end of multiple inputs filed or single field
		}
    }
    
    function bsk_gfblcv_update_invit_list_item_hits(  
                                                      $property_appendix,
                                                      $field_id_str, 
                                                      $field_value,
                                                      $field_obj_array,
                                                      $entry
                                                   ){
        
        $list_id_to_check = '';
        $comparison_to_check = '';
        $list_type = '';
        
        if( isset($field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix];
            $list_type = 'INVIT_LIST';
        }

        if( $field_value == "" || $list_type == '' ){
            return;
        }

        if( !$list_id_to_check || !$comparison_to_check ){
            return;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return;
        }

        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array($checked_results) && count($checked_results) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
            //update hits to entry id
            $this->_OBJ_common->bsk_gfblcv_update_item_hits_to( $item_id_str, $entry['form_id'], $entry['id'], 'GF' );
        }

        return;
    }
}