<?php

class BSK_GFBLCV_Pro_Submitting_FormidableForms {
    
    var $_OBJ_common = false;
    
    var $_entry_id_processed = false;
    
	public function __construct( $args ) {
        
        $this->_OBJ_common = $args['common_class'];
        
        if ( BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_is_form_plugin_supported('FF') ) {
            //https://formidableforms.com/knowledgebase/frm_validate_field_entry/
            add_filter( 'frm_validate_entry', array( $this, 'bsk_gfblcv_ff_validaiton_field' ), 10, 3 );
            
            add_filter( 'frm_skip_form_action', array( $this, 'bsk_gfblcv_ff_skip_action' ), 10, 3 );
            
            //do_action( 'frm_process_entry', $params, $errors, $form, array( 'ajax' => $ajax ) );
            add_action( 'frm_process_entry', array( $this, 'bsk_gfblcv_ff_save_entry_id' ), 10, 1 );
            //apply_filters( 'frm_success_filter', $method, $atts['form'], 'create' );
            add_filter( 'frm_success_filter', array( $this, 'bsk_gfblcv_ff_change_confirmation' ), 20, 3 );
            
            add_filter( 'frm_after_entry_processed', array( $this, 'bsk_gfblcv_ff_delete_entry' ), 9990, 1 );
            add_filter( 'frm_after_entry_processed', array( $this, 'bsk_gfblcv_update_invit_list_items_hits_data' ), 9991, 1 );
        }
        
	}
	
    function bsk_gfblcv_ff_validaiton_field( $errors, $values, $exclude ){
        extract( $exclude );
        
        //check spam
        if ( is_array( $errors ) && isset( $errors['spam'] ) ) {
             return $errors;
        }
        
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if ( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return $errors;
		}
        $form_id = $values['form_id'];
        $form = $form_id;
        FrmForm::maybe_get_form( $form );
        if ( ! is_object( $form ) ) {
			return $errors;
		}
        //form settings
        $bsk_gfblcv_form_settings = maybe_unserialize( get_option( BSK_GFBLCV_Pro_Dashboard_Formidable_Forms::$_bsk_gfblcv_ff_form_settings_option_name_prefix . $form_id) );

        $enable = true;
        $action_when_hit = array( 'BLOCK' );
        $validation_message_array = array();
        $validation_message_array['black'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['white'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['email'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        $validation_message_array['ip'] = 'Your IP address [VISITOR_IP] is forbidden!';
        $validation_message_array['invit'] = 'The value for field "[FIELD_LABEL]" is invalid!';
        
        if ( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ) {
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $validation_message_array['black'] = $bsk_gfblcv_form_settings['blacklist_message'];
            $validation_message_array['white'] = $bsk_gfblcv_form_settings['whitelist_message'];
            $validation_message_array['email'] = $bsk_gfblcv_form_settings['emaillist_message'];
            $validation_message_array['ip'] = $bsk_gfblcv_form_settings['iplist_message'];
            if( isset($bsk_gfblcv_form_settings['invitlist_message']) && 
                $bsk_gfblcv_form_settings['invitlist_message'] ){
                $validation_message_array['invit'] = $bsk_gfblcv_form_settings['invitlist_message'];
            }
        }
        
        if ( ! $enable ){

            return $errors;
        }

        if ( ! in_array( 'BLOCK', $action_when_hit ) ){

            return $errors;
        }
        
        $where = apply_filters( 'frm_posted_field_ids', array( 'fi.form_id' => $values['form_id'] ) );
		// Don't get subfields
		$where['fr.parent_form_id'] = array( null, 0 );
		// Don't get excluded fields (like file upload fields in the ajax validation)
		if ( ! empty( $exclude ) ) {
			$where['fi.type not'] = $exclude['exclude'];
		}
        
		$posted_fields = FrmField::getAll( $where, 'field_order' );
        
        //check reCAPTCHA
        $reCAPTCHA_field_id = 0;
        foreach ( $posted_fields as $posted_field ) {
            if ( $posted_field->type == 'captcha' ) {
                $reCAPTCHA_field_id = $posted_field->id;
                break;
            }
        }
        if ( $reCAPTCHA_field_id > 0 && isset ( $errors['field'.$reCAPTCHA_field_id] ) ) {
            return $errors;
        }
        
        $args = array( 'exclude' => $exclude );
        
        //validation
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $fields_hit_item_array = array(); //only for blocked
        $form_data_array = array();

		foreach ( $posted_fields as $field ) {
			if ( in_array( $field->type, array( 'html', 'user_id', 'captcha', 'hidden' ) ) ) {
                return $errors;
            }
            
            //get field value
            $field_value = self::get_field_value( $field, $values, $args );
            
            $field_id_str = $field->id;
            $field_label = $field->name;

            if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                $form_data_array[$field_id_str] = array( 'label' => $field_label, 'value' => $field_value );
            }

            $property_appendix = '';
            $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                  $property_appendix,
                                                                  $fields_hit_item_array,
                                                                  $field,
                                                                  $errors,
                                                                  $field_id_str, 
                                                                  $field_value, 
                                                                  $field_label, 
                                                                  $field->field_options, 
                                                                  $validation_message_array
                                                                );
            
            
		}
        
        //insert form data and hits data into database
        //only for blocked
        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
            
            //global settings
            $settings_data = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_settings_option, false );
            $global_save_blocked_entry = 'NO';
            $global_notify_blocked = 'NO';
            if( $settings_data && is_array( $settings_data ) && count( $settings_data ) > 0 ){
                if( isset( $settings_data['save_blocked_entry'] ) ){
                    $global_save_blocked_entry = $settings_data['save_blocked_entry'];
                }
                if( isset( $settings_data['notify_blocked'] ) ){
                    $global_notify_blocked = $settings_data['notify_blocked'];
                }
            }
            
            //form settings
            $save_blocked_data = 'NO';
            $notify_administrators = 'NO';
            if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
                $save_blocked_data = $bsk_gfblcv_form_settings['save_blocked_data'];
                $notify_administrators = $bsk_gfblcv_form_settings['notify_administrators'];
                $form_notify_send_to = $bsk_gfblcv_form_settings['notify_send_to'];
            }

            //get final settings
            $final_save_blocked_form_data = true;
            $final_notify_administrators = false;
            if( $global_save_blocked_entry == 'NO' || $save_blocked_data == 'NO' ){
                $final_save_blocked_form_data = false;
            }
            if( $global_notify_blocked == 'YES' && $notify_administrators == 'YES' ){
                $final_notify_administrators = true;
            }
            
            if( $fields_hit_item_array && is_array( $fields_hit_item_array ) && count( $fields_hit_item_array ) > 0 ){
                //save hits data
                if( $final_save_blocked_form_data ){
                    $form_data_array['form_id'] = $form_id;
                    $this->_OBJ_common->bsk_gfblcv_save_blocked_form_data( $fields_hit_item_array, $form_data_array, 'FF' );
                }
                
                //send out administrator notifications
                if( $final_notify_administrators ){
                    $this->_OBJ_common->bsk_gfblcv_notify_administrators( $form_notify_send_to, $form->name, $form_data_array, $fields_hit_item_array, 'FF' );
                }
            }
            
        }
        
        return $errors;
    }
    
    function bsk_gfblcv_check_field_value_againsit_list_item( $property_appendix,
                                                              &$fields_hit_item_array,
                                                              $field,
                                                              &$validation_result,
                                                              $field_id_str, 
                                                              $field_value, 
                                                              $field_label, 
                                                              $field_obj_array, 
                                                              $validation_message_array ){
        
        global $wpdb;
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        
        $list_id_to_check = '';
        $comparison_to_check = '';
        $validation_message = '';
        $list_type = '';
        
        if( isset($field_obj_array['bsk_gfbl_apply_blacklist_Property'.$property_appendix]) &&
            $field_obj_array['bsk_gfbl_apply_blacklist_Property'.$property_appendix] &&
            isset($field_obj_array['bsk_gfbl_apply_blacklist_Comparison'.$property_appendix]) && 
            $field_obj_array['bsk_gfbl_apply_blacklist_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_blacklist_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_blacklist_Comparison'.$property_appendix];
            $list_type = 'BLACK_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['black'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_white_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_white_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_white_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_white_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_white_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_white_list_Comparison'.$property_appendix];
            $list_type = 'WHITE_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['white'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_email_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_email_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_email_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_email_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_email_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_email_list_Comparison'.$property_appendix];
            $list_type = 'EMAIL_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['email'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_ip_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_ip_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_ip_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_ip_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_ip_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_ip_list_Comparison'.$property_appendix];
            $list_type = 'IP_LIST';
            $field_value = FrmAppHelper::get_ip_address();

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['ip'];
            }
        }else if( isset($field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix]) &&
                  $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix] &&
                  isset($field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix]) && 
                  $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix];
            $list_type = 'INVIT_LIST';

            if( isset( $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix] ) ){
                $validation_message = $field_obj_array['bsk_gfblcv_validation_message'.$property_appendix];
            }
            if( trim( $validation_message ) == '' ){
                $validation_message = $validation_message_array['invit'];
            }
        }

        $invalid_validation = false;
        if( $field_value == "" || $list_type == '' ){
            return $invalid_validation;
        }
        
        if( !$list_id_to_check || !$comparison_to_check ){
            return $invalid_validation;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return $invalid_validation;
        }

        $validation_message = $this->_OBJ_common->bsk_gfblcv_render_validation_message( 
                                                                                    $validation_message, 
                                                                                    $field_label, 
                                                                                    $field_value, 
                                                                                    FrmAppHelper::get_ip_address() 
                                                                                );

        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array($checked_results) && count($checked_results) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
        }
        
        switch( $list_type ){
            case 'BLACK_LIST':
                if( $checked_results ){
                    $validation_result['field'. $field_id_str] = $validation_message;
                    
                    $invalid_validation = true;

                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_id_str] = array( 
                                                                        'list_id' => $list_id_to_check, 
                                                                        'items_id' => explode( ',', $item_id_str ),
                                                                        'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                    );
                    }
                }
            break;
            case 'WHITE_LIST':
                if( ! $checked_results ){
                    $validation_result['field'. $field_id_str] = $validation_message;
                    
                    $invalid_validation = true;

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => array( -1 ), 
                                                                            'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                        );
                    }
                }else{
                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                }
            break;
            case 'IP_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){
                        $validation_result['field'. $field_id_str] = $validation_message;
                        
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => array( -2 ), 
                                                                                'extra_data' => array( 'mode' => 'ALLOW' )
                                                                            );
                        }

                        break;
                    }else if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ) {
                        //for the case by country, it only return true or false, so won't come to here
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){
                        $validation_result['field'. $field_id_str] = $validation_message;
                        
                        $invalid_validation = true;

                        $blocked_item_id_to_save = array( -2 ); //default -2 is for IP list COUNTRY check way
                        if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ){
                            //for the case by country, it only return true or false, so won't come to here
                            //update hits counter
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                            $blocked_item_id_to_save = explode( ',', $item_id_str );
                        }

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => $blocked_item_id_to_save, 
                                                                                'extra_data' => array( 'mode' => 'BLOCK' )
                                                                         );
                        }
                    }
                }
            break;
            case 'EMAIL_LIST':
            case 'INVIT_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){
                        $validation_result['field'. $field_id_str] = $validation_message;
                        
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                                            'list_id' => $list_id_to_check, 
                                                                                            'items_id' => array( -1 ), 
                                                                                            'extra_data' => array( 'mode' => 'ALLOW' )
                                                                                        );
                        }

                        break;
                    }else{
                        //update hits counter, invit codes list will be updated to entry id at the last
                        if( $list_type != 'INVIT_LIST' ){
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                        }
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){
                        $validation_result['field'. $field_id_str] = $validation_message;
                        
                        $invalid_validation = true;
                        
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_id_str] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => explode( ',', $item_id_str ), 
                                                                            'extra_data' => array( 'mode' => 'BLOCK' )
                                                                         );
                        }
                    }
                }
            break;
        }
        
        return $invalid_validation;
    }
    
    public static function get_field_value( $posted_field, $values, $args = array() ) {
		$defaults = array(
			'id'              => $posted_field->id,
			'parent_field_id' => '', // the id of the repeat or embed form
			'key_pointer'     => '', // the pointer in the posted array
			'exclude'         => array(), // exclude these field types from validation
		);
		$args     = wp_parse_args( $args, $defaults );

		if ( empty( $args['parent_field_id'] ) ) {
			$value = isset( $values['item_meta'][ $args['id'] ] ) ? $values['item_meta'][ $args['id'] ] : '';
		} else {
			// value is from a nested form
			$value = $values;
		}

		// Check for values in "Other" fields
		FrmEntriesHelper::maybe_set_other_validation( $posted_field, $value, $args );

		self::maybe_clear_value_for_default_blank_setting( $posted_field, $value );

		$should_trim = is_array( $value ) && count( $value ) == 1 && isset( $value[0] ) && $posted_field->type !== 'checkbox';
		if ( $should_trim ) {
			$value = reset( $value );
		}

		if ( ! is_array( $value ) ) {
			$value = trim( $value );
		}

		return $value;
	}
    
    private static function maybe_clear_value_for_default_blank_setting( $field, &$value ) {
		$position = FrmField::get_option( $field, 'label' );
		if ( ! $position ) {
			$position = FrmStylesController::get_style_val( 'position', $field->form_id );
		}

		if ( $position === 'inside' && FrmFieldsHelper::is_placeholder_field_type( $field->type ) && $value === $field->name ) {
			$value = '';
		}
	}
    
    function bsk_gfblcv_ff_skip_action( $skip_this_action, $args ){
        if( $skip_this_action ) {
            return $skip_this_action;
        }
        
        //print_r( $args );exit;
        
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if ( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return $skip_this_action;
		}
        $form_id = $args['form']->id;
        $form = $form_id;
        FrmForm::maybe_get_form( $form );
        if ( ! is_object( $form ) ) {
			return $skip_this_action;
		}
        //form settings
        $bsk_gfblcv_form_settings = maybe_unserialize( get_option( BSK_GFBLCV_Pro_Dashboard_Formidable_Forms::$_bsk_gfblcv_ff_form_settings_option_name_prefix . $form_id) );

        $enable = true;
        $action_when_hit = array();
        $notifications_to_skip = array();
        
        if ( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ) {
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $notifications_to_skip = $bsk_gfblcv_form_settings['notification_to_skip'];
        }

        if( !$enable || !in_array( 'SKIP', $action_when_hit ) || !in_array( $args['action']->ID, $notifications_to_skip ) ){
            return $skip_this_action;
        }
        
        $entry = false;
        if ( is_object( $args['entry'] ) ) {
          $entry = $args['entry'];
        } else {
          $entry = FrmEntry::getOne( $args['entry'], true );
        }
        
        if ( ! $entry || ! isset( $entry->metas ) || ! is_array( $entry->metas ) || count( $entry->metas ) < 1 ) {
            return $skip_this_action;
        }
        
        $where = apply_filters( 'frm_posted_field_ids', array( 'fi.form_id' => $form_id ) );
		// Don't get subfields
		$where['fr.parent_form_id'] = array( null, 0 );
		// Don't get excluded fields (like file upload fields in the ajax validation)
		if ( ! empty( $exclude ) ) {
			$where['fi.type not'] = $exclude['exclude'];
		}
        
		$posted_fields = FrmField::getAll( $where, 'field_order' );
        
        $validation_message_array = array();
        $validation_message_array['black'] = '';
        $validation_message_array['white'] = '';
        $validation_message_array['email'] = '';
        $validation_message_array['ip'] = '';
        $validation_message_array['invit'] = '';
        //validation
        $fields_hit_item_array = array();
        $validation_result = array();

        foreach ( $posted_fields as $field ) {
			if ( in_array( $field->type, array( 'html', 'user_id', 'captcha', 'hidden' ) ) ) {
                continue;
            }
            
            //get field value
            $field_value = isset( $entry->metas[$field->id] ) ? $entry->metas[$field->id] : '';
            $field_id_str = $field->id;
            $field_label = $field->name;
            $property_appendix = '';
            $validation_failed = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                  $property_appendix,
                                                                  $fields_hit_item_array,
                                                                  $field,
                                                                  $validation_result,
                                                                  $field_id_str, 
                                                                  $field_value, 
                                                                  $field_label, 
                                                                  $field->field_options, 
                                                                  $validation_message_array
                                                                );
            if ( $validation_failed ) {
                return true;
            }            
		}
        
        return $skip_this_action;
    }
    
    function bsk_gfblcv_ff_save_entry_id( $params ){
        $this->_entry_id_processed = $params['id'];
    }
    
    function bsk_gfblcv_ff_change_confirmation( $method, $form, $action ){
        
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if ( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return $method;
		}
        $form_id = $form->id;
        $form = $form_id;
        FrmForm::maybe_get_form( $form );
        if ( ! is_object( $form ) ) {
			return $method;
		}
        //form settings
        $bsk_gfblcv_form_settings = maybe_unserialize( get_option( BSK_GFBLCV_Pro_Dashboard_Formidable_Forms::$_bsk_gfblcv_ff_form_settings_option_name_prefix . $form_id) );

        $enable = true;
        $action_when_hit = array();
        $confirmation_to_go = '';
        
        if ( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ) {
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $confirmation_to_go = $bsk_gfblcv_form_settings['confirmation_to_go'];
        }

        if ( !$enable || !in_array( 'CONFIRMATION', $action_when_hit ) || $confirmation_to_go == '' ){
            return $method;
        }
        
        if ( !$this->_entry_id_processed ) {
            return $method;
        }
        
        $entry = FrmEntry::getOne( $this->_entry_id_processed, true );
        if ( ! $entry || ! isset( $entry->metas ) || ! is_array( $entry->metas ) || count( $entry->metas ) < 1 ) {
            return $method;
        }
        
        $where = apply_filters( 'frm_posted_field_ids', array( 'fi.form_id' => $form_id ) );
		// Don't get subfields
		$where['fr.parent_form_id'] = array( null, 0 );
		// Don't get excluded fields (like file upload fields in the ajax validation)
		if ( ! empty( $exclude ) ) {
			$where['fi.type not'] = $exclude['exclude'];
		}
        
		$posted_fields = FrmField::getAll( $where, 'field_order' );
        
        $validation_message_array = array();
        $validation_message_array['black'] = '';
        $validation_message_array['white'] = '';
        $validation_message_array['email'] = '';
        $validation_message_array['ip'] = '';
        $validation_message_array['invit'] = '';
        
        //validation
        $fields_hit_item_array = array();
        $validation_result = array();
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        if( $license_type == 'PERSONAL' ){
            return $method;
        }

        foreach ( $posted_fields as $field ) {
			if ( in_array( $field->type, array( 'html', 'user_id', 'captcha', 'hidden' ) ) ) {
                continue;
            }
            
            //get field value
            $field_value = isset( $entry->metas[$field->id] ) ? $entry->metas[$field->id] : '';
            $field_id_str = $field->id;
            $field_label = $field->name;
            $property_appendix = '';
            $validation_failed = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                  $property_appendix,
                                                                  $fields_hit_item_array,
                                                                  $field,
                                                                  $validation_result,
                                                                  $field_id_str, 
                                                                  $field_value, 
                                                                  $field_label, 
                                                                  $field->field_options, 
                                                                  $validation_message_array
                                                                );
            if ( $validation_failed ) {
                
                //here need to delete entry, because if redirect then the after_entry_process won't be processed
                if( $confirmation_to_go == 'redirect' ){
                    $this->bsk_gfblcv_ff_delete_entry( array( 'form' => $form, 'entry_id' => $entry->id ) );
                }
                
                return $confirmation_to_go;
            }            
		}
        
        return $method;
    }
    
    function bsk_gfblcv_ff_delete_entry( $attr ){

        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if ( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){

            return;
		}
        $form_id = $attr['form']->id;
        $form = $form_id;
        FrmForm::maybe_get_form( $form );
        if ( ! is_object( $form ) ) {

            return;
		}
        //form settings
        $bsk_gfblcv_form_settings = maybe_unserialize( get_option( BSK_GFBLCV_Pro_Dashboard_Formidable_Forms::$_bsk_gfblcv_ff_form_settings_option_name_prefix . $form_id) );

        $enable = true;
        $action_when_hit = array( 'BLOCK' );
        $delete_entry = '';
        if ( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ) {
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            $delete_entry = $bsk_gfblcv_form_settings['delete_entry'];
        }

        if ( !$enable || $delete_entry != 'YES' ){

            return;
        }
        
        if( in_array( 'BLOCK', $action_when_hit ) ){

            return;
        }
        
        $entry = FrmEntry::getOne( $attr['entry_id'], true );
        if ( ! $entry || ! isset( $entry->metas ) || ! is_array( $entry->metas ) || count( $entry->metas ) < 1 ) {
            return;
        }
        
        $where = apply_filters( 'frm_posted_field_ids', array( 'fi.form_id' => $form_id ) );
		// Don't get subfields
		$where['fr.parent_form_id'] = array( null, 0 );
		// Don't get excluded fields (like file upload fields in the ajax validation)
		if ( ! empty( $exclude ) ) {
			$where['fi.type not'] = $exclude['exclude'];
		}
        
		$posted_fields = FrmField::getAll( $where, 'field_order' );
        
        $validation_message_array = array();
        $validation_message_array['black'] = '';
        $validation_message_array['white'] = '';
        $validation_message_array['email'] = '';
        $validation_message_array['ip'] = '';
        $validation_message_array['invit'] = '';
        
        //validation
        $fields_hit_item_array = array();
        $validation_result = array();
        foreach ( $posted_fields as $field ) {
			if ( in_array( $field->type, array( 'html', 'user_id', 'captcha', 'hidden' ) ) ) {
                continue;
            }
            
            //get field value
            $field_value = isset( $entry->metas[$field->id] ) ? $entry->metas[$field->id] : '';
            $field_id_str = $field->id;
            $field_label = $field->name;
            $property_appendix = '';
            $validation_failed = $this->bsk_gfblcv_check_field_value_againsit_list_item(
                                                                  $property_appendix,
                                                                  $fields_hit_item_array,
                                                                  $field,
                                                                  $validation_result,
                                                                  $field_id_str, 
                                                                  $field_value, 
                                                                  $field_label, 
                                                                  $field->field_options, 
                                                                  $validation_message_array
                                                                );
            if ( $validation_failed ) {
                //delete entry
                FrmEntry::destroy( $entry->id );
                
                return;
            }
		}
        
        return;
    }
    
    function bsk_gfblcv_update_invit_list_items_hits_data( $attr ){
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if ( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return;
		}
        $form_id = $attr['form']->id;
        $form = $form_id;
        FrmForm::maybe_get_form( $form );
        if ( ! is_object( $form ) ) {
			return;
		}
        //form settings
        $bsk_gfblcv_form_settings = maybe_unserialize( get_option( BSK_GFBLCV_Pro_Dashboard_Formidable_Forms::$_bsk_gfblcv_ff_form_settings_option_name_prefix . $form_id) );
        
        $enable = true;
        
        if ( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ) {
            $enable = $bsk_gfblcv_form_settings['enable'];
        }

        if ( !$enable ){
            return;
        }
        
        $entry = FrmEntry::getOne( $attr['entry_id'], true );
        if ( !$entry || ! isset( $entry->metas ) || ! is_array( $entry->metas ) || count( $entry->metas ) < 1 ) {
            return;
        }

        $where = apply_filters( 'frm_posted_field_ids', array( 'fi.form_id' => $form_id ) );
		// Don't get subfields
		$where['fr.parent_form_id'] = array( null, 0 );
		// Don't get excluded fields (like file upload fields in the ajax validation)
		if ( ! empty( $exclude ) ) {
			$where['fi.type not'] = $exclude['exclude'];
		}
        
		$posted_fields = FrmField::getAll( $where, 'field_order' );
        foreach ( $posted_fields as $field ) {
			if ( in_array( $field->type, array( 'html', 'user_id', 'captcha', 'hidden' ) ) ) {
                continue;
            }

            //get field value
            $field_value = isset( $entry->metas[$field->id] ) ? $entry->metas[$field->id] : '';
            $field_id_str = $field->id;
            $property_appendix = '';
            if( $field_value == "" ){
                continue;
            }
            $this->bsk_gfblcv_update_invit_list_item_hits( $property_appendix, $field_id_str, $field_value, $field->field_options, $entry );          
		}
        
        return;
    }
    
    function bsk_gfblcv_update_invit_list_item_hits(  
                                                      $property_appendix,
                                                      $field_id_str, 
                                                      $field_value,
                                                      $field_obj_array,
                                                      $entry
                                                   ){
        $list_id_to_check = '';
        $comparison_to_check = '';
        $list_type = '';
        
        if( isset($field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix]) &&
            $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix] &&
            isset($field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix]) && 
            $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix] ){

            $list_id_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Property'.$property_appendix];
            $comparison_to_check = $field_obj_array['bsk_gfbl_apply_invit_list_Comparison'.$property_appendix];
            $list_type = 'INVIT_LIST';
        }

        if( $field_value == "" || $list_type == '' ){
            return;
        }

        if( !$list_id_to_check || !$comparison_to_check ){
            return;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return;
        }

        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array($checked_results) && count($checked_results) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
            //update hits to entry id
            $this->_OBJ_common->bsk_gfblcv_update_item_hits_to( $item_id_str, $entry->form_id, $entry->id, 'FF' );
        }

        return;
    }
    
}
