<?php

class BSK_GFBLCV_Pro_Submitting_Common {

	public function __construct() {
        
	}
    
    function bsk_gfblcv_front_check_list_status( $list_id, $list_type ) {
        global $wpdb;
        
        $sql = 'SELECT COUNT(*) FROM `'.$wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_list_tbl_name.'` WHERE `id` = %d AND `list_type` = %s';
        $sql = $wpdb->prepare( $sql, intval($list_id), esc_sql( $list_type ) );
        if ( $wpdb->get_var( $sql ) < 1 ) {
            return false;
        }
        
        return true;
    }
    
    function bsk_gfblcv_render_validation_message( $validation_message, $field_label, $field_value, $ip_address ){
        
        $validation_message = str_replace(
                                          '[FIELD_LABEL]', 
                                          $field_label, 
                                          $validation_message
                                         );
        $validation_message = str_replace(
                                          '[FIELD_VALUE]',
                                          $field_value, 
                                          $validation_message 
                                         );
        
        $validation_message = str_replace(
                                          '[VISITOR_IP]',
                                          $ip_address, 
                                          $validation_message 
                                         );
        
        
        return $validation_message;
    }
    
    function bsk_gfblcv_update_item_hits( $items_id_str ) {
        global $wpdb;
        
        $table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
        $sql = 'UPDATE `'.$table.'` SET `hits` = `hits` + 1 WHERE `id` IN( '.esc_sql($items_id_str).' )';
        $wpdb->query( $sql );
    }
    
    function bsk_gfblcv_update_item_hits_to( $items_id_str, $form_id, $to, $forms ) {
        global $wpdb;
        
        $table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
        $sql = 'SELECT `id`, `extra` FROM `'.$table.'` WHERE `id` IN( '.esc_sql($items_id_str).' )';
        $results = $wpdb->get_results( $sql );
        if( $results && is_array( $results ) && count( $results ) ){
            foreach( $results as $item_obj ){
                $extra = array();
                if( $item_obj->extra ){
                    $extra = unserialize( $item_obj->extra );
                }
                $extra['forms'] = $forms;
                $extra['form_id'] = $form_id;
                $data_to_update = array( 'hits' => $to, 'extra' => serialize($extra) );
                $wpdb->update( $table, $data_to_update, array( 'id' => $item_obj->id ) );
            }
        }
    }
    
    function bsk_gfblcv_front_check_field_value_match_list( $list_type, $list_id, $list_comparison, $field_value ){
		global $wpdb;
		
		if( $field_value == "" ){
			return false;
		}
        
        $list_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_list_tbl_name;
        $items_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
        
        $list_data_sql = 'SELECT `list_type`, `check_way`, `extra` FROM `'.$list_table.'` '.
                         'WHERE `id` = %d';
        $list_data_sql = $wpdb->prepare( $list_data_sql, $list_id );
        $list_data_results = $wpdb->get_results( $list_data_sql );
        
        if( !$list_data_results || !is_array( $list_data_results ) || count( $list_data_results ) < 1 ){
            return false;
        }
        
        $list_check_way = $list_data_results[0]->check_way;
        $list_extra_data = false; 
        if( $list_data_results[0]->extra ){
            $list_extra_data = unserialize( $list_data_results[0]->extra );
        }
        
        if( $list_type == 'IP_LIST' && $list_check_way == 'COUNTRY' ){
            //do nothing
        }else{
            $items_array = array();
            //get items data
            $items_sql = 'SELECT I.`id`, I.`value` FROM `'.$items_table.'` AS I '.
                         'WHERE I.`list_id` = %d';
            if( $list_type == 'INVIT_LIST' ){
                //for invitation codes list, save the entry id to hits
                $items_sql .= ' AND `hits` = 0'; 
            }
            $items_sql = $wpdb->prepare( $items_sql, $list_id );
            $items_array = $wpdb->get_results( $items_sql );
            if( !$items_array || !is_array($items_array) || count($items_array) < 1 ){
                return false;
            }
            
            if( ($list_type == 'BLACK_LIST' || $list_type == 'WHITE_LIST') && $list_check_way == 'ALL' ){
                $check_all_return = $this->bsk_gfblcv_front_check_field_value_match_list_ALL( $list_id, $items_array, $list_comparison, $field_value );
                
                return $check_all_return;
            }
        }
        
        $checked_results = false;
		switch ($list_comparison) {
			case 'SAME_CASE_INSENSITIVE':
				$field_value_uppercase = strtoupper( $field_value );
				foreach( $items_array as $item_obj ){
					$item_uppercase = strtoupper( $item_obj->value );
                    if( strpos( $item_uppercase, strtoupper('#bsk_whole#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_whole#'), '', $item_uppercase );
                    }

                    if( strpos( $item_uppercase, strtoupper('#bsk_word#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_word#'), '', $item_uppercase );
                    }
                    
					if( $item_uppercase == $field_value_uppercase ){
						$checked_results = $item_obj->id;
						break;
					}
				}
			break;
			case 'CONTAINS_CASE_INSENSITIVE':
				$field_value_uppercase = strtoupper( $field_value );
				foreach( $items_array as $item_obj ){
                    $item_uppercase = strtoupper( $item_obj->value );
                    if( strpos( $item_uppercase, strtoupper('#bsk_whole#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_whole#'), '', $item_uppercase );
                        if( strpos( $field_value_uppercase, $item_uppercase ) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        } else {
                            continue;
                        }
                    }

                    if( strpos( $item_uppercase, strtoupper('#bsk_word#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_word#'), '', $item_uppercase );

                        //convert field value to word
                        $field_value_uppercase_array = explode( ' ', $field_value_uppercase );
                        foreach( $field_value_uppercase_array as $field_value_word ) {
                            $field_value_word = trim( $field_value_word );
                            if( $field_value_word == $item_uppercase ){
                                $checked_results = $item_obj->id;
                                break;
                            }
                        }
                        if ( $checked_results ) {
                            break;
                        } else {
                            continue;
                        }
                    }
                    
                    $item_uppercase = strtoupper( trim($item_obj->value) );
                    if( strpos( $item_uppercase, ' ') !== false ){
                        //multiple words
                        $field_value_single_space = preg_replace( '/\s+/', ' ', $field_value_uppercase );
                        $item_uppercase_single_space = preg_replace( '/\s+/', ' ', $item_uppercase );
                        if( strpos($field_value_single_space, $item_uppercase_single_space) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                        
                        //enhanced checking 1
                        $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                        $matches_array = array();
                        $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                        if( $match_return && count($matches_array) > 1 ){
                            $special_char_array = array_unique( $matches_array[1] );
                            foreach( $special_char_array as $special_char ){
                                //organise new keyword
                                $item_uppercase_single_word_array = explode( ' ', $item_uppercase_single_space );
                                foreach( $item_uppercase_single_word_array as $key => $signle_word ){
                                    $new_single_word_array = str_split( $signle_word );
                                    $new_single_word = implode( $special_char, $new_single_word_array );
                                    $item_uppercase_single_word_array[$key] = $new_single_word;
                                }
                                $item_to_check = implode( ' ', $item_uppercase_single_word_array );
                                if( strpos($field_value_single_space, $item_to_check) !== false ){
                                    $checked_results = $item_obj->id;
                                    break; //only break foreach for $special_char_array
                                }
                            }
                            
                            if( $checked_results ){
                                break;
                            }
                        }
                        
                        //enhanced checking 2
                        $pattern = '/["*#$!=+@%_\'~,-]/';
                        $field_value_single_space = preg_replace( $pattern, '', $field_value_single_space );
                        if( strpos($field_value_single_space, $item_uppercase_single_space) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                        
                    }else{
                        //single word
                        if( strpos($field_value_uppercase, $item_uppercase) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                        
                        //enhanced checking 1
                        $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                        $matches_array = array();
                        $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                        if( $match_return && count($matches_array) > 1 ){
                            $special_char_array = array_unique( $matches_array[1] );
                            foreach( $special_char_array as $special_char ){
                                //organise new keyword
                                $new_item_uppercase_array = str_split( $item_uppercase );
                                $item_to_check = implode( $special_char, $new_item_uppercase_array );

                                if( strpos($field_value_uppercase, $item_to_check) !== false ){
                                    $checked_results = $item_obj->id;
                                    break; //only break foreach for $special_char_array
                                }
                            }
                        }
                        
                        if( $checked_results ){
                            break;
                        }

                        //enhanced checking 2
                        $pattern = '/[ "*#$!=+@%_\'~,-]/';
                        $field_value_uppercase_to_check = preg_replace( $pattern, '', $field_value_uppercase );
                        if( strpos($field_value_uppercase_to_check, $item_uppercase) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                    }
				}
			break;
			case 'SAME_CASE_SENSITIVE':
				foreach( $items_array as $item_obj ){
                    $item_value = $item_obj->value;
                    if( strpos( $item_value, '#bsk_whole#' ) !== false ){
                        //whole string match
                        $item_value = str_replace( '#bsk_whole#', '', $item_value );
                    }
                    if( strpos( $item_value, '#bsk_word#' ) !== false ){
                        //whole string match
                        $item_value = str_replace( '#bsk_word#', '', $item_value );
                    }
					if( $field_value == $item_value ){
						$checked_results = $item_obj->id;
						break;
					}
				}
			break;
			case 'CONTAINS_CASE_SENSITIVE':
				foreach( $items_array as $item_obj ){
                    $item_value = $item_obj->value;
                    if( strpos( $item_value, '#bsk_whole#' ) !== false ){
                        //whole string match
                        $item_value = str_replace( '#bsk_whole#', '', $item_value );
                        if( strpos($field_value, $item_value ) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }else{
                            continue;
                        }
                    }

                    if( strpos( $item_value, '#bsk_word#' ) !== false ){
                        //whole string match
                        $item_value = str_replace( '#bsk_word#', '', $item_value );

                        //convert field value to word
                        $field_value_array = explode( ' ', $field_value );
                        foreach( $field_value_array as $field_value_word ) {
                            $field_value_word = trim( $field_value_word );
                            if( $field_value_word == $item_value ){
                                $checked_results = $item_obj->id;
                                break;
                            }
                        }
                        if ( $checked_results ) {
                            break;
                        } else {
                            continue;
                        }
                    }

                    $item_value = trim($item_obj->value);
                    if( strpos( $item_value, ' ') !== false ){
                        //multiple words
                        $field_value_single_space = preg_replace( '/\s+/', ' ', $field_value );
                        $item_single_space = preg_replace( '/\s+/', ' ', $item_value );
                        if( strpos($field_value_single_space, $item_single_space) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                        
                        //enhanced checking 1
                        $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                        $matches_array = array();
                        $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                        if( $match_return && count($matches_array) > 1 ){
                            $special_char_array = array_unique( $matches_array[1] );
                            foreach( $special_char_array as $special_char ){
                                //organise new keyword
                                $item_single_word_array = explode( ' ', $item_single_space );
                                foreach( $item_single_word_array as $key => $signle_word ){
                                    $new_single_word_array = str_split( $signle_word );
                                    $new_single_word = implode( $special_char, $new_single_word_array );
                                    $item_single_word_array[$key] = $new_single_word;
                                }
                                $item_to_check = implode( ' ', $item_single_word_array );
                                if( strpos($field_value_single_space, $item_to_check) !== false ){
                                    $checked_results = $item_obj->id;
                                    break; //only break foreach for $special_char_array
                                }
                            }
                            
                            if( $checked_results ){
                                break;
                            }
                        }
                        
                        //enhanced checking 2
                        $pattern = '/["*#$!=+@%_\'~,-]/';
                        $field_value_single_space = preg_replace( $pattern, '', $field_value_single_space );
                        if( strpos($field_value_single_space, $item_single_space) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                    }else{
                        //single word
                        if( strpos($field_value, $item_value) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                        
                        //enchanced checking 1
                        $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                        $matches_array = array();
                        $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                        if( $match_return && count($matches_array) > 1 ){
                            $special_char_array = array_unique( $matches_array[1] );
                            foreach( $special_char_array as $special_char ){
                                //organise new keyword
                                $new_item_array = str_split( $item_obj->value );
                                $item_to_check = implode( $special_char, $new_item_array );

                                if( strpos($field_value, $item_to_check) !== false ){
                                    $checked_results = $item_obj->id;
                                    break; ////only break foreach for $special_char_array
                                }
                            }
                            
                            if( $checked_results ){
                                break;
                            }
                        }

                        //enhanced checking 2
                        $pattern = '/[ "*#$!=+@%_\'~,-]/';
                        $field_value_to_check = preg_replace( $pattern, '', $field_value );
                        if( strpos($field_value_to_check, $item_obj->value) !== false ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                    }
				}
			break;
			//for email & IP & invit list
			case 'ALLOW':
			case 'BLOCK':
                if( $list_type == 'IP_LIST' ){
                    if( $list_check_way == 'COUNTRY' && is_array( $list_extra_data ) && count( $list_extra_data ) > 0 ){
                        //according to extra data to check IP address
                        $_bsk_gfblcv_OBJ_ip_country = BSK_GFBLCV_Pro::instance()->_CLASS_OBJ_ip_country;

                        $is_ip_belongs_to_selected_country = $_bsk_gfblcv_OBJ_ip_country->validate_ip_in_country( $list_extra_data, $field_value );
                        $checked_results = $is_ip_belongs_to_selected_country;
                        
                        break;
                    }else{
                        foreach( $items_array as $item_obj ){
                            if( $item_obj->value == $field_value ){
                                $checked_results = array( $item_obj->id );
                                break;
                            }
                            //check if ip range 45.91.94.1 - 45.91.94.123
                            if( strpos( $item_obj->value, '-' ) !== false ){
                                $ip_start_end = explode( '-', $item_obj->value );
                                $ip_start_end[0] = trim( $ip_start_end[0] );
                                $ip_start_end[1] = trim( $ip_start_end[1] );
                                $client_ip = ip2long( $field_value );
                                $ip_start = ip2long( $ip_start_end[0] );
                                $ip_end = ip2long( $ip_start_end[1] );
                                if( ($client_ip >= $ip_start) && ($client_ip <= $ip_end) ){
                                    $checked_results = array( $item_obj->id );
                                    break;
                                }
                            }
                        }

                        if( $checked_results === false ){
                            //check ip range g.91.94.*
                            $ip_address_array = explode( '.', $field_value );
                            unset( $ip_address_array[count($ip_address_array) - 1] );
                            $new_ip = implode( '.', $ip_address_array ).'.*';
                            foreach( $items_array as $item_obj ){
                                if( $item_obj->value == $new_ip ){
                                    $checked_results = array( $item_obj->id );
                                    break;
                                }
                            }
                        }
                    }
                }else if( $list_type == 'EMAIL_LIST' ){
                    $field_value_domain_start = strpos( $field_value, '@' );
                    if( $field_value_domain_start === false ){
                        $checked_results = false;
                        break;
                    }
                    $filed_value_domain = substr( $field_value, $field_value_domain_start + 1, -1 );
                    $field_value_uppercase = strtoupper( $field_value );
                    foreach( $items_array as $item_obj ){
                        //check if email domain
                        if( strpos( $item_obj->value, '*@' ) !== false ){
                            $email_domain = substr( $item_obj->value, 2, -1 );

                            if( strtoupper($filed_value_domain) == strtoupper($email_domain) ){
                                $checked_results = $item_obj->id;
                                break;
                            }
                        }else{
                            $item_uppercase = strtoupper( $item_obj->value );
                            if( $item_uppercase == $field_value_uppercase ){
                                $checked_results = $item_obj->id;
                                break;
                            }
                        }
                    }
                }else if( $list_type == 'INVIT_LIST' ){
                    $field_value_uppercase = $field_value;
                    foreach( $items_array as $item_obj ){
                        $item_uppercase = $item_obj->value;
                        if( $item_uppercase == $field_value_uppercase ){
                            $checked_results = $item_obj->id;
                            break;
                        }
                    }
                }
			break;
		}
		
		return $checked_results;
	}
    
    function bsk_gfblcv_front_check_field_value_match_list_ALL( $list_id, $items_array, $list_comparison, $field_value ){
		global $wpdb;
        
        if( !$items_array || !is_array( $items_array ) || count($items_array) < 1 ){
            return false;
		}

        $checked_results = false;
        foreach ( $items_array as $item_obj ) {
            switch ( $list_comparison ) {
                case 'SAME_CASE_INSENSITIVE':
                    $field_value_uppercase = strtoupper( $field_value );
                    $item_uppercase = strtoupper( $item_obj->value );
                    
                    if( strpos( $item_uppercase, strtoupper('#bsk_whole#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_whole#'), '', $item_uppercase );
                    }
                    if( strpos( $item_uppercase, strtoupper('#bsk_word#') ) !== false ){
                        //word string match
                        $item_uppercase = str_replace( strtoupper('#bsk_word#'), '', $item_uppercase );
                    }

                    if( $item_uppercase != $field_value_uppercase ){
                        //Match_All mode, so if one item not matched then the checking will be stopped
                        $checked_results = false;
                        break;
                    } else {
                        $checked_results[] = $item_obj->id;
                    }
                break;
                case 'CONTAINS_CASE_INSENSITIVE':
                    $field_value_uppercase = strtoupper( $field_value );
                    $item_uppercase = strtoupper( $item_obj->value );
                    
                    $whole_checking = false;
                    $word_checking = false;
                    $normal_checking = false;
                    $enhanced_checking_1 = false;
                    $enhanced_checking_2 = false;
                    
                    if ( strpos( $item_uppercase, strtoupper('#bsk_whole#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_whole#'), '', $item_uppercase );
                        if( strpos($field_value_uppercase, $item_uppercase) !== false ){
                            $whole_checking = true;
                        }
                    } else if( strpos( $item_uppercase, strtoupper('#bsk_word#') ) !== false ){
                        //whole string match
                        $item_uppercase = str_replace( strtoupper('#bsk_word#'), '', $item_uppercase );
                        $field_value_uppercase_array = explode( ' ', $field_value_uppercase );
                        foreach( $field_value_uppercase_array as $field_value_word ) {
                            $field_value_word = trim( $field_value_word );
                            if( $field_value_word == $item_uppercase ){
                                $word_checking = true;
                                break;
                            }
                        }
                    } else {
                        $item_uppercase = strtoupper( trim($item_obj->value) );
                        if( strpos( $item_uppercase, ' ') !== false ){

                            //multiple words
                            $field_value_single_space = preg_replace( '/\s+/', ' ', $field_value_uppercase );
                            $item_uppercase_single_space = preg_replace( '/\s+/', ' ', $item_uppercase );
                            if( strpos($field_value_single_space, $item_uppercase_single_space) !== false ){
                                $normal_checking = true;
                            }else{
                                //enhanced checking 1
                                $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                                $matches_array = array();
                                $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                                if( $match_return && count($matches_array) > 1 ){
                                    $special_char_array = array_unique( $matches_array[1] );
                                    foreach( $special_char_array as $special_char ){
                                        //organise new keyword
                                        $item_uppercase_single_word_array = explode( ' ', $item_uppercase_single_space );
                                        foreach( $item_uppercase_single_word_array as $key => $signle_word ){
                                            $new_single_word_array = str_split( $signle_word );
                                            $new_single_word = implode( $special_char, $new_single_word_array );
                                            $item_uppercase_single_word_array[$key] = $new_single_word;
                                        }
                                        $item_to_check = implode( ' ', $item_uppercase_single_word_array );
                                        if( strpos($field_value_single_space, $item_to_check) !== false ){
                                            $enhanced_checking_1 = true;
                                            break; //only break foreach for $special_char_array
                                        }
                                    }
                                }

                                if( $enhanced_checking_1 === false ){
                                    //enhanced checking 2
                                    $pattern = '/["*#$!=+@%_\'~,-]/';
                                    $field_value_single_space = preg_replace( $pattern, '', $field_value_single_space );
                                    if( strpos($field_value_single_space, $item_uppercase_single_space) !== false ){
                                        $enhanced_checking_2 = true;
                                    }
                                }
                            }
                        }else{
                            //single word
                            if( strpos($field_value_uppercase, $item_uppercase) !== false ){
                                $normal_checking = true;
                            }else{
                                //enhanced checking 1
                                $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                                $matches_array = array();
                                $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                                if( $match_return && count($matches_array) > 1 ){
                                    $special_char_array = array_unique( $matches_array[1] );
                                    foreach( $special_char_array as $special_char ){
                                        //organise new keyword
                                        $new_item_uppercase_array = str_split( $item_uppercase );
                                        $item_to_check = implode( $special_char, $new_item_uppercase_array );

                                        if( strpos($field_value_uppercase, $item_to_check) !== false ){
                                            $enhanced_checking_1 = true;
                                            break; //only break foreach for $special_char_array
                                        }
                                    }
                                }
                                if( $enhanced_checking_1 == false ){
                                    //enhanced checking 2
                                    $pattern = '/[ "*#$!=+@%_\'~,-]/';
                                    $field_value_uppercase_to_check = preg_replace( $pattern, '', $field_value_uppercase );
                                    if( strpos($field_value_uppercase_to_check, $item_uppercase) !== false ){
                                        $enhanced_checking_2 = true;
                                    }
                                }
                            }

                        }
                    }
                    
                    if( $whole_checking == false &&
                        $word_checking == false &&
                        $normal_checking == false &&
                        $enhanced_checking_1 == false &&
                        $enhanced_checking_2 == false ){

                        $checked_results = false;
                        break;
                    } else {
                        $checked_results[] = $item_obj->id;
                    }
                break;
                case 'SAME_CASE_SENSITIVE':
                    foreach ( $items_array as $item_obj ) {
                        $item_value = $item_obj->value;
                        if( strpos( $item_value, '#bsk_whole#' ) !== false ){
                            //whole string match
                            $item_value = str_replace( '#bsk_whole#', '', $item_value );
                        }
                        if( strpos( $item_value, '#bsk_word#' ) !== false ){
                            //whole string match
                            $item_value = str_replace( '#bsk_word#', '', $item_value );
                        }
                        if( $field_value != $item_value ){
                            //Match_All mode, so if one item not matched then the checking will be stopped
                            $checked_results = false;
                            break;
                        }else{
                            $checked_results[] = $item_obj->id;
                        }
                    }
                break;
                case 'CONTAINS_CASE_SENSITIVE':
                    $whole_checking = false;
                    $word_checking = false;
                    $normal_checking = false;
                    $enhanced_checking_1 = false;
                    $enhanced_checking_2 = false;
                    
                    $item_value = $item_obj->value;
                    if ( strpos( $item_value, '#bsk_whole#' ) !== false ){
                        //whole string match
                        $item_value = str_replace( '#bsk_whole#', '', $item_value );
                        if( strpos($field_value, $item_value) !== false ){
                            $whole_checking = true;
                        }
                    } else if( strpos( $item_value, '#bsk_word#' ) !== false ){
                        //whole string match
                        $item_value = str_replace( '#bsk_word#', '', $item_value );
                        $field_value_array = explode( ' ', $field_value );
                        foreach( $field_value_array as $field_value_word ) {
                            $field_value_word = trim( $field_value_word );
                            if( $field_value_word == $item_value ){
                                $word_checking = true;
                                break;
                            }
                        }
                    } else {
                        if( strpos( $item_value, ' ') !== false ){

                            //multiple words
                            $field_value_single_space = preg_replace( '/\s+/', ' ', $field_value );
                            $item_value_single_space = preg_replace( '/\s+/', ' ', $item_value );
                            if( strpos($field_value_single_space, $item_value_single_space) !== false ){
                                $normal_checking = true;
                            }else{
                                //enhanced checking 1
                                $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                                $matches_array = array();
                                $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                                if ( $match_return && count($matches_array) > 1 ) {
                                    $special_char_array = array_unique( $matches_array[1] );
                                    foreach ( $special_char_array as $special_char ) {
                                        //organise new keyword
                                        $item_value_single_word_array = explode( ' ', $item_value_single_space );
                                        foreach( $item_value_single_word_array as $key => $signle_word ){
                                            $new_single_word_array = str_split( $signle_word );
                                            $new_single_word = implode( $special_char, $new_single_word_array );
                                            $item_value_single_word_array[$key] = $new_single_word;
                                        }
                                        $item_to_check = implode( ' ', $item_value_single_word_array );
                                        if( strpos($field_value_single_space, $item_to_check) !== false ) {
                                            $enhanced_checking_1 = true;
                                            break; //only break foreach for $special_char_array
                                        }
                                    }
                                }

                                if( $enhanced_checking_1 === false ){
                                    //enhanced checking 2
                                    $pattern = '/["*#$!=+@%_\'~,-]/';
                                    $field_value_single_space = preg_replace( $pattern, '', $field_value_single_space );
                                    if( strpos($field_value_single_space, $item_value_single_space) !== false ){
                                        $enhanced_checking_2 = true;
                                    }
                                }
                            }
                        }else{
                            //single word
                            if( strpos($field_value, $item_value) !== false ){
                                $normal_checking = true;
                            }else{
                                //enhanced checking 1
                                $pattern = '/[a-zA-Z0-9]+([ "*#$!=+@%_\'~,-]+)[a-zA-Z0-9]+/i';
                                $matches_array = array();
                                $match_return = preg_match_all( $pattern, $field_value, $matches_array );
                                if( $match_return && count($matches_array) > 1 ){
                                    $special_char_array = array_unique( $matches_array[1] );
                                    foreach( $special_char_array as $special_char ){
                                        //organise new keyword
                                        $new_item_value_array = str_split( $item_value );
                                        $item_to_check = implode( $special_char, $new_item_value_array );

                                        if( strpos($field_value, $item_to_check) !== false ){
                                            $enhanced_checking_1 = true;
                                            break; //only break foreach for $special_char_array
                                        }
                                    }
                                }
                                if( $enhanced_checking_1 == false ){
                                    //enhanced checking 2
                                    $pattern = '/[ "*#$!=+@%_\'~,-]/';
                                    $field_value_to_check = preg_replace( $pattern, '', $field_value );
                                    if( strpos($field_value_to_check, $item_value) !== false ){
                                        $enhanced_checking_2 = true;
                                    }
                                }
                            }

                        }
                    }
                    
                    if( $whole_checking == false &&
                        $word_checking == false &&
                        $normal_checking == false &&
                        $enhanced_checking_1 == false &&
                        $enhanced_checking_2 == false ){

                        $checked_results = false;
                        break;
                    } else {
                        $checked_results[] = $item_obj->id;
                    }
                break;
            }
        }

        //check the checked_results_array
        if ( is_array( $checked_results ) && count( $checked_results ) > 0 ) {
            $checked_results = array_unique( $checked_results );

            if ( count( $checked_results ) == count( $items_array ) ) {
                return $checked_results;
            }
        }

        $checked_results = false;

        return $checked_results;
	}
    
    function bsk_gfblcv_save_blocked_form_data( $fields_hit_data, $form_data, $form_plugins ){
        global $wpdb;
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        if( $license_type == 'PERSONAL' || $license_type == 'CREATOR' ){
            return;
        }
                
        $current_date = date( 'Y-m-d H:i:s', current_time('timestamp') );
        $client_ip = BSK_GFBLCV_Pro_Dashboard_Common::get_ip();

        //insert entry
        $data_to_insert = array();
        $data_to_insert['form_id'] = $form_data['form_id'];
        $data_to_insert['form_data'] = serialize( $form_data );
        $data_to_insert['ip'] = $client_ip;
        $data_to_insert['submit_date'] = $current_date;
        $data_to_insert['forms'] = $form_plugins;

        $wpdb->insert( $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_entries_tbl_name, $data_to_insert, array( '%d', '%s', '%s', '%s', '%s' ) );
        $entry_id = $wpdb->insert_id;

        //insert hits data
        foreach( $fields_hit_data as $field_id => $list_items_data ){
            $data_to_insert = array();
            $data_to_insert['entry_id'] = $entry_id;
            $data_to_insert['field_id'] = $field_id;
            $data_to_insert['list_id'] = $list_items_data['list_id'];
            $data_to_insert['extra_data'] = serialize( $list_items_data['extra_data'] );
            $data_to_insert['submit_date'] = $current_date;
            foreach( $list_items_data['items_id'] as $item_id ){
                $data_to_insert['item_id'] = intval( $item_id );
                $wpdb->insert( $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_hits_tbl_name, $data_to_insert, array( '%d', '%s', '%d', '%s', '%s', '%d' ) );
            }
        }
    }
    
    function bsk_gfblcv_notify_administrators( $form_notify_send_to, $form_title, $form_submission_data, $field_hits_data_array, $form_plugin ){
        $plugin_settings = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_settings_option, false );
        if( !isset( $plugin_settings['notify_details'] ) || !is_array( $plugin_settings['notify_details'] ) ){
            return;
        }
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        if( $license_type == 'PERSONAL' || $license_type == 'CREATOR' ){
            return;
        }
        
        global $wpdb;
        
        $list_tbl = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_list_tbl_name;
        $item_tbl = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
        
        $send_to = get_option( 'admin_email' );
        $from_name = '';
        $from_email = '';
        $subject = 'New submission from {form_title} on {form_submission_date}';
        $message = '{form_submission_data}';
        $client_ip = BSK_GFBLCV_Pro_Dashboard_Common::get_ip();
        $submit_date = date( 'Y-m-d H:i:s', current_time('timestamp') );
        
        //global settings
        $notify_details = $plugin_settings['notify_details'];
        if( $notify_details && is_array( $notify_details ) && count( $notify_details ) > 0 ){
            if( isset( $notify_details['send_to'] ) && $notify_details['send_to'] ){
                $send_to = $notify_details['send_to'];
            }
            if( isset( $notify_details['from_name'] ) && $notify_details['from_name'] ){
                $from_name = $notify_details['from_name'];
            }
            if( isset( $notify_details['from_email'] ) && $notify_details['from_email'] ){
                $from_email = $notify_details['from_email'];
            }
            if( isset( $notify_details['subject'] ) && $notify_details['subject'] ){
                $subject = $notify_details['subject'];
            }
            if( isset( $notify_details['message'] ) && $notify_details['message'] ){
                $message = $notify_details['message'];
            }
        }
        
        if ( $form_notify_send_to && strlen( $form_notify_send_to ) > 2 ) {
            $send_to = $form_notify_send_to;
        }
        
        $subject = str_replace( '{form_title}', $form_title, $subject );
        $subject = str_replace( '{form_submission_date}', $submit_date, $subject );
        $subject = str_replace( '{form_submission_IP}', $client_ip, $subject );
        if( strpos( $message, '{form_submission_data}' ) !== false ){
            //organise hits data
            $hits_data = array();
            foreach( $field_hits_data_array as $field_id => $list_items_data ){
                
                if( !isset( $hits_data[$field_id] ) ){
                    $hits_data[$field_id] = array();
                }
                
                //get list by id
                $sql = 'SELECT L.`list_name`, L.`list_type`, L.`check_way`, L.`extra` AS list_extra '.
                       'FROM `'.$list_tbl.'` AS L '.
                       'WHERE L.`id` = %d';
                $sql = $wpdb->prepare( $sql, $list_items_data['list_id'] );
                $list_obj_results = $wpdb->get_results( $sql );
                if( !$list_obj_results || !is_array( $list_obj_results ) || count( $list_obj_results ) < 1 ){
                    continue;
                }
                $list_obj = $list_obj_results[0];

                $hits_data[$field_id]['list_id'] = $list_items_data['list_id'];
                $hits_data[$field_id]['list_name'] = $list_obj->list_name;
                $hits_data[$field_id]['list_type'] = $list_obj->list_type;
                $hits_data[$field_id]['list_check_way'] = $list_obj->check_way;
                $hits_data[$field_id]['list_extra'] = $list_obj->list_extra;
                $hits_data[$field_id]['extra_data'] = $list_items_data['extra_data'];
                if( !isset( $hits_data[$field_id]['items_value'] ) ){
                    $hits_data[$field_id]['items_value'] = array();
                }
                
                //get items
                if( is_array( $list_items_data['items_id'] ) && count( $list_items_data['items_id'] ) > 0 ){
                    $sql = 'SELECT I.`id`, I.`value` FROM `'.$item_tbl.'` AS I WHERE I.`id` IN( '.implode( ',', $list_items_data['items_id'] ).' )';
                    $item_obj_results = $wpdb->get_results( $sql );
                    
                    $item_value_array = array();
                    if( $item_obj_results && is_array( $item_obj_results ) && count( $item_obj_results ) > 0 ){
                        foreach( $item_obj_results as $item_obj ){
                            $item_value_array[$item_obj->id] = $item_obj->value;
                        }
                    }
                    foreach( $list_items_data['items_id'] as $item_id ){
                        $item_value = isset( $item_value_array[$item_id] ) ? $item_value_array[$item_id] : $item_id;
                        $hits_data[$field_id]['items_value'][] = ( $item_id == -1 || $item_id == -2 ) ? 'NO_ITEM_MATCH' : $item_value;
                    }
                }
            }
            
            //organie form data
            $entry_id = 0;
            $entry_html = BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_render_entry_html( $form_submission_data, $hits_data, $entry_id, $client_ip, $form_plugin );
            $message = str_replace( '{form_submission_data}', $entry_html, $message );
        }
        
        $message = str_replace( '{form_title}', $form_title, $message );
        $message = str_replace( '{form_submission_date}', $submit_date, $message );
        $message = str_replace( '{form_submission_IP}', $client_ip, $message );
        
        //get template
        $tmpl = BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_get_mail_tmpl( 'notify-admin-tmpl' );
        $message = str_replace( '{BSK_GFBL_MAIL_BODY}', $message, $tmpl );
        $message = str_replace( '{BSK_GFBL_MAIL_SUBJECT}', $subject, $message );
        
        add_filter( 'wp_mail_content_type', array( $this, 'bsk_gfblcv_wp_mail_content_type' ) );
        
        if( strpos( $send_to, ',' ) !== false ){
           $send_to = explode( ',', $send_to ); 
        }

        $headers = array( 'Content-Type: text/html; charset=UTF-8' );
        $headers[] = 'From: '.$from_name.' <'.$from_email.'>';

        wp_mail( $send_to, $subject, $message, $headers );
        
        remove_filter( 'wp_mail_content_type', array( $this, 'bsk_gfblcv_wp_mail_content_type' ) );
    }
    
    function bsk_gfblcv_wp_mail_content_type(){
        return "text/html";
    }

}
