<?php

class BSK_GFBLCV_Pro_Submitting_CF7 {
    
    var $_OBJ_common = false;

	public function __construct( $args ) {
        
        $this->_OBJ_common = $args['common_class'];
        
        if ( BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_is_form_plugin_supported('CF7') ) {
            add_filter( 'wpcf7_validate', array( $this, 'bsk_gfblcv_cf7_validate_item' ), 10, 2 );
            add_filter( 'wpcf7_skip_mail', array( $this, 'bsk_gfblcv_cf7_skip_mail'), 10, 2 );
            add_filter( 'wpcf7_additional_mail', array( $this, 'bsk_gfblcv_cf7_skip_mail_2'), 10, 2 );
            add_action( 'wpcf7_mail_sent', array( $this, 'bsk_gfblcv_cf7_update_invit_list_items_hits_data' ), 9999, 1 );
        }
		
	}
	
	function bsk_gfblcv_cf7_validate_item( $validation_result, $form_fields ){
        
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){

            return $validation_result;
		}

        if( ! $form_fields || ! is_array( $form_fields ) || count( $form_fields ) < 1 ){
            return $validation_result;
        }

        $wpcf7_instance = WPCF7_Submission::get_instance();
        $contact_form = $wpcf7_instance->get_contact_form();
        $form_id = $contact_form->id();
        $form_title = $contact_form->title();
        $bsk_gfblcv_form_settings = $this->cf7_blacklist_get_form_settings( $form_id, $contact_form );

        $enable = false;
        $action_when_hit = array( 'BLOCK' );
        $mails_to_skip = array();
        $save_blocked_data = 'NO';
        $notify_administrators = 'NO';
        $notify_send_to = '';
        $delete_entry = 'NO';
        $default = 'The value for field "[FIELD_LABEL]" is invalid!';
        $ip_default = 'Your IP address [VISITOR_IP] is forbidden!';
        $blacklist_message = $default;
        $whitelist_message = $default;
        $emaillist_message = $default;
        $iplist_message = $ip_default;
        $invitlist_message = $default;
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            if ( isset( $bsk_gfblcv_form_settings['mails_to_skip'] ) ) {
                $mails_to_skip = $bsk_gfblcv_form_settings['mails_to_skip'];
            }
            $save_blocked_data = $bsk_gfblcv_form_settings['save_blocked_data'];
            $notify_administrators = $bsk_gfblcv_form_settings['notify_administrators'];
            $notify_send_to = $bsk_gfblcv_form_settings['notify_send_to'];
            $delete_entry = $bsk_gfblcv_form_settings['delete_entry'];
            $blacklist_message = $bsk_gfblcv_form_settings['blacklist_message'];
            $whitelist_message = $bsk_gfblcv_form_settings['whitelist_message'];
            if ( isset($bsk_gfblcv_form_settings['emaillist_message']) && 
                $bsk_gfblcv_form_settings['emaillist_message'] ) {
                $emaillist_message = $bsk_gfblcv_form_settings['emaillist_message'];
            }
            if ( isset($bsk_gfblcv_form_settings['iplist_message']) && 
                $bsk_gfblcv_form_settings['iplist_message'] ) {
                $iplist_message = $bsk_gfblcv_form_settings['iplist_message'];
            }
            if ( isset($bsk_gfblcv_form_settings['invitlist_message']) && 
                $bsk_gfblcv_form_settings['invitlist_message'] ) {
                $invitlist_message = $bsk_gfblcv_form_settings['invitlist_message'];
            }
        }
        $form_default_validation_messages = array( 
                                                    'black' => $blacklist_message,
                                                    'white' => $whitelist_message,
                                                    'email' => $emaillist_message,
                                                    'ip' => $iplist_message,
                                                    'invit' => $invitlist_message,
                                                 );
        if ( !$enable ) {
            return $validation_result;
        }
        
        if ( !in_array( 'BLOCK', $action_when_hit ) ) {
            return $validation_result;
        }
        
        //validation
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $fields_hit_item_array = array(); //only for blocked
        $form_data_array = array();
        //get field mapping
        $form_mappings = $this->cf7_blacklist_get_form_mappings( $form_id );
        foreach ( $form_fields as $field ) {
            if( $field->name == "" ){
                continue;
            }

            $field_value = $wpcf7_instance->get_posted_data( $field->name );
            if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                $form_data_array[$field->name] = array( 'label' => $field->name, 'value' => $field_value );
            }

            if( isset( $validation_result->invalid_fields[$field->name] ) ){
                continue;
            }
            
            //validate field value against blacklist
            if( ! isset( $form_mappings[$field->name] ) || ! is_array( $form_mappings[$field->name] ) || count( $form_mappings[$field->name] ) < 1 || 
                $form_mappings[$field->name]['list_type'] == '' || $form_mappings[$field->name]['save_id_error'] || $form_mappings[$field->name]['save_comparison_error'] ){
                continue;
            }
            
            $field_return_message = '';
            $checked_results = $this->bsk_gfblcv_check_field_value_againsit_list_item( $form_mappings[$field->name], 
                                                                                       $field->name, 
                                                                                       $field_value, 
                                                                                       $form_default_validation_messages,
                                                                                       $fields_hit_item_array,
                                                                                       $field_return_message );
            if( $checked_results ){
                $validation_result->invalidate( $field, $field_return_message );
            }
        }

        //insert form data and hits data into database
        //only for blocked
        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
            
            //global settings
            $settings_data = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_settings_option, false );
            $global_save_blocked_entry = 'NO';
            $global_notify_blocked = 'NO';
            if( $settings_data && is_array( $settings_data ) && count( $settings_data ) > 0 ){
                if( isset( $settings_data['save_blocked_entry'] ) ){
                    $global_save_blocked_entry = $settings_data['save_blocked_entry'];
                }
                if( isset( $settings_data['notify_blocked'] ) ){
                    $global_notify_blocked = $settings_data['notify_blocked'];
                }
            }
            
            //get final settings
            $final_save_blocked_form_data = true;
            $final_notify_administrators = false;
            if( $global_save_blocked_entry == 'NO' || $save_blocked_data == 'NO' ){
                $final_save_blocked_form_data = false;
            }
            if( $global_notify_blocked == 'YES' && $notify_administrators == 'YES' ){
                $final_notify_administrators = true;
            }
            
            if( $fields_hit_item_array && is_array( $fields_hit_item_array ) && count( $fields_hit_item_array ) > 0 ){
                //save hits data
                if( $final_save_blocked_form_data ){
                    $form_data_array['form_id'] = $form_id;
                    $this->_OBJ_common->bsk_gfblcv_save_blocked_form_data( $fields_hit_item_array, $form_data_array, 'CF7' );
                }
                
                //send out administrator notifications
                if( $final_notify_administrators ){
                    $this->_OBJ_common->bsk_gfblcv_notify_administrators( $notify_send_to, $form_title, $form_data_array, $fields_hit_item_array, 'CF7' );
                }
            }
            
        }
        
        return $validation_result;
    }
    
    function cf7_blacklist_get_form_settings( $form_id, $contact_form ){

        $bsk_gfblcv_form_settings = get_post_meta( $form_id, BSK_GFBLCV_Pro_Dashboard::$_bsk_gfblcv_cf7_form_settings_opt, true );
		if ( ! $bsk_gfblcv_form_settings || ! is_array( $bsk_gfblcv_form_settings ) || count( $bsk_gfblcv_form_settings ) < 1 ) {
			//no saved, to check if convert from CF7 Blacklist plugin
			BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_cf7_convert_cf7blacklist_data( $contact_form );
			//get again
			$bsk_gfblcv_form_settings = get_post_meta( $form_id, BSK_GFBLCV_Pro_Dashboard::$_bsk_gfblcv_cf7_form_settings_opt, true );
		}
        
        return $bsk_gfblcv_form_settings;
    }

    function cf7_blacklist_get_form_mappings( $form_id ){
        $form_mappings = get_post_meta( $form_id, BSK_GFBLCV_Pro_Dashboard::$_bsk_gfblcv_cf7_form_mappings_opt, true );
        
        return $form_mappings;
    }
    
    function bsk_gfblcv_check_field_value_againsit_list_item( $field_mappings,
                                                              $field_name,
                                                              $field_value, 
                                                              $form_default_validation_message_array,
                                                              &$fields_hit_item_array,
                                                              &$validation_return_message ){
        
        global $wpdb;
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        
        $list_type = $field_mappings['list_type'];
        $list_id_to_check = $field_mappings['list_id'];
        $comparison_to_check = $field_mappings['list_comparison'];
        $validation_message = '';

        $invalid_validation = false;
        if( $field_value == "" || $list_type == '' ){
            return $invalid_validation;
        }

        if( ! $list_id_to_check || ! $comparison_to_check ){
            return $invalid_validation;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return $invalid_validation;
        }

        switch ( $list_type ) {
            case 'BLACK_LIST':
                $validation_message = $form_default_validation_message_array['black'];
            break;
            case 'WHITE_LIST':
                $validation_message = $form_default_validation_message_array['white'];
            break;
            case 'EMAIL_LIST':
                $validation_message = $form_default_validation_message_array['email'];
            break;
            case 'IP_LIST':
                $validation_message = $form_default_validation_message_array['ip'];
                $field_value = BSK_GFBLCV_Pro_Dashboard_Common::get_ip();
            break;
            case 'INVIT_LIST':
                $validation_message = $form_default_validation_message_array['invit'];
            break;
        }

        if ( isset( $field_mappings['validation_message'] ) && strlen( trim( $field_mappings['validation_message'] ) ) > 0 ) {
            $validation_message = $field_mappings['validation_message'];
        }

        $validation_message = $this->_OBJ_common->bsk_gfblcv_render_validation_message( 
                                                                                    $validation_message, 
                                                                                    $field_name, 
                                                                                    $field_value, 
                                                                                    BSK_GFBLCV_Pro_Dashboard_Common::get_ip() 
                                                                                );
        
        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array($checked_results) && count($checked_results) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
        }
        
        switch( $list_type ){
            case 'BLACK_LIST':
                if( $checked_results ){

                    $validation_return_message = $validation_message;
                    $invalid_validation = true;

                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_name] = array( 
                                                                        'list_id' => $list_id_to_check, 
                                                                        'items_id' => explode( ',', $item_id_str ),
                                                                        'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                    );
                    }
                }
            break;
            case 'WHITE_LIST':
                if( ! $checked_results ){

                    $validation_return_message = $validation_message;
                    $invalid_validation = true;

                    //save items id for blocked entry
                    if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                        $fields_hit_item_array[$field_name] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => array( -1 ), 
                                                                            'extra_data' => array( 'mode' => 'NOT_APPLIIED' )
                                                                        );
                    }
                }else{
                    //update hits counter
                    $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                }
            break;
            case 'IP_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){

                        $validation_return_message = $validation_message;
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_name] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => array( -2 ), 
                                                                                'extra_data' => array( 'mode' => 'ALLOW' )
                                                                            );
                        }

                        break;
                    }else if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ) {
                        //for the case by country, it only return true or false, so won't come to here
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){

                        $validation_return_message = $validation_message;
                        $invalid_validation = true;

                        $blocked_item_id_to_save = array( -2 ); //default -2 is for IP list COUNTRY check way
                        if( $checked_results > 1 || ( is_array($checked_results) && count($checked_results) ) ){
                            //for the case by country, it only return true or false, so won't come to here
                            //update hits counter
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                            $blocked_item_id_to_save = explode( ',', $item_id_str );
                        }

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_name] = array( 
                                                                                'list_id' => $list_id_to_check, 
                                                                                'items_id' => $blocked_item_id_to_save, 
                                                                                'extra_data' => array( 'mode' => 'BLOCK' )
                                                                            );
                        }
                    }
                }
            break;
            case 'EMAIL_LIST':
            case 'INVIT_LIST':
                if( $comparison_to_check == 'ALLOW' ){
                    if( !$checked_results ){

                        $validation_return_message = $validation_message;
                        $invalid_validation = true;

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_name] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => array( -1 ), 
                                                                            'extra_data' => array( 'mode' => 'ALLOW' )
                                                                         );
                        }

                        break;
                    }else{
                        //update hits counter, invit codes list will be updated to entry id at the last
                        if( $list_type != 'INVIT_LIST' ){
                            $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );
                        }
                    }
                }else if( $comparison_to_check == 'BLOCK' ){
                    if( $checked_results ){

                        $validation_return_message = $validation_message;
                        $invalid_validation = true;
                        
                        //update hits counter
                        $this->_OBJ_common->bsk_gfblcv_update_item_hits( $item_id_str );

                        //save items id for blocked entry
                        if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                            $fields_hit_item_array[$field_name] = array( 
                                                                            'list_id' => $list_id_to_check, 
                                                                            'items_id' => explode( ',', $item_id_str ), 
                                                                            'extra_data' => array( 'mode' => 'BLOCK' )
                                                                         );
                        }
                    }
                }
            break;
        }
        
        return $invalid_validation;
    }

    function bsk_gfblcv_cf7_update_invit_list_items_hits_data( $contact_form ) {

        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return;
		}
        
        $wpcf7_instance = WPCF7_Submission::get_instance();
        $manager = WPCF7_FormTagsManager::get_instance();
        $form_fields = $manager->scan( $contact_form->prop( 'form' ) );
        if( ! $form_fields || !is_array( $form_fields ) || count( $form_fields ) < 1 ){
            return;
        }

        $form_id = $contact_form->id();
        $form_title = $contact_form->title();
        $bsk_gfblcv_form_settings = $this->cf7_blacklist_get_form_settings( $form_id, $contact_form );

        $enable = false;
        $action_when_hit = array( 'BLOCK' );
        $mails_to_skip = array();
        $save_blocked_data = 'NO';
        $notify_administrators = 'NO';
        $notify_send_to = '';
        $delete_entry = 'NO';
        $default = 'The value for field "[FIELD_LABEL]" is invalid!';
        $ip_default = 'Your IP address [VISITOR_IP] is forbidden!';
        $blacklist_message = $default;
        $whitelist_message = $default;
        $emaillist_message = $default;
        $iplist_message = $ip_default;
        $invitlist_message = $default;
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            if ( isset( $bsk_gfblcv_form_settings['mails_to_skip'] ) ) {
                $mails_to_skip = $bsk_gfblcv_form_settings['mails_to_skip'];
            }
            $save_blocked_data = $bsk_gfblcv_form_settings['save_blocked_data'];
            $notify_administrators = $bsk_gfblcv_form_settings['notify_administrators'];
            $notify_send_to = $bsk_gfblcv_form_settings['notify_send_to'];
            $delete_entry = $bsk_gfblcv_form_settings['delete_entry'];
            $blacklist_message = $bsk_gfblcv_form_settings['blacklist_message'];
            $whitelist_message = $bsk_gfblcv_form_settings['whitelist_message'];
            if ( isset($bsk_gfblcv_form_settings['emaillist_message']) && 
                $bsk_gfblcv_form_settings['emaillist_message'] ) {
                $emaillist_message = $bsk_gfblcv_form_settings['invitlist_message'];
            }
            if ( isset($bsk_gfblcv_form_settings['iplist_message']) && 
                $bsk_gfblcv_form_settings['iplist_message'] ) {
                $iplist_message = $bsk_gfblcv_form_settings['iplist_message'];
            }
            if ( isset($bsk_gfblcv_form_settings['invitlist_message']) && 
                $bsk_gfblcv_form_settings['invitlist_message'] ) {
                $invitlist_message = $bsk_gfblcv_form_settings['invitlist_message'];
            }
        }
        $form_default_validation_messages = array( 
                                                    'black' => $blacklist_message,
                                                    'white' => $whitelist_message,
                                                    'email' => $emaillist_message,
                                                    'ip' => $iplist_message,
                                                    'invit' => $invitlist_message,
                                                 );
        if ( !$enable ) {
            return;
        }
        
        if ( !in_array( 'BLOCK', $action_when_hit ) ) {
            return;
        }

        //validation
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $fields_hit_item_array = array(); //only for blocked
        $form_data_array = array();
        //get field mapping
        $form_mappings = $this->cf7_blacklist_get_form_mappings( $form_id );
        if ( ! $form_mappings || ! is_array( $form_mappings ) || count( $form_mappings ) < 1 ) {
            return;
        }
        foreach ( $form_fields as $field ) {
            if( $field->name == "" ){
                continue;
            }

            $field_value = $wpcf7_instance->get_posted_data( $field->name );
            if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                $form_data_array[$field->name] = array( 'label' => $field->name, 'value' => $field_value );
            }

            if( isset( $validation_result->invalid_fields[$field->name] ) ){
                continue;
            }
            
            //validate field value against blacklist
            if( ! isset( $form_mappings[$field->name] ) || ! is_array( $form_mappings[$field->name] ) || count( $form_mappings[$field->name] ) < 1 || 
                $form_mappings[$field->name]['list_type'] == '' || $form_mappings[$field->name]['save_id_error'] || $form_mappings[$field->name]['save_comparison_error'] ||
                $form_mappings[$field->name]['list_type'] != 'INVIT_LIST' ){

                continue;
            }

            $field_return_message = '';
            $this->bsk_gfblcv_update_invit_list_item_hits(  
                                                            $form_id,
                                                            $form_mappings[$field->name], 
                                                            $field->name, 
                                                            $field_value, 
                                                            $form_default_validation_messages,
                                                            $fields_hit_item_array,
                                                            $field_return_message 
                                                        );
        }

    }
    
    function bsk_gfblcv_update_invit_list_item_hits(    $form_id,
                                                        $field_mappings,
                                                        $field_name,
                                                        $field_value, 
                                                        $form_default_validation_message_array,
                                                        &$fields_hit_item_array,
                                                        &$validation_return_message ){
        
        $list_type = $field_mappings['list_type'];
        $list_id_to_check = $field_mappings['list_id'];
        $comparison_to_check = $field_mappings['list_comparison'];
        $validation_message = '';

        $invalid_validation = false;
        if( $field_value == "" || $list_type == '' ){
            return;
        }

        if( ! $list_id_to_check || ! $comparison_to_check ){
            return;
        }

        //check if the list still active, as some case the list deleted but it still save in form settings
        if ( ! $this->_OBJ_common->bsk_gfblcv_front_check_list_status( $list_id_to_check, $list_type ) ) {
            return $invalid_validation;
        }

        $checked_results = $this->_OBJ_common->bsk_gfblcv_front_check_field_value_match_list(
                                                        $list_type,
                                                        $list_id_to_check, 
                                                        $comparison_to_check, 
                                                        $field_value
                                                    );
        $item_id_str = '';
        if( $checked_results ){
            if( is_array( $checked_results ) && count( $checked_results ) > 0 ){
                $item_id_str = implode( ',', $checked_results );
            }else{
                $item_id_str = $checked_results;
            }
            //update hits to entry id
            $entry_id = -1;
            $this->_OBJ_common->bsk_gfblcv_update_item_hits_to( $item_id_str, $form_id, $entry_id, 'CF7' );
        }

        return;
    }

    function bsk_gfblcv_cf7_skip_mail( $skip, $contact_form ){
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return $skip;
		}
        
        $wpcf7_instance = WPCF7_Submission::get_instance();
        $manager = WPCF7_FormTagsManager::get_instance();
        $form_fields = $manager->scan( $contact_form->prop( 'form' ) );
        if( ! $form_fields || !is_array( $form_fields ) || count( $form_fields ) < 1 ){
            return $skip;
        }

        $form_id = $contact_form->id();
        $form_title = $contact_form->title();
        $bsk_gfblcv_form_settings = $this->cf7_blacklist_get_form_settings( $form_id, $contact_form );

        $enable = false;
        $action_when_hit = array( 'BLOCK' );
        $mails_to_skip = array();
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            if ( isset( $bsk_gfblcv_form_settings['mails_to_skip'] ) ) {
                $mails_to_skip = $bsk_gfblcv_form_settings['mails_to_skip'];
            }
        }

        if ( ! $enable ) {
            return $skip;
        }
        
        if ( ! in_array( 'SKIP', $action_when_hit ) ) {
            return $skip;
        }

        if ( ! in_array( 'Mail', $mails_to_skip ) ) {
            return $skip;
        }

        $default = 'The value for field "[FIELD_LABEL]" is invalid!';
        $ip_default = 'Your IP address [VISITOR_IP] is forbidden!';
        $blacklist_message = $default;
        $whitelist_message = $default;
        $emaillist_message = $default;
        $iplist_message = $ip_default;
        $invitlist_message = $default;
        $form_default_validation_messages = array( 
                                                    'black' => $blacklist_message,
                                                    'white' => $whitelist_message,
                                                    'email' => $emaillist_message,
                                                    'ip' => $iplist_message,
                                                    'invit' => $invitlist_message,
                                                 );

        //validation
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $fields_hit_item_array = array(); //only for blocked
        $form_data_array = array();
        //get field mapping
        $form_mappings = $this->cf7_blacklist_get_form_mappings( $form_id );
        foreach ( $form_fields as $field ) {
            if( $field->name == "" ){
                continue;
            }

            $field_value = $wpcf7_instance->get_posted_data( $field->name );
            if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                $form_data_array[$field->name] = array( 'label' => $field->name, 'value' => $field_value );
            }

            if( isset( $validation_result->invalid_fields[$field->name] ) ){
                continue;
            }
            
            //validate field value against blacklist
            if( ! isset( $form_mappings[$field->name] ) || ! is_array( $form_mappings[$field->name] ) || count( $form_mappings[$field->name] ) < 1 || 
                $form_mappings[$field->name]['list_type'] == '' || $form_mappings[$field->name]['save_id_error'] || $form_mappings[$field->name]['save_comparison_error'] ){
                continue;
            }
            
            $field_return_message = '';
            $checked_results = $this->bsk_gfblcv_check_field_value_againsit_list_item( $form_mappings[$field->name], 
                                                                                       $field->name, 
                                                                                       $field_value, 
                                                                                       $form_default_validation_messages,
                                                                                       $fields_hit_item_array,
                                                                                       $field_return_message );
            if( $checked_results ){
                return true;
            }
        }

        return $skip;
    }

    function bsk_gfblcv_cf7_skip_mail_2( $additional_mail, $contact_form ) {
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		$license_actived = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
            
			return $additional_mail;
		}
        
        $wpcf7_instance = WPCF7_Submission::get_instance();
        $manager = WPCF7_FormTagsManager::get_instance();
        $form_fields = $manager->scan( $contact_form->prop( 'form' ) );
        if( ! $form_fields || !is_array( $form_fields ) || count( $form_fields ) < 1 ){
            return $additional_mail;
        }

        $form_id = $contact_form->id();
        $form_title = $contact_form->title();
        $bsk_gfblcv_form_settings = $this->cf7_blacklist_get_form_settings( $form_id, $contact_form );

        $enable = false;
        $action_when_hit = array( 'BLOCK' );
        $mails_to_skip = array();
        if( $bsk_gfblcv_form_settings && is_array( $bsk_gfblcv_form_settings ) && count( $bsk_gfblcv_form_settings ) > 0 ){
            $enable = $bsk_gfblcv_form_settings['enable'];
            $action_when_hit = $bsk_gfblcv_form_settings['actions'];
            if ( isset( $bsk_gfblcv_form_settings['mails_to_skip'] ) ) {
                $mails_to_skip = $bsk_gfblcv_form_settings['mails_to_skip'];
            }
        }

        if ( ! $enable ) {
            return $additional_mail;
        }
        
        if ( ! in_array( 'SKIP', $action_when_hit ) ) {
            return $additional_mail;
        }

        if ( ! in_array( 'Mail_2', $mails_to_skip ) ) {
            return $additional_mail;
        }

        $default = 'The value for field "[FIELD_LABEL]" is invalid!';
        $ip_default = 'Your IP address [VISITOR_IP] is forbidden!';
        $blacklist_message = $default;
        $whitelist_message = $default;
        $emaillist_message = $default;
        $iplist_message = $ip_default;
        $invitlist_message = $default;
        $form_default_validation_messages = array( 
                                                    'black' => $blacklist_message,
                                                    'white' => $whitelist_message,
                                                    'email' => $emaillist_message,
                                                    'ip' => $iplist_message,
                                                    'invit' => $invitlist_message,
                                                 );

        //validation
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        $fields_hit_item_array = array(); //only for blocked
        $form_data_array = array();
        //get field mapping
        $form_mappings = $this->cf7_blacklist_get_form_mappings( $form_id );
        foreach ( $form_fields as $field ) {
            if( $field->name == "" ){
                continue;
            }

            $field_value = $wpcf7_instance->get_posted_data( $field->name );
            if( $license_type == 'BUSINESS' || $license_type == 'ELITE' ){
                $form_data_array[$field->name] = array( 'label' => $field->name, 'value' => $field_value );
            }

            if( isset( $validation_result->invalid_fields[$field->name] ) ){
                continue;
            }
            
            //validate field value against blacklist
            if( ! isset( $form_mappings[$field->name] ) || ! is_array( $form_mappings[$field->name] ) || count( $form_mappings[$field->name] ) < 1 || 
                $form_mappings[$field->name]['list_type'] == '' || $form_mappings[$field->name]['save_id_error'] || $form_mappings[$field->name]['save_comparison_error'] ){
                continue;
            }
            
            $field_return_message = '';
            $checked_results = $this->bsk_gfblcv_check_field_value_againsit_list_item( $form_mappings[$field->name], 
                                                                                       $field->name, 
                                                                                       $field_value, 
                                                                                       $form_default_validation_messages,
                                                                                       $fields_hit_item_array,
                                                                                       $field_return_message );
            if( $checked_results ){
                unset( $additional_mail['mail_2'] );
                return $additional_mail;
            }
        }

        return $additional_mail;
    }
}