<?php

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class BSK_GFBLCV_Pro_Dashboard_Items extends WP_List_Table {
    
    private $_bsk_gfblcv_list_id = 0;
    private $_bsk_gfblcv_list_type = '';
    
    function __construct( $list_id, $list_type ) {
        $this->_bsk_gfblcv_list_id = $list_id;
        $this->_bsk_gfblcv_list_type = $list_type;
        
        //Set parent defaults
        parent::__construct( array( 
            'singular' => 'bsk-gfblcv-item',  //singular name of the listed records
            'plural'   => 'bsk-gfblcv-items', //plural name of the listed records
            'ajax'     => false                          //does this table support ajax?
        ) );
    }

    function column_default( $item, $column_name ) {
        switch( $column_name ) {
			case 'id':
				echo $item['id'];
				break;
			case 'value':
				echo $item['value'];
				break;
            case 'hits':
				echo $item['hits'];
				break;
			case 'action':
				echo $item['action'];
                break;
        }
    }
   
    function column_cb( $item ) {
        return sprintf( 
            '<input type="checkbox" name="%1$s[]" value="%2$s" />',
            esc_attr( $this->_args['singular'] ),
            esc_attr( $item['id'] )
        );
    }

    function get_columns() {
        
        $columns = array( 
			'cb'        		=> '<input type="checkbox"/>',
			'id'				=> 'ID',
            'value'     		=> 'Content',
        );
    
        $columns['hits'] = 'Hits';
        if( $this->_bsk_gfblcv_list_type == 'INVIT_LIST' ){
            $columns['hits'] = 'Extra';
        }
        $columns['action'] = 'Action';
        
        return $columns;
    }
   
	function get_sortable_columns() {
		$c = array( 'value' => 'value' );
        if( $this->_bsk_gfblcv_list_type != 'WHITE_LIST' ){
            $c['hits'] = 'hits';
        }
        
		return $c;
	}
	
    function get_views() {
        return array();
    }
   
    function get_bulk_actions() {
    
        $actions = array( 
            'delete'=> 'Delete'
        );
        
        return $actions;
    }

    function do_bulk_action() {
        global $wpdb;
        
        $items_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
        
		if( isset($_POST['bsk-gfblcv-item']) && count($_POST['bsk-gfblcv-item']) > 0 ){
			
			if( $_POST['action'] == 'delete' || $_POST['action2'] == 'delete' ){
				$sql = 'DELETE FROM `'.$items_table.'` WHERE `id` IN('.implode(',', $_POST['bsk-gfblcv-item']).')';
				$wpdb->query( $sql );
			}
		}
    }

    function get_data() {
		global $wpdb;
		
        $items_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
        
        
        $license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		if( trim($license) == '' || 
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
			return NULL;
		}
		
		$search = '';
		$orderby = '';
		$order = '';
        // check to see if we are searching
        if( isset( $_POST['s'] ) ) {
            $search = trim( $_POST['s'] );
        }
		if ( isset( $_REQUEST['orderby'] ) ){
			$orderby = $_REQUEST['orderby'];
		}
		if ( isset( $_REQUEST['order'] ) ){
			$order = $_REQUEST['order'];
		}
		
		$sql = 'SELECT * FROM `'.
		       $items_table.'` AS i WHERE i.`list_id` = %d ';
		if( $search ){
			$sql .= ' AND i.`value` LIKE %s';
			$sql = $wpdb->prepare( $sql, $this->_bsk_gfblcv_list_id, '%'.$search.'%' );
		}else{
			$sql = $wpdb->prepare( $sql, $this->_bsk_gfblcv_list_id );
		}
		$orderCase = ' ORDER BY i.`value` DESC';
        if( $this->_bsk_gfblcv_list_type == 'INVIT_LIST' ){
            $orderCase = ' ORDER BY i.`id` DESC';
        }
		if ( $orderby ){
			$orderCase = ' ORDER BY i.`'.$orderby.'` '.$order;
		}
		$items = $wpdb->get_results($sql.$orderCase);
		if (!$items || count($items) < 1){
			return NULL;
		}
		
		$items_data = array();
		foreach ( $items as $item ) {
			$delete_anchor = '<a class="bsk-gfblcv-action-anchor bsk-gfblcv-action-anchor-first bsk-gfblcv-item-delete-anchor" rel="'.$item->id.'">Delete</a>';
			$send_out_anchor = '<a class="bsk-gfblcv-action-anchor bsk-gfblcv-item-send-out-anchor" rel="'.$item->id.'" style="margin-left: 10px;">Send to</a>';
            $send_out_anchor .= '<span class="bsk-gfblcv-item-send-out-ajax-loder" style="display:none; margin-left:10px;">'.BSK_GFBLCV_Pro::$ajax_loader.'</span>';
            
            $item_value = $item->value;
            $item_hits = $item->hits;
            $item_extra = $item->extra ? unserialize( $item->extra ) : array();
            $invit_code_extra_info = $item_hits;
            if( $this->_bsk_gfblcv_list_type == 'INVIT_LIST' ){
                $invit_code_extra_info = '';
                if( $item_hits != 0 ){
                    $item_value = '<del>'.$item_value.'</del>';
                    if( isset( $item_extra['forms'] ) ){
                        switch ($item_extra['forms'] ) {
                            case 'GF':
                                if( class_exists( 'GFAPI' ) ){
                                    $entry = GFAPI::get_entry( $item_hits );
                                    if( !$entry || is_wp_error( $entry ) ){
                                        $invit_code_extra_info .= 'Used by Gravity Forms Entry #'.$item_hits;
                                    }else{
                                        $entry_id = $entry['id'];
                                        $form_id = $entry['form_id'];
                                        $entry_link = admin_url( 'admin.php?page=gf_entries&view=entry&id='.$form_id.'&lid='.$entry_id );
                                        $form_link = admin_url( 'admin.php?page=gf_edit_forms&id='.$form_id );
                                        $form_obj = GFAPI::get_form( $form_id );
                                        $invit_code_extra_info .= 'Used by Gravity Forms: <a href="' . $form_link . '">' . $form_obj['title'] . '( ID: ' . $form_id . ' )</a>, Entry <a href="' . $entry_link . '">#' . $entry_id . '</a>';
                                    }
                                } else {
                                    $invit_code_extra_info .= 'Used by Gravity Forms Entry #'.$item_hits;
                                }
                            break;
                            case 'FF':
                                if( class_exists( 'FrmEntry' ) ){
                                    $entry = FrmEntry::getOne( $item_hits, true );
                                    if ( !$entry || is_wp_error( $entry ) ){
                                        $invit_code_extra_info .= 'Used by Formidable Forms Entry #' . $item_hits;
                                    } else {
                                        $entry_id = $entry->id;
                                        $form_id = $entry->form_id;
                                        $entry_link = admin_url( 'admin.php?page=formidable-entries&frm_action=show&id=' . $entry_id );
                                        $form_link = admin_url( 'admin.php?page=formidable&frm_action=edit&id=' . $form_id );
                                        $invit_code_extra_info .= 'Used by Formidable Forms: <a href="' . $form_link . '">' . $entry->form_name . '( ID: ' . $form_id . ' )</a>, Entry <a href="' . $entry_link . '">#' . $entry_id . '</a>';
                                    }
                                } else {
                                    $invit_code_extra_info .= 'Used by Formidable Forms Entry #' . $item_hits;
                                }
                            break;
                            case 'WPF':
                                if( $item_hits > 0 ) {
                                    if ( function_exists( 'wpforms' ) ){
                                        $entry = wpforms()->entry->get( $item_hits );
                                        if ( empty( $entry ) ) {
                                            $invit_code_extra_info .= 'Used by WPForms Entry #' . $item_hits;
                                        } else {
                                            $entry_link = admin_url( 'admin.php?page=wpforms-entries&view=details&entry_id='.$entry->entry_id );
                                            $form_id = $entry->form_id;
                                            $form_link = admin_url( 'admin.php?page=wpforms-builder&view=fields&form_id=' . $form_id ); 
                                            $form_obj = wpforms()->form->get( $form_id );
                                            $invit_code_extra_info .= 'Used by WPForms: <a href="' . $form_link . '">' . $form_obj->post_title . '( ID: ' . $form_id . ' )</a>, Entry <a href="' . $entry_link . '">#' . $entry->entry_id . '</a>';
                                        }
                                    } else {
                                        $invit_code_extra_info .= 'Used by WPForms Entry #' . $item_hits;
                                    }
                                    
                                }else{
                                    //-1, WPForms lite version no entry saved
                                    $invit_code_extra_info .= 'Used by WPForms lite, no entry saved';
                                }
                            break;
                            case 'CF7':
                                $invit_code_extra_info .= 'Used by Contact Forms 7';
                            break;
                            case 'FRMT':
                                if( class_exists( 'Forminator_API' ) ){
                                    $entry = false;
                                    $form_id = 0;
                                    $form_title = '';
                                    if ( isset( $item_extra['form_id'] ) && $item_extra['form_id'] ) {
                                        $form_id = $item_extra['form_id'];
                                        $form_obj = Forminator_API::get_form( $form_id );
                                        $form_title = $form_obj->settings['formName'];
                                        $entry = Forminator_API::get_entry( $item_extra['form_id'], $item_hits );
                                    }
                                    if ( ! $entry || is_wp_error( $entry ) ) {
                                        $invit_code_extra_info .= 'Used by Forminator Form: ' . $form_title . '( ID: ' . $form_id . ' ), Entry #' . $item_hits;
                                    } else {
                                        $entry_id = $item_hits;
                                        $entry_link = admin_url( 'admin.php?page=forminator-entries&form_type=forminator_forms&form_id=' . $form_id );
                                        $form_link = admin_url( 'admin.php?page=forminator-cform-wizard&id=' . $form_id );
                                        $invit_code_extra_info .= 'Used by Forminator: <a href="' . $form_link . '">' . $form_title . '( ID: ' . $form_id . ' )</a>, Entry <a href="' . $entry_link . '">#' . $entry_id . '</a>';
                                    }
                                } else {
                                    $form_id = isset( $item_extra['form_id'] ) ? $item_extra['form_id'] : 0;
                                    $invit_code_extra_info .= 'Used by Forminator Form #' . $form_id . ', Entry #' . $item_hits;
                                }
                            break;
                        }
                    }
                    $send_out_anchor = '';
                }else{
                    $item_value = '
                    <div class="bsk-gfbl-invitation-code">
                        <span class="bsk-gfbl-code-to-copy">'.$item_value.'</span>
                        <div class="bsk-gfbl-copy-tooltip">
                            <span class="bsk-gfbl-copy-tooltip-text">click to copy</span>
                            <span class="bsk-gfbl-copy-anchor"></span>
                        </div>
                    </div>
                    ';
                }
                $email_address_in_extra = isset( $item_extra['RECIPIENT'] ) ? $item_extra['RECIPIENT'] : '';
                if( isset( $item_extra['SEND_USER'] ) && $item_extra['SEND_USER'] ){
                    $user = get_user_by( 'ID', $item_extra['SEND_USER'] );
                    if( $user ){
                        $edit_link = get_edit_user_link( $user->ID );
                        $invit_code_extra_info .= '<span style="display:block;">Sent to user: <a href="'.$edit_link.'">'.$user->user_nicename.'</a>, '.$email_address_in_extra.'</span>';
                    }
                }
                if( isset( $item_extra['SEND_EMAIL_LIST'] ) && $item_extra['SEND_EMAIL_LIST'] ){
                    $email_list_item_id_array = explode( ':', $item_extra['SEND_EMAIL_LIST'] );
                    if( $email_list_item_id_array && count($email_list_item_id_array) > 1 ){
                        $list_id = $email_list_item_id_array[0];
                        $item_id = $email_list_item_id_array[1];
                        $list_edit_link = BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_get_list_edit_link( $list_id );
                        if( $list_edit_link ){
                            $invit_code_extra_info .= '<span style="display:block;">Sent to email list: <a href="'.$list_edit_link['link'].'">'.$list_edit_link['name'].', item ID: '.$item_id.'</a>, '.$email_address_in_extra.'</span>';
                        }else{
                            $invit_code_extra_info .= '<span style="display:block;">Sent to email list, '.$email_address_in_extra.'</span>';
                        }
                    }
                }
                if( isset( $item_extra['SEND_TO_EMAIL'] ) && $item_extra['SEND_TO_EMAIL'] ){
                    $email_address = $item_extra['SEND_TO_EMAIL'];
                    $invit_code_extra_info .= '<span style="display:block;">Sent to email: '.$email_address.'</span>';
                }
                $delete_anchor = $delete_anchor.$send_out_anchor;
            }
            $delete_anchor .= '<p class="bsk-gfblcv-item-action-confirm-p" style="display:none; margin-top: 10px;"></p>';
            $delete_anchor .= '<p class="bsk-gfblcv-item-action-msg-p" style="display:none; margin-top: 10px;"></p>';
            $delete_anchor .= '<p class="bsk-gfblcv-item-action-ajax-loader" style="display:none; margin-top: 10px;">'.BSK_GFBLCV_Pro::$ajax_loader.'</p>';
			//organise data
			$lists_data[] = array( 
			    'id' 				=> $item->id,
				'value'     		=> $item_value,
                'hits'     		    => $invit_code_extra_info,
				'action'			=> $delete_anchor
			);
		}
		
		return $lists_data;
    }

    function prepare_items() {
       
        /**
         * First, lets decide how many records per page to show
         */
        $user = get_current_user_id();
        $screen = get_current_screen();
        $per_page = 50;
        
        $data = array();
		
        add_thickbox();

		$this->do_bulk_action();
       
        $data = $this->get_data();
   
        $current_page = $this->get_pagenum();
        $total_items = 0;
        if( $data && is_array( $data ) ){
            $total_items = count( $data );
        }
        
	    if ($total_items > 0){
        	$data = array_slice( $data,( ( $current_page-1 )*$per_page ),$per_page );
		}
        $this->items = $data;

        $this->set_pagination_args( array( 
            'total_items' => $total_items,                  // We have to calculate the total number of items
            'per_page'    => $per_page,                     // We have to determine how many items to show on a page
            'total_pages' => ceil( $total_items/$per_page ) // We have to calculate the total number of pages
        ) );
    }
	

	
	function get_column_info() {
		
		$columns = array( 
							'cb'        		=> '<input type="checkbox"/>',
							'id'				=> 'ID',
							'value'     		=> 'Content',
						);
        $columns['hits'] = 'Hits';
        if( $this->_bsk_gfblcv_list_type == 'INVIT_LIST' ){
            $columns['hits'] = 'Extra';
        }
        $columns['action'] = 'Action';
        
		$hidden = array();

		$_sortable = apply_filters( "manage_{$this->screen->id}_sortable_columns", $this->get_sortable_columns() );

		$sortable = array();
		foreach ( $_sortable as $id => $data ) {
			if ( empty( $data ) )
				continue;

			$data = (array) $data;
			if ( !isset( $data[1] ) )
				$data[1] = false;

			$sortable[$id] = $data;
		}

		$_column_headers = array( $columns, $hidden, $sortable, array() );

		return $_column_headers;
	}
}