<?php

if ( ! class_exists( 'WP_List_Table' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

class BSK_GFBLCV_Pro_Dashboard_Entries_List extends WP_List_Table {

    var $form_plugin = '';
    var $form_id = 0;

    function __construct( $args ) {
		global $wpdb;

		//Set parent defaults
		parent::__construct( array(
								'singular' => 'bsk-gfblcv-entries',  //singular name of the listed records
								'plural'   => 'bsk-gfblcv-entries', //plural name of the listed records
								'ajax'     => false                          //does this table support ajax?
								)
						   );

		$this->form_plugin = $args['form_plugin'];
        $this->form_id = $args['form_id'];
    }

    function column_default( $list_item, $column_name ) {
        switch( $column_name ) {
			case 'id':
				echo $list_item['id'];
            break;
            case 'form_plugin':
                $form_plugin_name = '';
				switch( $list_item['form_plugin'] ){
                    case 'GF':
                        $form_plugin_name = 'Gravity Forms';
                    break;
                    case 'FF':
                        $form_plugin_name = 'Formidable Forms';
                    break;
                    case 'CF7':
                        $form_plugin_name = 'Contact Form 7';
                    break;
                    case 'WPF':
                        $form_plugin_name = 'WP Forms';
                    break;
                    case 'NF':
                        $form_plugin_name = 'Ninja Forms';
                    break;
                    case 'FRMT':
                        $form_plugin_name = 'Forminator';
                    break;
                }
                echo $form_plugin_name;
            break;
            case 'form_title':
				echo $list_item['form_title'];
            break;
			case 'form_data':
                $hits_data = false;
                $entry_html = BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_render_entry_html( $list_item['form_data'], $hits_data, $list_item['id'], $list_item['ip'], $list_item['form_plugin'] );
                echo $entry_html;
            break;
            case 'date':
                echo '<p>'.$list_item['date'].'</p>';
                echo '<p>'.$list_item['ip'].'</p>';
            break;
        }
    }

    function column_cb( $item ) {
        return sprintf(
            '<input type="checkbox" name="%1$s[]" value="%2$s" />',
            esc_attr( $this->_args['singular'] ),
            esc_attr( $item['id'] )
        );
    }

    function get_columns() {

        $columns = array(
			'cb'        	=> '<input type="checkbox"/>',
			'id'			=> 'ID',
            'form_plugin'   => 'Form Plugin',
            'form_title'    => 'Form Title',
            'form_data'     => 'Form Data',
            'date'          => 'Date&IP',
        );

        return $columns;
    }

	function get_sortable_columns() {

		$c = array( 'date' => 'date' );

		return $c;
	}

    function get_views() {

        return array();
    }

    function get_bulk_actions() {

        $actions = array(
            'delete'=> 'Delete'
        );


        return $actions;
    }

    function do_bulk_action() {

        global $wpdb;

        $entries_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_entries_tbl_name;

		if( isset($_POST['bsk-gfblcv-entries']) && count($_POST['bsk-gfblcv-entries']) > 0 ){

			if( $_POST['action'] == 'delete' || $_POST['action2'] == 'delete' ){

                //delete form data
				$sql = 'DELETE FROM `'.$entries_table.'` WHERE `id` IN( '.( implode(',', $_POST['bsk-gfblcv-entries']) ).' ) ';
				$wpdb->query( $sql );

                //delete hits data that assoicated witht he entry
                $hits_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_hits_tbl_name;
                $sql = 'DELETE FROM `'.$hits_table.'` WHERE `entry_id` IN( '.( implode(',', $_POST['bsk-gfblcv-entries']) ).' ) ';
                $wpdb->query( $sql );
			}
		}
    }

    function get_data() {
		global $wpdb;

		$license = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license );
		$license_status = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_stauts );
		if( trim($license) == '' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
			return NULL;
		}

		$license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        if( $license_type == 'PERSONAL' || $license_type == 'CREATOR' ){
            return NULL;
        }

		$search = '';
		$orderby = '';
		$order = 'DESC';
        // check to see if we are searching
        if( isset( $_POST['s'] ) ) {
            $search = trim( $_POST['s'] );
        }
		if ( isset( $_REQUEST['orderby'] ) ){
			$orderby = $_REQUEST['orderby'];
		}
		if ( isset( $_REQUEST['order'] ) ){
			$order = $_REQUEST['order'];
		}

        $entries_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_entries_tbl_name;
        $sql = 'SELECT * FROM `'.$entries_table.'` '.
               'WHERE 1 ';
        if( $this->form_plugin ){
            $sql .= 'AND `forms` LIKE %s ';
            $sql = $wpdb->prepare( $sql, $this->form_plugin );
        }

        if( $this->form_id ){
            $sql .= 'AND `form_id` = %d ';
            $sql = $wpdb->prepare( $sql, $this->form_id );
        }
        $order_case = 'ORDER BY `submit_date` '.$order;
        $sql = $sql.$order_case;

		$hits_lists = $wpdb->get_results( $sql );
		if( !$hits_lists || count($hits_lists) < 1 ){
			return NULL;
		}

        $items_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_items_tbl_name;
		$data_to_return = array();
		foreach( $hits_lists as $hits_data_record ){

            $form_id = $hits_data_record->form_id;
            $form_plugin = $hits_data_record->forms;

            $form_edit_url = '';
            if ( $form_plugin == 'GF' ) {
                if ( class_exists('GFAPI') ) {
                    $form = GFAPI::get_form( $form_id );
                    if( $form == false ){
                        continue;
                    }
                    $form_edit_url = '<a href="'.admin_url( 'admin.php?page=gf_edit_forms&id='.$form_id ).'">'.$form['title'].'</a>';
                } else {
                    $form_edit_url = '<a href="javascript:void(0);">Gravity Forms is not active</a>';
                }
            } else if ( $form_plugin == 'FF' ) {
                $form = $form_id;
                if ( class_exists('FrmForm') ) {
                    FrmForm::maybe_get_form( $form );
                    if ( ! is_object( $form ) ) {
                        continue;
                    }
                    $form_edit_url = '<a href="'.admin_url( 'admin.php?page=formidable&frm_action=edit&id='.$form_id ).'">'.$form->name.'</a>';
                } else {
                    $form_edit_url = '<a href="javascript:void(0);">Formidable Forms is not active</a>';
                }
            } else if ( $form_plugin == 'WPF' ) {
                if ( class_exists('WPForms') ) {
                    $form = wpforms()->form->get( $form_id );
                    if ( ! is_object( $form ) ) {
                        continue;
                    }
                    $form_edit_url = '<a href="'.admin_url( 'admin.php?page=wpforms-builder&view=fields&form_id='.$form_id ).'">'.$form->post_title.'</a>';
                } else {
                    $form_edit_url = '<a href="javascript:void(0);">WPForms is not active</a>';
                }
            } else if ( $form_plugin == 'FRMT' ) {
                if ( class_exists('Forminator_API') ) {
                    $form = Forminator_API::get_form( $form_id );
                    if ( ! is_object( $form ) ) {
                        continue;
                    }
                    $form_title = $form->settings['formName'];
                    $form_link = admin_url( 'admin.php?page=forminator-cform-wizard&id=' . $form_id );
                    $form_edit_url = '<a href="'.$form_link.'">'.$form_title.'</a>';
                    
                } else {
                    $form_edit_url = '<a href="javascript:void(0);">Forminator is not active</a>';
                }
            }

            //organise data
			$data_to_return[] = array(
                                        'id' 			=> $hits_data_record->id,
                                        'form_plugin'   => $form_plugin,
                                        'form_title'    => $form_edit_url,
                                        'form_data'     => $hits_data_record->form_data,
                                        'ip'     	    => $hits_data_record->ip,
                                        'date'			=> $hits_data_record->submit_date,
                                     );
		}

		return $data_to_return;
    }

    function prepare_items() {

        /**
         * First, lets decide how many records per page to show
         */
        $user = get_current_user_id();
        $screen = get_current_screen();
        $option = $screen->get_option('per_page', 'option');
        $per_page = 50;
        if( empty ( $per_page) || $per_page < 1 ){
            $per_page = $screen->get_option( 'per_page', 'default' );
        }

        $data = array();

        add_thickbox();

		$this->do_bulk_action();

        $data = $this->get_data();

        $current_page = $this->get_pagenum();
        $total_items = 0;
        if( $data && is_array( $data ) ){
            count( $data );
        }

	    if ($total_items > 0){
        	$data = array_slice( $data,( ( $current_page-1 )*$per_page ),$per_page );
		}
        $this->items = $data;

        $this->set_pagination_args( array(
            'total_items' => $total_items,                  // We have to calculate the total number of items
            'per_page'    => $per_page,                     // We have to determine how many items to show on a page
            'total_pages' => ceil( $total_items/$per_page ) // We have to calculate the total number of pages
        ) );
    }



	function get_column_info() {

		$columns = array(
			'cb'        	=> '<input type="checkbox"/>',
			'id'			=> 'ID',
            'form_plugin'   => 'Form Plugin',
            'form_title'    => 'Form Title',
            'form_data'     => 'Form Data',
            'date'          => 'Date&IP',
        );

		$hidden = array();

		$_sortable = apply_filters( "manage_{$this->screen->id}_sortable_columns", $this->get_sortable_columns() );

		$sortable = array();
		foreach( $_sortable as $id => $data ) {
			if ( empty( $data ) )
				continue;

			$data = (array) $data;
			if ( !isset( $data[1] ) )
				$data[1] = false;

			$sortable[$id] = $data;
		}

		$_column_headers = array( $columns, $hidden, $sortable, array() );

		return $_column_headers;
	}

}
