<?php
class BSK_GFBLCV_Pro_Dashboard {
	
    public static $_bsk_gfblcv_pages = array(  
                                                'base' => array( 'slug' => 'bsk-forms-blacklist', 'label' => 'Blacklist' ),
                                                'whitelist' => array( 'slug' => 'bsk-forms-whitelist', 'label' => 'White List' ),
                                                'emailist' => array( 'slug' => 'bsk-forms-emailist', 'label' => 'Email List' ),
                                                'iplist' => array( 'slug' => 'bsk-forms-iplist', 'label' => 'IP List' ),
                                                'invitlist' => array( 'slug' => 'bsk-forms-invitation-codes-list', 'label' => 'Invitation Codes List' ),
                                                'blocked_data' => array( 'slug' => 'bsk-forms-blocked-data', 'label' => 'Blocked Data' ),
                                                'settings' => array( 'slug' => 'bsk-forms-settings', 'label' => 'Settings' ),
                                                'license_update' => array( 'slug' => 'bsk-forms-license-update', 'label' => 'License &amp; Update' ),
                                                'forminator_blacklist' => array( 'slug' => 'bsk-forminator-blacklist', 'label' => 'BSK Blacklist' ),
                                            );
    
	public static $_plugin_license = '_bsk_gfbl_license_';
	public static $_plugin_license_stauts = '_bsk_gfbl_license_stauts_';
	public static $_plugin_license_actived = '_bsk_gfbl_license_actived_';
    public static $_plugin_license_actived_manually = '_bsk_gfbl_license_actived_manually_';
    public static $_plugin_license_activation_return = '_bsk_gfbl_activation_return_';
    public static $_plugin_license_type = '_bsk_gfbl_license_type_';
    public static $_plugin_license_expiry_date = '_bsk_gfbl_license_expiry_date_';
    
    public static $_plugin_settings_option = '_bsk_gfbl_settings_';

    public static $_bsk_gfblcv_cf7_form_settings_opt = '_bsk_gfblcv_cf7_form_settings_';
    public static $_bsk_gfblcv_cf7_form_mappings_opt = '_bsk_gfblcv_cf7_form_mappings_';
    
    public $_bsk_gfblcv_OBJ_settings = NULL;
    public $_bsk_gfblcv_OBJ_list = NULL;
    public $_bsk_gfblcv_OBJ_ip_country = NULL;
    
    public $_bsk_gfblcv_forms_OBJ_gf = NULL;
    public $_bsk_gfblcv_forms_OBJ_ff = NULL;
    public $_bsk_gfblcv_forms_OBJ_wpf = NULL;
    public $_bsk_gfblcv_forms_OBJ_cf7 = NULL;
    public $_bsk_gfblcv_forms_OBJ_frmt = NULL;
    
    public $_bsk_gfblcv_OBJ_updater = NULL;
    public $_bsk_gfblcv_OBJ_update_helper = NULL;
    
	public function __construct() {
		
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/common.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/list.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/lists.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/items.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/dashboard-settings.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/entries.php' );
        
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/gravityforms/gravityforms.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/formidable-forms/formidable-forms.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/wpforms/wpforms.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/cf7/cf7.php' );
        require_once( BSK_GFBLCV_DIR.'classes/dashboard/forminator/forminator.php' );
        
        require_once( BSK_GFBLCV_DIR.'classes/updater/updater.php' );
        require_once( BSK_GFBLCV_DIR.'classes/updater/update-helper.php' );
        
        $this->_bsk_gfblcv_OBJ_ip_country = new BSK_GFBLCV_Pro_IP_Country();
        $this->_bsk_gfblcv_OBJ_list = new BSK_GFBLCV_Pro_Dashboard_List( $this->_bsk_gfblcv_OBJ_ip_country );
        $this->_bsk_gfblcv_OBJ_settings = new BSK_GFBLCV_Pro_Dashboard_Settings();
        
        $this->_bsk_gfblcv_forms_OBJ_gf = new BSK_GFBLCV_Pro_Dashboard_GravityForms();
        $this->_bsk_gfblcv_forms_OBJ_ff = new BSK_GFBLCV_Pro_Dashboard_Formidable_Forms();
        $this->_bsk_gfblcv_forms_OBJ_wpf = new BSK_GFBLCV_Pro_Dashboard_WPForms();
        $this->_bsk_gfblcv_forms_OBJ_cf7 = new BSK_GFBLCV_Pro_Dashboard_CF7();
        $this->_bsk_gfblcv_forms_OBJ_frmt = new BSK_GFBLCV_Pro_Dashboard_Forminator();
        
		
        $this->_bsk_gfblcv_OBJ_update_helper = new BSK_GFBLCV_Pro_Update_Helper();
        $this->_bsk_gfblcv_OBJ_updater = new BSK_GFBLCV_Pro_Updater();
        
        /*
          * Actions & Filters
          */
        add_action( 'admin_menu', array( $this, 'bsk_gfblcv_dashboard_menu' ), 999 );
        add_action( 'admin_init', array( $this, 'bsk_gfblcv_activate_license' ) );
        add_action( 'admin_init', array( $this, 'bsk_gfblcv_deactivate_license' ) );
        
        add_filter( 'set-screen-option', array( $this, 'bsk_gfblcv_set_option' ), 10, 3);
        add_action( 'admin_notices', array( $this, 'bsk_gfblcv_upgrade_done_notice_fun' ) );
        
        add_action( 'gform_after_delete_form', array( $this, 'bsk_gfblcv_delete_entries_fun' ) );
	}
	
	function bsk_gfblcv_dashboard_menu() {
		
		$authorized_level = 'manage_options';
        
        add_menu_page( 
                         'BSK Blacklist Pro', 
                         'BSK Blacklist Pro', 
                         $authorized_level, 
                         self::$_bsk_gfblcv_pages['base']['slug'], 
                         '', 
                         'dashicons-admin-network'
                     );
		
		$license = get_option( self::$_plugin_license );
		$license_status = get_option( self::$_plugin_license_stauts );
		$license_actived = get_option( self::$_plugin_license_actived );
		if( trim($license) == '' || 
			$license_actived != 'ACTIVED' ||
		    ( $license_status != 'VALID' && $license_status != 'EXPIRED' ) ){
				
			add_submenu_page( 
                              self::$_bsk_gfblcv_pages['base']['slug'],
							  self::$_bsk_gfblcv_pages['base']['label'], 
							  self::$_bsk_gfblcv_pages['base']['label'],
							  $authorized_level, 
							  self::$_bsk_gfblcv_pages['base']['slug'],
							  array($this, 'bsk_gfblcv_license_update') 
                            );
		
		}else{
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['base']['label'],
                                self::$_bsk_gfblcv_pages['base']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                array($this, 'bsk_gfblcv_blacklist') 
                            );
            
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['whitelist']['label'],
                                self::$_bsk_gfblcv_pages['whitelist']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['whitelist']['slug'],
                                array($this, 'bsk_gfblcv_whitelist') 
                            );
            
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['emailist']['label'],
                                self::$_bsk_gfblcv_pages['emailist']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['emailist']['slug'],
                                array($this, 'bsk_gfblcv_emailist') 
                            );
            
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['iplist']['label'],
                                self::$_bsk_gfblcv_pages['iplist']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['iplist']['slug'],
                                array($this, 'bsk_gfblcv_iplist') 
                            );
            
             add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['invitlist']['label'],
                                self::$_bsk_gfblcv_pages['invitlist']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['invitlist']['slug'],
                                array($this, 'bsk_gfblcv_invitlist_list') 
                            );
            
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['blocked_data']['label'],
                                self::$_bsk_gfblcv_pages['blocked_data']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['blocked_data']['slug'],
                                array($this, 'bsk_gfblcv_blocked_data') 
                            );
            
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['settings']['label'],
                                self::$_bsk_gfblcv_pages['settings']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['settings']['slug'],
                                array($this, 'bsk_gfblcv_settings') 
                            );
            add_submenu_page( 
                                self::$_bsk_gfblcv_pages['base']['slug'],
                                self::$_bsk_gfblcv_pages['license_update']['label'],
                                self::$_bsk_gfblcv_pages['license_update']['label'],
                                $authorized_level, 
                                self::$_bsk_gfblcv_pages['license_update']['slug'],
                                array($this, 'bsk_gfblcv_license_update') 
                            );
            
		}
	}
	
	function bsk_gfblcv_blacklist(){
        
		$current_view = 'list';
        if(isset($_GET['view']) && $_GET['view']){
			$current_view = trim($_GET['view']);
		}
		if(isset($_POST['view']) && $_POST['view']){
			$current_view = trim($_POST['view']);
		}
        
		$current_list_view = 'blacklist';
		$current_base_page = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['base']['slug'].'&view='.$current_view );
		
		if( $current_view == 'list' ){
            $_bsk_gfblcv_OBJ_lists = new BSK_GFBLCV_Pro_Dashboard_Lists( array( 'list' => 'blacklist' ) );

            //Fetch, prepare, sort, and filter our data...
            $_bsk_gfblcv_OBJ_lists->prepare_items();

            $add_new_page_url = add_query_arg( 'view', 'addnew', $current_base_page );
            echo '<div class="wrap">
                    <div id="icon-edit" class="icon32"><br/></div>
                    <h2>BSK Forms Blacklist<a href="'.$add_new_page_url.'" class="add-new-h2">Add New</a></h2>';
            echo '  <form id="bsk_gfblcv_lists_form_id" method="post" action="'.$current_base_page.'">';
                        $_bsk_gfblcv_OBJ_lists->display();
            echo '  
                        <input type="hidden" name="bsk_gfblcv_list_id" id="bsk_gfblcv_list_id_to_be_processed_ID" value="0" />
                        <input type="hidden" name="bsk_gfblcv_action" id="bsk_gfblcv_action_ID" value="" />';
                        wp_nonce_field( 'bsk_gfblcv_list_oper_nonce' );
            echo '
                    </form>
                  </div>';
		}else if ( $current_view == 'addnew' || $current_view == 'edit' ){
			$list_id = -1;
			if(isset($_GET['id']) && $_GET['id']){
				$list_id = trim($_GET['id']);
				$list_id = absint($list_id);
			}
            $this->_bsk_gfblcv_OBJ_list->bsk_gfblcv_list_edit( 
                                                               $list_id, 
                                                               $current_list_view, 
                                                               $current_view 
                                                             );
		}
	}
    
    function bsk_gfblcv_whitelist(){
        
        $current_view = 'list';
        if(isset($_GET['view']) && $_GET['view']){
			$current_view = trim($_GET['view']);
		}
		if(isset($_POST['view']) && $_POST['view']){
			$current_view = trim($_POST['view']);
		}
        
		$current_list_view = 'whitelist';
		$current_base_page = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['whitelist']['slug'].'&view='.$current_view );
		
		if( $current_view == 'list' ){
            $init_args = array();
            $_bsk_gfblcv_OBJ_lists = new BSK_GFBLCV_Pro_Dashboard_Lists( array( 'list' => 'whitelist' ) );

            //Fetch, prepare, sort, and filter our data...
            $_bsk_gfblcv_OBJ_lists->prepare_items();

            $add_new_page_url = add_query_arg( 'view', 'addnew', $current_base_page );
            echo '<div class="wrap">
                    <div id="icon-edit" class="icon32"><br/></div>
                    <h2>BSK Forms White List<a href="'.$add_new_page_url.'" class="add-new-h2">Add New</a></h2>';
            echo '  <form id="bsk_gfblcv_lists_form_id" method="post" action="'.$current_base_page.'">';
                        $_bsk_gfblcv_OBJ_lists->display();
            echo '  
                        <input type="hidden" name="bsk_gfblcv_list_id" id="bsk_gfblcv_list_id_to_be_processed_ID" value="0" />
                        <input type="hidden" name="bsk_gfblcv_action" id="bsk_gfblcv_action_ID" value="" />';
                        wp_nonce_field( 'bsk_gfblcv_list_oper_nonce' );
            echo '
                    </form>
                  </div>';
		}else if ( $current_view == 'addnew' || $current_view == 'edit' ){
			$list_id = -1;
			if(isset($_GET['id']) && $_GET['id']){
				$list_id = trim($_GET['id']);
				$list_id = absint($list_id);
			}
            $this->_bsk_gfblcv_OBJ_list->bsk_gfblcv_list_edit( 
                                                               $list_id, 
                                                               $current_list_view, 
                                                               $current_view 
                                                             );
		}
	}
    
    function bsk_gfblcv_emailist(){
        
        $current_view = 'list';
        if(isset($_GET['view']) && $_GET['view']){
			$current_view = trim($_GET['view']);
		}
		if(isset($_POST['view']) && $_POST['view']){
			$current_view = trim($_POST['view']);
		}
        
		$current_list_view = 'emaillist';
		$current_base_page = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['emailist']['slug'].'&view='.$current_view );
		
		if( $current_view == 'list' ){
            $_bsk_gfblcv_OBJ_lists = new BSK_GFBLCV_Pro_Dashboard_Lists( array( 'list' => 'emaillist' ) );

            //Fetch, prepare, sort, and filter our data...
            $_bsk_gfblcv_OBJ_lists->prepare_items();

            $add_new_page_url = add_query_arg( 'view', 'addnew', $current_base_page );
            echo '<div class="wrap">
                    <div id="icon-edit" class="icon32"><br/></div>
                    <h2>BSK Forms Email List<a href="'.$add_new_page_url.'" class="add-new-h2">Add New</a></h2>';
            echo '  <form id="bsk_gfblcv_lists_form_id" method="post" action="'.$current_base_page.'">';
                        $_bsk_gfblcv_OBJ_lists->display();
            echo '  
                        <input type="hidden" name="bsk_gfblcv_list_id" id="bsk_gfblcv_list_id_to_be_processed_ID" value="0" />
                        <input type="hidden" name="bsk_gfblcv_action" id="bsk_gfblcv_action_ID" value="" />';
                        wp_nonce_field( 'bsk_gfblcv_list_oper_nonce' );
            echo '
                    </form>
                  </div>';
		}else if ( $current_view == 'addnew' || $current_view == 'edit' ){
			$list_id = -1;
			if(isset($_GET['id']) && $_GET['id']){
				$list_id = trim($_GET['id']);
				$list_id = absint($list_id);
			}
            $this->_bsk_gfblcv_OBJ_list->bsk_gfblcv_list_edit( 
                                                               $list_id, 
                                                               $current_list_view, 
                                                               $current_view 
                                                             );
		}
	}
    
    function bsk_gfblcv_iplist(){
        
        $current_view = 'list';
        if(isset($_GET['view']) && $_GET['view']){
			$current_view = trim($_GET['view']);
		}
		if(isset($_POST['view']) && $_POST['view']){
			$current_view = trim($_POST['view']);
		}
        
		$current_list_view = 'iplist';
		$current_base_page = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['iplist']['slug'].'&view='.$current_view );
		
		if( $current_view == 'list' ){
            $_bsk_gfblcv_OBJ_lists = new BSK_GFBLCV_Pro_Dashboard_Lists( array( 'list' => 'iplist' ) );

            //Fetch, prepare, sort, and filter our data...
            $_bsk_gfblcv_OBJ_lists->prepare_items();

            $add_new_page_url = add_query_arg( 'view', 'addnew', $current_base_page );
            echo '<div class="wrap">
                    <div id="icon-edit" class="icon32"><br/></div>
                    <h2>BSK Forms IP List<a href="'.$add_new_page_url.'" class="add-new-h2">Add New</a></h2>';
            echo '  <form id="bsk_gfblcv_lists_form_id" method="post" action="'.$current_base_page.'">';
                        $_bsk_gfblcv_OBJ_lists->display();
            echo '  
                        <input type="hidden" name="bsk_gfblcv_list_id" id="bsk_gfblcv_list_id_to_be_processed_ID" value="0" />
                        <input type="hidden" name="bsk_gfblcv_action" id="bsk_gfblcv_action_ID" value="" />';
                        wp_nonce_field( 'bsk_gfblcv_list_oper_nonce' );
            echo '
                    </form>
                  </div>';
		}else if ( $current_view == 'addnew' || $current_view == 'edit' ){
			$list_id = -1;
			if(isset($_GET['id']) && $_GET['id']){
				$list_id = trim($_GET['id']);
				$list_id = absint($list_id);
			}
            $this->_bsk_gfblcv_OBJ_list->bsk_gfblcv_list_edit( 
                                                               $list_id, 
                                                               $current_list_view, 
                                                               $current_view 
                                                             );
		}
	}
    
    function bsk_gfblcv_invitlist_list(){
        
        $current_view = 'list';
        if(isset($_GET['view']) && $_GET['view']){
			$current_view = trim($_GET['view']);
		}
		if(isset($_POST['view']) && $_POST['view']){
			$current_view = trim($_POST['view']);
		}
        
		$current_list_view = 'invitlist';
		$current_base_page = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['invitlist']['slug'].'&view='.$current_view );
		
		if( $current_view == 'list' ){
            $_bsk_gfblcv_OBJ_lists = new BSK_GFBLCV_Pro_Dashboard_Lists( array( 'list' => 'invitlist' ) );

            //Fetch, prepare, sort, and filter our data...
            $_bsk_gfblcv_OBJ_lists->prepare_items();

            $add_new_page_url = add_query_arg( 'view', 'addnew', $current_base_page );
            echo '<div class="wrap">
                    <div id="icon-edit" class="icon32"><br/></div>
                    <h2>BSK Forms Invitation Codes List<a href="'.$add_new_page_url.'" class="add-new-h2">Add New</a></h2>';
            echo '  <form id="bsk_gfblcv_lists_form_id" method="post" action="'.$current_base_page.'">';
                        $_bsk_gfblcv_OBJ_lists->display();
            echo '  
                        <input type="hidden" name="bsk_gfblcv_list_id" id="bsk_gfblcv_list_id_to_be_processed_ID" value="0" />
                        <input type="hidden" name="bsk_gfblcv_action" id="bsk_gfblcv_action_ID" value="" />';
                        wp_nonce_field( 'bsk_gfblcv_list_oper_nonce' );
            echo '
                    </form>
                  </div>';
		}else if ( $current_view == 'addnew' || $current_view == 'edit' ){
			$list_id = -1;
			if(isset($_GET['id']) && $_GET['id']){
				$list_id = trim($_GET['id']);
				$list_id = absint($list_id);
			}
            $this->_bsk_gfblcv_OBJ_list->bsk_gfblcv_list_edit( 
                                                               $list_id, 
                                                               $current_list_view, 
                                                               $current_view 
                                                             );
		}
	}
    
    function bsk_gfblcv_blocked_data(){
        
        $license_type = get_option( BSK_GFBLCV_Pro_Dashboard::$_plugin_license_type, 'PERSONAL' );
        
        $settings_data = get_option( self::$_plugin_settings_option, false );
        $save_blocked_entry = true;
        if( $settings_data && is_array( $settings_data ) && count( $settings_data ) > 0 ){
            if( isset( $settings_data['save_blocked_entry'] ) ){
                $save_blocked_entry = $settings_data['save_blocked_entry'];
            }
        }
        $action_url = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['blocked_data']['slug'] );
		?>
        <div class="wrap">
            <div id="icon-edit" class="icon32"><br/></div>
            <h2>Blocked Data</h3>
            <div style="clear: both;"></div>
            <form action="<?php echo $action_url; ?>" method="POST" id="bsk_gfblcv_entries_form_ID">
            <div>
                <?php 
                if( $license_type == 'PERSONAL' || $license_type == 'CREATOR' ){
                    $license = get_option( self::$_plugin_license, '' );
                    $update_license_type_url = add_query_arg( 
                                                              array( 'bskddaction' => 'renewlicense', 
                                                                     'bskddlicense' => $license), 
                                                              BSK_GFBLCV_Pro_Update_Helper::$_plugin_home_url 
                                                            );
                ?>
                <div class="bsk-gfblcv-tips-box">
                    <p>This feature requires ask a <span style="font-weight: bold;">BUSINESS</span>( or above ) license, your license type is: <span style="font-weight: bold;"><?php echo $license_type; ?></span>. </p>
                    <p>To update your license type, please <a href="<?php echo $update_license_type_url; ?>" target="_blank">click here >></a></p>
                </div>
                <?php
                }else{
                    if( $save_blocked_entry == 'NO' ){
                        $settings_url = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['settings']['slug'] );
                        echo '<p>Save blocked entry is disabled now, to enable it please go to <a href="'.$settings_url.'">settings</a> page.</p>';
                    }
                ?>
                <h4 style="margin-top: 40px;">Please select form plugin and form name to filter blocked data</h4>
                <p>
                    <?php
                    $selected_form_plugin = '';
                    $current_selected_form_plugin = '';
                    $form_plugin_list = BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_get_form_plugin();
                    if( isset( $_POST['bsk_gfbl_form_selected_plugin'] ) ){
                        $selected_form_plugin = sanitize_text_field( $_POST['bsk_gfbl_form_selected_plugin'] );
                        $current_selected_form_plugin = sanitize_text_field( $_POST['bsk_gfbl_form_current_selected_plugin'] );
                    }
                    
                    ?>
                    <select name="bsk_gfbl_form_selected_plugin" id="bsk_gfbl_form_selected_plugin_ID" class="bsk-gfbl-entries-filter-select">
                        <option value="">Select form plugin...</option>
                        <?php 
                        if( $form_plugin_list ){
                            foreach( $form_plugin_list as $form_plugin_id => $form_plugin_title ){
                                if( $selected_form_plugin == $form_plugin_id ){
                                    echo '<option value="'.$form_plugin_id.'" selected>'.$form_plugin_title.'</option>';
                                }else{
                                    echo '<option value="'.$form_plugin_id.'">'.$form_plugin_title.'</option>';
                                }
                            }    
                        }
                        ?>
                    </select>
                    <?php
                    $selected_form_id = 0;
                    if( isset( $_POST['bsk_gfbl_form_select_to_list_entries'] ) && $_POST['bsk_gfbl_form_select_to_list_entries'] > 0 ){
                        if ( $current_selected_form_plugin && $current_selected_form_plugin == $selected_form_plugin ) {
                            $selected_form_id = $_POST['bsk_gfbl_form_select_to_list_entries'];
                        }
                    }
                    ?>
                    <select name="bsk_gfbl_form_select_to_list_entries" id="bsk_gfbl_form_select_to_list_entries_ID" class="bsk-gfbl-entries-filter-select" style="display: inline-block; margin-left: 20px;">
                        <option value="">Select form...</option>
                        <?php 
                        if( $selected_form_plugin ){
                            $forms_list = BSK_GFBLCV_Pro_Dashboard_Common::bsk_gfblcv_get_gf_forms( $selected_form_plugin );
                            foreach( $forms_list as $form_id => $form_title ){
                                if( $selected_form_id == $form_id ){
                                    echo '<option value="'.$form_id.'" selected>'.$form_title.'</option>';
                                }else{
                                    echo '<option value="'.$form_id.'">'.$form_title.'</option>';
                                }
                            }    
                        }
                        ?>
                    </select>
                </p>
                <div>
                <?php
                $init_args = array();
                $init_args['form_plugin'] = $selected_form_plugin;
                $init_args['form_id'] = $selected_form_id;
                $_bsk_gfblcv_OBJ_entries_lists = new BSK_GFBLCV_Pro_Dashboard_Entries_List( $init_args );

                //Fetch, prepare, sort, and filter our data...
                $_bsk_gfblcv_OBJ_entries_lists->prepare_items();
                $_bsk_gfblcv_OBJ_entries_lists->display();
                    
                ?>
                </div>
                <?php
                } //end of license type
                ?>
            </div>
            <p style="margin-top: 40px;">
                <?php wp_nonce_field( 'bsk_gfbcv_settings_save_oper_nonce' ); ?>
                <input type="hidden" name="bsk_gfbl_form_current_selected_plugin" value="<?php echo $selected_form_plugin; ?>" />
            </p>
            </form>
        </div>
        <?php
	}
    
    function bsk_gfblcv_settings(){
        $action = '';
        $tmpl = '';
        if( isset($_GET['action']) && $_GET['action'] ){
            $action = sanitize_text_field( $_GET['action'] );
        }
        if( isset($_GET['tmpl']) && $_GET['tmpl'] ){
            $tmpl = sanitize_text_field( $_GET['tmpl'] );
        }
        if( $action == 'preview-email-tmpl' ){
            if( $tmpl ){
                $this->_bsk_gfblcv_OBJ_settings->bsk_gfblcv_preview_email_tmpl( $tmpl );
                
                return;
            }
        }
        
        $this->_bsk_gfblcv_OBJ_settings->display();
	}
    
    function bsk_gfblcv_license_update(){
        $action_url = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['base']['slug'] );
		$license = get_option( self::$_plugin_license );
		$license_status = get_option( self::$_plugin_license_stauts );
		$license_actived = get_option( self::$_plugin_license_actived );

		$read_only_str = '';
		if( trim($license) != "" && $license_status == 'VALID' ) {
			$read_only_str = 'readonly';
            $action_url = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['license_update']['slug'] );
		}
		?>
        <div class="wrap">
            <div id="icon-edit" class="icon32"><br/></div>
            <h2>License &amp; Update</h2>
            <form action="<?php echo $action_url; ?>" method="POST" id="bsk_gfblcv_license_form_ID">
            <h3 style="margin-top:60px;">License Activation</h3>
            <p style="margin-top:20px;">In the field below please enter your license key to activate this plugin</p>
            <p style="margin-top:20px;">
                <input id="bsk_gfblcv_license_key_id" name="bsk_gfblcv_license" type="text" value="<?php echo $license; ?>" size="50" <?php echo $read_only_str; ?> />
                <?php
                if( $license_status == 'VALID' && $license_actived == 'ACTIVED' ) {
                    echo '<span style="color:green;">Active</span>';
                    echo '<input type="submit" class="button-secondary" name="bsk_gfblcv_license_deactivate" value="Deactivate License" style="margin-left:20px;" />';
                }else{
                    if( $license_status ){
                        echo '<span style="color:red;">'.$license_status.'</span>';
                    }
                    echo '<input type="submit" class="button-secondary" name="bsk_gfblcv_license_activate" value="Activate License" style="margin-left:20px;" />';
                }
                wp_nonce_field( 'bsk_gfblcv_license_nonce' );
                ?>	
            </p>
            <?php
            $activation_return = get_option( self::$_plugin_license_activation_return, NULL );
            if( $license_status != 'VALID' && $license_actived != 'ACTIVED' && 
                $activation_return && is_array($activation_return) && isset($activation_return['success']) && !$activation_return['success']) {
                echo '<p class="bsk-gfblcv-error-message">'.$activation_return['error'].'</p>'; 
            }
            ?>
            <?php
            if( $license_status == 'VALID' && $license_actived == 'ACTIVED' ) {
                if( $this->_bsk_gfblcv_OBJ_update_helper ){
                    $this->_bsk_gfblcv_OBJ_update_helper->bsk_gfblcv_show_license_summary_fun();
                }
            }
            ?>
            <?php
                if( trim($license) != ""  && $this->_bsk_gfblcv_OBJ_update_helper ){
                    $this->_bsk_gfblcv_OBJ_update_helper->bsk_gfblcv_plugin_update_center();
                }
            ?>
            </form>
        </div>
        <div class="bsk-prdoucts">
        	<div class="bsk-prdoucts-single">
            	<h4>BSK PDF Manager</h4>
                <p>The plugin support you manage your PDF files in WordPress. It’s convenient to make use of. You just need replica the shortcodes into the page/post the place where you wish to have PDF files to exhibit.</p>
                <ol>
                	<li>Upload PDF files via categories</li>
                    <li>Display PDF order by title, date, filename or custom order. Support most top X files shown.</li>
                    <li>Bulk Upload PDF via FTP</li>
                    <li>Show PDF in widget area</li>
                    <li>Featured image supported</li>
               	</ol>
                <p><span style="color:#F33;">Extra 10% off if you have any valid license of our products</span></p>
                <p class="bsk-prdoucts-single-center">
                	<a class="button button-primary bsk-prdoucts-single-link-button" href="http://www.bannersky.com/bsk-pdf-manager/" target="_blank">More Info</a>
                </p>
            </div>
        </div>
        <?php
	}
    
	function bsk_gfblcv_activate_license() {
		if( !isset( $_POST['bsk_gfblcv_license_activate'] ) ) {
			return;
		}
		
		if( !wp_verify_nonce( $_POST['_wpnonce'], 'bsk_gfblcv_license_nonce' ) ) {
     		wp_die( 'Security check failed. Please refreh page and try again! '."\n".'File: '.__FILE__.' Line: '.__LINE__ ); 
		}

		$license = trim( $_POST['bsk_gfblcv_license'] );
			
		// data to send in our API request
		$api_params = array( 
			'bskddaction'=> 'activate_license', 
			'license' 	=> $license, 
			'product_id' => BSK_GFBLCV_Pro_Update_Helper::$_plugin_product_id,
			'site' => site_url()
		);
		
		$response = wp_remote_get( add_query_arg( $api_params, BSK_GFBLCV_Pro_Update_Helper::$_plugin_home_url ), array( 'timeout' => 15, 'sslverify' => false ) );
		if( is_wp_error( $response ) ){
			update_option( self::$_plugin_license_activation_return, 
                           array( 'success' => false, 'error' => $response->get_error_message() ) );
			return false;
		}

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		update_option( self::$_plugin_license, $license );
		
        $url_to_redirect = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['license_update']['slug'] );
		if( $license_data->license_status == 'VALID' ){
			update_option( self::$_plugin_license_actived, 'ACTIVED' );
            delete_option( self::$_plugin_license_activation_return );
		}else{
            delete_option( self::$_plugin_license_actived );
			update_option( self::$_plugin_license_activation_return, 
                           array( 'success' => false, 'error' => 'License Status: '.$license_data->license_status ) 
                         );
            $url_to_redirect = admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['base']['slug'] );
		}
        
        update_option( self::$_plugin_license_stauts, $license_data->license_status );
        
        $license_type = isset($license_data->license_type) ? $license_data->license_type : 'PERSONAL';
        update_option( self::$_plugin_license_type, $license_type );
        
        $expiry_date = isset($license_data->expiry_date) ? $license_data->expiry_date : '';
        update_option( self::$_plugin_license_expiry_date, $expiry_date );        
        
        wp_redirect( $url_to_redirect );
	}

	function bsk_gfblcv_deactivate_license() {
		if( !isset( $_POST['bsk_gfblcv_license_deactivate'] ) ) {
			return;
		}
		if( ! wp_verify_nonce( $_POST['_wpnonce'], 'bsk_gfblcv_license_nonce' ) ) {
     		die( 'Security check - '. __FILE__.' Line: '.__LINE__ ); 
		}

		$license = trim( $_POST['bsk_gfblcv_license'] );
		
		// data to send in our API request
		$api_params = array( 
			'bskddaction'=> 'deactivate_license', 
			'license' 	=> $license, 
			'product_id' => BSK_GFBLCV_Pro_Update_Helper::$_plugin_product_id,
			'site' => site_url()
		);
		
		$response = wp_remote_get( add_query_arg( $api_params, BSK_GFBLCV_Pro_Update_Helper::$_plugin_home_url ), array( 'timeout' => 15, 'sslverify' => false ) );
		
		delete_option( self::$_plugin_license_stauts );
		
		wp_redirect( admin_url( 'admin.php?page='.self::$_bsk_gfblcv_pages['base']['slug'] ) );
	}
	

    function bsk_gfblcv_set_option($status, $option, $value) {

        if ( 'bsk_gfblcv_lists_per_page' == $option || 
             'bsk_gfblcv_items_per_page' == $option ){
            
            return $value;
        } 
        
        return $status;
    }
    
    function bsk_gfblcv_upgrade_done_notice_fun(){
        if( ! isset( $_GET[ 'upgrade' ] ) || 
            $_GET[ 'upgrade' ] != 'bskgfbl' ){
            return;
        } 
        ?>
        <div class="notice notice-success is-dismissible">
            <p>Congratulations!</p>
            <p>You have upgraded to Pro version successfully, the free version has been deactivated. To avoid confusion we suggest you delete free version instantly.</p>
            <p><a href="<?php echo admin_url( 'plugins.php?s=BSK%20Forms%20Blacklist&plugin_status=all' ); ?>">Go to delete free version</a></p>
        </div>
        <?php
    }
    
    function bsk_gfblcv_delete_entries_fun( $form_id ){
        global $wpdb;
        
        $entries_table = $wpdb->prefix.BSK_GFBLCV_Pro::$_bsk_gfblcv_entries_tbl_name;
        $sql = 'DELETE FROM `'.$entries_table.'` WHERE `form_id` = %d';
        $sql = $wpdb->prepare( $sql, $form_id );
        
        $wpdb->query( $sql );
    }
}
