<?php

$is_global_schedule = get_site_option( 'bb_single_schedule' );

if ( ! empty( $is_global_schedule ) ) {
	$type_option = ! empty( get_site_option( 'bb_schedule_type' ) ) ? absint( get_site_option( 'bb_schedule_type' ) ) : 30;
} else {
	$type_option = ! empty( get_user_meta( $user_id, 'bb_schedule_type' ) ) ? absint( get_user_meta( $user_id, 'bb_schedule_type' ) ) : 30;
}

$type        = isset( $_GET['type'] ) ? absint( $_GET['type'] ) : $type_option;

$hour_standard_12 = get_site_option( 'bb_schedule_12_hour_standard' );
$hour_standard_24 = get_site_option( 'bb_schedule_24_hour_standard' );

$hours = [
	'am' => [
		'12',
		'1',
		'2',
		'3',
		'4',
		'5',
		'6',
		'7',
		'8',
		'9',
		'10',
		'11',
	],
	'pm' => [
		'12',
		'1',
		'2',
		'3',
		'4',
		'5',
		'6',
		'7',
		'8',
		'9',
		'10',
		'11',
	],
];

if ( ! empty( $hour_standard_24 ) ) {
	$hour_24_labels = [];
}

$days = [
	'mon' => 'Monday',
	'tue' => 'Tuesday',
	'wed' => 'Wednesday',
	'thu' => 'Thursday',
	'fri' => 'Friday',
	'sat' => 'Saturday',
	'sun' => 'Sunday',
];

$types = [
	'15' => [ '00', '15', '30', '45' ],
	'30' => [ '00', '30' ],
	'60' => [ '00' ],
	'120' => [ '00' ],
	'240' => [ '00' ],
];

$fields = [];

foreach ( $hours as $abbr => $times ) {
	foreach ( $times as $time ) {
		$fields["{$abbr}_{$time}"] = [ 'label' => "{$time}:00 {$abbr}", 'days' => [] ];

		foreach ( $days as $key => $day ) {
			$fields["{$abbr}_{$time}"]['days'][$key] = [ 'label' => $day, 'slots' => [] ];

			foreach ( $types[$type] as $slot ) {
				$fields["{$abbr}_{$time}"]['days'][$key]['slots']["{$key}_{$abbr}_{$time}_{$slot}"] = ":{$slot}";
			}
		}
	}
}
