<?php
use Carbon_Fields\Container;
use Carbon_Fields\Field;

Container::make( 'post_meta', __( 'Appointment Settings', 'brindle-booking' ) )
	->where( 'post_type', '=', 'bb_appointment' )
	->add_tab( __( 'General', 'brindle-booking' ), array(
		Field::make( 'text', 'bb_staff_member', __( 'Staff Member', 'brindle-booking' ) ),
		Field::make( 'separator', 'bb_service_separator', __( 'Service & Date', 'brindle-booking' ) ),
		Field::make( 'select', 'bb_appointment_category', __( 'Category', 'brindle-booking' ) )
			->add_options( bb_get_category_for_select() ),
		Field::make( 'select', 'bb_appointment_service', __( 'Service', 'brindle-booking' ) )
			->add_options( bb_get_services_for_select() ),
		Field::make( 'text', 'bb_appointment_method', __( 'Method', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_time_slot', __( 'Time slot', 'brindle-booking' ) ),
		Field::make( 'date', 'bb_appointment_date', __( 'Date', 'brindle-booking' ) ),
		Field::make( 'separator', 'bb_details_separator', __( 'Details/Payment', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_full_name', __( 'Full Name', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_email', __( 'Email', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_phone', __( 'Phone', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_address', __( 'Address', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_payment_method', __( 'Payment Method', 'brindle-booking' ) ),
	) )
	->add_tab( __( 'Payment', 'brindle-booking' ), array(
		Field::make( 'text', 'bb_appointment_payment_balance_transaction', __( 'Balance Transaction', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_payment_amount', __( 'Amount ( * used from the API )', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_payment_paid_amount', __( 'Paid Amount', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_payment_currency', __( 'Currency', 'brindle-booking' ) ),
		Field::make( 'text', 'bb_appointment_payment_status', __( 'Status', 'brindle-booking' ) ),
	) )
	->add_tab( __( 'Zoom', 'brindle-booking' ), [
		Field::make( 'text', 'bb_zoom_meeting_title', __( 'Title', 'crb' ) ),
		Field::make( 'text', 'bb_zoom_meeting_start_time', __( 'Start Time', 'crb' ) ),
		Field::make( 'text', 'bb_zoom_meeting_duration', __( 'Duration', 'crb' ) ),
		Field::make( 'text', 'bb_zoom_meeting_join_link', __( 'Join Link', 'crb' ) ),
	] )
	;