<?php

$fields = [
	__( 'Payment Details', 'brindle-booking' ) => [
		[
			[
				'enable_online_payments'     => [
					'title' => __( 'Enable Online Payments', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_enable_online_payments', true ),
					'hint'  => __( 'Let customers pay for any service via credit card (Stripe) directly in the booking process.', 'brindle-booking' )
				],
				'enable_payment_on_location' => [
					'title' => __( 'Enable Payment on Location', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_enable_payment_on_location', true ),
					'hint'  => __( 'Allow customers to pay on location for the service or appointment.', 'brindle-booking' )
				],
				'enable_payment_via_invoice' => [
					'title' => __( 'Enable Payment via Invoice Later', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_enable_payment_via_invoice', true ),
					'hint'  => __( 'Let customers pay via an invoice. Note Invoice must be sent separately and is not a feature of this plugin.', 'brindle-booking' )
				],
			],
			 __( 'Stripe API Keys', 'brindle-booking' ) => [
				'stripe_publishable_key' => [
					'title'       => __( 'Publishable key', 'brindle-booking' ),
					'type'        => 'text',
					'placeholder' => __( 'Please enter your key...', 'brindle-booking' ),
					'value'       => get_site_option( 'bb_stripe_pk_key', true )
				],
				'stripe_secret_key' => [
					'title'       => __( 'Secret key', 'brindle-booking' ),
					'type'        => 'text',
					'placeholder' => __( 'Please enter your key...', 'brindle-booking' ),
					'value'       => get_site_option( 'bb_stripe_sk_key', true ),
					'help_text' => sprintf(
						__( 'You need Stripe account to get API keys. You can find more information %s.', 'brindle-booking' ),
						sprintf(
							'<a href="https://support.stripe.com/questions/locate-api-keys-in-the-dashboard" target="_blank">%s</a>',
							_x( 'here', 'Get API Key', 'brindle-booking' )
						)
					)
				]
			],
			__( 'Currency', 'brindle-booking' ) => [
				'payment_currency' => [
					'title'       => '',
					'type'        => 'select',
					'options'     => mbbb_get_supported_currencies(), // Expects array with key => value
					'placeholder' => '',
					'value'       => get_site_option( 'bb_payment_currency', true )
				]
			]
		]
	],
	__( 'Location Settings', 'brindle-booking' ) => [
		[
			[
				'display_our_time'     => [
					'title' => __( 'Display "Our Time"', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_display_our_time', true ),
					'hint'  => __( 'Add a small realtime clock to let customers know what time it is in your specific time zone as they book.', 'brindle-booking' )
				],
				'display_directions' => [
					'title' => __( 'Display Directions', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_display_directions', true ),
					'hint'  => __( 'Provide directions to your facility via Google Maps.', 'brindle-booking' )
				],
			],
			__( 'Location Address', 'brindle-booking' ) => [
				'location_address' => [
					'type'        => 'text',
					'placeholder' => __( 'Enter full address of your location to provide directions to customers...', 'brindle-booking' ),
					'value'       => get_site_option( 'bb_location_address', true )
				]
			],
		]
	],
	__( 'Front End Settings', 'brindle-booking' ) => [
		[
			__( 'Include/Exclude', 'brindle-booking' ) => [
				'include_category'     => [
					'title' => __( 'Category', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_include_category', true ),
					'hint'  => __( 'If you have different service types (for example if you would like to allow paid services and non-paid meetings) then you can allow customers to select the category via this dropdown. You can create categories in the Services tab.', 'brindle-booking' )
				],
				'include_service' => [
					'title' => __( 'Service', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_include_service', true ),
					'hint'  => __( 'If you are providing multiple services, this will add a dropdown so customers can choose which service to book.', 'brindle-booking' )
				],
				'include_appointment_method' => [
					'title' => __( 'Appointment Method', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_include_appointment_method', true ),
					'hint'  => __( 'Adds a dropdown that lets customers choose the appointment method, ie online or at facility.', 'brindle-booking' )
				],
				'include_show_booked_time_slots' => [
					'title' => __( 'Show Booked time Slots', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_include_show_booked_time_slots', true ),
					'hint'  => __( 'Display previously booked time slots with booked label. This is good for showing other customers that there is demand for your service, and also for fellow team members to see your schedule.', 'brindle-booking' )
				],
			],
			__( 'Appointment Methods', 'brindle-booking' ) => [
				'method_in_store'     => [
					'title' => __( 'In Store', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_method_in_store', true )
				],
				'method_at_facility' => [
					'title' => __( 'At Facility', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_method_at_facility', true )
				],
				'method_online_video' => [
					'title' => __( 'Online Consultation (video)', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_method_online_video', true )
				],
				'method_phone_call' => [
					'title' => __( 'Phone Call', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_method_phone_call', true )
				],
				'method_delivery' => [
					'title' => __( 'Delivery', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_method_delivery', true )
				],
			],
			__( 'Customer Details Collected', 'brindle-booking' ) => [
				'collected_details_full_name'     => [
					'title' => '<strong>' . __( 'Full Name', 'brindle-booking' ) . '</strong>',
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_collected_details_full_name', true ),
					'class' => 'collected_data'
				],
				'collected_details_full_name_required' => [
					'title'      => __( 'Required', 'brindle-booking' ),
					'type'       => 'checkbox',
					'value'      => get_site_option( 'bb_collected_details_full_name_required', true ),
					'logic'      => true,
					'prev_value' => get_site_option( 'bb_collected_details_full_name', true )
				],
				'collected_details_email'     => [
					'title' => '<strong>' . __( 'Email', 'brindle-booking' ) . '</strong>',
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_collected_details_email', true ),
					'class' => 'collected_data'
				],
				'collected_details_email_required' => [
					'title'      => __( 'Required', 'brindle-booking' ),
					'type'       => 'checkbox',
					'value'      => get_site_option( 'bb_collected_details_email_required', true ),
					'logic'      => true,
					'prev_value' => get_site_option( 'bb_collected_details_email', true )
				],
				'collected_details_phone'     => [
					'title' => '<strong>' . __( 'Phone', 'brindle-booking' ) . '</strong>',
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_collected_details_phone', true ),
					'class' => 'collected_data'
				],
				'collected_details_phone_required' => [
					'title'      => __( 'Required', 'brindle-booking' ),
					'type'       => 'checkbox',
					'value'      => get_site_option( 'bb_collected_details_phone_required', true ),
					'logic'      => true,
					'prev_value' => get_site_option( 'bb_collected_details_phone', true )
				],
				'collected_details_address'     => [
					'title' => '<strong>' . __( 'Address', 'brindle-booking' ) . '</strong>',
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_collected_details_address', true ),
					'class' => 'collected_data'
				],
				'collected_details_address_required' => [
					'title'      => __( 'Required', 'brindle-booking' ),
					'type'       => 'checkbox',
					'value'      => get_site_option( 'bb_collected_details_address_required', true ),
					'logic'      => true,
					'prev_value' => get_site_option( 'bb_collected_details_address', true )
				],
			],
			__( 'Acknowledgement <span>(ensure visitor agrees to GDPR, Terms, etc.)</span>', 'brindle-booking' ) => [
				'include_acknowledgement' => [
					'title' => __( 'Include', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_include_acknowledgement', 0 ),
				],
				'selected_by_default_acknowledgement' => [
					'title' => __( 'Selected by default', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_selected_by_default_acknowledgement', 0 ),
				],
			],
			[
				'text_entry_acknowledgement' => [
					'title'   => '',
					'type'    => 'rich_text',
					'value'   => stripslashes( get_site_option( 'bb_text_entry_acknowledgement', 'I have read &amp; agree to the <a href=\"#\" target=\"\\&quot;_blank\\&quot;\" rel=\"\\&quot;noopener\\&quot;\">cancellation policy</a> and <a href=\"#\" target=\"\\&quot;_blank\\&quot;\" rel=\"\\&quot;noopener\\&quot;\">privacy policy</a>' ) ),
					'options' => [
						'media_buttons' => false,
						'tinymce'       => [
							'toolbar1'    => 'formatselect,bold,italic,link',
							'toolbar2'    => false,
							'statusbar'   => false,
							'content_css' => BB_PLUGIN_URL . 'css/tinymce.css'
						],
						'quicktags' => false,
					]
				]
			],
			__( 'Confirmation Page', 'brindle-booking' ) => [
				'conf_page_print'     => [
					'title' => __( 'Ability to Print', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_conf_page_print', true )
				],
				'conf_page_google_reminder' => [
					'title' => __( 'Google Calendar Reminder', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_conf_page_google_reminder', true )
				],
				'conf_page_support_link' => [
					'title' => __( 'Link to Support', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_conf_page_support_link', true )
				],
				'conf_page_facebook_share' => [
					'title' => __( 'Ability to Share on Facebook', 'brindle-booking' ),
					'type'  => 'checkbox',
					'value' => get_site_option( 'bb_conf_page_facebook_share', true )
				],
			],
			[
				'support_page_link' => [
					'title'       => 'Support Button URL',
					'type'        => 'text',
					'placeholder' => __( 'Enter Link for tech support page here...', 'brindle-booking' ),
					'value'       => get_site_option( 'bb_support_page_link', true )
				]
			],
			[
				'google_calendar_credentials' => [
					'title'     => __( 'Google Calendar Credentials', 'brindle-booking' ),
					'type'      => 'file',
					'option'    => get_site_option( 'bb_gc_credentials', true ),
					'accept'    => 'application/json',
					'help_text' => sprintf(
						__( 'You can generate your credentials, by visiting %s and following the instructions. After you genereate "OAuth 2.0 Client ID" you should download credentials.json file and upload it.', 'brindle-booking' ),
						sprintf(
							'<a href="https://developers.google.com/identity/protocols/oauth2" target="_blank">%s</a>',
							_x( 'Google OAuth 2.0 Docs', 'Get API Key', 'brindle-booking' )
						)
					)
				]
			],
			__( 'Redirect After Booking?', 'brindle-booking' ) => [
				'enable_redirect' => [
					'title'        => __( 'Enable Redirect after Booking', 'brindle-booking' ),
					'type'         => 'checkbox',
					'value'        => get_site_option( 'bb_enable_redirect', 0 )
				],
			],
			[
				'redirect_url'    => [
					'title'        => '',
					'type'         => 'text',
					'placeholder'  => __( 'Enter URL to page you’d like to redirect to after user has booked an appointment...', 'brindle-booking' ),
					'value'        => get_site_option( 'bb_redirect_url', '' )
				]
			]
		]
	],
	__( 'Other Settings', 'brindle-booking' ) => [
		[
			__( 'Loading Assets', 'brindle-booking' ) => [
				'load_assets_on_all_pages' => [
					'value' => get_site_option( 'bb_load_assets_on_all_pages', 'load_assets_on_all_pages_yes' ),
					'type'  => 'radio',
					'checkboxes' => [
						[
							'id'    => 'load_assets_on_all_pages_yes',
							'label' => __( 'Load on all Pages', 'brindle-booking' ),
							'value' => 'load_assets_on_all_pages_yes',
						],
						[
							'id'    => 'load_assets_on_specific_pages',
							'label' => __( 'Load on specific pages only', 'brindle-booking' ),
							'value' => 'load_assets_on_specific_pages',
						],
					],
				],
				'load_assets_choose_pages' => [
					'title' => __( 'Choose Pages', 'brindle-booking' ),
					'type'  => 'association',
					'value' => get_site_option( 'bb_load_assets_choose_pages', '' ),
					'types' => [
						[
							'post_type' => 'page'
						],
						[
							'post_type' => 'post'
						],
						[
							'post_type' => 'custom_post_type'
						],
					],
					'help_text' => '',
				]
			]
		]
	]
];
?>