;(function($, window, document, undefined) {
	let stripe;
	let cardElement;

	$(document).ready(function() {
		bbSwitchSlidesOnClick();
		bbTriggerPopup();
		bbPrint();
		bbAjaxCategoryServices();
		bbAjaxStepTransition();
		bbSelectTimeOfDay();
		bbStepBackToPrev();
		bbLoadPaymentMethod();
		bbSwitchTabsOnClick();
		bbPaymentMethodChange();
	});

	function bbPaymentMethodChange() {
		$(document).on('change', '#payment_method', function() {
			const $this = $(this);

			if ($this.find('option:selected').val() === 'stripe') {
				return;
			}

			$this.closest('.bb-section__row').find('.bb-section__aside').html('');
		});
	}

	function bbSwitchTabs($nextTab) {
		$nextTab.addClass('bb-active').siblings().removeClass('bb-active');
	}

	function bbSwitchTabsOnClick() {
		$(document).on('click', '.bb-tabs .bb-tabs__nav a', function(event) {
			event.preventDefault();

			var $parent = $(this).parent();

			if (! $parent.is('.bb-done-step')) {
				return;
			}

			var $activatedTab = $(this).closest('.bb-tabs').find('.bb-tab').eq($parent.index());

			$parent.addClass('bb-active').siblings().removeClass('bb-active');

			bbSwitchTabs($activatedTab);
		});
	}

	function bbGetPrevNextSlide($slides, $datePrev, $dateNext) {
		if (! $slides.length) {
			return;
		}

		var $container = $('.bb-booking-module--inline');

		if ($('body').is('.bb-popup-visible')) {
			$container = $('.bb-popup');
		}

		var category = $container.find('#bb-form-service-category option:selected').val();
		var service = $container.find('#bb-form-service option:selected').val();
		var staffMember = $container.find('#bb-form-staff-member option:selected').val();

		$.ajax({
			url: bb_options.ajax_url,
			method: 'POST',
			data: {
				action: 'bb_ajax_get_prev_next_date_slide',
				date_for_prev: $datePrev,
				date_for_next: $dateNext,
				cat_id: category,
				service_id: service,
				staff_member: staffMember
			},
			dataType: 'json',
			beforeSend: function() {
				$slides.closest('.js-slider-default').addClass('nav-disabled');
			},
			success: function(result) {
				$slides.prepend(result.slides.prev);
				$slides.append(result.slides.next);
				$slides.closest('.bb-section-time').find('.bb-tabs-schedule').prepend(result.time_slots.prev);
				$slides.closest('.bb-section-time').find('.bb-tabs-schedule').append(result.time_slots.next);
				
				$slides.closest('.js-slider-default').removeClass('nav-disabled');

				setTimeout(function(){
					$slides.find('.bb-slider__slide[style="display: none;"]').attr('style', '');
					$slides.find('.bb-slider__slide[style="display: none;"]').removeAttr('style');
					$slides.find('.bb-slider__slide').css('display', 'block');

				}, 400);
			}
		});
	}

	function bbSwitchSlides(direction, currentTranslate, $currentSlide) {
		var $parent = $currentSlide.parent();
		var $currentTab = $parent.closest('.bb-section-time').find('.bb-tab-schedule.bb-is-active');

		var translateAmount  = $currentSlide.innerWidth() + (parseInt($currentSlide.css('marginRight').replace('px', '')) * 2);

		if (direction === 'left') {
			var $nextSlide = $currentSlide.prev();
			var $nextTab   = $currentTab.prev();
			var translateResult = currentTranslate + translateAmount;

			if (! $nextSlide.prev().length) {
				bbGetPrevNextSlide($parent, $nextSlide.data('date'), $parent.find('.bb-slider__slide:last-child').data('date'));
			}
		} else {
			var $nextSlide = $currentSlide.next();
			var $nextTab   = $currentTab.next();
			var translateResult = currentTranslate - translateAmount;

			if (! $nextSlide.next().length) {
				bbGetPrevNextSlide($parent, $nextSlide.data('date'), $parent.find('.bb-slider__slide:last-child').data('date'));
			}
		}

		if (! $nextSlide.length) {
			return;
		}

		$currentTab.removeClass('bb-is-active');
		$currentTab.find('.bb-list-times .bb-is-selected').removeClass('bb-is-selected');
		$currentTab.closest('.bb-section-time').find('.bb-field-date-time-selected').val('');

		$nextTab.addClass('bb-is-active');

		$parent.closest('.bb-slider-default').find('#bb-slider-dates-field').val($nextSlide.data('date'));

		$currentSlide.removeClass('bb-is-active');
		$nextSlide.addClass('bb-is-active');
		$parent.css('transform', 'translateX(' + translateResult + 'px)');

		setTimeout(function() {
			if ($nextSlide.prev().is('[data-past="true"]')) {
				$nextSlide.closest('.js-slider-default').find('.js-slide-prev').attr('data-disabled', 'true');
			} else {
				$nextSlide.closest('.js-slider-default').find('.js-slide-prev').attr('data-disabled', 'false');
			}
		}, 400);
	}

	function bbSwitchSlidesOnClick() {
		currentTranslate = 0;

		$(document).on('click', '.js-slide-prev, .js-slide-next', function(event) {
			event.preventDefault();

			var $container = $('.bb-booking-module--inline');

			if ($('body').is('.bb-popup-visible')) {
				$container = $('.bb-popup');
			}

			var $this = $(this);

			if ($this.closest('.js-slider-default').is('.nav-disabled')) {
				return;
			}

			var direction = $this.is('.js-slide-next') ? 'right' : 'left';
			var $currentSlide = $this.closest('.js-slider-default').find('.bb-slider__slide.bb-is-active');

			if (direction === 'left' && $currentSlide.prev().length < 1 || direction === 'right' && $currentSlide.next().length < 1) {
				return;
			}

			bbSwitchSlides(direction, currentTranslate, $currentSlide);

			if (direction === 'left') {
				currentTranslate += $currentSlide.innerWidth() + (parseInt($currentSlide.css('marginRight').replace('px', '')) *2);
			} else {
				currentTranslate -= $currentSlide.innerWidth() + (parseInt($currentSlide.css('marginRight').replace('px', '')) *2);
			}

			$container.find('#bb-field-date-selected').val($('.bb-slider__slide.bb-is-active').data('date'));
		});
	}

	function bbTriggerPopup() {
		$(document).on('click', '.bb-js-trigger-popup', function(event) {
			event.preventDefault();
			var popups = $('.bb-js-popup');

			$('body').addClass('bb-popup-visible');

			popups.each(function(index, elem) {
				var $elem = $(elem);

				$elem.addClass('is-visible');
			});
		});

		$(document).on('click', '.bb-js-cancel, .bb-js-close', function(event) {
			event.preventDefault();

			var $container = $('.bb-booking-module--inline');

			if ($('body').is('.bb-popup-visible')) {
				$container = $('.bb-popup');
			}

			var popups = $('.bb-js-popup');
			var tabs = $container.find('.bb-tab');
			var navs = $container.find('.bb-tabs__nav li');
			var $this = $(this);

			$('body').removeClass('bb-popup-visible');

			popups.each(function(index, elem) {
				var $elem = $(elem);

				$elem.removeClass('is-visible');
			});

			setTimeout(function() {
				tabs.each(function(index, elem) {
					var $elem = $(elem);

					if (index === 0) {
						$elem.addClass('bb-active');
					} else {
						$elem.removeClass('bb-active');
						$elem.find('.bb-tab__body').html('');
					}
				});

				navs.each(function(index, elem) {
					var $elem = $(elem);

					if (index === 0) {
						$elem.addClass('bb-active');
					} else {
						$elem.removeClass('bb-active');
					}
				});
			}, 300);

			if ($this.data('redirect') === true && $this.data('redirect-url').length) {
				setTimeout(function() {
					window.location.href = $this.data('redirect-url');
				}, 400);
			}
		});
	}

	function bbPrint() {
		$(document).on('click', '.js-print', function(event) {
			event.preventDefault();

			var $container = $('.bb-booking-module--inline');

			if ($('body').is('.bb-popup-visible')) {
				$container = $('.bb-popup');
			}

			var style = '<style type="text/css" media="all">.bb-table{padding:20px 0;border:1px solid #eaeaea;overflow:hidden;border-radius:8px}.bb-table table{width:100%;}.bb-table table tr:nth-child(odd){background:#f7f7f7;-webkit-print-color-adjust:exact}.bb-table table td{width:60%;height:32px;padding:0 16px;font-size:13px;font-family:museo-sans,sans-serif;color:#525252;font-weight:400}.bb-table table td:first-child{text-align:left;width:40%;font-weight:700}.bb-table table td:last-child{text-align:right}.bb-table table a{text-decoration:underline;color:inherit}.bb-table table a:hover{text-decoration:none}</style>';

			var $prtContent = $container.find('.bb-section-confirmation .bb-section__body');
			var WinPrint = window.open('', '', 'left=0,top=0,width=800,height=900,toolbar=0,scrollbars=0,status=0');
			WinPrint.document.write(style);
			WinPrint.document.write($prtContent.html());
			WinPrint.document.close();
			WinPrint.focus();
			WinPrint.print();
			WinPrint.close();
		});
	}

	function bbAjaxCategoryServices() {
		$(document).on('change', '.js-ajax-services', function(event) {
			var $this = $(this);
			var $select = $this.closest('.bb-list-inputs').find('#bb-form-service');
			var value = $this.find('option:selected').val();
			var $ajaxContainer = $this.closest('.bb-list-inputs');

			$.ajax({
				url: bb_options.ajax_url,
				method: 'POST',
				data: {
					action: 'bb_ajax_return_category_services',
					cat_id: value
				},
				dataType: 'json',
				success: function(result) {
					$select.html(result.content);
				},
				error: function() {
					$ajaxContainer.html('<h3>Error has occurred please reload the page and try again!</h3>')
				}
			});
		});
	}

	function bbValidateStep1() {
		var $container = $('.bb-booking-module--inline');

		if ($('body').is('.bb-popup-visible')) {
			$container = $('.bb-popup');
		}

		var $staffMember = $container.find('.bb-section-service #bb-form-staff-member option:selected');

		if ( $staffMember.length && ! $staffMember.val().length ) {
			$container.find('.bb-section-service').append('<p class="bb-validation-error">Please select a staff member for your booking in order to continue.</p>');

			return false;
		}

		if (! $container.find('.bb-calendar + .flatpickr-calendar').find('.flatpickr-day.selected').length) {
			if ($container.find('.bb-section-service').find('.bb-validation-error').length) {
				$container.find('.bb-section-service').find('.bb-validation-error').remove();
			}

			$container.find('.bb-section-service').append('<p class="bb-validation-error">Please select a date on calendar for your booking in order to continue.</p>');

			return false;
		} else {
			$container.find('.bb-section-service').find('.bb-validation-error').remove();

			return true;
		}
	}

	function bbValidateStep2() {
		var $container = $('.bb-booking-module--inline');

		if ($('body').is('.bb-popup-visible')) {
			$container = $('.bb-popup');
		}

		var $input = $container.find('input[name="bb-field-date-time-selected"]');

		if (! $input.val()) {
			if ($container.find('.bb-section-time').find('.bb-validation-error').length) {
				$container.find('.bb-section-time').find('.bb-validation-error').remove();
			}

			$container.find('.bb-section-time').append('<p class="bb-validation-error">Please select a valid time slot for your appointment.</p>');

			return false;
		} else {
			$container.find('.bb-section-time').find('.bb-validation-error').remove();

			return true;
		}
	}

	function bbValidateStep3() {
		return true;
	}

	function bbTransitionToStep2() {
		var $container = $('.bb-booking-module--inline');

		if ($('body').is('.bb-popup-visible')) {
			$container = $('.bb-popup');
		}

		var index = $container.find('.bb-tabs li.bb-active').data('index');
		var $ajaxContainer = $container.find('.bb-tab:nth-child(' + ( index + 1 ) + ')');
		var dates = $container.find('#bb-calendar-dates-field').val();
		var category = $container.find('#bb-form-service-category option:selected').val();
		var service = $container.find('#bb-form-service option:selected').val();
		var staffMember = $container.find('#bb-form-staff-member option:selected').val();
		var appointmentMethod = $container.find('#bb-form-method option:selected').val();

		$ajaxContainer.addClass('bb-active').siblings().removeClass('bb-active');

		$.ajax({
			url: bb_options.ajax_url,
			method: 'POST',
			dataType: 'json',
			data: {
				action: 'bb_ajax_step_two',
				dates: dates,
				cat_id: category,
				service_id: service,
				staff_member: staffMember,
				appointment_method: appointmentMethod,
			},
			beforeSend: function() {
				$ajaxContainer.find('.bb-tab__body').html('<i class="bb-ico-loading"></i>');
			},
			success: function(result) {
				if (result.status) {
					$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + ( index + 1 ) + ')').prev().addClass('bb-done-step');
					$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + ( index + 1 ) + ')').nextAll().removeClass('bb-done-step');
					$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + ( index + 1 ) + ')').addClass('bb-active').siblings().removeClass('bb-active');

					if (typeof currentTranslate !== 'undefined') {
						currentTranslate = 0;
					}

					$ajaxContainer.find('.bb-tab__body').html(result.content);

					var $slider = $ajaxContainer.find('.bb-slider-default');

					bbGetPrevNextSlide($slider.find('.bb-slider__slides'), $slider.find('.bb-slider__slide:first-child').data('date'), $slider.find('.bb-slider__slide:last-child').data('date'));
				} else {
					$ajaxContainer.removeClass('bb-active').prev().addClass('bb-active');

					var $fields = $container.find('.bb-section-service [data-validate="true"]');

					bbValidateFields($fields, result.field_validation);
				}
			},
		});
	}

	function bbValidateFields($fields, field_validation) {
		if (! $fields.length || ! field_validation) {
			return;
		}

		$fields.each(function(fieldIndex, elem) {
			var $elem = $(elem);
			var $bbField = $elem.closest('.bb-field');
			var key = $elem.data('type');

			$elem.parent().removeClass('validation-error');
			$elem.closest('.bb-field').find('.bb-validation-error').remove();

			Object.keys(field_validation).forEach(function(objElem, objIndex) {
				if (objElem !== key) {
					return;
				}

				var values = Object.values(field_validation)[objIndex];
				var errorMessage = ''

				if (values.required.validation === false) {
					errorMessage = values.required.error_message;
				} else if (values.format.validation === false) {
					errorMessage = values.format.error_message;
				} else {
					return;
				}

				$bbField.addClass('validation-error');

				$bbField.append('<p class="bb-validation-error">' + errorMessage + '</p>');
			});
		});
	}

	function bbTransitionToStep3() {
		var $container = $('.bb-booking-module--inline');

		if ($('body').is('.bb-popup-visible')) {
			$container = $('.bb-popup');
		}

		var index = $container.find('.bb-tabs li.bb-active').data('index');
		var $ajaxContainer = $container.find('.bb-tab:nth-child(' + ( index + 1 ) + ')');
		var dates = $container.find('#bb-calendar-dates-field').val();
		var category = $container.find('#bb-form-service-category option:selected').val();
		var service = $container.find('#bb-form-service option:selected').val();
		var date = $container.find('#bb-field-date-selected').val() ? $container.find('#bb-field-date-selected').val() : $container.find('#bb-calendar-dates-field').val();
		var slot = $container.find('#bb-field-date-time-selected').val();
		var staffMember = $container.find('#bb-form-staff-member option:selected').val();

		$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + ( index + 1 ) + ')').addClass('bb-active').siblings().removeClass('bb-active');

		$ajaxContainer.addClass('bb-active').siblings().removeClass('bb-active');

		$.ajax({
			url: bb_options.ajax_url,
			method: 'POST',
			data: {
				action: 'bb_ajax_step_three',
				dates: dates,
				cat_id: category,
				service_id: service,
				date: date,
				slot: slot,
				staff_member: staffMember,
			},
			dataType: 'json',
			beforeSend: function(result) {
				$ajaxContainer.find('.bb-tab__body').html('<i class="bb-ico-loading"></i>');
			},
			success: function(result) {
				$ajaxContainer.find('.bb-tab__body').html(result.content);
			}
		});
	}

	function bbTransitionToStep4() {
		var $container = $('.bb-booking-module--inline');

		if ($('body').is('.bb-popup-visible')) {
			$container = $('.bb-popup');
		}

		var index = $container.find('.bb-tabs li.bb-active').data('index');
		var $ajaxContainer = $container.find('.bb-tab:nth-child(' + ( index + 1 ) + ')');
		var dates = $container.find('#bb-calendar-dates-field').val();
		var category = $container.find('#bb-form-service-category option:selected').val();
		var service = $container.find('#bb-form-service option:selected').val();
		var date = $container.find('#bb-field-date-selected').val() ? $container.find('#bb-field-date-selected').val() : $container.find('#bb-calendar-dates-field').val();
		var method = $container.find('#bb-form-method').val();
		var payment_method = $container.find('#payment_method').val();
		var slot = $container.find('#bb-field-date-time-selected').val();
		var name = $container.find('#bb-form-payment-name').val();
		var email = $container.find('#bb-form-payment-email').val();
		var phone = $container.find('#bb-form-payment-phone').val();
		var address = $container.find('#bb-form-payment-address').val();
		var agreement = $container.find('#bb-form-payment-agreement-checkbox').length ? $container.find('#bb-form-payment-agreement-checkbox')[0].checked : 'false';
		var staffMember = $container.find('#bb-form-staff-member option:selected').val();

		if (agreement === false) {
			agreement = 0;
		}

		if (payment_method === 'stripe') {
			var token = $container.find('.bb-booking-module--inline #stripeToken').val();
			var payment_name = $container.find('.bb-booking-module--inline #payment_name').val();
			
			var resultContainer = document.querySelector('.bb-booking-module--inline #paymentResponse');

			if ($('body').is('.bb-popup-visible')) {
				resultContainer = document.querySelector('.bb-popup #paymentResponse');
			}

			stripe.createToken(cardElement).then(function(result) {
				if (result.error) {
					return;
				} else {
					$ajaxContainer.addClass('bb-active').siblings().removeClass('bb-active');
					$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + ( index + 1 ) + ')').addClass('bb-active').siblings().removeClass('bb-active');

					// Send the token to your server
					token = result.token.id;

					$.ajax({
						url: bb_options.ajax_url,
						method: 'POST',
						data: {
							action: 'bb_ajax_step_four',
							dates,
							cat_id: category,
							service_id: service,
							date,
							method,
							slot,
							name,
							email,
							phone,
							address,
							agreement,
							payment_method,
							token,
							payment_name,
							staff_member: staffMember,
						},
						dataType: 'json',
						beforeSend: function() {
							$ajaxContainer.find('.bb-tab__body').html('<i class="bb-ico-loading"></i>');
						},
						success: function(result) {
							if (result.status == 'error') {
								if ($container.find('.bb-section-payment').find('.bb-validation-error').length) {
									$container.find('.bb-section-payment').find('.bb-validation-error').remove();
								}

								$container.find('.bb-tab:nth-child(' + index + ')').addClass('bb-active').siblings().removeClass('bb-active');
								$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + index + ')').addClass('bb-active').siblings().removeClass('bb-active');

								var $fields = $container.find('.bb-section-payment [data-validate="true"]');

								$fields.each(function(fieldIndex, elem) {
									var $elem = $(elem);
									var $bbField = $elem.closest('.bb-field');
									var key = $elem.data('type');

									$elem.parent().removeClass('validation-error');
									$elem.closest('.bb-field').find('.bb-validation-error').remove();

									Object.keys(result.field_validation).forEach(function(objElem, objIndex) {
										if (objElem !== key) {
											return;
										}

										var values = Object.values(result.field_validation)[objIndex];
										var errorMessage = ''

										if (values.required.validation === false) {
											errorMessage = values.required.error_message;
										} else if (values.format.validation === false) {
											errorMessage = values.format.error_message;
										} else {
											return;
										}

										$bbField.addClass('validation-error');

										$bbField.append('<p class="bb-validation-error">' + errorMessage + '</p>');
									});
								});
							} else {
								$ajaxContainer.find('.bb-tab__body').html($(result.content));
							}
						},
					});

					return;
				}
			});
		} else {
			$ajaxContainer.addClass('bb-active').siblings().removeClass('bb-active');
			$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + ( index + 1 ) + ')').addClass('bb-active').siblings().removeClass('bb-active');

			$.ajax({
				url: bb_options.ajax_url,
				method: 'POST',
				data: {
					action: 'bb_ajax_step_four',
					dates: dates,
					cat_id: category,
					service_id: service,
					date: date,
					method: method,
					slot: slot,
					name: name,
					email: email,
					phone: phone,
					address: address,
					agreement,
					payment_method,
					staff_member: staffMember,
				},
				dataType: 'json',
				beforeSend: function() {
					$ajaxContainer.find('.bb-tab__body').html('<i class="bb-ico-loading"></i>');
				},
				success: function(result) {
					if (result.status == 'error') {
						if ($container.find('.bb-section-payment').find('.bb-validation-error').length) {
							$container.find('.bb-section-payment').find('.bb-validation-error').remove();
						}

						$container.find('.bb-tab:nth-child(' + index + ')').addClass('bb-active').siblings().removeClass('bb-active');
						$container.find('.bb-tabs .bb-tabs__nav li:nth-child(' + index + ')').addClass('bb-active').siblings().removeClass('bb-active');

						var $fields = $container.find('.bb-section-payment [data-validate="true"]');

						$fields.each(function(fieldIndex, elem) {
							var $elem = $(elem);
							var $bbField = $elem.closest('.bb-field');
							var key = $elem.data('type');

							$elem.parent().removeClass('validation-error');
							$elem.closest('.bb-field').find('.bb-validation-error').remove();

							Object.keys(result.field_validation).forEach(function(objElem, objIndex) {
								if (objElem !== key) {
									return;
								}


								var values = Object.values(result.field_validation)[objIndex];
								var errorMessage = ''

								if (values.required.validation === false) {
									errorMessage = values.required.error_message;
								} else if (values.format.validation === false) {
									errorMessage = values.format.error_message;
								} else {
									return;
								}

								$bbField.addClass('validation-error');

								$bbField.append('<p class="bb-validation-error">' + errorMessage + '</p>');
							});
						});
					} else {
						$ajaxContainer.find('.bb-tab__body').html($(result.content));
					}
				},
			});
		}
	}

	function bbAjaxStepTransition() {
		$(document).on('click', '.bb-js-next', function(event) {
			event.preventDefault();
			var step = $(this).data('count');

			if (step.toString(10) === '1') {
				bbTransitionToStep2();
			}

			if (step.toString(10) === '2') {
				if (! bbValidateStep2()) {
					return;
				}

				bbTransitionToStep3();
			}

			if (step.toString(10) === '3') {
				if (! bbValidateStep3()) {
					return;
				}

				bbTransitionToStep4();
			}
		});
	}

	function bbSelectTimeOfDay() {
		$(document).on('click', '.js-select-time-of-day a', function(event) {
			event.preventDefault();

			var $parent = $(this).parent();
			var value = $parent.data('time');

			if ($parent.is('.bb-is-selected')) {
				$parent.removeClass('bb-is-selected').closest('.bb-section-time').find('#bb-field-date-time-selected').val('');
			} else {
				$parent.addClass('bb-is-selected').closest('.bb-section-time').find('#bb-field-date-time-selected').val(value);

				$parent.siblings().removeClass('bb-is-selected');
			}
		});
	}

	function bbStepBackToPrev() {
		$(document).on('click', '.bb-js-prev', function(event) {
			event.preventDefault();

			var $this = $(this);

			$this.closest('.bb-tab.bb-active').removeClass('bb-active').prev().addClass('bb-active');

			$this.closest('.bb-tabs').find('.bb-tabs__nav li.bb-active').removeClass('bb-active').prev().addClass('bb-active');
		});
	}

	function bbLoadPaymentMethod() {
		$(document).on('change', '#payment_method', function() {
			let method = $(this).find(":selected").val();

			if (method === 'stripe') {
				$.ajax({
					url: bb_options.ajax_url,
					method: 'POST',
					data: {
						action: 'bb_ajax_get_payment_method',
						method,
					},
					dataType: 'json',
					success: function(result) {
						$('.bb-section__aside--payment').html(result.content);

						bbLoadStripe();
					}
				});
			}
		});
	}

	function bbLoadStripe() {
		stripe = Stripe(bb_options.pk_key);

		// Create an instance of elements
		var elements = stripe.elements();

		var style = {
			base: {
				fontWeight: 400,
				fontFamily: 'museo-sans, sans-serif',
				fontSize: '13px',
				color: '#777',
				backgroundColor: '#fff',
				'::placeholder': {
					color: '#888',
				},
			},
			invalid: {
				color: '#eb1c26',
			}
		};

		cardElement = elements.create('cardNumber', {
			style: style
		});
		cardElement.mount('#payment_card_number');

		var exp = elements.create('cardExpiry', {
			style: style
		});
		exp.mount('#payment_card_expiry');

		var cvc = elements.create('cardCvc', {
			style: style
		});
		cvc.mount('#payment_card_cvc');

		// Validate input of the card elements
		var resultContainer = document.getElementById('paymentResponse');
		cardElement.addEventListener('change', function(event) {
			if (event.error) {
				resultContainer.innerHTML = '<p>'+event.error.message+'</p>';
			} else {
				resultContainer.innerHTML = '';
			}
		});
	}
})(jQuery, window, document);