;(function($, window, document, undefined) {
	$(document).ready(function() {

		var $containers = $('.bb-booking-module--inline, .bb-popup');

		$containers.each(function(index, elem) {
			var $flatpickrInstance = false;

			bbInitFlatpickr($flatpickrInstance);

			$(elem).find('#bb-form-staff-member').on('change', function() {
				var staffMember = $(this).find('option:selected').val();

				bbInitFlatpickr($flatpickrInstance, staffMember);
			});
		});

		bbToggleCalendarTooltip();
	});

	function bbInitFlatpickr($flatpickrInstance, staffMember = null) {
		var availableDaysOfWeek = [];

		var $container = $('.bb-booking-module--inline');

		if (! $container.length) {
			$container = $('.bb-popup');
		}

		$.ajax({
			url: bb_options.ajax_url,
			method: 'POST',
			dataType: 'json',
			data: {
				action: 'bb_ajax_get_available_days',
				staff_member: staffMember ? staffMember : '0'
			},
			beforeSend: function() {
				$container.find('.bb-section-service .bb-section__calendar').addClass('bb-loading');
			},
			success: function(response) {
				if (response === 'error') {
					alert('Something went wrong. Please reload the page and try again.');

					return;
				}

				if (response.available_days.length) {
					availableDaysOfWeek = response.available_days;
				}

				$container.find('.bb-section-service .bb-section__calendar').removeClass('bb-loading')
			}
		}).then(function() {
			if ($flatpickrInstance) {
				$flatpickrInstance.destroy();
			}

			var options = {
				inline: true,
				dateFormat: 'Y-m-d',
				defaultDate: 'today',
				minDate: 'today',
				onDayCreate: function(dObj, dStr, fp, dayElem) {
					var ariaLabel = $(dayElem).attr('aria-label');

					var interval = window.setInterval(function() {
						var $dayElement = $('[aria-label="' + ariaLabel + '"]');

						if ($dayElement.length) {
							if ($dayElement.prevAll().filter('.today').length) {
								$dayElement.addClass('futureDay');
							}

							clearInterval(interval);
						}
					}, 1);
				},
				disable: [
					function(date) {
						return availableDaysOfWeek.indexOf(date.getDay()) === -1;
					},
				],
				onChange: function(selectedDates, dateStr, instance) {
					const $filterContainer = $(instance.calendarContainer).closest('.bb-section__calendar');
					const $input = $container.find('#bb-calendar-dates-field');
					const dates = dateStr;

					$filterContainer
						.find($input)
							.val(dates);
				}
			}

			if (bb_options.locale !== 'en') {
				options.locale = bb_options.locale;
			}

			$flatpickrInstance = flatpickr('#bb-calendar', options);
		});
	}

	function bbToggleCalendarTooltip() {
		$(document).on('mouseenter', '.flatpickr-day.flatpickr-disabled:not(.prevMonthDay):not(.pastDay)', function() {
			var $this = $(this);
			var tooltipText = $this.closest('.bb-section__calendar').find('#bb-calendar').data('disabled-string');

			if (! $this.find('.bb-calendar-toolbox').length) {
				$this.append('<div class="bb-calendar-toolbox"><p></p></div>');
			}

			$this.find('.bb-calendar-toolbox p').text(tooltipText);
			$this.addClass('show-tooltip');
		});

		$(document).on('mouseleave', '.flatpickr-day.flatpickr-disabled:not(.prevMonthDay):not(.pastDay)', function() {
			var $this = $(this);

			$this.removeClass('show-tooltip');
		});
	}
})(jQuery, window, document);