;(function($, window, document, undefined) {
	$(document).on('ready', function() {
		$(document).on('click', '.js-service-select', function(event) {
			event.preventDefault();

			if ($(event.target).is('a')) {
				return;
			}

			var $this = $(this);

			$this.toggleClass('is-selected');

			if ($this.is('.is-selected')) {
				$this.attr('data-selected', true);
			} else {
				$this.attr('data-selected', false);
			}
			
			if ($this.is('.js-service-select-bulk')) {
				var $services = $this.closest('.js-services-checkbox').find('.services__body .js-service-select');
				if ($this.is('.is-selected')) {
					$services.addClass('is-selected');
					$services.attr('data-selected', true);
				} else {
					$services.removeClass('is-selected');
					$services.attr('data-selected', false);
				}
			}
		});
	});

	$('.js-bulk-delete-services').on('click', function(event) {
		event.preventDefault();

		$(this).closest('.bb-section-services').find('.bb-services').addClass('is-confirming');
	});

	$('.js-confirm-bulk-delete').on('click', function() {
		event.preventDefault();
		var $this = $(this);
		var $markedServices = $('.bb-services .services__body .js-service-select[data-selected="true"]');
		var servicesIds = [];
		var pagenum = $('.bb-services .services__body').attr('data-page');

		$markedServices.each(function(index, elem) {
			servicesIds.push($(elem).attr('data-id'));
		});

		var $ajaxContainer = $('.bb-services');

		$.ajax({
			url: bb_site_ajax.ajaxurl,
			method: 'POST',
			data: {
				action: 'bb_bulk_delete_services',
				ids: servicesIds,
				pagenum: pagenum,
			},
			beforeSend: function() {
				$this.closest('.bb-services').removeClass('is-confirming');
				$ajaxContainer.addClass('is-loading');
				$ajaxContainer.find('.services__body').append('<i class="bb-ico-loading"></i>');
			},
			success: function(data) {
				$ajaxContainer.removeClass('is-loading');
				$ajaxContainer.find('.bb-ico-loading').remove();

				for (var property in data.deleted_posts) {
					$ajaxContainer.find('.bb-service[data-id="' + property.toString() + '"]').remove();
				}

				updateServicesOrderClientSide();
			}
		});
	});

	$('.js-cancel-bulk-delete').on('click', function(event) {
		event.preventDefault();

		$(this).closest('.bb-services').removeClass('is-confirming');
	});

	function updateServicesOrderClientSide() {
		var $input = $('[name="services_in_order"]');
		var $services = $('.bb-services .services__body > ul > li > .bb-service');
		var pagenum = $('.bb-services .services__body').attr('data-page');
		var idsInOrder = [];

		$services.each(function(index, elem) {
			idsInOrder.push($(elem).attr('data-id'));
		});

		var newOrder = idsInOrder.join('|');

		if (! $services.length) {
			newOrder = '';
		}

		if ($input.val() === newOrder) {
			return;
		}

		$input.val(newOrder);

		updateServicesOrderServerSide(newOrder, pagenum);
	}

	function updateServicesOrderServerSide(servicesOrder, pagenum) {
		var $ajaxContainer = $('.bb-services .services__body');

		$.ajax({
			url: bb_site_ajax.ajaxurl,
			method: 'POST',
			data: {
				action: 'bb_ajax_set_services_order',
				order: servicesOrder,
				pagenum: pagenum,
			},
			beforeSend: function() {
				$ajaxContainer.addClass('is-loading');
				$ajaxContainer.append('<i class="bb-ico-loading"></i>');
			},
			success: function(data) {
				$ajaxContainer.removeClass('is-loading');
				$ajaxContainer.find('.bb-ico-loading').remove();
			}
		});
	}
})(jQuery, window, document);