;(function($, window, document, undefined) {
	var $doc = $(document);

	$doc.on('ready', function() {
		$doc.on('click', 'a.js-edit', function(e){
			e.preventDefault();

			let $this = $(this);

			$('.bb-popup-service').show();

			var $ajaxContainer = $('.bb-popup-service #TB_ajaxContent' );

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'GET',
				data: {
					action: 'bb_modify_service',
					id: $this.data('service'),
					cat: $this.data('cat'),
					paged: $this.data('paged')
				},
				beforeSend() {
					$ajaxContainer.addClass('ajax-loading');
				},
				success: function( response ) {
					$ajaxContainer.removeClass('ajax-loading');
					if( response === 'error' ) {
						$ajaxContainer.html( 'No results' );
					} else {
						$ajaxContainer.html( $(response).html() );
					}
				},
				error() {
					$ajaxContainer.html('<h3>Error has occurred please try again!</h3>');
					$ajaxContainer.removeClass('ajax-loading');
				},
				always() {
					$ajaxContainer.removeClass('ajax-loading');
				}
			});
		});
	
		$doc.on('submit', 'form.js-form-edit-service', function(event) {
			event.preventDefault();

			var $form = $(this);

			var $ajaxContainer = $('.bb-services .services__body');

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'POST',
				data: $form.serialize(),
				beforeSend: function() {
					$('.bb-popup-service').hide();
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="bb-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.bb-ico-loading').remove();

					if (data.status === 'success') {
						var id = data.new_service.ID.toString();
						var title = data.new_service.post_title.toString();
						var $service = $('.bb-service[data-id="' + id + '"]');

						$service.find('.service__content p a').text(title + ' ' + data.new_price);
						$service.find('.service__body p').text(data.new_term_name);
					}
				}
			});
		});
	});
})(jQuery, window, document);