;(function($, window, document, undefined) {
	var $doc = $(document);

	$doc.on('ready', function() {
		$doc.on('click', '.js-delete-service', function(event) {
			event.preventDefault();

			var $this = $(this);
			var id = $this.closest('.bb-service').attr('data-id');

			var $ajaxContainer = $('.bb-services .services__body');

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'bb_delete_service',
					id: id,
				},
				beforeSend: function() {
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="bb-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.bb-ico-loading').remove();

					for (var property in data.deleted_posts) {
						$ajaxContainer.find('.bb-service[data-id="' + property.toString() + '"]').parent().remove();
					}

					updateServicesOrderClientSide();
				}
			});
		});

		function updateServicesOrderClientSide() {
			var $input = $('[name="services_in_order"]');
			var $services = $('.bb-services .services__body > ul > li > .bb-service');
			var pagenum = $('.bb-services .services__body').attr('data-page');
			var idsInOrder = [];

			$services.each(function(index, elem) {
				idsInOrder.push($(elem).attr('data-id'));
			});

			var newOrder = idsInOrder.join('|');

			if (! $services.length) {
				newOrder = '';
			}

			if ($input.val() === newOrder) {
				return;
			}

			$input.val(newOrder);

			updateServicesOrderServerSide(newOrder);
		}

		function updateServicesOrderServerSide(servicesOrder) {
			var $ajaxContainer = $('.bb-services .services__body');

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'bb_ajax_set_services_order',
					order: servicesOrder,
				},
				beforeSend: function() {
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="bb-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.bb-ico-loading').remove();
				}
			});
		}
	});
})(jQuery, window, document);