;(function($, window, document, undefined) {
	$(document).on('click', '.js-drag-and-drop-category', function(event){
		event.preventDefault();
	});

	$(document).on('click', '.js-delete-category', function(event){
		event.preventDefault();

		var $link = $(this).parent();
		var action = $link.attr('data-action');
		var $ajaxContainer = $('.bb-categories');

		$.ajax({
			url: bb_site_ajax.ajaxurl,
			method: 'POST',
			data: {
				action: 'bb_delete_service_category',
				cat_id: $link.attr('data-cat-id'),
			},
			beforeSend: function() {
				$ajaxContainer.addClass('is-loading');
				$ajaxContainer.append('<i class="bb-ico-loading"></i>');
			},
			success: function(data) {
				if (data.status === true) {
					$link.parent().remove();
					updateCategoryOrderClientSide();
				} else {
					alert('Something went wrong. Please reload the page and try again.');
				}

				$ajaxContainer.removeClass('is-loading');
				$ajaxContainer.find('.bb-ico-loading').remove();
			}
		});
	});

	function updateCategoryOrderClientSide() {
		var $input = $('[name="service_categories_in_order"]');
		var $categories = $('.bb-categories > form > ul > li > a');
		var idsInOrder = [];

		$categories.each(function(index, elem) {
			idsInOrder.push($(elem).attr('data-cat-id'));
		});

		var newOrder = idsInOrder.join('|');

		if (! $categories.length) {
			newOrder = '';
		}

		if ($input.val() === newOrder) {
			return;
		}

		$input.val(newOrder);

		updateCategoryOrderServerSide(newOrder);
	}

	function updateCategoryOrderServerSide(categoryOrder) {
		var $ajaxContainer = $('.bb-categories');

		$.ajax({
			url: bb_site_ajax.ajaxurl,
			method: 'POST',
			data: {
				action: 'bb_ajax_set_category_order',
				order: categoryOrder,
			},
			beforeSend: function() {
				$ajaxContainer.addClass('is-loading');
				$ajaxContainer.append('<i class="bb-ico-loading"></i>');
			},
			success: function(data) {
				$ajaxContainer.removeClass('is-loading');
				$ajaxContainer.find('.bb-ico-loading').remove();
			}
		});
	}
})(jQuery, window, document);