;(function($, window, document, undefined) {
	$(document).on('ready', function() {
		var $categoryItems = $('.bb-categories li');

		$(window).on('load', function() {
			if (! $categoryItems.length) {
				return;
			}

			updateCategoryOrderClientSide();
		});

		$('#sortable').sortable({
			update: function( event, ui ) {
				updateCategoryOrderClientSide();
			}
		});

		function updateCategoryOrderClientSide() {
			var $input = $('[name="service_categories_in_order"]');
			var $categories = $('.bb-categories > form > ul > li > a');
			var idsInOrder = [];

			$categories.each(function(index, elem) {
				idsInOrder.push($(elem).attr('data-cat-id'));
			});

			var newOrder = idsInOrder.join('|');

			if (! $categories.length) {
				newOrder = '';
			}

			if ($input.val() === newOrder) {
				return;
			}

			$input.val(newOrder);

			updateCategoryOrderServerSide(newOrder);
		}

		function updateCategoryOrderServerSide(categoryOrder) {
			var $ajaxContainer = $('.bb-categories');

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'bb_ajax_set_category_order',
					order: categoryOrder,
				},
				beforeSend: function() {
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="bb-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.bb-ico-loading').remove();
				}
			});
		}
	});
})(jQuery, window, document);