;(function($, window, document, undefined) {
	var $doc = $(document);

	$doc.on('ready', function() {
		$doc.on('click', 'a.js-add-service', function(e){
			e.preventDefault();

			let $this = $(this);

			$('.bb-popup-service').show();

			var $ajaxContainer = $('.bb-popup-service #TB_ajaxContent' );

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'GET',
				data: {
					action: 'bb_add_service',
				},
				beforeSend() {
					$ajaxContainer.addClass('ajax-loading');
				},
				success: function( response ) {
					$ajaxContainer.removeClass('ajax-loading');
					if( response === 'error' ) {
						$ajaxContainer.html( 'No results' );
					} else {
						$ajaxContainer.html( $(response).html() );
					}
				},
				error() {
					$ajaxContainer.html('<h3>Error has occurred please try again!</h3>');
					$ajaxContainer.removeClass('ajax-loading');
				},
				always() {
					$ajaxContainer.removeClass('ajax-loading');
				}
			});
		});
	
		$doc.on('submit', 'form.js-form-add-service', function(event) {
			event.preventDefault();

			var $form = $(this);
			var title = $form.find('#service_title').val();
			var term = $form.find('#service_category option:selected').val();
			var price = $form.find('#service_price').val();
			var zoom = $form.find('#generate_zoom_meeting')[0].checked;
			var reminder = $form.find('#generate_google_calendar_reminder')[0].checked;

			var $ajaxContainer = $('.bb-services .services__body')

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'bb_add_service_post',
					service_title: title,
					service_category: term,
					service_price: price,
					generate_zoom: zoom ? zoom : 0,
					generate_reminder: reminder ? reminder : 0,
				},
				beforeSend: function() {
					$('.bb-popup-service').hide();
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="bb-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.bb-ico-loading').remove();

					if (data.status === 'success') {
						$ajaxContainer.find('> p').remove();
						$ajaxContainer.find('#sortable-services').prepend(data.new_service);

						updateServicesOrderClientSide();
					}
				}
			});
		});

		function updateServicesOrderClientSide() {
			var $input = $('[name="services_in_order"]');
			var $services = $('.bb-services .services__body > ul > li > .bb-service');
			var pagenum = $('.bb-services .services__body').attr('data-page');
			var idsInOrder = [];

			$services.each(function(index, elem) {
				idsInOrder.push($(elem).attr('data-id'));
			});

			var newOrder = idsInOrder.join('|');

			if (! $services.length) {
				newOrder = '';
			}

			if ($input.val() === newOrder) {
				return;
			}

			$input.val(newOrder);

			updateServicesOrderServerSide(newOrder);
		}

		function updateServicesOrderServerSide(servicesOrder) {
			var $ajaxContainer = $('.bb-services .services__body');

			$.ajax({
				url: bb_site_ajax.ajaxurl,
				method: 'POST',
				data: {
					action: 'bb_ajax_set_services_order',
					order: servicesOrder,
				},
				beforeSend: function() {
					$ajaxContainer.addClass('is-loading');
					$ajaxContainer.append('<i class="bb-ico-loading"></i>');
				},
				success: function(data) {
					$ajaxContainer.removeClass('is-loading');
					$ajaxContainer.find('.bb-ico-loading').remove();
				}
			});
		}
	});
})(jQuery, window, document);