;(function($, window, document, undefined) {
	$(document).on('submit', '.bb-categories form', function(event){
		event.preventDefault();

		var $this = $(this);

		var $input = $this.find('#new_service_cat_name');
		$input.removeClass('error');

		if (! $input.val().length) {
			$input.addClass('error');

			return;
		}

		var $ajaxContainer = $('.bb-categories');

		$.ajax({
			url: bb_site_ajax.ajaxurl,
			method: 'POST',
			data: {
				action: 'bb_add_service_category',
				new_service_cat_name: $input.val(),
			},
			beforeSend: function() {
				$ajaxContainer.addClass('is-loading');
				$ajaxContainer.append('<i class="bb-ico-loading"></i>');
			},
			success: function(data) {
				$ajaxContainer.removeClass('is-loading');
				$ajaxContainer.find('.bb-ico-loading').remove();

				if (data.status === 'fail') {
					alert('Something went wrong. Please reload the page and try again.');

					return;
				}

				$input.val('');

				$this.find('> ul').prepend(data.new_category);
				
				updateCategoryOrderClientSide();
			}
		});
	});

	function updateCategoryOrderClientSide() {
		var $input = $('[name="service_categories_in_order"]');
		var $categories = $('.bb-categories > form > ul > li > a');
		var idsInOrder = [];

		$categories.each(function(index, elem) {
			idsInOrder.push($(elem).attr('data-cat-id'));
		});

		var newOrder = idsInOrder.join('|');

		if (! $categories.length) {
			newOrder = '';
		}

		if ($input.val() === newOrder) {
			return;
		}

		$input.val(idsInOrder.join('|'));

		updateCategoryOrderServerSide(newOrder);
	}

	function updateCategoryOrderServerSide(categoryOrder) {
		var $ajaxContainer = $('.bb-categories');

		$.ajax({
			url: bb_site_ajax.ajaxurl,
			method: 'POST',
			data: {
				action: 'bb_ajax_set_category_order',
				order: categoryOrder,
			},
			beforeSend: function() {
				$ajaxContainer.addClass('is-loading');
				$ajaxContainer.append('<i class="bb-ico-loading"></i>');
			},
			success: function(data) {
				$ajaxContainer.removeClass('is-loading');
				$ajaxContainer.find('.bb-ico-loading').remove();
			}
		});
	}
})(jQuery, window, document);