;(function($, window, document, undefined) {
	$(document).ready(function($){
		function bbSwitchTopLevelMenuLinkURL($item, $switch) {
			const newUrl = $switch.attr('href');

			$item.attr('href', newUrl);
		}

		bbSwitchTopLevelMenuLinkURL($('.toplevel_page_my-brindle'), $('#toplevel_page_my-brindle > .wp-submenu > .wp-first-item + li > a'));

		$('.bb-color-picker-field').wpColorPicker();

		$('.toplevel_page_my-brindle .wp-submenu a').each(function() {
			if ($(this).is('[href*="admin.php?page=brindle-booking"')) {
				if (window.location.href.indexOf('brindle-booking') > -1) {
					$(this).parent().addClass('current')
				}
			}
		});

		if ($('#conf_page_google_reminder').length) {
			let $uploadField = $('#google_calendar_credentials').parent('.form__controls');

			if ($('#conf_page_google_reminder').prop('checked') === true) {
				$uploadField.show();
			} else {
				$uploadField.hide();
			}
		}

		if ($('#enable_online_payments').length) {
			let $fields = $('#stripe_publishable_key').parent('.form__controls');

			if ($('#enable_online_payments').prop('checked') === true) {
				$fields.show();
			} else {
				$fields.hide();
			}
		}
	});

	$(document).on('click', 'a.js-bb-save', function(e){
		e.preventDefault();

		$('form.mb-bb-admin-form').submit();
	});

	$('#single_schedule').on('change', function(){
		$(this).val(this.checked.toString());
		$('.schedule-type').submit();
	});

	$('#include_staff_member').on('change', function(){
		$('[name="include_staff_member_change"]').val('1');
		$('.schedule-type').submit();
	});

	$('.schedule-type select').on('change', function(){
		$('.schedule-type').submit();
	});

	$('#category-filter').on('change', function(){
		$('.services-filter').submit();
	});

	$('[name="schedule_hour_standard"]').on('change', function() {
		$('.schedule-type').submit();
	});

	$(document).on('click', 'a.js-close-popup', function(e){
		e.preventDefault();

		$('.bb-popup-service').hide();
	});

	$(document).on('change', '#conf_page_google_reminder', function(){
		let $uploadField = $('#google_calendar_credentials').parent('.form__controls');

		if ($(this).prop('checked') === true) {
			$uploadField.show();
		} else {
			$uploadField.hide();
		}
	});

	$(document).on('change', '#enable_online_payments', function(){
		let $fields = $('#stripe_publishable_key').parent('.form__controls');

		if ($('#enable_online_payments').prop('checked') === true) {
			$fields.show();
		} else {
			$fields.hide();
		}
	});

	$(document).on('click', '.field-tooltip-icon', function(event) {
		event.preventDefault();

		$(this).next().fadeToggle();
	});

	$(document).on('click', '.field-tooltip', function(event) {
		event.preventDefault();
	});

	$(document).on('click', function(event) {
		var condition = $(event.target).is('.field-tooltip-container') || $(event.target).closest('.field-tooltip-container').length;

		if (condition) {
			return;
		}

		$('.field-tooltip').fadeOut();
	});

	$(document).on('change', '.collected_data', function(){

		let $requiredFiled = $(this).parent('.form__checkbox').next().find('input');

		if ($(this).prop('checked') !== true) {
			$requiredFiled.prop('checked', false);
			$requiredFiled.prop('disabled', true);
		} else {
			$requiredFiled.prop('disabled', false);
		}
	});

	$(document).on('click', '.js-association', function(event) {
		event.preventDefault();

		var $this = $(this).parent();
		var $association = $this.closest('.bb-association')
		var $parent = $this.closest('.association__side');
		var $input = $association.find('[id^="bb_association_data_"]');

		if ($parent.is('.association__side--left')) {
			$this.clone().appendTo($parent.next().find('ul'));

			$this.addClass('disabled');
		} else if ($parent.is('.association__side--right')) {
			var id = $this.find('a').attr('data-post-id');

			$this.remove();

			$parent.prev().find('a[data-post-id="' + id + '"]').parent().removeClass('disabled');
		}

		var $selectedPosts = $association.find('.association__side--right ul li');

		$input.val('');

		if (! $selectedPosts.length) {
			return;
		}

		$selectedPosts.each(function(index, elem) {
			var $elem = $(elem);
			var id = $elem.find('a').attr('data-post-id');

			$input.val($input.val() + id);

			if (index !== $selectedPosts.length - 1) {
				$input.val($input.val() + '|');
			}
		});
	});
})(jQuery, window, document);