<?php
add_action( 'wp_head', 'bb_facebook_opengraph' );
function bb_facebook_opengraph() {
	if ( ! is_singular( 'bb_appointment' ) ) {
		return;
	}
	$site_name = get_bloginfo('name');
	$title     = __( 'New appointment', 'brindle-booking' );
	$desc      = __( "I just booked my appointment with {$site_name}!", 'brindle-booking' );

	?>
	<meta property="og:locale" content="<?php echo esc_attr( get_locale() ); ?>" />
	<meta property="og:type" content="article" />
	<meta property="og:title" content="<?php echo esc_attr( $title ) . ' | ' . esc_attr( $site_name ); ?>" />
	<meta property="og:description" content="<?php echo esc_attr( $desc ); ?>" />
	<meta property="og:url" content="<?php echo home_url( '/' ); ?>" />
	<meta property="og:site_name" content="<?php echo esc_attr( $site_name ); ?>" />
	<?php

}