<?php

add_action( 'wp_ajax_bb_ajax_get_available_days', 'bb_ajax_get_available_days' );
add_action( 'wp_ajax_nopriv_bb_ajax_get_available_days', 'bb_ajax_get_available_days' );

function bb_ajax_get_available_days() {
	$global_schedule = get_site_option( 'bb_single_schedule' );
	$staff_member    = isset( $_POST['staff_member'] ) ? esc_html( $_POST['staff_member'] ) : '';
	$saved_slots     = '';

	$available_days = [];

	$days = [
		'sun' => 0,
		'mon' => 1,
		'tue' => 2,
		'wed' => 3,
		'thu' => 4,
		'fri' => 5,
		'sat' => 6,
	];

	if ( ! empty( $global_schedule ) ) {
		$saved_slots = get_site_option( 'bb_schedule_slots' );
	} else {
		if ( empty( $staff_member ) ) {
			$available_days = [
				0,
				1,
				2,
				3,
				4,
				5,
				6,
			];
		} else {
			$saved_slots = get_user_meta( intval( $staff_member ), 'bb_schedule_slots', true );
		}
	}

	if ( ! empty( $saved_slots ) ) {
		foreach ( $saved_slots as $key => $slot ) {
			$key_array = explode( '_', $key );

			if ( in_array( $days[ $key_array[0] ], $available_days ) ) {
				continue;
			}

			$available_days[] = $days[ $key_array[0] ];
		}
	}


	$return = array( 'available_days' => $available_days );

	wp_send_json( $return );

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_return_category_services', 'bb_ajax_return_category_services' );
add_action( 'wp_ajax_nopriv_bb_ajax_return_category_services', 'bb_ajax_return_category_services' );

function bb_ajax_return_category_services() {
	$cat_id = absint( $_POST['cat_id'] );

	if ( empty( $cat_id ) ) {
		wp_die();
	}

	$query    = bb_get_category_services( $cat_id );
	$services = $query->posts;

	$services_order = mbbb_get_services_full_order();

	$services      = mbbb_order_services( $services, $services_order );

	$markup   = '';

	$currency = get_site_option( 'bb_payment_currency' );

	$supported_currencies = mbbb_get_supported_currencies();

	if ( ! array_key_exists( $currency, $supported_currencies ) ) {
		$currency = 'usd';
	}

	$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

	if ( empty( $services ) ) {
		$markup = '<option value="">' . __( 'There are no Services', 'brindle-booking' ) . '</option>';
	} else {
		foreach ( $services as $service ) {
			if ( ! empty( $price = get_post_meta( $service->ID, 'bb_service_price', true ) ) ) {
				$price = sprintf( '| %s%s', $currency_sign, number_format( $price, 2 ) );
			} else {
				$price = '';
			}

			$markup = $markup . '<option value="' . $service->ID . '">' . $service->post_title  . ' ' . $price . '</option>';
		}
	}

	ob_start();

	$result = $markup;

	ob_end_clean();

	$return = array( 'content' => $result );

	wp_send_json( $return );

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_step_two', 'bb_ajax_step_two' );
add_action( 'wp_ajax_nopriv_bb_ajax_step_two', 'bb_ajax_step_two' );

function bb_ajax_step_two() {
	$date               = ! empty( $_POST['dates'] ) ? esc_html( $_POST['dates'] ) : '';
	$cat_id             = ! empty( $_POST['cat_id'] ) ? esc_html( $_POST['cat_id'] ) : '';
	$service_id         = ! empty( $_POST['service_id'] ) ? esc_html( $_POST['service_id'] ) : '';
	$staff_member       = ! empty( $_POST['staff_member'] ) ? esc_html( intval( $_POST['staff_member'] ) ) : '';
	$appointment_method = ! empty( $_POST['appointment_method'] ) ? esc_html( $_POST['appointment_method'] ) : '';

	$category      = get_term( $cat_id )->name;
	$service_title = get_the_title( $service_id );
	$service_price = get_post_meta( $service_id, 'bb_service_price', true );

	$prev_date      = strtotime( '-1 day', strtotime( $date ) );
	$prev_prev_date = strtotime( '-2 day', strtotime( $date ) );
	$next_date      = strtotime( '+1 day', strtotime( $date ) );
	$next_next_date = strtotime( '+2 day', strtotime( $date ) );

	$days = [
		'mon' => 'Monday',
		'tue' => 'Tuesday',
		'wed' => 'Wednesday',
		'thu' => 'Thursday',
		'fri' => 'Friday',
		'sat' => 'Saturday',
		'sun' => 'Sunday',
	];

	$is_global_schedule = get_site_option( 'bb_single_schedule' );

	if ( empty( $is_global_schedule ) ) {
		$saved_slots = get_user_meta( $staff_member, 'bb_schedule_slots', true );

		$type_option = get_user_meta( $staff_member, 'bb_schedule_type' );
		$type_option = $type_option[0];
	} else {
		$type_option = absint( get_site_option( 'bb_schedule_type' ) );
		$saved_slots = get_site_option( 'bb_schedule_slots' );
	}

	$day_abbr      = array_search( date( 'l', strtotime( $date ) ), $days );
	$prev_day_abbr = array_search( date( 'l', $prev_date ), $days );
	$next_day_abbr = array_search( date( 'l', $next_date ), $days );

	$has_slots_today    = false;
	$has_slots_prev_day = false;
	$has_slots_next_day = false;

	foreach ( $saved_slots as $key => $value ) {
		$keys_array = explode( '_', $key );

		if ( $keys_array[0] === $day_abbr ) {
			$has_slots_today    = true;
		}

		if ( $keys_array[0] === $prev_day_abbr ) {
			$has_slots_prev_day    = true;
		}

		if ( $keys_array[0] === $next_day_abbr ) {
			$has_slots_next_day    = true;
		}
	}

	$disable_double_booking = get_site_option( 'bb_disable_double_booking', false );
	$staff_member_arg = false;

	if ( empty( $is_global_schedule ) ) {
		$staff_member_user = get_user_by( 'id', intval( $staff_member ) );

		$staff_member_arg  = $staff_member_user->display_name;
	}

	$service_arg = $service_id;

	if ( ! empty( $disable_double_booking ) ) {
		$service_arg = false;
	}

	$atts      = bb_get_appointments_atts( $cat_id, $service_arg, date( 'Y-m-d', strtotime( $date ) ), $staff_member_arg );
	$prev_atts = bb_get_appointments_atts( $cat_id, $service_arg, date( 'Y-m-d', $prev_date ), $staff_member_arg );
	$next_atts = bb_get_appointments_atts( $cat_id, $service_arg, date( 'Y-m-d', $next_date ), $staff_member_arg );

	$field_validation = bb_check_requred_fields( [
		'staff-member'       => $staff_member,
		'appointment-method' => $appointment_method,
	] );

	ob_start();

	include( BB_PLUGIN_DIR . 'fragments/steps/step-2.php' );

	$result = ob_get_contents();

	ob_end_clean();

	$return = [
		'status'  => $field_validation['validated'],
		'content' => $result,
		'field_validation' => ! empty( $field_validation['fields'] ) ? $field_validation['fields'] : ''
	];

	wp_send_json($return);

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_get_prev_next_date_slide', 'bb_ajax_get_prev_next_date_slide' );
add_action( 'wp_ajax_nopriv_bb_ajax_get_prev_next_date_slide', 'bb_ajax_get_prev_next_date_slide' );

function bb_ajax_get_prev_next_date_slide() {
	$date_for_prev      = ! empty( $_POST['date_for_prev'] ) ? esc_html( $_POST['date_for_prev'] ) : '';
	$date_for_next      = ! empty( $_POST['date_for_next'] ) ? esc_html( $_POST['date_for_next'] ) : '';
	$cat_id             = ! empty( $_POST['cat_id'] ) ? esc_html( $_POST['cat_id'] ) : '';
	$service_id         = ! empty( $_POST['service_id'] ) ? esc_html( $_POST['service_id'] ) : '';
	$staff_member       = ! empty( $_POST['staff_member'] ) ? esc_html( $_POST['staff_member'] ) : '';
	
	$prev_date          = strtotime( '-1 day', strtotime( $date_for_prev ) );
	$next_date          = strtotime( '+1 day', strtotime( $date_for_next ) );

	ob_start();

	include_once( BB_PLUGIN_DIR . 'fragments/slider/prev-slide.php' );

	$prev_slides = ob_get_contents();

	$return['slides']['prev'] = $prev_slides;

	ob_end_clean();

	ob_start();

	include_once( BB_PLUGIN_DIR . 'fragments/slider/next-slide.php' );

	$next_slides = ob_get_contents();

	$return['slides']['next'] = $next_slides;

	ob_end_clean();

	ob_start();

	include_once( BB_PLUGIN_DIR . 'fragments/time-slots/prev-time-slots.php' );

	$prev_time_slots = ob_get_contents();

	ob_end_clean();

	ob_start();

	include_once( BB_PLUGIN_DIR . 'fragments/time-slots/next-time-slots.php' );

	$next_time_slots = ob_get_contents();

	ob_end_clean();

	$return['time_slots'] = [
		'prev' => $prev_time_slots,
		'next' => $next_time_slots
	];

	wp_send_json($return);

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_step_three', 'bb_ajax_step_three' );
add_action( 'wp_ajax_nopriv_bb_ajax_step_three', 'bb_ajax_step_three' );

function bb_ajax_step_three() {
	$date         = esc_html( $_POST['dates'] );
	$cat_id       = esc_html( $_POST['cat_id'] );
	$service_id   = esc_html( $_POST['service_id'] );
	$date         = esc_html( $_POST['date'] );
	$slot         = esc_html( $_POST['slot'] );
	$staff_member = intval( $_POST['staff_member'] );

	$show_slots = get_site_option( 'bb_include_show_booked_time_slots', true );
	$fields     = bb_get_user_data_fields();

	$category      = get_term( $cat_id )->name;
	$service_title = get_the_title( $service_id );
	$service_price = get_post_meta( $service_id, 'bb_service_price', true );
	$date_string   = wp_date( 'D F jS, Y', strtotime( $date ) );

	$is_global_schedule = get_site_option( 'bb_single_schedule' );
	
	$type_option = absint( get_site_option( 'bb_schedule_type' ) );

	if ( empty( $is_global_schedule ) ) {
		$type_option = get_user_meta( $staff_member, 'bb_schedule_type', true );
	}

	$location    = get_site_option( 'bb_location_address' );
	$show_on_map = get_site_option( 'bb_display_directions' );

	$on_location     = get_site_option( 'bb_enable_payment_on_location' );
	$online_payments = get_site_option( 'bb_enable_online_payments' );
	$via_invoice     = get_site_option( 'bb_enable_payment_via_invoice' );
	$pk_key          = get_site_option( 'bb_stripe_pk_key' );
	$sk_key          = get_site_option( 'bb_stripe_sk_key' );

	$include_agreement             = get_site_option( 'bb_include_acknowledgement' );
	$selected_by_default_agreement = get_site_option( 'bb_selected_by_default_acknowledgement' );
	$text_entry_agreement          = stripslashes( get_site_option( 'bb_text_entry_acknowledgement' ) );

	$values     = explode( '_', $slot );
	$start_hour = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
	$end_hour   = date( 'g:ia T', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );

	$hour_standard_12 = get_site_option( 'bb_schedule_12_hour_standard' );
	$hour_standard_24 = get_site_option( 'bb_schedule_24_hour_standard' );

	if ( ! empty( $hour_standard_24 ) ) {
		$start_hour = date( 'H:i', strtotime( $start_hour ) );
		$end_hour   = date( 'H:i', strtotime( $end_hour ) );
	}

	ob_start();

	include( BB_PLUGIN_DIR . 'fragments/steps/step-3.php' );

	$result = ob_get_contents();

	ob_end_clean();

	$return = array( 'content' => $result );

	wp_send_json( $return );

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_step_four', 'bb_ajax_step_four' );
add_action( 'wp_ajax_nopriv_bb_ajax_step_four', 'bb_ajax_step_four' );

function bb_ajax_step_four() {
	$date           = isset( $_POST['dates'] ) ? esc_html( $_POST['dates'] ) : '';
	$cat_id         = isset( $_POST['cat_id'] ) ? esc_html( $_POST['cat_id'] ) : '';
	$service_id     = isset( $_POST['service_id'] ) ? esc_html( $_POST['service_id'] ) : '';
	$date           = isset( $_POST['date'] ) ? esc_html( $_POST['date'] ) : '';
	$method         = isset( $_POST['method'] ) ? esc_html( $_POST['method'] ) : '';
	$payment_method = isset( $_POST['payment_method'] ) ? esc_html( $_POST['payment_method'] ) : '';
	$slot           = isset( $_POST['slot'] ) ? esc_html( $_POST['slot'] ) : '';
	$name           = isset( $_POST['name'] ) ? $_POST['name'] : '';
	$email          = isset( $_POST['email'] ) ? $_POST['email'] : '';
	$phone          = isset( $_POST['phone'] ) ? $_POST['phone'] : '';
	$address        = isset( $_POST['address'] ) ? $_POST['address'] : '';
	$agreement      = isset( $_POST['agreement'] ) ? $_POST['agreement'] : false;
	$appointment    = '';
	$staff_member   = intval( $_POST['staff_member'] );

	$currency       = get_site_option( 'bb_payment_currency' );

	$supported_currencies = mbbb_get_supported_currencies();

	if ( ! array_key_exists( $currency, $supported_currencies ) ) {
		$currency = 'usd';
	}

	$is_global_schedule = get_site_option( 'bb_single_schedule' );

	$type_option = absint( get_site_option( 'bb_schedule_type' ) );

	if ( empty( $is_global_schedule ) ) {
		$type_option = get_user_meta( $staff_member, 'bb_schedule_type', true );
	}

	$location    = get_site_option( 'bb_location_address' );

	$show_slots  = get_site_option( 'bb_include_show_booked_time_slots', true );
	$values      = explode( '_', $slot );
	$start_hour  = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
	$end_hour    = date( 'g:ia T', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );

	$hour_standard_12 = get_site_option( 'bb_schedule_12_hour_standard' );
	$hour_standard_24 = get_site_option( 'bb_schedule_24_hour_standard' );

	if ( ! empty( $hour_standard_24 ) ) {
		$start_hour = date( 'H:i', strtotime( $start_hour ) );
		$end_hour   = date( 'H:i', strtotime( $end_hour ) );
	}

	$payment_meta = [];

	$selected_staff_member = get_user_by( 'id', $staff_member );

	$generate_zoom = get_post_meta( intval( $service_id ), 'bb_generate_zoom_meeting', true );
	$zoom_meeting  = '';

	if ( ! empty( $generate_zoom ) ) {
		$service = get_post( intval( $service_id ) );

		$start_date = date( 'Y-m-d', strtotime( $date ) );
		$start_time = date( 'H:i:s', strtotime( $start_hour ) );

		$start_datetime = $start_date . 'T' . $start_time;

		$timezone = get_option( 'timezone_string' );

		$args = [
			'topic' => 'Booking for ' . $service->post_title,
			'type' => 2,
			'start_time' => date( 'Y-m-d', strtotime( $start_hour ) ),
			'start_time' => $start_datetime,
			'duration' => $type_option,
		];

		if ( ! empty( $timezone ) ) {
			$args['timezone'] = $timezone;
		}

		$zoom_meeting = mbbb_create_zoom_meeting( $args );
	}

	$args = [
		'post_title'   => esc_sql( $name . ' - ' . $date ),
		'post_content' => '',
		'post_status'  => 'publish',
		'post_type'    => 'bb_appointment',
		'meta_input'   => [
			'_bb_appointment_category'       => absint( $cat_id ),
			'_bb_appointment_service'        => absint( $service_id ),
			'_bb_appointment_method'         => bb_methods_post_meta( esc_sql( $method ) ),
			'_bb_appointment_payment_method' => bb_payment_methods_post_meta( esc_sql( $payment_method ) ),
			'_bb_appointment_slot'           => esc_sql( $slot ),
			'_bb_appointment_time_slot'      => sprintf( '%s - %s', $start_hour, $end_hour ),
			'_bb_appointment_date'           => esc_sql( $date ),
			'_bb_appointment_full_name'      => esc_sql( $name ),
			'_bb_appointment_email'          => esc_sql( $email ),
			'_bb_appointment_phone'          => esc_sql( $phone ),
			'_bb_appointment_address'        => esc_sql( $address ),
			'_bb_staff_member'               => esc_sql( $selected_staff_member->display_name ),
		],
	];

	if ( ! empty( $zoom_meeting ) ) {
		$formatted_start_time = esc_sql( $zoom_meeting->start_time );
		$formatted_start_time = str_replace( 'T', ' ', $formatted_start_time );
		$formatted_start_time = str_replace( 'Z', '', $formatted_start_time );
		$timestamp            = strtotime( $formatted_start_time );
		$timezone_offset      = get_option( 'gmt_offset' );
		$timestamp            = $timestamp + ( intval( $timezone_offset ) * 60 * 60 );
		$datetime             = wp_date( 'd M, Y - H:i', $timestamp );

		if ( $hour_standard_12 ) {
			$datetime = wp_date( 'd M, Y - h:i a', $timestamp );
		}

		$args['meta_input']['_bb_zoom_meeting_title'] = esc_sql( $zoom_meeting->topic );
		$args['meta_input']['_bb_zoom_meeting_start_time'] = $datetime;
		$args['meta_input']['_bb_zoom_meeting_duration'] = esc_sql( mbbb_format_minutes( $zoom_meeting->duration ) );
		$args['meta_input']['_bb_zoom_meeting_join_link'] = esc_sql( $zoom_meeting->join_url );
	}

	$disable_double_booking = get_site_option( 'bb_disable_double_booking', false );
	$service_arg  = $service_id;
	$staff_member_arg = false;

	if ( empty( $is_global_schedule ) ) {
		$staff_member_arg  = $selected_staff_member->display_name;
	}

	if ( ! empty( $disable_double_booking ) ) {
		$service_arg = false;
	}

	$appointment_exists = bb_check_if_appointment_exists( $cat_id, $service_arg, $date, $slot, $staff_member_arg );

	if ( empty( $appointment_exists ) ) {
		$field_validation_args = [
			'name' => $name,
			'email' => $email,
			'phone' => $phone,
			'address' => $address,
			'agreement-checkbox' => $agreement,
		];

		if ( $payment_method !== '' ) {
			$field_validation_args['payment-method'] = $payment_method;
		}

		$field_validation = bb_check_requred_fields( $field_validation_args );

		if ( $field_validation['validated'] ) {
			if ( $payment_method === 'stripe' ) {
				$token         = $_POST['token'];
				$payment_name  = $_POST['payment_name'];
				$secret_key    = get_site_option( 'bb_stripe_sk_key', true );

				$title         = get_the_title( $service_id );
				$price         = get_post_meta( $service_id, 'bb_service_price', true );
				$date_string   = wp_date( 'D F jS, Y', strtotime( $date ) );
				$time_period   = sprintf( '%s - %s', $start_hour, $end_hour );

				$stripe = new \Stripe\StripeClient(
					$secret_key
				);

				$new_customer = '';
				$customers    = ! empty( $customers = $stripe->customers->all() ) ? $customers->data : '';

				foreach ( $customers as $customer ) {
					if ( $customer->email === $email ) {
						$new_customer = $customer;
					}
				}

				if ( empty( $new_customer ) ) {
					$new_customer = $stripe->customers->create( [
						'email'  => $email,
						'name'   => $payment_name,
						'source' => $token
					] );
				} else {
					if ( empty( $card_id = bb_check_duplicate_card( $stripe, $new_customer, $token, true ) ) ) {
						$new_source = $stripe->customers->createSource(
							$new_customer->id,
							[
								'source' => $token,
							]
						);

						$stripe->customers->update(
							$new_customer->id,
							[
								'name'           => $payment_name,
								'default_source' => $new_source->id,
							]
						);
					} else {
						$stripe->customers->update(
							$new_customer->id,
							[
								'name'           => $payment_name,
								'default_source' => $card_id,
							]
						);
					}
				}

				try {
					$charge = $stripe->charges->create( [
						'amount'      => floatval( round( $price, 2 ) ) * 100, // 2000 => 20$
						'currency'    => $currency,
						'description' => $title . ' on ' . $date_string . ' ' . $time_period . ', ' . $location,
						'customer'    => $new_customer->id
					] );
				} catch( Exception $e ) {
					$api_error = $e->getMessage();
				}

				if ( empty( $api_error ) && $charge ) {
					$chargeJson = $charge->jsonSerialize();

					// Check whether the charge is successful
					if ( $chargeJson['amount_refunded'] == 0 && empty( $chargeJson['failure_code' ] ) && $chargeJson['paid'] == 1 && $chargeJson['captured'] == 1 ){
						// Transaction details
						$payment_meta['_bb_appointment_payment_balance_transaction'] = $chargeJson['balance_transaction'];
						$payment_meta['_bb_appointment_payment_amount']              = $chargeJson['amount'];
						$payment_meta['_bb_appointment_payment_paid_amount']         = ( $chargeJson['amount'] / 100 );
						$payment_meta['_bb_appointment_payment_currency']            = $chargeJson['currency'];
						$payment_meta['_bb_appointment_payment_status']              = $chargeJson['status'];

						if ( ! empty( $payment_meta ) ) {
							$args['meta_input'] = array_merge( $args['meta_input'], $payment_meta );
						}
					}
				} else {

					echo json_encode( [ 'status' => 'error', 'content' => '<p class="bb-validation-error">' . $api_error . '</p>' ] );

					wp_die();
				}
			}

			$appointment = wp_insert_post( $args );

			$generate_reminder = get_post_meta( intval( $service_id ), 'bb_generate_google_calendar_reminder', true );

			if ( ! empty( $generate_reminder ) ) {
				$is_global_schedule = get_site_option( 'bb_single_schedule' );

				$admins = get_users( [
					'role'    => 'administrator',
					'orderby' => 'user_nicename',
					'order'   => 'ASC'
				] );

				if ( ! empty( $is_global_schedule ) ) {
					foreach ( $admins as $admin ) {
						$user_key = get_site_option( 'bb_google_api_user_key_' . strval( $admin->ID ), '' );

						if ( ! empty( $user_key ) ) {
							mbbb_set_a_reminder( $appointment, $_SERVER['SERVER_NAME'], strval( $admin->ID ), $user_key );
						}
					}
				} else {
					$user_key = get_site_option( 'bb_google_api_user_key_' . strval( $staff_member ), '' );

					if ( ! empty( $user_key ) ) {
						mbbb_set_a_reminder( $appointment, $_SERVER['SERVER_NAME'], strval( $staff_member ), $user_key );
					}
				}
			}

			$error_message = __( 'There was an Error', 'brindle-booking' );
		} else {
			$error_message = __( 'Please fill all required information marked with *.', 'brindle-booking' );
		}
	} else {
		$error_message = __( 'Please select another time slot and/or date.', 'brindle-booking' );
	}

	if ( ! empty( $appointment ) ) {
		$category      = get_term( $cat_id )->name;
		$service_title = get_the_title( $service_id );
		$service_price = get_post_meta( $service_id, 'bb_service_price', true );
		$date_string   = wp_date( 'D F jS, Y', strtotime( $date ) );

		$is_global_schedule = get_site_option( 'bb_single_schedule' );

		$type_option = absint( get_site_option( 'bb_schedule_type' ) );

		if ( empty( $is_global_schedule ) ) {
			$type_option = get_user_meta( $staff_member, 'bb_schedule_type', true );
		}

		$location    = get_site_option( 'bb_location_address' );
		$show_on_map = get_site_option( 'bb_display_directions' );

		$values     = explode( '_', $slot );
		$start_hour = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
		$end_hour   = date( 'g:ia T', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );

		$hour_standard_12 = get_site_option( 'bb_schedule_12_hour_standard' );
		$hour_standard_24 = get_site_option( 'bb_schedule_24_hour_standard' );

		if ( ! empty( $hour_standard_24 ) ) {
			$start_hour = date( 'H:i', strtotime( $start_hour ) );
			$end_hour   = date( 'H:i', strtotime( $end_hour ) );
		}

		$main_color   = ! empty( get_site_option( 'bb_main_color', true ) ) ? get_site_option( 'bb_main_color', true ) : '#01bae8';
		$accent_color = ! empty( get_site_option( 'bb_accent_color', true ) ) ? get_site_option( 'bb_accent_color', true ) : '#ff1b63';
		$titles_color = ! empty( get_site_option( 'bb_titles_color', true ) ) ? get_site_option( 'bb_titles_color', true ) : '#01bae8';

		$admin_email = get_option( 'admin_email' );
		$notified_admins = get_site_option( 'bb_notified_admins', '' );

		$is_for_admin = true;

		$admin_subject   = get_site_option( 'bb_admin_notification_subject', 'Booking Reservation' );
		$visitor_subject = get_site_option( 'bb_visitor_notification_subject', 'Your Booking is Confirmed!' );

		if ( empty( $admin_subject ) ) {
			$admin_subject = __( 'Booking Reservation', 'brindle-booking' );
		}

		if ( empty( $visitor_subject ) ) {
			$visitor_subject = __( 'Your Booking is Confirmed!', 'brindle-booking' );
		}

		$no_admin_notification = get_site_option( 'bb_no_notification_admin', '' );

		if ( empty( $no_admin_notification ) ) {
			if ( ! empty( $notified_admins ) || ! empty( $admin_email ) ) {
				ob_start();

				include( BB_PLUGIN_DIR . 'fragments/email/confirmation.php' );

				$email_content = ob_get_contents();

				$headers = array( 'Content-Type: text/html; charset=UTF-8' );

				ob_end_clean();

				if ( empty( $notified_admins ) ) {
					if ( $admin_email !== $selected_staff_member->user_email ) {
						wp_mail( $admin_email, esc_html( $admin_subject ), $email_content, $headers );
					}
				} else {
					$admins_ids = explode( '|', $notified_admins );

					foreach ( $admins_ids as $id ) {
						$user = get_userdata( intval( $id ) );
						$user_email = $user->user_email;

						if ( ! empty( $user_email ) ) {
							if ( $user_email !== $selected_staff_member->user_email ) {
								wp_mail( $user_email, esc_html( $admin_subject ), $email_content, $headers );
							}
						}
					}
				}
			}
		}

		if ( ! empty( $selected_staff_member ) && ! empty( $selected_staff_member->user_email ) ) {
			ob_start();

			include( BB_PLUGIN_DIR . 'fragments/email/confirmation.php' );

			$email_content = ob_get_contents();

			$headers = array( 'Content-Type: text/html; charset=UTF-8' );

			ob_end_clean();

			wp_mail( $selected_staff_member->user_email, esc_html( $admin_subject ), $email_content, $headers );
		}

		if ( ! empty( $email ) ) {
			$is_for_admin = false;
			$is_for_visitor = true;

			ob_start();

			include( BB_PLUGIN_DIR . 'fragments/email/confirmation.php' );

			$email_content = ob_get_contents();

			$headers = array( 'Content-Type: text/html; charset=UTF-8' );

			ob_end_clean();

			wp_mail( $email, esc_html( $visitor_subject ), $email_content, $headers );
		}

		ob_start();

		include( BB_PLUGIN_DIR . 'fragments/steps/step-4.php' );

		$content = ob_get_clean();

		echo json_encode( [ 'status' => 'success', 'content' => $content ] );

	} else {

		echo json_encode( [
			'status' => 'error',
			'content' => '<p class="bb-validation-error">' . $error_message . '</p>',
			'field_validation' => ! empty( $field_validation['fields'] ) ? $field_validation['fields'] : '',
		] );

	}

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_get_payment_method', 'bb_ajax_payment_method' );
add_action( 'wp_ajax_nopriv_bb_ajax_get_payment_method', 'bb_ajax_payment_method' );

function bb_ajax_payment_method() {
	$method = $_POST['method'];

	ob_start();

	include_once( BB_PLUGIN_DIR . 'fragments/payment-method.php' );

	$return = array( 'content' => ob_get_clean() );

	wp_send_json( $return );

	wp_die();
}

function bb_check_duplicate_card( $stripe, $customer, $token, $check_exp = false ) {
	try {
		// get token data
		$response = $stripe->tokens->retrieve(
			$token
		);
		$token_fingerprint = $response->card->fingerprint;
		$token_exp_month   = $response->card->exp_month;
		$token_exp_year    = $response->card->exp_year;

		$duplicate_found = false;

		foreach ( $customer->sources->data as &$value ) {
			// get data
			$fingerprint = $value->fingerprint;
			$exp_month   = $value->exp_month;
			$exp_year    = $value->exp_year;

			if ( $fingerprint == $token_fingerprint ) {
				if ( $check_exp ) {
					if ( ( $exp_month == $token_exp_month ) && ( $exp_year == $token_exp_year ) ) {
						$duplicate_found = $value->id;
						break;
					}
				} else {
					$duplicate_found = $value->id;
					break;
				}
			}
		}
	} catch ( Exception $e ) {
		$return_array = [
			"message" => $e->getMessage(),
		];

		$return_str = json_encode( $return_array );
		echo $return_str;
	}

	return $duplicate_found;
}