<?php

add_action( 'init', 'mbbb_add_user_role', 10 );

function mbbb_add_user_role() {
	$role = 'mbbb_staff_member';

	global $wp_roles;

	$existing_roles = $wp_roles->get_names();

	if ( array_key_exists( $role, $existing_roles ) ) {
		return;
	}

	$display_name = 'Staff Member';
	$capabilities = array( 'read' => true );

	add_role( $role, $display_name, $capabilities );

	$staff_member_role = get_role( 'mbbb_staff_member' );
	$admin_member_role = get_role( 'administrator' );

	$staff_member_role->add_cap( 'edit_appointment' );
	$staff_member_role->add_cap( 'read_appointment' );
	$staff_member_role->add_cap( 'delete_appointment' );
	$staff_member_role->add_cap( 'edit_appointments' );
	$staff_member_role->add_cap( 'edit_others_appointment' );
	$staff_member_role->add_cap( 'publish_appointment' );
	$staff_member_role->add_cap( 'read_private_appointment' );
	$staff_member_role->add_cap( 'create_posts_appointment' );

	$admin_member_role->add_cap( 'edit_appointment' );
	$admin_member_role->add_cap( 'read_appointment' );
	$admin_member_role->add_cap( 'delete_appointment' );
	$admin_member_role->add_cap( 'edit_appointments' );
	$admin_member_role->add_cap( 'edit_others_appointment' );
	$admin_member_role->add_cap( 'publish_appointment' );
	$admin_member_role->add_cap( 'read_private_appointment' );
	$admin_member_role->add_cap( 'create_posts_appointment' );
}

add_filter( 'admin_body_class', 'mbbb_browser_classes' );
function mbbb_browser_classes( $classes ) {
	$user = wp_get_current_user();

	if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
		$classes .= ' role-mbbb_staff_member';
	}

    return $classes;
}