<?php
/*
 * Functions and actions used for Services.
 */

/*
 * AJAX body of Edit Service functionality
 */
add_action( 'wp_ajax_bb_modify_service', 'bb_ajax_edit_service' );
function bb_ajax_edit_service() {
	if ( empty( $id = absint( $_GET['id'] ) ) ) {
		return;
	}

	$paged     = absint( $_GET['paged'] );
	$cat       = absint( $_GET['cat'] );

	$terms     = get_the_terms( $id, 'bb_service_category' );
	$terms_ids = ! empty( $terms ) ? wp_list_pluck( $terms, 'term_id' ) : [];

	$categories = get_terms( [
		'taxonomy'   => 'bb_service_category',
		'hide_empty' => false,
	] );

	$price = get_post_meta( $id, 'bb_service_price', true );

	ob_start();

	include_once( BB_PLUGIN_DIR . 'admin/fragments/edit.php' );

	echo json_encode( ob_get_contents() );

	die();
}

/*
 * AJAX body of Add Service functionality
 */
add_action( 'wp_ajax_bb_add_service', 'bb_ajax_add_service' );
function bb_ajax_add_service() {
	$categories = get_terms( [
		'taxonomy'   => 'bb_service_category',
		'hide_empty' => false,
	] );

	ob_start();

	include_once( BB_PLUGIN_DIR . 'admin/fragments/add.php' );

	echo json_encode( ob_get_contents() );

	die();
}

/*
 * Handle Add Service request
 */
add_action( 'wp_ajax_bb_add_service_post', 'bb_add_service_post' );
add_action( 'wp_ajax_nopriv_bb_add_service_post', 'bb_add_service_post' );

function bb_add_service_post() {
	$title         = isset( $_POST['service_title'] ) ? sanitize_text_field( $_POST['service_title'] ) : '';
	$term          = isset( $_POST['service_category'] ) ? sanitize_text_field( $_POST['service_category'] ) : '';
	$price         = isset( $_POST['service_price'] ) ? sanitize_text_field( $_POST['service_price'] ) : '';
	$generate_zoom = isset( $_POST['generate_zoom'] ) ? sanitize_text_field( $_POST['generate_zoom'] ) : 0;
	$generate_reminder = isset( $_POST['generate_reminder'] ) ? sanitize_text_field( $_POST['generate_reminder'] ) : 0;

	if ( ! empty( $title ) ) {
		$service = [
			'post_title'    => wp_strip_all_tags( $title ),
			'post_content'  => '',
			'post_status'   => 'publish',
			'post_type'     => 'bb_service',
			'post_author'   => get_current_user_id(),
		];

		if ( ! empty( $term ) ) {
			$service['tax_input'] = [
		        'bb_service_category' => [ $term ]
		    ];
		}
		// Insert the post into the database
		$service_id = wp_insert_post( $service );

		if ( ! empty( $price ) ) {
			add_post_meta( $service_id, 'bb_service_price', $price );
		}

		if ( ! empty( $generate_zoom ) ) {
			add_post_meta( $service_id, 'bb_generate_zoom_meeting', $generate_zoom );
		}

		if ( ! empty( $generate_reminder ) ) {
			add_post_meta( $service_id, 'bb_generate_google_calendar_reminder', $generate_reminder );
		}
	}

	if ( ! is_wp_error( $service_id ) ) {
		$service = get_post( intval( $service_id ) );

		ob_start();

		?>

		<li class="ui-state-default">
			<div class="bb-service js-service-select" data-selected="false" data-id="<?php echo $service->ID; ?>">
				<div class="service__content">
					<p>
						<a href="<?php echo get_edit_post_link( $service->ID ); ?>">
							<?php echo get_the_title( $service->ID ) ?>

							<?php

							$price    = get_post_meta( $service->ID, 'bb_service_price', true );
							$currency = get_site_option( 'bb_payment_currency' );
							$supported_currencies = mbbb_get_supported_currencies();

							if ( ! array_key_exists( $currency, $supported_currencies ) ) {
								$currency = 'usd';
							}

							$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

							?>

							<?php if ( ! empty( $price ) ) : ?>
								<?php printf( '%s%s', $currency_sign, strval( round( floatval( $price ), 2 ) ) ) ?>
							<?php endif ?>
						</a>
					</p>
				</div><!-- /.service__content -->

				<div class="service__body">
					<p>
						<?php
						$service_categories = get_the_terms( $service->ID, 'bb_service_category' );

						if ( ! empty( $service_categories ) ) :
							$categories_names = wp_list_pluck( $service_categories, 'name' );
							?>
							<?php echo implode( ',', $categories_names ); ?>
						<?php endif ?>
					</p>
				</div><!-- /.service__content -->

				<div class="service__actions">
					<ul>
						<li>
							<a class="service__btn-delete js-delete-service" href="<?php echo get_delete_post_link( $service->ID, '', true ) ?>">
								<?php _e( 'Delete', 'brindle-booking' ); ?>
							</a>
						</li>
						<li>
							<a class="service__btn-edit js-edit" href="<?php echo get_edit_post_link( $service->ID ) ?>" data-service="<?php echo absint( $service->ID ); ?>" data-paged="<?php echo isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : ''; ?>" data-cat="<?php echo isset( $_GET['category-filter'] ) ? absint( $_GET['category-filter'] ) : ''; ?>" >
								<?php _e( 'Edit', 'brindle-booking' ); ?>
							</a>
						</li>

						<li>
							<a class="ui-icon service__btn-sort js-sort-service" href="#">
								<i class="bb-ico-sort"></i>
							</a>
						</li>
					</ul>
				</div><!-- /.service__actions -->
			</div><!-- /.bb-service -->
		</li>

		<?php

		$new_service = ob_get_contents();

		ob_end_clean();
	}

	wp_send_json( [
		'status' => ! empty( $service_id ) ? 'success' : 'fail',
		'new_service' => $new_service,
	] );

	wp_die();
}

/*
 * Handle Edit Service request.
 */
add_action( 'wp_ajax_bb_process_edit_form', 'bb_process_edit_form' );
add_action( 'wp_ajax_nopriv_bb_process_edit_form', 'bb_process_edit_form' );

function bb_process_edit_form() {
	$id            = isset( $_POST['mb_bb_id'] ) ? sanitize_text_field( $_POST['mb_bb_id'] ) : '';
	$cat           = isset( $_POST['mb_bb_cat'] ) ? sanitize_text_field( $_POST['mb_bb_cat'] ) : '';
	$title         = isset( $_POST['service_title'] ) ? sanitize_text_field( $_POST['service_title'] ) : '';
	$term          = isset( $_POST['service_category'] ) ? sanitize_text_field( $_POST['service_category'] ) : '';
	$price         = isset( $_POST['service_price'] ) ? sanitize_text_field( $_POST['service_price'] ) : '';
	$generate_zoom = isset( $_POST['generate_zoom_meeting'] ) ? sanitize_text_field( $_POST['generate_zoom_meeting'] ) : 0;
	$generate_google_calendar_reminder = isset( $_POST['generate_google_calendar_reminder'] ) ? sanitize_text_field( $_POST['generate_google_calendar_reminder'] ) : 0;

	if ( ! empty( $title ) ) {
		$service = [
			'ID'           => $id,
			'post_title'   => wp_strip_all_tags( $title ),
			'post_content' => '',
			'tax_input'    => [
				'bb_service_category' => [ $term ]
			]
		];

		// Update the post
		$service_id = wp_update_post( $service );

		update_post_meta( $service_id, 'bb_service_price', $price );
	}

	update_post_meta( $service_id, 'bb_generate_zoom_meeting', $generate_zoom );
	update_post_meta( $service_id, 'bb_generate_google_calendar_reminder', $generate_google_calendar_reminder );

	$category_object = get_term_by( 'id', $term, 'bb_service_category' );

	$post = '';

	if ( ! empty( $service_id ) ) {
		$post = get_post( intval( $service_id ) );
	}

	$currency = get_site_option( 'bb_payment_currency' );
	$supported_currencies = mbbb_get_supported_currencies();

	if ( ! array_key_exists( $currency, $supported_currencies ) ) {
		$currency = 'usd';
	}

	$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

	if ( ! empty( $price ) ) {
		$price = sprintf( '%s%s', $currency_sign, strval( round( floatval( $price ), 2 ) ) );
	}

	wp_send_json( [
		'status' => ! empty( $service_id ) ? 'success' : 'fail',
		'new_service' => $post,
		'new_price' => $price,
		'new_term_name' => $category_object->name,
		'new_term_id' => $category_object->term_id,
	] );

	wp_die();
}

add_action( 'admin_init','bb_catch_deleted_services_handler' );
function bb_catch_deleted_services_handler() {
	$post_type = isset( $_GET['post'] ) ? get_post_type( $_GET['post'] ) : '';

	if ( isset( $_GET['action'] ) &&  $_GET['action'] === 'delete' && ! empty( $post_type ) && $post_type === 'bb_service' ) {
		$paged = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;

		$args = [
			'post_type'      => 'bb_service',
			'paged'          => $paged,
			'posts_per_page' => 10,
		];

		if ( ! empty( $_GET['category-filter'] ) ) {
			$args['tax_query'] = [
				[
					'taxonomy' => 'bb_service_category',
					'field'    => 'term_id',
					'terms'    => [ absint( $_GET['category-filter'] ) ]
				]
			];
		}

		$query = new WP_Query( $args );

		if ( $query->max_num_pages < $paged ) {
			$admin_url = admin_url( 'admin.php?page=brindle-booking' );

			if ( isset( $_GET['category-filter'] ) && ! empty( $_GET['category-filter'] ) ) {
				$admin_url = add_query_arg( 'category-filter', absint( $_GET['category-filter'] ), $admin_url );
			}

			wp_safe_redirect( $admin_url );
			exit;
		}
	}
}

add_action( 'wp_ajax_bb_delete_service', 'bb_delete_service' );
add_action( 'wp_ajax_nopriv_bb_delete_service', 'bb_delete_service' );

function bb_delete_service() {
	$service_id = isset( $_POST['id'] ) ? $_POST['id'] : '';

	if ( empty( $service_id ) ) {
		wp_send_json( [
			'deleted_posts' => []
		] );
	}

	$deleted_posts = [];

	$deleted_posts[$service_id] = wp_delete_post( intval( esc_html( $service_id ) ), true );

	wp_send_json( [
		'deleted_posts' => $deleted_posts,
	] );

	wp_die();
}

add_action( 'wp_ajax_bb_bulk_delete_services', 'bb_bulk_delete_services' );
add_action( 'wp_ajax_nopriv_bb_bulk_delete_services', 'bb_bulk_delete_services' );

function bb_bulk_delete_services() {
	$service_ids = isset( $_POST['ids'] ) ? $_POST['ids'] : '';
	$pagenum    = isset( $_POST['pagenum'] ) ? esc_html( $_POST['pagenum'] ) : false;

	if ( empty( $service_ids ) ) {
		wp_send_json( [
			'deleted_posts' => []
		] );
	}

	$deleted_posts = [];

	$current_order = json_decode( get_site_option( 'bb_services_in_order', '' ) );

	if ( $current_order && $pagenum ) {
		$service_ids_string = implode( '|', $service_ids );

		$new_order = $current_order;
		$new_order->$pagenum = str_replace( $service_ids_string, '', $new_order->$pagenum );

		$update = update_site_option( 'bb_services_in_order', json_encode( $new_order ) );
	}

	foreach ( $service_ids as $id ) {
		$deleted_posts[$id] = wp_delete_post( intval( esc_html( $id ) ), true );
	}

	wp_send_json( [
		'deleted_posts' => $deleted_posts,
		'service_ids_string' => $service_ids_string,
		'new_order' => $new_order->$pagenum,
		'new_order_replace' => str_replace( $service_ids_string, '', $new_order->$pagenum ),
	] );

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_set_services_order', 'bb_ajax_set_services_order' );
add_action( 'wp_ajax_nopriv_bb_ajax_set_services_order', 'bb_ajax_set_services_order' );

function bb_ajax_set_services_order() {
	$order     = isset( $_POST['order'] ) ? esc_html( $_POST['order'] ) : false;

	$update = false;

	$current_order = get_site_option( 'bb_services_in_order', '' );

	if ( $order !== false && $order !== $current_order ) {
		$update = update_site_option( 'bb_services_in_order', $order );
	}

	$return = [ 'status' => $update ? 'success' : 'fail' ];

	wp_send_json( $return );

	wp_die();
}