<?php

/* LOCAL USE ONLY */
//use GuzzleHttp\Client;
/* END */

add_action( 'template_redirect', 'bb_set_google_event' );

function bb_set_google_event() {
	if ( ( isset( $_GET['bb-set-reminder'] ) && ! empty( $_GET['bb-set-reminder'] ) ) || ( isset( $_GET['code'] ) && ! empty( $_GET['code'] ) ) ) {
		session_start();

		$appointment_id = isset( $_GET['bb-set-reminder'] ) ? absint( $_GET['bb-set-reminder'] ) : $_SESSION['bb-appointment-id'];

		if ( FALSE === get_post_status( $appointment_id ) ) {
			return;
		}

		$_SESSION['bb-appointment-id'] = $appointment_id;

		/* LOCAL USE ONLY */
		$http = new GuzzleHttp\Client( [ 'verify' => false ] );
		/* END */

		$category   = get_post_meta( $appointment_id, '_bb_appointment_category', true );
		$title      = ! empty( get_term( $category )->name ) ? get_term( $category )->name : '';
		$service    = get_post_meta( $appointment_id, '_bb_appointment_service', true );
		$desc       = ! empty( get_the_title( $service ) ) ? get_the_title( $service ) : '';

		$slot       = get_post_meta( $appointment_id, '_bb_appointment_slot', true );
		$date       = get_post_meta( $appointment_id, '_bb_appointment_date', true );

		$type       = absint( get_site_option( 'bb_schedule_type' ) );

		$values     = explode( '_', $slot );
		$start_hour = date( 'Y-m-d\TH:i:s', strtotime( $values[2] . ':' . $values[3] . $values[1] . ' ' . $date ) );
		$end_hour   = date( 'Y-m-d\TH:i:s', strtotime( '+' . $type . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] . ' ' . $date ) ) );

		$client = new Google_Client();

		/* LOCAL USE ONLY */
		//$client->setHttpClient( $http );
		/* END */

		$client->setAuthConfig( BB_PLUGIN_UPLOAD_DIR . '/credentials.json' );

		$client->addScope( 'https://www.googleapis.com/auth/calendar' );

		if ( isset( $_SESSION['access_token'] ) && ! empty( $_SESSION['access_token'] ) ) {
			// Set your method for authentication. Depending on the API,
			// This could be directly with an access token or API key.
			try {
				$client->setAccessToken( $_SESSION['access_token'] );
			} catch( Exception $e ) {
				$client->setRedirectUri( home_url('/') );

				if ( ! isset( $_GET['code'] ) ) {
					$auth_url = $client->createAuthUrl();

					header( 'Location: ' . $auth_url );
					die;

				} else {
					$client->authenticate( $_GET['code'] );
					$_SESSION['access_token'] = $client->getAccessToken();
					unset( $_SESSION['bb-appointment-id'] );

					header( 'Location: ' . home_url( '/?bb-set-reminder='. $appointment_id ) );
					die;
				}
			}

			// returns a Guzzle HTTP Client
			$httpClient = $client->authorize();

			$service    = new Google_Service_Calendar( $client );
			$event      = new Google_Service_Calendar_Event( [
				'summary'     => $title,
				'location'    => get_site_option( 'bb_location_address' ),
				'description' => $desc,
				'start'       => [
					'dateTime' => $start_hour,
					'timeZone' => wp_timezone_string(),
				],
				'end'         => [
					'dateTime' => $end_hour,
					'timeZone' => wp_timezone_string(),
				],
				'reminders'   => [
					'useDefault' => FALSE,
					'overrides'  => [
						[ 'method' => 'email', 'minutes' => 24 * 60 ],
						[ 'method' => 'popup', 'minutes' => 60 ],
					],
				],
			] );

			$event = $service->events->insert( 'primary', $event );

			if ( $event->htmlLink ) {
				header( 'Location: ' . $event->htmlLink );
				die;
			}

			header( 'Location: ' . home_url('/') );
			die;
		} else {
			$client->setRedirectUri( home_url('/') );

			if ( ! isset( $_GET['code'] ) ) {
				$auth_url = $client->createAuthUrl();

				header( 'Location: ' . $auth_url );
				die;

			} else {
				$client->authenticate( $_GET['code'] );
				$_SESSION['access_token'] = $client->getAccessToken();
				unset( $_SESSION['bb-appointment-id'] );

				header( 'Location: ' . home_url( '/?bb-set-reminder='. $appointment_id ) );
				die;
			}
		}
	}
}

function mbbb_get_appointment_reminder_args( $appointment_id ) {
	$args = [];

	$category   = get_post_meta( $appointment_id, '_bb_appointment_category', true );
	$title      = ! empty( get_term( $category )->name ) ? get_term( $category )->name : '';
	$service    = get_post_meta( $appointment_id, '_bb_appointment_service', true );
	$desc       = ! empty( get_the_title( $service ) ) ? get_the_title( $service ) : '';

	$slot       = get_post_meta( $appointment_id, '_bb_appointment_slot', true );
	$date       = get_post_meta( $appointment_id, '_bb_appointment_date', true );

	$type       = absint( get_site_option( 'bb_schedule_type' ) );

	$values     = explode( '_', $slot );
	$start_hour = date( 'Y-m-d\TH:i:s', strtotime( $values[2] . ':' . $values[3] . $values[1] . ' ' . $date ) );
	$end_hour   = date( 'Y-m-d\TH:i:s', strtotime( '+' . $type . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] . ' ' . $date ) ) );

	$args = [
		'summary'     => $title,
		'location'    => get_site_option( 'bb_location_address', '' ),
		'description' => $desc,
		'start_hour' => $start_hour,
		'time_zone' => wp_timezone_string(),
		'end_hour' => $end_hour,
	];

	return $args;
}

function mbbb_google_check_access_token() {
	$request = curl_init( 'https://mybrindle.com/google-calendar/google-check-access-token.php' );

	$data = [
		'url'     => $_SERVER['SERVER_NAME'],
		'user-id' => strval( get_current_user_id() ),
	];

	curl_setopt( $request, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt( $request, CURLOPT_SSL_VERIFYHOST, FALSE);
	curl_setopt( $request, CURLOPT_RETURNTRANSFER, true );
	curl_setopt( $request, CURLOPT_FOLLOWLOCATION, true );
	curl_setopt( $request, CURLOPT_POST, 1 );
	curl_setopt( $request, CURLOPT_POSTFIELDS, $data );

	$response = curl_exec( $request );

	curl_close( $request );

	$response_array = json_decode( $response );

	return $response_array;
}

function mbbb_google_api_refresh_access_token() {
	$responses = [];

	$users = get_users( [
		'role__in'    => [ 'administrator', 'mbbb_staff_member' ],
		'orderby' => 'user_nicename',
		'order'   => 'ASC'
	] );

	foreach ( $users as $user ) {
		$request = curl_init( 'https://mybrindle.com/google-calendar/google-refresh-token.php' );
	
		$user_key = get_site_option( 'bb_google_api_user_key_' . strval( $user->ID ), '' );

		if ( empty( $user_key ) ) {
			continue;
		}
		
		$data = [
			'url' => $_SERVER['SERVER_NAME'],
			'user-id' => strval( $user->ID ),
			'user-key' => $user_key
		];

		curl_setopt( $request, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt( $request, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt( $request, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $request, CURLOPT_FOLLOWLOCATION, true );
		curl_setopt( $request, CURLOPT_POST, 1 );
		curl_setopt( $request, CURLOPT_POSTFIELDS, $data );

		$response = curl_exec( $request );

		curl_close( $request );

		// $response_array = json_decode( $response );

		update_site_option( 'bb_google_api_user_key_' . strval( $user->ID ), esc_sql( $response ) );

		$responses[] = $response;
	}

	return $responses;
}

function mbbb_set_a_reminder( $appointment_id, $url, $user_id, $user_key ) {
	$data             = mbbb_get_appointment_reminder_args( $appointment_id );
	$data['url']      = $url;
	$data['user-id']  = $user_id;
	$data['user-key'] = $user_key;

	$headers =[
		'Content-Type: application/json'
	];

	$request = curl_init( 'https://mybrindle.com/google-calendar/google-set-a-reminder-server-side.php' );

	curl_setopt( $request, CURLOPT_SSL_VERIFYPEER, FALSE );
	curl_setopt( $request, CURLOPT_SSL_VERIFYHOST, FALSE );
	curl_setopt( $request, CURLOPT_RETURNTRANSFER, true );
	curl_setopt( $request, CURLOPT_FOLLOWLOCATION, true );
	curl_setopt( $request, CURLOPT_POST, 1 );
	curl_setopt( $request, CURLOPT_POSTFIELDS, $data );

	$response = curl_exec( $request );

	curl_close( $request );

	$response_array = json_decode( $response );

	return $response_array;
}