<?php

# Enqueue JS and CSS assets on the front-end
add_action('wp_enqueue_scripts', 'bb_wp_enqueue_scripts');
function bb_wp_enqueue_scripts() {

	$load_on_all_pages = get_site_option( 'bb_load_assets_on_all_pages', 'load_assets_on_all_pages_yes' );

	if ( $load_on_all_pages !== 'load_assets_on_all_pages_yes' ) {
		$page_id = get_the_ID();
		$selected_posts = get_site_option( 'bb_load_assets_choose_pages', '' );

		if ( empty( $selected_posts ) ) {
			return;
		}

		$selected_posts = explode( '|', $selected_posts );

		if ( ! in_array( strval( $page_id ), $selected_posts ) ) {
			return;
		}
	}

	$flatpickr_js_path = BB_PLUGIN_DIR . 'js/components/flatpickr-calendar.js';
	$functions_js_path = BB_PLUGIN_DIR . 'js/functions.js';
	
	$reset_css_path    = BB_PLUGIN_DIR . 'css/reset.css';
	$style_css_path    = BB_PLUGIN_DIR . 'css/style.css';

	$locale = explode( '_', get_locale() )[0];

	# Enqueue Custom JS files
	wp_enqueue_script( 'bb-flatpickr-calendar',  BB_PLUGIN_URL . 'js/components/flatpickr-calendar.js', array( 'jquery' ), filemtime( $flatpickr_js_path ) );
	wp_enqueue_script( 'bb-functions',  BB_PLUGIN_URL . 'js/functions.js', array( 'jquery' ), filemtime( $functions_js_path ) );
	wp_localize_script( 'bb-functions', 'bb_options', array(
		'ajax_url' => admin_url( 'admin-ajax.php' ),
		'locale'   => $locale,
		'pk_key'   => get_site_option( 'bb_stripe_pk_key', true )
	) );
	wp_enqueue_script( 'bb-stripe',  '//js.stripe.com/v3/' );

	# Enqueue Custom CSS files
	wp_enqueue_style( 'bb-reset', BB_PLUGIN_URL . 'css/reset.css', null, filemtime( $reset_css_path ) );
	wp_enqueue_style( 'bb-styles', BB_PLUGIN_URL . 'css/style.css', null, filemtime( $style_css_path ) );
	wp_enqueue_style( 'bb-font-styles', 'https://use.typekit.net/eip0gix.css' );
}