<?php
/*
 * Functions and actions used for Services' Categories.
 */

/*
 * Handle Add Service Category request.
 */
add_action( 'wp_ajax_bb_add_service_category', 'bb_add_service_category' );
add_action( 'wp_ajax_nopriv_bb_add_service_category', 'bb_add_service_category' );

function bb_add_service_category() {
	$title = isset( $_POST['new_service_cat_name'] ) ? sanitize_text_field( $_POST['new_service_cat_name'] ) : '';

	$insert = false;
	$new_category = '';

	if ( ! empty( $title ) ) {
		if ( ! term_exists( $title, 'bb_service_category' ) ) {
			$insert = wp_insert_term( $title, 'bb_service_category' );
		}
	}

	if ( ! is_wp_error( $insert ) ) {
		$category = get_term_by( 'id', $insert['term_id'], 'bb_service_category' );

		ob_start();

		?>

		<li class="ui-state-default">
			<a
			class="js-drag-and-drop-category"
			data-action="bb_delete_category"
			data-cat-id="<?php echo $category->term_id ?>"
			href="#">
				<span><?php echo esc_html( $category->name ); ?></span>

				<i class="bb-ico-close js-delete-category" aria-hidden="true">
					<span></span>

					<span></span>
				</i>
			</a>
		</li>

		<?php

		$new_category = ob_get_contents();

		ob_end_clean();
	}

	wp_send_json( [
		'status' => ! empty( $insert ) ? 'success' : 'fail',
		'new_category' => $new_category,
	] );

	wp_die();
}

add_action( 'wp_ajax_bb_delete_service_category', 'bb_delete_service_category' );
add_action( 'wp_ajax_nopriv_bb_delete_service_category', 'bb_delete_service_category' );

function bb_delete_service_category() {
	$term_id = isset( $_POST['cat_id'] ) ? absint( strip_tags( $_POST['cat_id'] ) ) : '';

	if ( empty( $term_id ) ) {
		return;
	}

	$delete_term = wp_delete_term( $term_id, 'bb_service_category' );

	wp_send_json( [
		'status' => $delete_term === true ? $delete_term : false
	] );

	wp_die();
}

add_action( 'wp_ajax_bb_ajax_set_category_order', 'bb_ajax_set_category_order' );
add_action( 'wp_ajax_nopriv_bb_ajax_set_category_order', 'bb_ajax_set_category_order' );

function bb_ajax_set_category_order() {
	$order    = isset( $_POST['order'] ) ? esc_html( $_POST['order'] ) : false;

	$update = false;

	if ( $order !== false ) {
		$update = update_site_option( 'bb_service_categories_in_order', esc_sql( $order ) );
	}

	$return = [ 'status' => $update ? 'success' : 'fail' ];

	wp_send_json( $return );

	wp_die();
}