<?php

add_action( 'admin_post_bb_design_options_form', 'bb_design_options_form_data' );
function bb_design_options_form_data() {
	if ( isset( $_POST['mb_bb_design_form_nonce'] ) && wp_verify_nonce( $_POST['mb_bb_design_form_nonce'], 'mb_bb_design_options_nonce' ) ) {
		$options = [
			'bb_main_color'   => sanitize_text_field( $_POST['main_color'] ),
			'bb_accent_color' => sanitize_text_field( $_POST['accent_color'] ),
			'bb_titles_color' => sanitize_text_field( $_POST['titles_color'] ),
		];

		foreach ( $options as $key => $option ) {
			if ( ! empty( $option ) ) {
				update_site_option( $key, $option );
			}
		}

		// redirect the user to the appropriate page
		wp_safe_redirect( admin_url( 'admin.php?page=brindle-booking-design' ) );
		exit;
	} else {
		wp_die( __( 'Invalid nonce specified', 'brindle-booking' ), __( 'Error', 'brindle-booking' ), array(
			'response' 	=> 403,
			'back_link' => admin_url( 'admin.php?page=brindle-booking-design' ),
		) );
	}
}

add_action( 'admin_post_bb_settings_options_form', 'bb_settings_options_form_data' );
function bb_settings_options_form_data() {
	if ( isset( $_POST['mb_bb_settings_form_nonce'] ) && wp_verify_nonce( $_POST['mb_bb_settings_form_nonce'], 'mb_bb_settings_options_nonce' ) ) {
		$options = [
			'bb_enable_online_payments'               => isset( $_POST['enable_online_payments'] ) ? esc_sql( $_POST['enable_online_payments'] ) : '',
			'bb_enable_payment_on_location'           => isset( $_POST['enable_payment_on_location'] ) ? esc_sql( $_POST['enable_payment_on_location'] ) : '',
			'bb_enable_payment_via_invoice'           => isset( $_POST['enable_payment_via_invoice'] ) ? esc_sql( $_POST['enable_payment_via_invoice'] ) : '',
			'bb_payment_currency'                     => esc_sql( $_POST['payment_currency'] ),
			'bb_display_our_time'                     => isset( $_POST['display_our_time'] ) ? esc_sql( $_POST['display_our_time'] ) : '',
			'bb_display_directions'                   => isset( $_POST['display_directions'] ) ? esc_sql( $_POST['display_directions'] ) : '',
			'bb_location_address'                     => esc_sql( $_POST['location_address'] ),
			'bb_include_category'                     => isset( $_POST['include_category'] ) ? esc_sql( $_POST['include_category'] ) : '',
			'bb_include_service'                      => isset( $_POST['include_service'] ) ? esc_sql( $_POST['include_service'] ) : '',
			'bb_include_appointment_method'           => isset( $_POST['include_appointment_method'] ) ? esc_sql( $_POST['include_appointment_method'] ) : '',
			'bb_include_show_booked_time_slots'       => isset( $_POST['include_show_booked_time_slots'] ) ? esc_sql( $_POST['include_show_booked_time_slots'] ) : '',
			'bb_disable_double_booking'               => isset( $_POST['disable_double_booking'] ) ? esc_sql( $_POST['disable_double_booking'] ) : '',
			'bb_method_in_store'                      => isset( $_POST['method_in_store'] ) ? esc_sql( $_POST['method_in_store'] ) : '',
			'bb_method_at_facility'                   => isset( $_POST['method_at_facility'] ) ? esc_sql( $_POST['method_at_facility'] ) : '',
			'bb_method_online_video'                  => isset( $_POST['method_online_video'] ) ? esc_sql( $_POST['method_online_video'] ) : '',
			'bb_method_phone_call'                    => isset( $_POST['method_phone_call'] ) ? esc_sql( $_POST['method_phone_call'] ) : '',
			'bb_method_delivery'                      => isset( $_POST['method_delivery'] ) ? esc_sql( $_POST['method_delivery'] ) : '',
			'bb_collected_details_full_name'          => isset( $_POST['collected_details_full_name'] ) ? esc_sql( $_POST['collected_details_full_name'] ) : '',
			'bb_collected_details_full_name_required' => isset( $_POST['collected_details_full_name_required'] ) ? esc_sql( $_POST['collected_details_full_name_required'] ) : '',
			'bb_collected_details_email'              => isset( $_POST['collected_details_email'] ) ? esc_sql( $_POST['collected_details_email'] ) : '',
			'bb_collected_details_email_required'     => isset( $_POST['collected_details_email_required'] ) ? esc_sql( $_POST['collected_details_email_required'] ) : '',
			'bb_collected_details_phone'              => isset( $_POST['collected_details_phone'] ) ? esc_sql( $_POST['collected_details_phone'] ) : '',
			'bb_collected_details_phone_required'     => isset( $_POST['collected_details_phone_required'] ) ? esc_sql( $_POST['collected_details_phone_required'] ) : '',
			'bb_collected_details_address'            => isset( $_POST['collected_details_address'] ) ? esc_sql( $_POST['collected_details_address'] ) : '',
			'bb_collected_details_address_required'   => isset( $_POST['collected_details_address_required'] ) ? esc_sql( $_POST['collected_details_address_required'] ) : '',
			'bb_include_acknowledgement'              => isset( $_POST['include_acknowledgement'] ) ? esc_sql( $_POST['include_acknowledgement'] ) : '',
			'bb_selected_by_default_acknowledgement'  => isset( $_POST['selected_by_default_acknowledgement'] ) ? esc_sql( $_POST['selected_by_default_acknowledgement'] ) : '',
			'bb_text_entry_acknowledgement'           => $_POST['text_entry_acknowledgement'],
			'bb_conf_page_print'                      => isset( $_POST['conf_page_print'] ) ? esc_sql( $_POST['conf_page_print'] ) : '',
			'bb_conf_page_google_reminder'            => isset( $_POST['conf_page_google_reminder'] ) ? esc_sql( $_POST['conf_page_google_reminder'] ) : '',
			'bb_conf_page_support_link'               => isset( $_POST['conf_page_support_link'] ) ? esc_sql( $_POST['conf_page_support_link'] ) : '',
			'bb_conf_page_facebook_share'             => isset( $_POST['conf_page_facebook_share'] ) ? esc_sql( $_POST['conf_page_facebook_share'] ) : '',
			'bb_support_page_link'                    => esc_sql( $_POST['support_page_link'] ),
			'bb_enable_redirect'                      => isset( $_POST['enable_redirect'] ) ? esc_sql( $_POST['enable_redirect'] ) : '',
			'bb_redirect_url'                         => isset( $_POST['redirect_url'] ) ? esc_sql( $_POST['redirect_url'] ) : '',
			'bb_load_assets_on_all_pages'             => isset( $_POST['load_assets_on_all_pages'] ) ? esc_sql( $_POST['load_assets_on_all_pages'] ) : '',
			'bb_load_assets_choose_pages'             => isset( $_POST['bb_association_data_load_assets_choose_pages'] ) ? esc_sql( $_POST['bb_association_data_load_assets_choose_pages'] ) : '',
		];

		foreach ( $options as $key => $option ) {
			if ( $key === 'bb_text_entry_acknowledgement' ) {
				update_site_option( $key, stripslashes( $option ) );
			}

			update_site_option( $key, $option );
		}

		// redirect the user to the appropriate page
		wp_safe_redirect( admin_url( 'admin.php?page=brindle-booking-settings' ) );
		exit;
	} else {
		wp_die( __( 'Invalid nonce specified', 'brindle-booking' ), __( 'Error', 'brindle-booking' ), array(
			'response' 	=> 403,
			'back_link' => admin_url( 'admin.php?page=brindle-booking-settings' ),
		) );
	}
}

add_action( 'admin_post_bb_schedule_options_form', 'bb_schedule_options_form_data' );
function bb_schedule_options_form_data() {
	if ( isset( $_POST['mb_bb_schedule_form_nonce'] ) && wp_verify_nonce( $_POST['mb_bb_schedule_form_nonce'], 'mb_bb_schedule_options_nonce' ) ) {

		$options              = $_POST;
		$type                 = ! empty( $options['schedule_type'] ) ? absint( $options['schedule_type'] ) : 30;
		$user_id              = ! empty( $options['user_id'] ) && is_numeric( $options['user_id'] ) ? intval( strip_tags( $options['user_id'] ) ) : '';

		unset( $options['action'] );
		unset( $options['mb_bb_schedule_form_nonce'] );
		unset( $options['schedule_type'] );
		unset( $options['user_id'] );
		unset( $options['single_schedule'] );
		unset( $options['include_staff_member'] );

		$global_schedule = get_site_option( 'bb_single_schedule' );

		if ( empty( $global_schedule ) ) {
			if ( ! empty( $user_id ) ) {
				update_user_meta( $user_id, 'bb_schedule_type', $type );
				update_user_meta( $user_id, 'bb_schedule_slots', $options );
			}
		} else {
			update_site_option( 'bb_schedule_type', $type );
			update_site_option( 'bb_schedule_slots', $options );
		}

		$user = wp_get_current_user();

		// redirect the user to the appropriate page
		if ( empty( $global_schedule ) ) {
			if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
				wp_safe_redirect( admin_url( sprintf( 'admin.php?page=brindle-booking&type=%s&user_id=%s', $type, $user_id ) ) );
			} else {
				wp_safe_redirect( admin_url( sprintf( 'admin.php?page=brindle-booking-schedule&type=%s&user_id=%s', $type, $user_id ) ) );
			}
		} else {
			wp_safe_redirect( admin_url( sprintf( 'admin.php?page=brindle-booking-schedule&type=%s&user_id=%s', $type, $user_id ) ) );
		}

		exit;
	} else {
		wp_die( __( 'Invalid nonce specified', 'brindle-booking' ), __( 'Error', 'brindle-booking' ), array(
			'response' 	=> 403,
			'back_link' => admin_url( 'admin.php?page=brindle-booking-settings' ),
		) );
	}
}

add_action( 'admin_post_bb_notifications_options_form', 'bb_notifications_options_form_data' );
function bb_notifications_options_form_data() {
	if ( isset( $_POST['mb_bb_notifications_form_nonce'] ) && wp_verify_nonce( $_POST['mb_bb_notifications_form_nonce'], 'mb_bb_settings_options_nonce' ) ) {
		$rich_text_options = [
			'bb_admin_notification'   => isset( $_POST['admin_notification'] ) ? $_POST['admin_notification'] : '',
			'bb_visitor_notification' => isset( $_POST['visitor_notification'] ) ? $_POST['visitor_notification'] : '',
		];

		$text_options = [
			'bb_notified_admins'              => isset( $_POST['bb_association_data_notified_admins'] ) ? $_POST['bb_association_data_notified_admins'] : '',
			'bb_no_notification_admin'        => isset( $_POST['no_notification_admin'] ) ? $_POST['no_notification_admin'] : '',
			'bb_admin_notification_subject'   => isset( $_POST['admin_notification_subject'] ) ? $_POST['admin_notification_subject'] : '',
			'bb_visitor_notification_subject' => isset( $_POST['visitor_notification_subject'] ) ? $_POST['visitor_notification_subject'] : '',
			'bb_mail_name_from'               => isset( $_POST['mail_name_from'] ) ? $_POST['mail_name_from'] : '',
		];

		foreach ( $rich_text_options as $key => $option ) {
			update_site_option( $key, stripslashes( $option ) );
		}

		foreach ( $text_options as $key => $option ) {
			update_site_option( $key, $option );
		}

		// redirect the user to the appropriate page
		wp_safe_redirect( admin_url( 'admin.php?page=brindle-booking-notifications' ) );
		exit;
	} else {
		wp_die( __( 'Invalid nonce specified', 'brindle-booking' ), __( 'Error', 'brindle-booking' ), array(
			'response' 	=> 403,
			'back_link' => admin_url( 'admin.php?page=brindle-booking-notifications' ),
		) );
	}
}

add_action( 'admin_post_bb_integrations_options_form', 'bb_integrations_options_form_data' );
function bb_integrations_options_form_data() {
	if ( isset( $_POST['mb_bb_integrations_form_nonce'] ) && wp_verify_nonce( $_POST['mb_bb_integrations_form_nonce'], 'mb_bb_settings_options_nonce' ) ) {

		$text_options = [
			'bb_stripe_pk_key' => isset( $_POST['stripe_publishable_key'] ) ? esc_sql( $_POST['stripe_publishable_key'] ) : '',
			'bb_stripe_sk_key' => isset( $_POST['stripe_secret_key'] ) ? esc_sql( $_POST['stripe_secret_key'] ) : '',
		];

		foreach ( $text_options as $key => $option ) {
			update_site_option( $key, $option );
		}

		if ( ! empty( $_FILES['google_calendar_credentials'] ) ) {
			if ( ! file_exists( BB_PLUGIN_UPLOAD_DIR ) ) {
				wp_mkdir_p( BB_PLUGIN_UPLOAD_DIR );
			};

			if ( ! function_exists( 'wp_handle_upload' ) ) {
			    require_once( ABSPATH . 'wp-admin/includes/file.php' );
			}

			if ( $_FILES['google_calendar_credentials']['name'] ) {
		        $destination = trailingslashit( BB_PLUGIN_UPLOAD_DIR ) . 'credentials.json';
		        move_uploaded_file( $_FILES['google_calendar_credentials']['tmp_name'], $destination );

		        update_site_option( 'bb_gc_credentials', 'credentials.json' );
		    }
		}

		// redirect the user to the appropriate page
		wp_safe_redirect( admin_url( 'admin.php?page=brindle-booking-integrations' ) );
		exit;
	} else {
		wp_die( __( 'Invalid nonce specified', 'brindle-booking' ), __( 'Error', 'brindle-booking' ), array(
			'response' 	=> 403,
			'back_link' => admin_url( 'admin.php?page=brindle-booking-integrations' ),
		) );
	}
}

// Add the custom columns to the appointment post type:
add_filter( 'manage_bb_appointment_posts_columns', 'mbbb_set_custom_edit_book_columns' );
function mbbb_set_custom_edit_book_columns( $columns ) {
    unset( $columns['author'] );

    $columns['staff_member'] = __( 'Staff Member', 'brindle-booking' );

    return $columns;
}

// Add the data to the custom columns for the appointment post type:
add_action( 'manage_bb_appointment_posts_custom_column' , 'mbbb_custom_appointments_column', 10, 2 );
function mbbb_custom_appointments_column( $column, $post_id ) {
	switch ( $column ) {
		case 'staff_member':
		$staff_member = carbon_get_post_meta( $post_id , 'bb_staff_member' );

		if ( ! empty( $staff_member ) ) {
			echo esc_html( $staff_member );
		}

		else {
			_e( '-', 'brindle-booking' );
		}

		break;
    }
}

add_action( 'pre_get_posts', 'mbbb_filter_appointments_for_staff_members' );

function mbbb_filter_appointments_for_staff_members( $query ) {
	$user = wp_get_current_user();

	if ( empty( $user ) ) {
		return;
	}

	if ( ! in_array( 'mbbb_staff_member', $user->roles ) ) {
		return;
	}

	if ( ! is_admin() ) {
		return;
	}

	global $wp_query;

	if ( $wp_query->query['post_type'] !== 'bb_appointment' ) {
		return;
	}

	$query->set( 'meta_key', '_bb_staff_member' );
	$query->set( 'meta_value', $user->display_name );
}

function mbbb_get_supported_currencies() {
	$currencies = [
		'usd' => __( 'US Dollar', 'brindle-booking' ),
		'eur' => __( 'Euro', 'brindle-booking' ),
		'jpy' => __( 'Japanese Yen', 'brindle-booking' ),
		'gbp' => __( 'Pound sterling', 'brindle-booking' ),
		'cad' => __( 'Canadian Dollar', 'brindle-booking' ),
		'chf' => __( 'Swiss Franc', 'brindle-booking' ),
		'rub' => __( 'Russian Ruble', 'brindle-booking' ),
		'aud' => __( 'Australian Dollar', 'brindle-booking' ),
		'pln' => __( 'Polish Złoty', 'brindle-booking' ),
		'myr' => __( 'Malaysian Ringgit', 'brindle-booking' ),
		'inr' => __( 'Indian Rupee', 'brindle-booking' ),
		'czk' => __( 'Czech Koruna', 'brindle-booking' ),
		'mxn' => __( 'Mexican Peso', 'brindle-booking' ),
		'hkd' => __( 'Hong Kong Dollar', 'brindle-booking' ),
		'kes' => __( 'Kenyan Shilling', 'brindle-booking' ),
		'sek' => __( 'Swedish Krona', 'brindle-booking' ),
		'dkk' => __( 'Danish Krona', 'brindle-booking' ),
		'nok' => __( 'Norwegian Krona', 'brindle-booking' ),
		'idr' => __( 'Indonesian Rupiah', 'brindle-booking' ),
		'ron' => __( 'Romanian Leu', 'brindle-booking' ),
		'huf' => __( 'Hungarian Forint', 'brindle-booking' ),
		'brl' => __( 'Brazilian Real', 'brindle-booking' ),
		'zar' => __( 'South African Rand', 'brindle-booking' ),
		'sgd' => __( 'Singapore Dollar', 'brindle-booking' ),
		'php' => __( 'Philippine Peso', 'brindle-booking' ),
	];

	return $currencies;
}

function mbbb_get_supported_currency_signs() {
	$currencies = [
		'usd' => '$',
		'eur' => '€',
		'jpy' => '¥',
		'gbp' => '£',
		'cad' => 'A$',
		'chf' => 'Fr',
		'rub' => '₽',
		'aud' => '$',
		'pln' => 'zł',
		'myr' => 'RM',
		'inr' => '₹',
		'czk' => 'Kč',
		'mxn' => 'Mex$',
		'hkd' => 'HK$',
		'kes' => 'Ksh',
		'sek' => 'kr',
		'dkk' => 'Kr.',
		'nok' => 'kr',
		'idr' => 'Rp',
		'ron' => 'lei',
		'huf' => 'Ft',
		'brl' => 'R$',
		'zar' => 'R',
		'sgd' => 'S$',
		'php' => '₱',
	];

	return $currencies;
}