<?php

use Stripe\Stripe;
use Stripe\StripeClient;
use Stripe\Customer;

add_action( 'after_setup_theme', 'bb_add_brindle_booking_options' );

function bb_add_brindle_booking_options() {

	require_once( 'vendor/autoload.php' );
	\Carbon_Fields\Carbon_Fields::boot();

	# Attach Custom Post Types
	include_once( BB_PLUGIN_DIR . 'options/post-types.php' );

	# Attach Custom Taxonomies
	include_once( BB_PLUGIN_DIR . 'options/taxonomies.php' );

	include_once( BB_PLUGIN_DIR . 'options/post-meta.php' );

	include_once( BB_PLUGIN_DIR . 'includes/google-calendar.php' );
	include_once( BB_PLUGIN_DIR . 'includes/shortcodes.php' );

}
/*
 * Load plugin textdomain.
 */

function mbbb_plugin_load_textdomain() {
	load_plugin_textdomain( 'brindle-booking', false, basename( dirname( __FILE__ ) ) . '/languages/' );
}

add_action( 'init', 'mbbb_plugin_load_textdomain' );

// Render Booking Popup Front-End
add_action( 'wp_footer', 'bb_render_popup' );

function bb_render_popup() {
	$load_on_all_pages = get_site_option( 'bb_load_assets_on_all_pages', 'load_assets_on_all_pages_yes' );

	if ( $load_on_all_pages !== 'load_assets_on_all_pages_yes' ) {
		$page_id = get_the_ID();
		$selected_posts = get_site_option( 'bb_load_assets_choose_pages', '' );

		if ( empty( $selected_posts ) ) {
			return;
		}

		$selected_posts = explode( '|', $selected_posts );

		if ( ! in_array( strval( $page_id ), $selected_posts ) ) {
			return;
		}
	}
	
	require_once( BB_PLUGIN_DIR . 'fragments/booking-popup.php' );
}

/**
 * Register My Brindle Tab.
 */
if ( ! function_exists( 'mb_register_menu_page_brindle' ) ) {
	function mb_register_menu_page_brindle() {
		
		$capabilities = 'manage_options';

		$user = wp_get_current_user();

		if ( in_array( 'mbbb_staff_member', $user->roles ) ) {
			$capabilities = 'read';
		}
		
		add_menu_page(
			'My Brindle',
			'My Brindle',
			$capabilities,
			'my-brindle.php',
			'',
			plugin_dir_url( __FILE__ ) . 'images/wp-icon.png',
			75
		);
	}

	add_action( 'admin_menu', 'mb_register_menu_page_brindle' );
}

add_action( 'admin_enqueue_scripts', 'bb_enqueue_files_admin' );

function bb_enqueue_files_admin() {

	/*
	 * Load default WordPress thickbox for popups.
	 */
	wp_enqueue_style( 'thickbox' );

	/*
	 * Load default WordPress Color Picker.
	 */
	wp_enqueue_style( 'wp-color-picker');

	$admin_js_dir = BB_PLUGIN_DIR . 'js/admin.js';
	$add_category_ajax_js = BB_PLUGIN_DIR . 'js/admin/add-category-ajax.js';
	$delete_category_ajax_js = BB_PLUGIN_DIR . 'js/admin/delete-category-ajax.js';
	$category_drag_and_drop = BB_PLUGIN_DIR . 'js/admin/category-order.js';
	$add_service_ajax_js = BB_PLUGIN_DIR . 'js/admin/add-service-ajax.js';
	$edit_service_ajax_js = BB_PLUGIN_DIR . 'js/admin/edit-service-ajax.js';
	$delete_service_ajax_js = BB_PLUGIN_DIR . 'js/admin/delete-service-ajax.js';
	$services_drag_and_drop = BB_PLUGIN_DIR . 'js/admin/services-order.js';
	$services_bulk_delete = BB_PLUGIN_DIR . 'js/admin/services-bulk-delete.js';

	wp_enqueue_script( 'bb-admin-js', plugins_url('js/admin.js', __FILE__ ), [ 'wp-color-picker', 'thickbox' ], filemtime( $admin_js_dir ), true );
	wp_enqueue_script( 'bb-delete-category-ajax-js', plugins_url('js/admin/delete-category-ajax.js', __FILE__ ), [ 'jquery', 'bb-admin-js' ], filemtime( $delete_category_ajax_js ), true );
	wp_enqueue_script( 'bb-add-category-ajax-js', plugins_url('js/admin/add-category-ajax.js', __FILE__ ), [ 'jquery', 'bb-admin-js' ], filemtime( $add_category_ajax_js ), true );
	wp_enqueue_script( 'bb-category-order', plugins_url('js/admin/category-order.js', __FILE__ ), [ 'jquery', 'bb-admin-js', 'jquery-ui-sortable', 'jquery-ui-draggable' ], filemtime( $category_drag_and_drop ), true );
	wp_enqueue_script( 'bb-add-service-ajax', plugins_url('js/admin/add-service-ajax.js', __FILE__ ), [ 'jquery', 'bb-admin-js' ], filemtime( $add_service_ajax_js ), true );
	wp_enqueue_script( 'bb-edit-service-ajax', plugins_url('js/admin/edit-service-ajax.js', __FILE__ ), [ 'jquery', 'bb-admin-js' ], filemtime( $edit_service_ajax_js ), true );
	wp_enqueue_script( 'bb-delete-service-ajax', plugins_url('js/admin/delete-service-ajax.js', __FILE__ ), [ 'jquery', 'bb-admin-js' ], filemtime( $add_service_ajax_js ), true );
	wp_enqueue_script( 'bb-services-order', plugins_url('js/admin/services-order.js', __FILE__ ), [ 'jquery', 'bb-admin-js', 'jquery-ui-sortable', 'jquery-ui-draggable' ], filemtime( $services_drag_and_drop ), true );
	wp_enqueue_script( 'bb-services-bulk-delete', plugins_url('js/admin/services-bulk-delete.js', __FILE__ ), [ 'jquery', 'bb-admin-js', 'jquery-ui-sortable', 'jquery-ui-draggable' ], filemtime( $services_bulk_delete ), true );

	wp_localize_script( 'bb-admin-js', 'bb_site_ajax', [
		'ajaxurl' => admin_url( 'admin-ajax.php'),
	] );

	$admin_style_dir = BB_PLUGIN_DIR . 'css/admin-style.css';

	wp_enqueue_style( 'bb-admin-styles', plugins_url( 'css/admin-style.css', __FILE__ ), null, filemtime( $admin_style_dir ) );	
	wp_enqueue_style( 'bb-admin-font-styles', 'https://use.typekit.net/eip0gix.css' );	
}

add_action( 'admin_menu', 'bb_modify_menu_class', 90 );
function bb_modify_menu_class() {
	global $menu;
	global $submenu;

	$subpages = [
		'brindle-booking-calendar',
		'brindle-booking',
		'brindle-booking-design',
		'brindle-booking-settings',
		'brindle-booking-schedule',
	];

	global $current_screen;

	$current_page = isset( $_GET['page'] ) && in_array( $_GET['page'], $subpages ) ? true : false;
	$post_type    = isset( $_GET['post'] ) && get_post_type( $_GET['post'] ) === 'bb_appointment' ? true : false;

	foreach( $menu as $key => $value ) {
		if ( 'My Brindle' === $value[0] && ( $current_page || $post_type ) ) {
			$menu[$key][4] .= ' wp-has-current-submenu';
		}
	}
}

function mbbb_appntm_email_template_replace_shortcodes( $email_content = '', $data = [], $for = 'admin' ) {
	if ( empty( $email_content ) ) {
		return '';
	}

	$shortcodes = [
		'[date]'                  => $data['date'],
		'[time]'                  => $data['time'],
		'[staff member]'          => $data['staff_member'],
		'[category]'              => $data['category'],
		'[name]'                  => $data['name'],
		'[email]'                 => $data['email'],
		'[phone]'                 => $data['phone'],
		'[address]'               => $data['address'],
		'[service]'               => $data['service'],
		'[site link]'             => sprintf( '<a href="%s">%s</a>', get_home_url(), get_bloginfo( 'name' ) ),
		'[zoom link]'             => property_exists( $data['zoom'], 'join_url' ) ? sprintf( '<a target="_blank" href="%s">%s</a>', $data['zoom']->join_url, __( 'Zoom Meeting Link', 'brindle-booking' ) ) : '',
	];

	ob_start();

	$category       = $data['category'];
	$service_title  = $data['service'];
	$service_price  = $data['service_price'];
	$staff_member   = $data['staff_member'];
	$time           = $data['time'];
	$date_string    = $data['date_string'];
	$show_slots     = $data['show_slots'];
	$start_hour     = $data['start_hour'];
	$end_hour       = $data['end_hour'];
	$location       = $data['location'];
	$show_on_map    = $data['show_on_map'];
	$payment_method = $data['payment_method'];
	$service        = $data['service'];
	$name           = $data['name'];
	$email          = $data['email'];
	$phone          = $data['phone'];
	$address        = $data['address'];
	$zoom_link      = property_exists( $data['zoom'], 'join_url' ) ? sprintf( '<a target="_blank" href="%s">%s</a>', $data['zoom']->join_url, __( 'Zoom Meeting Link', 'brindle-booking' ) ) : '';

	include BB_PLUGIN_DIR . 'fragments/email/confirmation/common/details-table.php';

	$details = ob_get_contents();

	ob_end_clean();

	$shortcodes['[details]'] = $details;

	if ( $for === 'admin' ) {
		$shortcodes['{View Appointment Link}'] = sprintf( '<a href="%s">%s</a>', get_edit_post_link( $data['appointment_id'] ), __( 'View Appointment', 'brindle-booking' ) );
	} else {
		$shortcodes['{View Appointment Link}'] = sprintf( '<a href="%s">%s</a>', get_home_url(), __( 'View Appointment', 'brindle-booking' ) );
	}

	foreach ( $shortcodes as $shortcode => $value ) {
		$email_content = str_replace( $shortcode, $value, $email_content );
	}

	return $email_content;
}

require_once( BB_PLUGIN_DIR . 'includes/wp-ajax.php' );

require_once( BB_PLUGIN_DIR . 'includes/staff-members.php' );

require_once( BB_PLUGIN_DIR . 'includes/zoom.php' );

add_filter( 'wp_mail_from_name', 'mbbb_modify_email_from' );
function mbbb_modify_email_from( $from_name ) {
	$from_name = get_site_option( 'bb_mail_name_from', 'WordPress' );

	if ( empty( $from_name ) ) {
		$from_name = 'WordPress';
	}

    return $from_name;
}

function mbbb_cron_schedules( $schedules ) {
	if( ! isset( $schedules['55min'] ) ){
		$schedules['55min'] = array(
			'interval' => 55*60,
			'display' => __( 'Once every 55 minutes' )
		);
	}

	if( ! isset( $schedules['1min'] ) ){
		$schedules['1min'] = array(
			'interval' => 60,
			'display' => __( 'Once every 1 minute' )
		);
	}

	return $schedules;
}

add_filter( 'cron_schedules', 'mbbb_cron_schedules' );

add_action( 'mbbb_refresh_access_token_55_min', 'mbbb_refresh_access_token' );


$users = get_users( [
	'role__in'    => [ 'administrator', 'mbbb_staff_member' ],
	'orderby' => 'user_nicename',
	'order'   => 'ASC'
] );

foreach ( $users as $user ) {
	add_action( 'mbbb_google_api_refresh_access_token_55_min_' . strval( $user->ID ), 'mbbb_google_api_refresh_access_token' );
}
