<?php

$days = [
	'mon' => 'Monday',
	'tue' => 'Tuesday',
	'wed' => 'Wednesday',
	'thu' => 'Thursday',
	'fri' => 'Friday',
	'sat' => 'Saturday',
	'sun' => 'Sunday',
];

$is_global_schedule = get_site_option( 'bb_single_schedule' );

if ( empty( $is_global_schedule ) ) {
	$saved_slots = get_user_meta( $staff_member, 'bb_schedule_slots', true );

	$type_option = get_user_meta( $staff_member, 'bb_schedule_type' );
	$type_option = $type_option[0];
} else {
	$type_option = absint( get_site_option( 'bb_schedule_type' ) );
	$saved_slots = get_site_option( 'bb_schedule_slots' );
}

$prev_day_abbr = array_search( date( 'l', $prev_date ), $days );

$has_slots_prev_day = false;

foreach ( $saved_slots as $key => $value ) {
	$keys_array = explode( '_', $key );

	if ( $keys_array[0] === $prev_day_abbr ) {
		$has_slots_prev_day    = true;

		break;
	}
}

$atts = bb_get_appointments_atts( $cat_id, $service_id, date( 'Y-m-d', $prev_date ) );

?>

<div class="bb-tab-schedule">
	<?php if ( $has_slots_prev_day ) : ?>
		<ol class="bb-list-times">
			<?php foreach ( $saved_slots as $key => $value ) : ?>
				<?php if ( strpos( $key, $prev_day_abbr ) !== false ) : ?>
					<?php
					$values     = explode( '_', $key );
					$start_hour = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
					$end_hour   = date( 'g:ia', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );


					if ( ! empty( $hour_standard_24 ) ) {
						$start_hour = date( 'H:i', strtotime( $start_hour ) );
						$end_hour   = date( 'H:i', strtotime( $end_hour ) );
					}

					$is_booked = false;
					$is_expire = false;

					if ( in_array( $key, $atts['slots'] ) && in_array( date( 'Y-m-d', $prev_date ), $atts['dates'] ) ) {
						if ( empty( get_site_option( 'bb_include_show_booked_time_slots', true ) ) ) {
							continue;
						}

						$is_booked = true;
					}

					if ( strtotime( date( 'j-m-Y', time() ) ) > strtotime( date( 'j-m-Y', $prev_date ) ) ) {
						$is_expire = true;
					}
					?>
					<li data-time="<?php echo $key; ?>" class="<?php echo $is_booked || $is_expire ? 'bb-is-disabled' : ''; ?> js-select-time-of-day">
						<a href="#">
							<span><?php printf( '%s - %s', $start_hour, $end_hour ); ?></span>

							<?php if ( $is_booked ) : ?>
								<span><?php _e( 'Booked', 'brindle-booking' ); ?></span>
							<?php endif ?>
						</a>
					</li>
				<?php endif ?>
			<?php endforeach ?>
		</ol><!-- /.bb-list-times -->
	<?php else: ?>
		<p class="bb-booking-slots-message"><?php echo __( 'No time slots for this date.' ); ?></p>
	<?php endif; ?>
</div><!-- /.bb-tab-schedule -->