<?php

$main_color   = ! empty( get_site_option( 'bb_main_color', true ) ) ? get_site_option( 'bb_main_color', true ) : '#01bae8';
$accent_color = ! empty( get_site_option( 'bb_accent_color', true ) ) ? get_site_option( 'bb_accent_color', true ) : '#ff1b63';
$titles_color = ! empty( get_site_option( 'bb_titles_color', true ) ) ? get_site_option( 'bb_titles_color', true ) : '#01bae8';

$selected_staff_member = get_user_by( 'id', $staff_member );

$currency = get_site_option( 'bb_payment_currency' );

$supported_currencies = mbbb_get_supported_currencies();

if ( ! array_key_exists( $currency, $supported_currencies ) ) {
	$currency = 'usd';
}

$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

?>

<section class="bb-section-confirmation">
	<header class="bb-section__head">
		<h2 style="color: <?php echo $accent_color ?>"><?php echo __( 'Appointment Confirmed!', 'brindle-booking' ) ?></h2>

		<h3><?php echo __( 'An email confirmation has been sent to your email.', 'brindle-booking' ) ?></h3>
	</header><!-- /.bb-section__head -->

	<div class="bb-section__body">
		<div class="bb-table">
			<div class="table">
				<table>
					<?php if ( ! empty( $selected_staff_member ) ) : ?>
						<tr>
							<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Staff Member', 'brindle-booking' ); ?></td>

							<td><?php echo $selected_staff_member->display_name ?></td>
						</tr>
					<?php endif; ?>

					<?php if ( ! empty( $category ) ) : ?>
						<tr>
							<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Category', 'brindle-booking' ); ?></td>

							<td><?php esc_html_e( $category ); ?></td>
						</tr>
					<?php endif ?>

					<?php if ( ! empty( $service_title ) ) : ?>
						<tr>
							<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Service', 'brindle-booking' ); ?></td>

							<td>
								<?php esc_html_e( $service_title ); ?>

								<?php if ( ! empty( $service_price ) ) : ?>
									<?php printf( '| %s%s', $currency_sign, strval( round( floatval( $service_price ), 2 ) ) ) ?>
								<?php endif ?>
							</td>
						</tr>
					<?php endif ?>

					<tr>
						<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Date', 'brindle-booking' ); ?></td>

						<td><?php echo $date_string; ?></td>
					</tr>

					<?php if ( ! empty( $show_slots ) ) : ?>
						<tr>
							<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Time', 'brindle-booking' ); ?></td>

							<td><?php printf( '%s - %s', $start_hour, $end_hour ); ?></td>
						</tr>
					<?php endif ?>


					<?php if ( ! empty( $location ) ) : ?>
						<tr>
							<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Location', 'brindle-booking' ); ?></td>

							<td>
								<?php esc_html_e( $location ); ?>

								<?php if ( ! empty( $show_on_map ) ) : ?>
									<i class="bb-ico-pin"></i> <a href="<?php echo esc_url( 'https://www.google.com/maps/search/' . urldecode( $location ) .'/') ?>" target="_blank"><?php _e( 'Directions', 'brindle-booking' ); ?></a>
								<?php endif ?>
							</td>
						</tr>
					<?php endif ?>

					<?php if ( ! empty( $payment_method ) ): ?>
						<tr>
							<td style="color: <?php echo $titles_color ?>"><?php _e( 'Payment Method', 'brindle-booking' ) ?></td>

							<td>
								<?php if ( $payment_method === 'stripe' ) : ?>
									<?php _e( 'Paid in full via Credit Card', 'brindle-booking' ); ?>
								<?php elseif ( $payment_method === 'with_invoice' ) : ?>
									<?php _e( 'Payment with Invoice Later', 'brindle-booking' ); ?>
								<?php else : ?>
									<?php _e( 'Payment on location', 'brindle-booking' ); ?>
								<?php endif ?>
							</td>
						</tr>
					<?php endif; ?>

					<?php if ( ! empty( $zoom_meeting ) && property_exists( $zoom_meeting, 'join_url' ) ) : ?>
						<tr>
							<td style="color: <?php echo $titles_color ?>"><?php _e( 'Zoom', 'brindle-booking' ) ?></td>

							<td>
								<?php printf( '<a target="_blank" href="%s">%s</a>', $zoom_meeting->join_url, __( 'Zoom Meeting Link', 'brindle-booking' ) ); ?>
							</td>
						</tr>
					<?php endif; ?>
				</table>
			</div><!-- /.table -->
		</div><!-- /.bb-table -->
	</div><!-- /.bb-section__body -->

	<?php
	$print       = get_site_option( 'bb_conf_page_print', true );
	$reminder    = get_site_option( 'bb_conf_page_google_reminder', true );
	$support     = get_site_option( 'bb_support_page_link', true );
	$support_url = get_site_option( 'bb_support_page_link', true );
	$fb_share    = get_site_option( 'bb_conf_page_facebook_share', true );

	if ( ! empty( $print ) || ! empty( $reminder ) || ! empty( $support ) || ! empty( $fb_share ) ) :
	?>
		<footer class="bb-section__foot">
			<div class="bb-btns-list">
				<ul>
					<?php if ( ! empty( $print ) ) : ?>
						<li>
							<a href="#" class="bb-btn-complex js-print">
								<i class="bb-ico-print"></i>

								<span><?php _e( 'Print this Confirmation', 'brindle-booking' ); ?></span>
							</a>
						</li>
					<?php endif ?>

					<?php if ( ! empty( $reminder ) ) : ?>
						<li>
							<a
							target="_blank"
							href="<?php echo esc_url( add_query_arg( mbbb_get_appointment_reminder_args( $appointment ), 'https://mybrindle.com/google-calendar/google-authorize.php' ) ); ?>"
							class="bb-btn-complex">
								<i class="bb-ico-reminder"></i>

								<span><?php _e( 'Set Reminder on Google Calendar', 'brindle-booking' ); ?></span>
							</a>
						</li>
					<?php endif ?>

					<?php if ( ! empty( $support ) && ! empty( $support_url ) ) : ?>
						<li>
							<a target="_blank" href="<?php echo esc_url( $support_url ); ?>" class="bb-btn-complex" target="_blank">
								<i class="bb-ico-phone"></i>

								<span><?php _e( 'Questions? Get In Touch Here', 'brindle-booking' ); ?></span>
							</a>
						</li>
					<?php endif ?>

					<?php if ( ! empty( $fb_share ) ) : ?>
						<li>
							<a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode( get_permalink( $service_id ) ); ?>" class="bb-btn-complex" target="_blank">
								<i class="bb-ico-share"></i>

								<span><?php _e( 'Share This Appointment', 'brindle-booking' ); ?></span>
							</a>
						</li>
					<?php endif ?>
				</ul>
			</div><!-- /.bb-btns-list -->
		</footer><!-- /.bb-section__foot -->
	<?php endif ?>
</section><!-- /.bb-section-confirmation -->