<?php

$main_color   = ! empty( get_site_option( 'bb_main_color', true ) ) ? get_site_option( 'bb_main_color', true ) : '#01bae8';
$accent_color = ! empty( get_site_option( 'bb_accent_color', true ) ) ? get_site_option( 'bb_accent_color', true ) : '#ff1b63';
$titles_color = ! empty( get_site_option( 'bb_titles_color', true ) ) ? get_site_option( 'bb_titles_color', true ) : '#01bae8';

$selected_staff_member = get_user_by( 'id', $staff_member );

$currency = get_site_option( 'bb_payment_currency' );

$supported_currencies = mbbb_get_supported_currencies();

if ( ! array_key_exists( $currency, $supported_currencies ) ) {
	$currency = 'usd';
}

$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

?>

<style type="text/css" media="screen">
	.bb-section-payment .bb-section__aside > h4 { color: <?php echo $titles_color; ?>; }
</style>

<section class="bb-section-payment">
	<div class="bb-section__row">
		<div class="bb-section__content">
			<div class="bb-list-inputs">
				<ul>
					<?php foreach ( $fields as $key => $field ) : ?>
						<?php if ( ! empty( $field['active'] ) ) : ?>
							<li>
								<div class="bb-form-controls">
									<label style="color: <?php echo $titles_color ?>" for="<?php echo $key; ?>">
										<?php printf( '%s%s', $field['label'], ! empty( $field['required'] ) ? '*' : '' ); ?>
									</label>

									<div class="bb-input">
										<div class="bb-field">
											<input
											data-validate="true"
											data-type="<?php echo str_replace( 'bb-form-payment-', '', $key ); ?>"
											type="text" id="<?php echo $key; ?>" placeholder="<?php esc_attr_e( $field['placeholder'] ); ?>" <?php ! empty( $field['required'] ) ? 'required' : ''; ?>>
										</div><!-- /.bb-field -->
									</div><!-- /.bb-input -->
								</div><!-- /.bb-form-controls -->
							</li>
						<?php endif ?>
					<?php endforeach ?>
				</ul>
			</div><!-- /.bb-list-inputs -->
		</div><!-- /.bb-section__content -->

		<aside class="bb-section__aside">
			<h4><?php _e( 'Appointment Details', 'brindle-booking' ); ?></h4>

			<div class="bb-table">
				<div class="table">
					<table>
						<?php if ( ! empty( $selected_staff_member ) ) : ?>
							<tr>
								<td><?php _e( 'Staff Member', 'brindle-booking' ); ?></td>

								<td><?php echo $selected_staff_member->display_name ?></td>
							</tr>
						<?php endif; ?>

						<?php if ( ! empty( $category ) ) : ?>
							<tr>
								<td><?php _e( 'Category', 'brindle-booking' ); ?></td>

								<td><?php esc_html_e( $category ); ?></td>
							</tr>
						<?php endif ?>

						<?php if ( ! empty( $service_title ) ) : ?>
							<tr>
								<td><?php _e( 'Service', 'brindle-booking' ); ?></td>

								<td>
									<?php esc_html_e( $service_title ); ?>

									<?php if ( ! empty( $service_price ) ) : ?>
										<?php printf( '| %s%s', $currency_sign, strval( round( floatval( $service_price ), 2 ) ) ) ?>
									<?php endif ?>
								</td>
							</tr>
						<?php endif ?>

						<tr>
							<td><?php _e( 'Date', 'brindle-booking' ); ?></td>

							<td><?php echo $date_string; ?></td>
						</tr>

						<?php if ( ! empty( $show_slots ) ) : ?>
							<tr>
								<td><?php _e( 'Time', 'brindle-booking' ); ?></td>

								<td><?php printf( '%s - %s', $start_hour, $end_hour ); ?></td>
							</tr>
						<?php endif ?>

						<?php if ( ! empty( $location ) ) : ?>
							<tr>
								<td><?php _e( 'Location', 'brindle-booking' ); ?></td>

								<td>
									<?php esc_html_e( $location ); ?>

									<?php if ( ! empty( $show_on_map ) ) : ?>
										<i class="bb-ico-pin"></i> <a href="<?php echo esc_url( 'https://www.google.com/maps/search/' . urldecode( $location ) .'/') ?>" target="_blank"><?php _e( 'Directions', 'brindle-booking' ); ?></a>
									<?php endif ?>
								</td>
							</tr>
						<?php endif ?>
					</table>
				</div><!-- /.table -->
			</div><!-- /.bb-table -->
		</aside><!-- /.bb-section__aside -->
	</div><!-- /.bb-section__row -->

	<?php if ( ! empty( $service_price ) ) : ?>
		<?php if ( ! empty( $online_payments ) || ! empty( $on_location ) || ! empty( $via_invoice ) ): ?>
			<div class="bb-section__row">
				<div class="bb-section__content">
					<div class="bb-list-inputs">
						<ul>
							<li>
								<div class="bb-form-controls">
									<label style="color: <?php echo $titles_color ?>" for="<?php echo $key; ?>">
										<?php _e( 'Payment Method', 'brindle-booking' ); ?>
									</label>

									<div class="bb-field">
										<div class="bb-select">
											<select
											data-validate="true"
											data-type="payment-method"
											name="payment_method" id="payment_method">
												<option value="0"><?php _e( 'Select a Payment Method', 'brindle-booking' ); ?></option>
												<?php if ( ! empty( $online_payments ) && ! empty( $pk_key ) && ! empty( $sk_key ) ) : ?>
													<option value="stripe"><?php _e( 'Credit Card (100% secure via Stripe)', 'brindle-booking' ); ?></option>
												<?php endif; ?>
												<?php if ( ! empty( $on_location ) ) : ?>
													<option value="on_location"><?php _e( 'Pay on Location', 'brindle-booking' ); ?></option>
												<?php endif; ?>
												<?php if ( ! empty( $via_invoice ) ) : ?>
													<option value="with_invoice"><?php _e( 'Pay via Invoice Later', 'brindle-booking' ); ?></option>
												<?php endif; ?>
											</select>
										</div><!-- /.bb-input -->
									</div><!-- /.bb-field -->
								</div><!-- /.bb-form-controls -->
							</li>
						</ul>
					</div><!-- /.bb-list-inputs -->
				</div><!-- /.bb-section__content -->

				<aside class="bb-section__aside bb-section__aside--payment"></aside><!-- /.bb-section__aside -->
			</div><!-- /.bb-section__row -->
		<?php endif ?>
	<?php endif; ?>

	<?php if ( ! empty( $include_agreement ) && ! empty( $text_entry_agreement ) ) : ?>
		<div class="bb-section__row">
			<div class="bb-list-inputs">
				<ul>
					<li>
						<div class="bb-form-controls">
							<div class="bb-field">
								<input
								data-validate="true"
								data-type="agreement-checkbox"
								id="bb-form-payment-agreement-checkbox" name="bb-form-payment-agreement-checkbox" type="checkbox" class="bb-checkbox" <?php echo ! empty( $selected_by_default_agreement ) ? 'checked' : ''; ?>>

								<label class="bb-checkbox-label" for="bb-form-payment-agreement-checkbox"><?php echo apply_filters( 'the_content', $text_entry_agreement ); ?></label>
							</div><!-- /.bb-field -->
						</div><!-- /.bb-form-controls -->
					</li>
				</ul>
			</div><!-- /.bb-list-inputs -->
		</div><!-- /.bb-section__row -->
	<?php endif; ?>
</section><!-- /.bb-section-payment -->