<?php

$main_color   = ! empty( get_site_option( 'bb_main_color', true ) ) ? get_site_option( 'bb_main_color', true ) : '#01bae8';
$accent_color = ! empty( get_site_option( 'bb_accent_color', true ) ) ? get_site_option( 'bb_accent_color', true ) : '#ff1b63';
$titles_color = ! empty( get_site_option( 'bb_titles_color', true ) ) ? get_site_option( 'bb_titles_color', true ) : '#01bae8';

$currency = get_site_option( 'bb_payment_currency' );

$supported_currencies = mbbb_get_supported_currencies();

if ( ! array_key_exists( $currency, $supported_currencies ) ) {
	$currency = 'usd';
}

$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

$hour_standard_12 = get_site_option( 'bb_schedule_12_hour_standard' );
$hour_standard_24 = get_site_option( 'bb_schedule_24_hour_standard' );

?>

<style type="text/css" media="screen">
	.bb-section-time .bb-section__head h2 { color: <?php echo $titles_color;?>; }
	.bb-list-times li.bb-is-selected a,
	.bb-list-times a:hover { background-color: <?php echo $accent_color; ?>; border-color: <?php echo $accent_color; ?>; }
</style>

<section class="bb-section-time">
	<header class="bb-section__head">
		<p>
			<?php _e( 'You are booking:', 'brindle-booking' ); ?>
			<strong>
				<?php echo $category; ?><i style="border-color: transparent transparent transparent <?php echo $main_color;?>" class="bb-ico-right" aria-hidden="true"></i><?php echo $service_title; ?>

				<?php if ( ! empty( $service_price ) ) : ?>
					<?php printf( '| %s%s', $currency_sign, strval( round( floatval( $service_price ), 2 ) ) ) ?>
				<?php endif ?>

				<?php if ( ! empty( $staff_member ) && is_numeric( $staff_member ) ) :

				$user = get_user_by( 'id', intval( esc_sql( $staff_member ) ) );

				?>
					<i style="border-color: transparent transparent transparent <?php echo $main_color;?>" class="bb-ico-right" aria-hidden="true"></i>
					<?php echo $user->display_name; ?>
				<?php endif ?>
			</strong>
		</p>

		<div class="bb-slider-default js-slider-default">
			<div class="bb-slider__inner">
				<div class="bb-slider__clip">
					<div class="bb-slider__slides">
						<div data-past="<?php echo $prev_date < strtotime( date( 'd F Y' ) ) ? 'true' : 'false' ?>" class="bb-slider__slide" data-date="<?php echo date( 'Y-m-d', $prev_date ) ?>">
							<h2><?php echo wp_date( 'l F jS, Y', $prev_date ) ?></h2>
						</div><!-- /.bb-slider__slide -->

						<div class="bb-slider__slide bb-is-active" data-date="<?php echo $date; ?>">
							<h2><?php echo wp_date( 'l F jS, Y', strtotime( $date ) ) ?></h2>
						</div><!-- /.bb-slider__slide -->

						<div class="bb-slider__slide" data-date="<?php echo date( 'Y-m-d', $next_date ) ?>">
							<h2><?php echo wp_date( 'l F jS, Y', $next_date ); ?></h2>
						</div><!-- /.bb-slider__slide -->
					</div><!-- /.bb-slider__slides -->
				</div><!-- /.bb-slider__clip -->

				<div class="bb-slider__actions">
					<a href="#" class="bb-slider__prev js-slide-prev" data-disabled="<?php echo $prev_date < strtotime( date( 'd F Y' ) ) ? 'true' : 'false' ?>">
						<span aria-hidden="true"></span>
					</a>

					<a href="#" class="bb-slider__next js-slide-next">
						<span aria-hidden="true"></span>
					</a>
				</div><!-- /.bb-slider__actions -->
			</div><!-- /.bb-slider__inner -->

			<input type="hidden" name="bb-calendar-dates-field" id="bb-slider-dates-field" value="<?php echo date( 'l F jS, Y', strtotime( $date ) ) ?>">
		</div><!-- /.bb-slider-default -->
	</header><!-- /.bb-section__head -->

	<div class="bb-section__body">
		<div class="bb-tabs-schedule">
			<div class="bb-tab-schedule">
				<?php if ( $has_slots_prev_day ) : ?>
					<ol class="bb-list-times">
						<?php foreach ( $saved_slots as $key => $value ) : ?>
							<?php if ( strpos( $key, $prev_day_abbr ) !== false ) : ?>
								<?php
								$values     = explode( '_', $key );
								$start_hour = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
								$end_hour   = date( 'g:ia', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );


								if ( ! empty( $hour_standard_24 ) ) {
									$start_hour = date( 'H:i', strtotime( $start_hour ) );
									$end_hour   = date( 'H:i', strtotime( $end_hour ) );
								}

								$is_booked = false;
								$is_expire = false;

								if ( in_array( $key, $prev_atts['slots'] ) && in_array( date( 'Y-m-d', $prev_date ), $prev_atts['dates'] ) ) {
									if ( empty( get_site_option( 'bb_include_show_booked_time_slots', true ) ) ) {
										continue;
									}

									$is_booked = true;
								}

								if ( strtotime( date( 'j-m-Y', time() ) ) > strtotime( date( 'j-m-Y', $prev_date ) ) ) {
									$is_expire = true;
								}
								?>
								<li data-time="<?php echo $key; ?>" class="<?php echo $is_booked || $is_expire ? 'bb-is-disabled' : ''; ?> js-select-time-of-day">
									<a href="#">
										<span><?php printf( '%s - %s', $start_hour, $end_hour ); ?></span>

										<?php if ( $is_booked ) : ?>
											<span><?php _e( 'Booked', 'brindle-booking' ); ?></span>
										<?php endif ?>
									</a>
								</li>
							<?php endif ?>
						<?php endforeach ?>
					</ol><!-- /.bb-list-times -->
				<?php else: ?>
					<p class="bb-booking-slots-message"><?php echo __( 'No time slots for this date.' ); ?></p>
				<?php endif; ?>
			</div><!-- /.bb-tab-schedule -->

			<div class="bb-tab-schedule bb-is-active">
				<?php if ( $has_slots_today ): ?>
					<ol class="bb-list-times">
						<?php foreach ( $saved_slots as $key => $value ) : ?>
							<?php if ( strpos( $key, $day_abbr ) !== false ) : ?>
								<?php
								$values     = explode( '_', $key );
								$start_hour = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
								$end_hour   = date( 'g:ia', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );

								if ( ! empty( $hour_standard_24 ) ) {
									$start_hour = date( 'H:i', strtotime( $start_hour ) );
									$end_hour   = date( 'H:i', strtotime( $end_hour ) );
								}

								$is_booked = false;
								$is_expire = false;

								if ( in_array( $key, $atts['slots'] ) && in_array( date( 'Y-m-d', strtotime( $date ) ), $atts['dates'] ) ) {
									if ( empty( get_site_option( 'bb_include_show_booked_time_slots', true ) ) ) {
										continue;
									}

									$is_booked = true;
								}

								if ( strtotime( date( 'j-m-Y', time() ) ) > strtotime( date( 'j-m-Y', strtotime( $date ) ) ) ) {
									$is_expire = true;
								}

								?>
								<li data-time="<?php echo $key; ?>" class="<?php echo $is_booked || $is_expire ? 'bb-is-disabled' : ''; ?> js-select-time-of-day">
									<a href="#">
										<span><?php printf( '%s - %s', $start_hour, $end_hour ); ?></span>

										<?php if ( $is_booked ) : ?>
											<span><?php _e( 'Booked', 'brindle-booking' ); ?></span>
										<?php endif ?>
									</a>
								</li>
							<?php endif; ?>
						<?php endforeach ?>
					</ol><!-- /.bb-list-times -->
				<?php else: ?>
					<p class="bb-booking-slots-message"><?php echo __( 'No time slots for this date.' ); ?></p>
				<?php endif; ?>
			</div><!-- /.bb-tab-schedule -->

			<div class="bb-tab-schedule">
				<?php if ( $has_slots_next_day ): ?>
					<ol class="bb-list-times">
						<?php foreach ( $saved_slots as $key => $value ) : ?>
							<?php if ( strpos( $key, $next_day_abbr ) !== false ) : ?>
								<?php
								$values     = explode( '_', $key );
								$start_hour = date( 'g:ia', strtotime( $values[2] . ':' . $values[3] . $values[1] ) );
								$end_hour   = date( 'g:ia', strtotime( '+' . $type_option . ' minutes', strtotime( $values[2] . ':' . $values[3] . $values[1] ) ) );

								if ( ! empty( $hour_standard_24 ) ) {
									$start_hour = date( 'H:i', strtotime( $start_hour ) );
									$end_hour   = date( 'H:i', strtotime( $end_hour ) );
								}

								$is_booked = false;
								$is_expire = false;

								if ( in_array( $key, $next_atts['slots'] ) && in_array( date( 'Y-m-d', $next_date ), $next_atts['dates'] ) ) {
									if ( empty( get_site_option( 'bb_include_show_booked_time_slots', true ) ) ) {
										continue;
									}

									$is_booked = true;
								}

								if ( strtotime( date( 'j-m-Y', time() ) ) > strtotime( date( 'j-m-Y', $next_date ) ) ) {
									$is_expire = true;
								}
								?>
								<li data-time="<?php echo $key; ?>" class="<?php echo $is_booked || $is_expire ? 'bb-is-disabled' : ''; ?> js-select-time-of-day">
									<a href="#">
										<span><?php printf( '%s - %s', $start_hour, $end_hour ); ?></span>

										<?php if ( $is_booked ) : ?>
											<span><?php _e( 'Booked', 'brindle-booking' ); ?></span>
										<?php endif ?>
									</a>
								</li>
							<?php endif ?>
						<?php endforeach ?>
					</ol><!-- /.bb-list-times -->
				<?php else: ?>
					<p class="bb-booking-slots-message"><?php echo __( 'No time slots for this date.' ); ?></p>
				<?php endif; ?>
			</div><!-- /.bb-tab-schedule -->
		</div><!-- /.bb-tabs-schedule -->

		<input type="hidden" name="bb-field-date-time-selected" id="bb-field-date-time-selected" value="">
		<input type="hidden" name="bb-field-date-selected" id="bb-field-date-selected" value="<?php echo date( 'Y-m-d', strtotime( $date ) ); ?>">
	</div><!-- /.bb-section__body -->
</section><!-- /.bb-section-time -->