<?php

$category      = get_site_option( 'bb_include_category', true );
$service       = get_site_option( 'bb_include_service', true );
$appointment   = get_site_option( 'bb_include_appointment_method', true );

$terms         = get_terms( [ 'taxonomy' => 'bb_service_category', 'hide_empty' => false ] );
$terms         = mbbb_order_service_categories( $terms );
$initial_term  = empty( $terms ) ? '' : $terms[0];

$services      = bb_get_category_services( ! empty( $initial_term ) ? $initial_term->term_id : '' )->posts;

$services_order = mbbb_get_services_full_order();

$services      = mbbb_order_services( $services, $services_order );

$methods       = bb_get_appointment_methods();

$main_color    = ! empty( get_site_option( 'bb_main_color', true ) ) ? get_site_option( 'bb_main_color', true ) : '#01bae8';
$accent_color  = ! empty( get_site_option( 'bb_accent_color', true ) ) ? get_site_option( 'bb_accent_color', true ) : '#ff1b63';
$titles_color  = ! empty( get_site_option( 'bb_titles_color', true ) ) ? get_site_option( 'bb_titles_color', true ) : '#01bae8';

$users         = get_users();
$staff_members = [];

$global_schedule = get_site_option( 'bb_single_schedule' );

$currency = get_site_option( 'bb_payment_currency' );

$supported_currencies = mbbb_get_supported_currencies();

if ( ! array_key_exists( $currency, $supported_currencies ) ) {
	$currency = 'usd';
}

$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];


foreach ( $users as $user ) {
	if ( ! in_array( 'mbbb_staff_member', $user->roles ) && ! in_array( 'administrator', $user->roles ) ) {
		continue;
	}

	$include_user_on_front_end = get_user_meta( $user->ID, 'bb_include_on_front_end', true );

	if ( empty( $include_user_on_front_end ) ) {
		continue;
	}

	$staff_members[] = array( 'ID' => $user->ID, 'name' => $user->display_name );
}

$locale = explode( '_', get_locale() )[0];

?>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.9/flatpickr.min.js"></script>
<?php if ( $locale !== 'en' ): ?>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/flatpickr/4.6.9/l10n/<?php echo $locale; ?>.min.js"></script>
<?php endif; ?>

<style type="text/css" media="screen">
	.bb-section-service .flatpickr-calendar .flatpickr-months { background: <?php echo $main_color; ?>; }
	.bb-section-service .flatpickr-calendar .flatpickr-day.selected { background: <?php echo $accent_color; ?>; color: #fff; }
	.bb-section-service .flatpickr-calendar .flatpickr-day:hover { background: <?php echo $accent_color; ?>; color: #fff; }
</style>

<div class="bb-section-service">
	<div class="bb-section__content">
		<div class="bb-list-inputs">
			<ul>
				<?php if ( empty( $global_schedule ) ) : ?>
					<li>
						<div class="bb-form-controls">
							<label style="color: <?php echo $titles_color ?>" for="bb-form-staff-member">
								<?php echo __( 'Staff Member', 'brindle-booking' ) ?>
							</label>

							<div class="bb-field">
								<div class="bb-select">
									<select
									data-validate="true"
									data-type="staff-member"
									name="bb-form-staff-member" id="bb-form-staff-member">
										<option value="0"><?php _e( 'Please select a staff member', 'brindle-booking' ); ?></option>
										
										<?php foreach ( $staff_members as $member ) : ?>
											<option value="<?php echo $member['ID'] ?>"><?php echo $member['name']; ?></option>
										<?php endforeach; ?>
									</select>
								</div><!-- /.bb-select -->
							</div><!-- /.bb-field -->
						</div><!-- /.bb-form-controls -->
					</li>
				<?php endif; ?>

				<?php if ( ! empty( $category ) && ! empty( $terms ) ) : ?>
					<li>
						<div class="bb-form-controls">
							<label style="color: <?php echo $titles_color ?>" for="bb-form-service-category">
								<?php echo __( 'Category', 'brindle-booking' ) ?>
							</label>

							<div class="bb-select">
								<select name="bb-form-service-category" class="js-ajax-services" id="bb-form-service-category">
									<?php foreach ( $terms as $term ) : ?>
										<option value="<?php echo $term->term_id ?>"><?php echo $term->name ?></option>
									<?php endforeach; ?>
								</select>
							</div><!-- /.bb-select -->
						</div><!-- /.bb-form-controls -->
					</li>
				<?php endif ?>

				<?php if ( ! empty( $service ) ) : ?>
					<li>
						<div class="bb-form-controls">
							<label style="color: <?php echo $titles_color ?>" for="bb-form-service-category">
								<?php echo __( 'Service', 'brindle-booking' ) ?>
							</label>

							<div class="bb-select">
								<select name="bb-form-service" id="bb-form-service">
									<?php if ( empty( $services ) ) : ?>
										<option value="<?php echo $service->ID ?>">
											<?php _e( 'There are no Services', 'brindle-booking' ); ?>
										</option>
									<?php else : ?>
										<?php foreach ( $services as $service ) : ?>
											<option value="<?php echo $service->ID ?>">
												<?php echo $service->post_title; ?>

												<?php if ( ! empty( $price = get_post_meta( $service->ID, 'bb_service_price', true ) ) ) : ?>
													<?php printf( '| %s%s', $currency_sign, strval( round( floatval( $price ), 2 ) ) ) ?>
												<?php endif ?>
											</option>
										<?php endforeach; ?>
									<?php endif ?>
								</select>
							</div><!-- /.bb-select -->
						</div><!-- /.bb-form-controls -->
					</li>
				<?php endif ?>

				<?php if ( ! empty( $appointment ) && count( $methods ) > 1 ) : ?>
					<li>
						<div class="bb-form-controls">
							<label style="color: <?php echo $titles_color ?>" for="bb-form-method">
								<?php echo __( 'Appointment Method', 'brindle-booking' ) ?>
							</label>

							<div class="bb-field">
								<div class="bb-select">
									<select
									data-validate="true"
									data-type="appointment-method"
									name="bb-form-method" id="bb-form-method">
										<?php foreach ( $methods as $value => $label ) : ?>
											<option value="<?php esc_attr_e( $value ); ?>"><?php esc_html_e( $label ); ?></option>
										<?php endforeach ?>
									</select>
								</div><!-- /.bb-select -->
							</div><!-- /.bb-field -->
						</div><!-- /.bb-form-controls -->
					</li>
				<?php endif ?>
			</ul>
		</div><!-- /.bb-list-inputs -->
	</div><!-- /.bb-section__content -->

	<div class="bb-section__calendar">
		<i class="bb-calendar-loading-spinner">
			<?php include( BB_PLUGIN_DIR . 'fragments/spinner.php' ); ?>
		</i>

		<div id="bb-calendar" class="bb-calendar" data-disabled-string="<?php echo __( 'No bookings available this day.', 'brindle-booking' ); ?>"></div><!-- /.bb-calendar -->

		<input type="hidden" name="bb-calendar-dates-field" id="bb-calendar-dates-field" value="<?php echo date( 'l F jS, Y' ) ?>">
	</div><!-- /.bb-section__calendar -->
</div><!-- /.bb-section-service -->