<p><?php printf( 'Thank you for making a reservation with <a href=""%s>%s</a>. <br> You can review the booking details below:', home_url('/'), get_bloginfo( 'site_title' ) ); ?></p>

<div class="bb-table">
	<div class="table">
		<table>
			<?php if ( ! empty( $category ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Category', 'brindle-booking' ); ?></td>

					<td><?php esc_html_e( $category ); ?></td>
				</tr>
			<?php endif ?>

			<?php if ( ! empty( $service_title ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Service', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $service_title ); ?>

						<?php if ( ! empty( $service_price ) ) : ?>
							<?php printf( '(%s%s)', __( '$', 'brindle-booking' ), number_format( $service_price, 0 ) ) ?>
						<?php endif ?>
					</td>
				</tr>
			<?php endif ?>

			<tr>
				<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Date', 'brindle-booking' ); ?></td>

				<td><?php echo $date_string; ?></td>
			</tr>

			<?php if ( ! empty( $show_slots ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Time', 'brindle-booking' ); ?></td>

					<td><?php printf( '%s - %s', $start_hour, $end_hour ); ?></td>
				</tr>
			<?php endif ?>


			<?php if ( ! empty( $location ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Location', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $location ); ?>

						<?php if ( ! empty( $show_on_map ) ) : ?>
							<i class="bb-ico-pin"></i> <a href="<?php echo esc_url( 'https://www.google.com/maps/search/' . urldecode( $location ) .'/') ?>" target="_blank"><?php _e( 'View on Map', 'brindle-booking' ); ?></a>
						<?php endif ?>
					</td>
				</tr>
			<?php endif ?>

			<?php if (  $payment_method !== NULL ): ?>
				<tr>
					<td style="color: <?php echo $titles_color ?>"><?php echo __( 'Payment Method', 'brindle-booking' ) ?></td>

					<td>
						<?php if ( $payment_method === 'stripe' ) : ?>
							<?php _e( 'Paid in full via Credit Card', 'brindle-booking' ); ?>
						<?php elseif ( $payment_method === 'with_invoice' ) : ?>
							<?php _e( 'Payment with Invoice Later', 'brindle-booking' ); ?>
						<?php else : ?>
							<?php _e( 'Payment on location', 'brindle-booking' ); ?>
						<?php endif ?>
					</td>
				</tr>
			<?php endif ?>
		</table>
	</div><!-- /.table -->
</div><!-- /.bb-table -->