<?php

$main_color   = ! empty( get_site_option( 'bb_main_color', true ) ) ? get_site_option( 'bb_main_color', true ) : '#01bae8';
$accent_color = ! empty( get_site_option( 'bb_accent_color', true ) ) ? get_site_option( 'bb_accent_color', true ) : '#ff1b63';
$titles_color = ! empty( get_site_option( 'bb_titles_color', true ) ) ? get_site_option( 'bb_titles_color', true ) : '#01bae8';

?>

<div class="bb-table">
	<div class="table">
		<table>
			<?php if ( ! empty( $category ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Category', 'brindle-booking' ); ?></td>

					<td><?php esc_html_e( $category ); ?></td>
				</tr>
			<?php endif ?>

			<?php if ( ! empty( $service_title ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Service', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $service_title ); ?>

						<?php if ( ! empty( $service_price ) ) : ?>
							<?php printf( '(%s%s)', __( '$', 'brindle-booking' ), number_format( $service_price, 0 ) ) ?>
						<?php endif ?>
					</td>
				</tr>
			<?php endif ?>

			<tr>
				<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Date', 'brindle-booking' ); ?></td>

				<td><?php echo $date_string; ?></td>
			</tr>

			<?php if ( ! empty( $show_slots ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Time', 'brindle-booking' ); ?></td>

					<td><?php printf( '%s - %s', $start_hour, $end_hour ); ?></td>
				</tr>
			<?php endif ?>


			<?php if ( ! empty( $location ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Location', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $location ); ?>

						<?php if ( ! empty( $show_on_map ) ) : ?>
							<i class="bb-ico-pin"></i> <a href="<?php echo esc_url( 'https://www.google.com/maps/search/' . urldecode( $location ) .'/') ?>" target="_blank"><?php _e( 'View on Map', 'brindle-booking' ); ?></a>
						<?php endif ?>
					</td>
				</tr>
			<?php endif; ?>

			<?php if (  $payment_method !== NULL && ! empty( $payment_method ) ): ?>
				<tr>
					<td style="color: <?php echo $titles_color ?>"><?php echo __( 'Payment Method', 'brindle-booking' ) ?></td>

					<td>
						<?php if ( $payment_method === 'stripe' ) : ?>
							<?php _e( 'Paid in full via Credit Card', 'brindle-booking' ); ?>
						<?php elseif ( $payment_method === 'with_invoice' ) : ?>
							<?php _e( 'Payment with Invoice Later', 'brindle-booking' ); ?>
						<?php else : ?>
							<?php _e( 'Payment on location', 'brindle-booking' ); ?>
						<?php endif ?>
					</td>
				</tr>
			<?php endif; ?>

			<?php if ( ! empty( $name ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Name', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $name ); ?>
					</td>
				</tr>
			<?php endif ?>

			<?php if ( ! empty( $email ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Email', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $email ); ?>
					</td>
				</tr>
			<?php endif ?>

			<?php if ( ! empty( $phone ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Phone Number', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $phone ); ?>
					</td>
				</tr>
			<?php endif ?>

			<?php if ( ! empty( $address ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Address', 'brindle-booking' ); ?></td>

					<td>
						<?php esc_html_e( $address ); ?>
					</td>
				</tr>
			<?php endif; ?>

			<?php if ( ! empty( $zoom_link ) ) : ?>
				<tr>
					<td style="color: <?php echo $titles_color; ?>"><?php _e( 'Zoom', 'brindle-booking' ); ?></td>

					<td>
						<?php echo $zoom_link; ?>
					</td>
				</tr>
			<?php endif; ?>
		</table>
	</div><!-- /.table -->
</div><!-- /.bb-table -->