<style type="text/css" media="screen">
.bb-section-booking { font-size: 13px; font-family: museo-sans, sans-serif; }

.bb-table { padding: 20px 0; border: 1px solid #eaeaea; overflow: hidden; border-radius: 8px; max-width: 600px; }

.bb-table table { width: 100%; }

.bb-table table tr:nth-child(odd) { background: #f7f7f7; -webkit-print-color-adjust: exact; }

.bb-table table td { width: 60%; height: 32px; padding: 0 16px; font-size: 13px; font-family: museo-sans, sans-serif; color: #525252; font-weight: 400; }
.bb-table table td:first-child { text-align: left; width: 40%; font-weight: 700; }
.bb-table table td:last-child { text-align: right; }
.bb-table table a { text-decoration: underline; color: inherit; }
.bb-table table a:hover { text-decoration: none; }
</style>

<?php

$staff_member_object = '';

if ( ! empty( $staff_member ) ) {
	$staff_member_object = get_user_by( 'id', $staff_member );
}


$data = [
	'date'           => ! empty( $date ) ? wp_date( 'D F jS, Y', strtotime( $date ) ) : '',
	'date_string'    => ! empty( $date ) ? wp_date( 'D F jS, Y', strtotime( $date ) ) : '',
	'show_slots'     => ! empty( $show_slots ) ? $show_slots : '',
	'show_on_map'    => ! empty( $show_on_map ) ? $show_on_map : '',
	'payment_method' => ! empty( $payment_method ) ? $payment_method : '',
	'start_hour'     => ! empty( $start_hour ) ? $start_hour : '',
	'end_hour'       => ! empty( $end_hour ) ? $end_hour : '',
	'time'           => ! empty( $start_hour ) && ! empty( ! empty( $start_hour ) ) ? sprintf( '%s - %s', $start_hour, $end_hour ) : '',
	'location'       => ! empty( $location ) ? $location : '',
	'staff_member'   => ! empty( $staff_member_object ) ? $staff_member_object->display_name : '_',
	'category'       => ! empty( $category ) ? $category : '',
	'service'        => ! empty( $service_title ) ? $service_title : '',
	'service_price'  => ! empty( $service_price ) ? $service_price : '',
	'name'           => ! empty( $name ) ? $name : '',
	'email'          => ! empty( $email ) ? $email : '',
	'phone'          => ! empty( $phone ) ? $phone : '',
	'address'        => ! empty( $address ) ? $address : '',
	'zoom'           => ! empty( $zoom_meeting ) ? $zoom_meeting : '',
];

?>

<section class="bb-section-booking">
	<div class="shell">
		<?php if ( $is_for_admin === true ): ?>
			<?php include BB_PLUGIN_DIR . 'fragments/email/confirmation/admin/template.php'; ?>
		<?php elseif ( $is_for_visitor === true ) : ?>
			<?php include BB_PLUGIN_DIR . 'fragments/email/confirmation/visitor/template.php'; ?>
		<?php endif ?>
	</div><!-- /.shell -->
</section><!-- /.bb-section-booking -->