<?php

/**
 * Plugin Name: Brindle Booking
 * Plugin URI: https://mybrindle.com/
 * Description: Flexible appointment booking made easy. Let customers and clients book online meetings, on-location services, and more.
 * Version: 1.1.7
 * Author: Brindle
 * Author URI: https://mybrindle.com/
 * Text Domain: brindle-booking
 * Domain Path: /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Invalid request.' );
}

require_once( plugin_dir_path( __FILE__ ) . 'mb-bb-api-manager-product-id.php' );

// Load the API Manager PHP Library
// Load WC_AM_Client class if it exists.
if ( ! class_exists( 'WC_AM_Client_MBBB' ) ) {
	/*
	* |---------------------------------------------------------------------
	* | This must be exactly the same for both plugins and themes.
	* |---------------------------------------------------------------------
	*/
	require_once( plugin_dir_path( __FILE__ ) . 'wc-am-client.php' );
}

// Instantiate WC_AM_Client class object if the WC_AM_Client class is loaded.
if ( class_exists( 'WC_AM_Client_MBBB' ) ) {
	/**
	* This file is only an example that includes a plugin header, and this code used to instantiate the client object. The variable $wcam_lib
	* can be used to access the public properties from the WC_AM_Client class,
	but $wcam_lib must have a unique name. To find data saved by
	* the WC_AM_Client in the options table, search for wc_am_client_{product_id},
	so in this example it would be wc_am_client_132967.
	*
	* All data here is sent to the WooCommerce API Manager API, except for the
	$software_title, which is used as a title, and menu label, for
	* the API Key activation form the client will see.
	*
	* ****
	* NOTE
	* ****
	* If $product_id is empty, the customer can manually enter the product_id into a form field on the activation screen.
	*
	* @param string $file Must be __FILE__ from the root plugin file, or theme functions, file locations.
	* @param int $product_id Must match the Product ID number (integer) in the product.
	* @param string $software_version This product's current software version.
	* @param string $plugin_or_theme 'plugin' or 'theme'
	* @param string $api_url The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/ Must be the root URL.
	* @param string $software_title The name, or title, of the product. The title is
	not sent to the API Manager APIs, but is used for menu titles.
	*
	* Example:
	*
	* $wcam_lib = new WC_AM_Client_2_8( $file, $product_id, $software_version, $plugin_or_theme, $api_url, $software_title );
	*/
	// Theme example.
	//$wcam_lib = new WC_AM_Client_2_8( __FILE__, 234, '1.0', 'theme', 'http://wc/', 'WooCommerce API Manager PHP Library for Plugins and Themes' );
	// Second argument must be the Product ID number if used. If left empty the client will need to enter it in the activation form.
	// Plugin example. The $wcam_lib is optional, and must have a unique name if used to check if the API Key has been activated before allowing use of the plugin/ theme.

	$mbbb_wcam_lib = new WC_AM_Client_MBBB( __FILE__, 12994, '1.1.7', 'plugin', 'https://mybrindle.com/', 'Brindle Booking' );
}

// $activation_status = get_option( $mbbb_wcam_lib->wc_am_activated_key );
// if ( $activation_status !== 'Activated' ) {
// 	return;
// }

if ( ! empty( get_site_option( 'timezone_string' ) ) )  {
	date_default_timezone_set( get_site_option( 'timezone_string' ) );
}

define( 'BB_PLUGIN_DIR', dirname( __FILE__ ) . DIRECTORY_SEPARATOR );
define( 'BB_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'BB_PLUGIN_DIR_FRAGMENTS', plugin_dir_url( __FILE__ ) . '/fragments/' );
define( 'BB_PLUGIN_UPLOAD_DIR', wp_upload_dir()['basedir'] . '/mb-gc-creds' );
define( 'BB_PLUGIN_UPLOAD_URL', wp_upload_dir()['baseurl'] . '/mb-gc-creds' );

// Include the dependencies needed to instantiate the plugin.
foreach ( glob( plugin_dir_path( __FILE__ ) . 'admin/*.php' ) as $file ) {
	include_once $file;
}

add_action( 'plugins_loaded', 'bb_admin_settings' );
/**
 * Starts the plugin.
 *
 * @since 1.0.0
 */
function bb_admin_settings() {

	include_once( BB_PLUGIN_DIR . 'includes/enqueue.php' );

	# Utils
	include_once( BB_PLUGIN_DIR . 'functions.php' );
	include_once( BB_PLUGIN_DIR . 'includes/service.php' );
	include_once( BB_PLUGIN_DIR . 'includes/category.php' );
	include_once( BB_PLUGIN_DIR . 'includes/admin-pages.php' );
	include_once( BB_PLUGIN_DIR . 'includes/utils.php' );
	include_once( BB_PLUGIN_DIR . 'includes/wp-head-utils.php' );

	$menu = new Brindle_Booking_Menu( new Brindle_Booking_Page() );
	$menu->init();
}

/*
 * Set default values on plugin activation.
 */
function mb_bb_plugin_activation(){
	do_action( 'mb_bb_plugin_default_options' );
}
register_activation_hook( __FILE__, 'mb_bb_plugin_activation' );

/*
 * Default options' values
 */
function mb_bb_plugin_default_values(){
	# Services
	add_option( 'bb_service_categories_in_order', '' );
	add_option( 'bb_services_in_order', '' );

	# Design
	add_option( 'bb_main_color', '#01bae8' );
	add_option( 'bb_accent_color', '#f55388' );
	add_option( 'bb_titles_color', '#01bae8' );

	# Settings
	add_option( 'bb_enable_online_payments', true );
	add_option( 'bb_enable_payment_on_location', true );
	add_option( 'bb_enable_payment_via_invoice', true );
	add_option( 'bb_payment_currency', 'USD' );

	add_option( 'bb_display_our_time', true );
	add_option( 'bb_display_directions', true );
	add_option( 'bb_location_address', '' );

	add_option( 'bb_include_category', true );
	add_option( 'bb_include_service', true );
	add_option( 'bb_include_appointment_method', true );
	add_option( 'bb_include_show_booked_time_slots', true );
	add_option( 'bb_disable_double_booking', false );

	add_option( 'bb_method_in_store', true );
	add_option( 'bb_method_at_facility', true );
	add_option( 'bb_method_online_video', true );
	add_option( 'bb_method_phone_call', true );
	add_option( 'bb_method_delivery', true );

	add_option( 'bb_collected_details_full_name', true );
	add_option( 'bb_collected_details_full_name_required', true );
	add_option( 'bb_collected_details_email', true );
	add_option( 'bb_collected_details_email_required', true );
	add_option( 'bb_collected_details_phone', true );
	add_option( 'bb_collected_details_phone_required', true );
	add_option( 'bb_collected_details_address', true );
	add_option( 'bb_collected_details_address_required', true );

	add_option( 'bb_include_acknowledgement', 0 );
	add_option( 'bb_selected_by_default_acknowledgement', 0 );
	add_option( 'bb_text_entry_acknowledgement', 'I have read &amp; agree to the <a href=\"#\" target=\"\\&quot;_blank\\&quot;\" rel=\"\\&quot;noopener\\&quot;\">cancellation policy</a> and <a href=\"#\" target=\"\\&quot;_blank\\&quot;\" rel=\"\\&quot;noopener\\&quot;\">privacy policy</a>' );

	add_option( 'bb_conf_page_print', true );
	add_option( 'bb_conf_page_google_reminder', true );
	add_option( 'bb_conf_page_support_link', true );
	add_option( 'bb_conf_page_facebook_share', true );

	add_option( 'bb_support_page_link', '' );

	# Schedule
	add_option( 'bb_schedule_12_hour_standard', 1 );
	add_option( 'bb_schedule_24_hour_standard', 0 );

	# Notifications
	add_option( 'bb_notified_admins', '' );
	add_option( 'bb_no_notification_admin', '' );
	add_option( 'bb_mail_name_from', 'WordPress' );
	add_option( 'bb_admin_notification', 'Hello! A visitor has booked an appointment on [date] at [time] with [staff member] for [category] [service].' );
	add_option( 'bb_admin_notification_subject', 'Booking Reservation' );
	add_option( 'bb_visitor_notification', 'Thank you for making a reservation with [site link]. <br> You have booked an appointment on [date] at [time] with [staff member] for [category] [service]. You can review the booking details here: <br><br> [details]' );
	add_option( 'bb_visitor_notification_subject', 'Your Booking is Confirmed!' );

	add_option( 'bb_single_schedule', '' );

	add_option( 'bb_enable_redirect', 0 );
	add_option( 'bb_redirect_url', '' );

	add_option( 'bb_load_assets_on_all_pages', 'load_assets_on_all_pages_yes' );
	add_option( 'bb_load_assets_choose_pages', '' );

	# Integrations
	add_option( 'bb_stripe_pk_key', null );
	add_option( 'bb_stripe_sk_key', null );
	add_option( 'bb_zoom_user_access_code', '' );
	add_option( 'bb_zoom_user_access_token', '' );
}
add_action( 'mb_bb_plugin_default_options', 'mb_bb_plugin_default_values' );