<section class="bb-section bb-section-services">
	<div class="section__logo">
		<img src="<?php echo BB_PLUGIN_URL . 'images/booking-logo.png' ?>"/>
	</div><!-- /.section__logo -->

	<div class="section__inner">
		<div class="section__content">
			<?php include_once( BB_PLUGIN_DIR . 'admin/templates/bar.php' ); ?>

			<div class="section__content-inner">
				<?php if ( isset( $_GET['bb-err'] ) ) : ?>
					<div class="section__notices">
						<?php echo bb_errors( $_GET['bb-err'] ); ?>
					</div><!-- /.section__notices -->
				<?php endif ?>

				<header class="section__head">
					<p>
						<?php _e( 'Categories', 'brindle-booking' ) ?>

						<span class="field-tooltip-container">
							<span class="field-tooltip-icon"><span>?</span></span>

							<span class="field-tooltip" style="display: none;">
								<?php _e( 'Have multiple Service types? You can group them into categories here. Enter Category name, then click Add.', 'brindle-booking' ); ?>
							</span>
						</span>
					</p>
				</header><!-- /.section__head -->

				<div class="section__body">
					<div class="bb-categories">
						<form method="post" action="<?php echo admin_url( 'admin-post.php' ) ?>">
							<div class="form__inner">
								<input type="hidden" name="action" value="bb_add_category_form">
								<input type="hidden" name="mb_bb_add_category_nonce" value="<?php echo wp_create_nonce( 'mb_bb_add_category_form_nonce' ); ?>" />

								<input type="text" name="new_service_cat_name" id="new_service_cat_name" required placeholder="<?php _e( 'Add New Category', 'brindle-booking' ); ?>">

								<input type="submit" name="submit" value="<?php _e( 'Add', 'brindle-booking' ); ?>">
							</div><!-- /.form__inner -->

							<input
							type="hidden"
							name="service_categories_in_order"
							value="<?php echo get_site_option( 'bb_service_categories_in_order', '' ); ?>">

							<ul id="sortable">
								<?php if ( ! empty( $categories ) ) : ?>
									<?php foreach ( $categories as $category ) : ?>
										<li class="ui-state-default">
											<a
											class="js-drag-and-drop-category"
											data-action="bb_delete_category"
											data-cat-id="<?php echo $category->term_id ?>"
											href="#">
												<span><?php echo esc_html( $category->name ); ?></span>

												<i class="bb-ico-close js-delete-category" aria-hidden="true">
													<span></span>

													<span></span>
												</i>
											</a>
										</li>
									<?php endforeach ?>
								<?php endif ?>
							</ul>
						</form>
					</div><!-- /.bb-categories -->
				</div><!-- /.section__body -->

				<div class="bb-services js-services-checkbox">
					<header class="section__head">
						<p>
							<?php echo __( 'Services', 'brindle-booking' ) ?>

							<span class="field-tooltip-container">
								<span class="field-tooltip-icon"><span>?</span></span>

								<span class="field-tooltip" style="display: none;">
									<?php _e( 'Create your services here, and group them into categories created above (optional). If charging for services, you can set the cost in this section as well.', 'brindle-booking' ); ?>
								</span>
							</span>
						</p>

						<a href="#" class="js-bulk-delete-services">
							<?php _e( 'Delete Selected', 'brindle-booking' ); ?>
						</a>
					</header><!-- /.section__head -->

					<?php if ( ! empty( $categories ) ) : ?>
						<form action="?" method="get" class="services-filter">
							<input type="hidden" name="page" value="brindle-booking">
							<select name="category-filter" id="category-filter">
								<option value=""><?php _e( 'All Categories', 'brindle-booking' ); ?></option>
								<?php foreach ( $categories as $category ) : ?>
									<option value="<?php echo absint( $category->term_id ); ?>" <?php echo isset( $_GET['category-filter'] ) && absint( $_GET['category-filter'] ) === absint( $category->term_id ) ? 'selected' : ''; ?>><?php echo esc_html( $category->name ); ?></option>
								<?php endforeach ?>
							</select>
						</form>
					<?php endif ?>

					<div class="section__body">
						<div class="services__confirmation">
							<p><?php echo sprintf( '%s <br> %s', __( 'Are you sure you want to delete the selected services?', 'brindle-booking' ), __( 'This cannot be undone.' ) ) ?></p>

							<a href="#" class="services__btn js-confirm-bulk-delete">
								<?php _e( 'Confirm', 'brindle-booking' ); ?>
							</a>

							<a href="#" class="services__btn js-cancel-bulk-delete">
								<?php _e( 'Cancel', 'brindle-booking' ); ?>
							</a>
						</div><!-- /.services__confirmation -->

						<?php if ( $query->have_posts() ) : ?>
							<div class="services__head">
								<div class="bb-service js-service-select js-service-select-bulk" data-selected="false">
									<div class="service__content">
										<p><?php _e( 'Service Title', 'brindle-booking' ) ?></p>
									</div><!-- /.service__content -->

									<div class="service__body">
										<p><?php _e( 'Category', 'brindle-booking' ) ?></p>
									</div><!-- /.service__body -->

									<div class="service__actions">
										<p><?php _e( 'Options', 'brindle-booking' ) ?></p>
									</div><!-- /.service__actions -->
								</div><!-- /.bb-service -->
							</div><!-- /.services__head -->

							<div
							class="services__body">
								<input
								type="hidden"
								name="services_in_order"
								value="<?php echo mbbb_get_services_page_order(); ?>">

								<ul id="<?php echo empty( $_GET['category-filter'] ) ? 'sortable-services' : ''; ?>">
									<?php foreach ( $posts as $post ) : ?>
										<li class="ui-state-default">
											<div class="bb-service js-service-select" data-selected="false" data-id="<?php echo $post->ID; ?>">
												<div class="service__content">
													<p>
														<a href="<?php echo get_edit_post_link( $post->ID ); ?>">
															<?php echo get_the_title( $post->ID ) ?>

															<?php

															$price    = get_post_meta( $post->ID, 'bb_service_price', true );
															$currency = get_site_option( 'bb_payment_currency' );
															$supported_currencies = mbbb_get_supported_currencies();

															if ( ! array_key_exists( $currency, $supported_currencies ) ) {
																$currency = 'usd';
															}

															$currency_sign = mbbb_get_supported_currency_signs()[ $currency ];

															?>

															<?php if ( ! empty( $price ) ) : ?>
																<?php printf( '%s%s', $currency_sign, strval( round( floatval( $price ), 2 ) ) ) ?>
															<?php endif ?>
														</a>
													</p>
												</div><!-- /.service__content -->

												<div class="service__body">
													<?php
													$service_categories = get_the_terms( $post->ID, 'bb_service_category' );

													if ( ! empty( $service_categories ) ) :
														$categories_names = wp_list_pluck( $service_categories, 'name' );
													?>
														<p><?php echo implode( ',', $categories_names ); ?></p>
													<?php endif ?>
												</div><!-- /.service__content -->

												<div class="service__actions">
													<ul>
														<li>
															<a class="service__btn-delete js-delete-service" href="<?php echo get_delete_post_link( $post->ID, '', true ) ?>">
																<?php _e( 'Delete', 'brindle-booking' ); ?>
															</a>
														</li>
														<li>
															<a class="service__btn-edit js-edit" href="<?php echo get_edit_post_link( $post->ID ) ?>" data-service="<?php echo absint( $post->ID ); ?>" data-paged="<?php echo isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : ''; ?>" data-cat="<?php echo isset( $_GET['category-filter'] ) ? absint( $_GET['category-filter'] ) : ''; ?>" >
																<?php _e( 'Edit', 'brindle-booking' ); ?>
															</a>
														</li>

														<?php if ( empty( $_GET['category-filter'] ) ): ?>
															<li>
																<a class="ui-icon service__btn-sort js-sort-service" href="#">
																	<i class="bb-ico-sort"></i>
																</a>
															</li>
														<?php endif ?>
													</ul>
												</div><!-- /.service__actions -->
											</div><!-- /.bb-service -->
										</li>
									<?php endforeach; ?>
								</ul>

								<?php
								$admin_url   = admin_url( 'admin.php?page=brindle-booking' );
								$paged       = isset( $_GET['paged'] ) ? absint( $_GET['paged'] ) : 1;
								$pages       = $query->max_num_pages;
								$pages_array = [];

								if ( isset( $_GET['category-filter'] ) && ! empty( $_GET['category-filter'] ) ) {
									$admin_url = add_query_arg( 'category-filter', absint( $_GET['category-filter'] ), $admin_url );
								}

								if ( $pages > 1 ) {
									$pages_array = range( 1, $pages );
								}

								if ( ! empty( $pages_array ) ) :
								?>
									<div class="pagination">
										<?php foreach ( $pages_array as $page ) : ?>
											<a href="<?php echo add_query_arg( 'paged', $page, $admin_url ); ?>" <?php echo isset( $_GET['paged'] ) && absint( $page ) === absint( $_GET['paged'] ) ? 'class="bb-current"' : ''; ?>><?php echo $page; ?></a>
										<?php endforeach ?>
									</div><!-- /.pagination -->
								<?php endif ?>
							</div><!-- /.services__body -->
						<?php else : ?>
							<div class="services__body">
								<p>
									<?php
									if ( isset( $_GET['category-filter'] ) && ! empty( $_GET['category-filter'] ) ) {
										_e( 'There are no services in selected category.', 'brindle-booking' );
									} else {
										_e( 'Click below to add a bookable service.', 'brindle-booking' );
									}
									?>
								</p>

								<ul id="<?php echo empty( $_GET['category-filter'] ) ? 'sortable-services' : ''; ?>">
								</ul>
							</div><!-- /.services__body -->
						<?php endif ?>
					</div><!-- /.section__body -->

					<div class="section__actions">
						<a href="#" class="bb-btn js-add-service"><?php _e( 'Add New Service', 'brindle-booking' ) ?></a>

						<div id="TB_window" class="thickbox-loading bb-popup-service" style="margin-left: -315px; width: 630px; margin-top: -295px; visibility: visible; display: none;">

							<div id="TB_ajaxContent" style="width:600px;height:545px">
							</div>
						</div>
					</div><!-- /.section_actions -->
				</div><!-- /.bb-services -->
			</div><!-- /.section__content-inner -->
		</div><!-- /.section__content -->

		<div class="section__sidebar">
			<a class="bb-btn" href="#"><?php _e( 'Save Changes', 'brindle-booking' ) ?></a>
		</div><!-- /.section__sidebar -->
	</div><!-- /.section__inner -->
</section><!-- /.bb-section -->