<section class="bb-section bb-section--schedule <?php echo isset( $_GET['type'] ) ? 'bb-section--schedule-grid-' . $_GET['type'] : ''; ?>">
	<div class="section__logo">
		<img src="<?php echo BB_PLUGIN_URL . 'images/booking-logo.png' ?>"/>
	</div><!-- /.section__logo -->

	<div class="section__inner">
		<div class="section__content">
			<?php include_once( BB_PLUGIN_DIR . 'admin/templates/bar.php' ); ?>

			<?php if ( ! empty( $global_schedule ) ): ?>
				<h1><?php _e( 'The administrator has set the schedule to global, so you cannot access your own schedule. Please contact the administrator for more information.', 'brindle-booking' ); ?></h1>
			<?php else: ?>
				<div class="section__content-inner">
					<?php if ( isset( $_GET['bb-err'] ) ) : ?>
						<div class="section__notices">
							<?php echo bb_errors( $_GET['bb-err'] ); ?>
						</div><!-- /.section__notices -->
					<?php endif ?>

					<header class="section__head">
						<p><?php _e( 'Available Time Slots', 'brindle-booking' ) ?></p>

						<div class="field-tooltip-container">
							<span class="field-tooltip-icon"><span>?</span></span>

							<span class="field-tooltip" style="display: none;">
								<?php _e( 'Set your schedule here to allow visitors to book specific time slots. You can set increments of 15, 30, and 60 minutes. Click the slots below to make them available (indicated in pink) and the front end will adapt accordingly.', 'brindle-booking' ); ?>
							</span>
						</div><!-- /.field-tooltip-container -->
					</header><!-- /.section__head -->

					<div class="section__subhead">
						<form action="?" method="get" class="schedule-type">
							<div class="schedule__cols">
								<div class="schedule__col">
									<input type="hidden" name="page" id="page" value="<?php echo in_array( 'mbbb_staff_member', $user->roles ) ? 'brindle-booking' : 'brindle-booking-schedule' ?>">

									<label for="type"><?php _e( 'Schedule grid:', 'brindle-booking' ); ?></label>

									<div class="select">
										<select name="type" id="type">
											<?php foreach ( bb_schedule_types() as $value => $label ) : ?>
												<option value="<?php esc_attr_e( $value ); ?>" <?php echo bb_schedule_selected_value( $value ); ?>><?php esc_html_e( $label ); ?></option>
											<?php endforeach ?>
										</select>
									</div><!-- /.select -->
								</div><!-- /.schedule__col -->

								<div class="schedule__col">
									<input type="hidden" name="include_staff_member_change" value="0">

									<label for="user_id"><?php _e( 'Staff Member:', 'brindle-booking' ); ?></label>

									<div class="select">
										<select name="user_id" id="user_id">
											<option value=""><?php _e( 'Select A Staff Member', 'brindle-booking' ); ?></option>

											<?php

											$selected_user = '';

											if ( isset( $_GET['user_id'] ) && is_numeric( $_GET['user_id'] ) ) {
												$selected_user = strip_tags( $_GET['user_id'] );
											}

											?>

											<?php foreach ( $staff_members as $member ) : ?>
												<option
												value="<?php echo $member['ID']; ?>"
												<?php echo $member['ID'] === $selected_user ? 'selected' : ''; ?>>
													<?php echo esc_html( $member['display_name'] ); ?>
												</option>
											<?php endforeach; ?>
										</select>
									</div><!-- /.select -->
								</div><!-- /.schedule__col -->
							</div><!-- /.schedule__cols -->
						</form>
					</div><!-- /.section__subhead -->
					
					<?php if ( isset( $_GET['user_id'] ) && is_numeric( $_GET['user_id'] ) ):

					$hour_standard_12 = get_site_option( 'bb_schedule_12_hour_standard' );
					$hour_standard_24 = get_site_option( 'bb_schedule_24_hour_standard' );

					?>
						<div class="section__body">
							<form class="bb-form-schedule mb-bb-admin-form" method="post" action="<?php echo admin_url( 'admin-post.php' ) ?>">
								<input type="hidden" name="action" value="bb_schedule_options_form">
								<input type="hidden" name="mb_bb_schedule_form_nonce" value="<?php echo wp_create_nonce( 'mb_bb_schedule_options_nonce' ); ?>" />
								<input type="hidden" name="schedule_type" value="<?php echo isset( $_GET['type'] ) ? absint( $_GET['type'] ) : 30; ?>">
								<input type="hidden" name="user_id" value="<?php echo isset( $_GET['user_id'] ) ? intval( strip_tags( $_GET['user_id'] ) ) : ''; ?>">
								<input type="hidden" name="single_schedule" value="true">

								<?php foreach ( $fields as $key => $field ) : ?>
									<?php if ( $key === 'am_12' ) : ?>
										<div class="bb-grid-schedule">
											<div class="grid__cols">
												<?php foreach ( $field['days'] as $day_key => $day ) : ?>
													<div class="grid__col">
														<p><?php esc_html_e( $day['label'] ); ?></p>
													</div><!-- /.grid__col -->
												<?php endforeach ?>
											</div><!-- /.grid__cols -->
										</div><!-- /.bb-grid-schedule -->
									<?php endif ?>

									<div class="bb-grid-schedule">
										<div class="grid__time">
											<?php if ( ! empty( $hour_standard_12 ) ) : ?>
												<?php esc_html_e( $field['label'] ); ?>
											<?php elseif ( $hour_standard_24 ) : ?>
												<?php esc_html_e( date( 'H:i', strtotime( $field['label'] ) ) ) ?>
											<?php endif; ?>
										</div><!-- /.grid__time -->

										<div class="grid__cols">
											<?php foreach ( $field['days'] as $day_key => $day ) : ?>
												<div class="grid__col">
													<?php foreach ( $day['slots'] as $slot_key => $slot ) : ?>
														<div class="grid__control">
															<input type="checkbox" id="<?php esc_attr_e( $slot_key ); ?>" name="<?php esc_attr_e( $slot_key ); ?>" <?php echo array_key_exists( $slot_key, $saved_slots ) && $saved_slots[$slot_key] == 'on' ? 'checked="checked"' : ''; ?>>
															<label for="<?php esc_attr_e( $slot_key ); ?>"><?php esc_html_e( $slot ); ?></label>
														</div><!-- /.grid__control -->
													<?php endforeach ?>
												</div><!-- /.grid__col -->
											<?php endforeach ?>
										</div><!-- /.grid__cols -->
									</div><!-- /.bb-grid-schedule -->
								<?php endforeach ?>
							</form>
						</div><!-- /.section__body -->
					<?php endif ?>
				</div><!-- /.section__content-inner -->
			<?php endif ?>
		</div><!-- /.section__content -->

		<div class="section__sidebar">
			<a class="bb-btn js-bb-save" href="#"><?php _e( 'Save Changes', 'brindle-booking' ) ?></a>
		</div><!-- /.section__sidebar -->
	</div><!-- /.section__inner -->
</section><!-- /.bb-section -->